/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.node;

import com.flipkart.krystal.krystex.commands.NodeCommand;
import com.flipkart.krystal.krystex.node.Node;
import com.flipkart.krystal.krystex.node.NodeId;
import com.flipkart.krystal.krystex.node.NodeResponse;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

final class NodeRegistry<T extends Node<? extends NodeCommand, ? extends NodeResponse>> {
    private final Map<NodeId, T> nodes = new LinkedHashMap<NodeId, T>();

    NodeRegistry() {
    }

    public T get(NodeId nodeId) {
        return (T)((Node)this.tryGet(nodeId).orElseThrow(() -> new IllegalArgumentException("No Node with id %s found".formatted(nodeId))));
    }

    public Optional<T> tryGet(NodeId nodeId) {
        return Optional.ofNullable((Node)this.nodes.get(nodeId));
    }

    public T createIfAbsent(NodeId nodeId, Function<NodeId, ? extends T> supplier) {
        return (T)((Node)this.nodes.computeIfAbsent(nodeId, supplier));
    }
}

