/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.decorators.observability;

import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.decorators.observability.NodeExecutionReport;
import com.flipkart.krystal.krystex.node.NodeId;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class MainLogicExecReporter
implements MainLogicDecorator {
    private final NodeExecutionReport nodeExecutionReport;

    public MainLogicExecReporter(NodeExecutionReport nodeExecutionReport) {
        this.nodeExecutionReport = nodeExecutionReport;
    }

    @Override
    public MainLogic<Object> decorateLogic(MainLogic<Object> logicToDecorate, MainLogicDefinition<Object> originalLogicDefinition) {
        return inputs -> {
            NodeId nodeId = originalLogicDefinition.nodeLogicId().nodeId();
            NodeLogicId nodeLogicId = originalLogicDefinition.nodeLogicId();
            this.nodeExecutionReport.reportMainLogicStart(nodeId, nodeLogicId, (ImmutableList<Inputs>)inputs);
            ImmutableMap results = logicToDecorate.execute((ImmutableList<Inputs>)inputs);
            CompletableFuture.allOf((CompletableFuture[])results.values().toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> this.nodeExecutionReport.reportMainLogicEnd(nodeId, nodeLogicId, (Results<Object>)new Results((ImmutableMap)results.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((CompletableFuture)((CompletableFuture)e.getValue()).handle(ValueOrError::valueOrError)).getNow(ValueOrError.empty()))))));
            return results;
        };
    }

    @Override
    public String getId() {
        return MainLogicExecReporter.class.getName();
    }
}

