/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex;

import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import com.flipkart.krystal.krystex.resolution.MultiResolverDefinition;
import com.flipkart.krystal.krystex.resolution.ResolverLogicDefinition;
import java.util.HashMap;
import java.util.Map;

public final class LogicDefinitionRegistry {
    private final Map<NodeLogicId, MainLogicDefinition<?>> mainLogicDefinitions = new HashMap();
    private final Map<NodeLogicId, ResolverLogicDefinition> resolverLogicDefinitions = new HashMap<NodeLogicId, ResolverLogicDefinition>();
    private final Map<NodeLogicId, MultiResolverDefinition> multiResolverDefinitions = new HashMap<NodeLogicId, MultiResolverDefinition>();

    public <T> MainLogicDefinition<T> getMain(NodeLogicId nodeLogicId) {
        return this.mainLogicDefinitions.get(nodeLogicId);
    }

    public ResolverLogicDefinition getResolver(NodeLogicId nodeLogicId) {
        return this.resolverLogicDefinitions.get(nodeLogicId);
    }

    public MultiResolverDefinition getMultiResolver(NodeLogicId nodeLogicId) {
        return this.multiResolverDefinitions.get(nodeLogicId);
    }

    public void addMainLogic(MainLogicDefinition<?> mainLogicDefinition) {
        if (this.mainLogicDefinitions.containsKey(mainLogicDefinition.nodeLogicId())) {
            return;
        }
        this.mainLogicDefinitions.put(mainLogicDefinition.nodeLogicId(), mainLogicDefinition);
    }

    public void addResolver(ResolverLogicDefinition def) {
        if (this.resolverLogicDefinitions.containsKey(def.nodeLogicId())) {
            return;
        }
        this.resolverLogicDefinitions.put(def.nodeLogicId(), def);
    }

    public void addMultiResolver(MultiResolverDefinition def) {
        if (this.multiResolverDefinitions.containsKey(def.nodeLogicId())) {
            return;
        }
        this.multiResolverDefinitions.put(def.nodeLogicId(), def);
    }

    public void validate() {
    }
}

