/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.commands.BatchCommand;
import com.flipkart.krystal.krystex.commands.CallbackBatch;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardBatch;
import com.flipkart.krystal.krystex.decoration.FlushCommand;
import com.flipkart.krystal.krystex.decoration.LogicDecorationOrdering;
import com.flipkart.krystal.krystex.decoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.kryon.AbstractKryon;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.kryon.DuplicateRequestException;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.kryon.KryonUtils;
import com.flipkart.krystal.krystex.kryon.MainLogicInputs;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.krystex.request.RequestIdGenerator;
import com.flipkart.krystal.krystex.resolution.DependencyResolutionRequest;
import com.flipkart.krystal.krystex.resolution.MultiResolver;
import com.flipkart.krystal.krystex.resolution.MultiResolverDefinition;
import com.flipkart.krystal.krystex.resolution.ResolverCommand;
import com.flipkart.krystal.krystex.resolution.ResolverDefinition;
import com.flipkart.krystal.utils.Futures;
import com.flipkart.krystal.utils.SkippedExecutionException;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

final class BatchKryon
extends AbstractKryon<BatchCommand, BatchResponse> {
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> availableInputsByDepChain = new LinkedHashMap<DependantChain, Set<String>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized ForwardBatch> inputsValueCollector = new LinkedHashMap<DependantChain, ForwardBatch>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized CallbackBatch>> dependencyValuesCollector = new LinkedHashMap<DependantChain, Map<String, CallbackBatch>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized BatchResponse>> resultsByDepChain = new LinkedHashMap<DependantChain, CompletableFuture<BatchResponse>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Inputs, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable @UnknownKeyFor @Initialized Object>> resultsCache = new LinkedHashMap<Inputs, CompletableFuture<Object>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> executedDependencies = new LinkedHashMap<DependantChain, Set<String>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RequestId>> requestsByDependantChain = new LinkedHashMap<DependantChain, Set<RequestId>>();
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized DependantChain> flushedDependantChain = new LinkedHashSet<DependantChain>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Boolean> mainLogicExecuted = new LinkedHashMap<DependantChain, Boolean>();

    BatchKryon(@UnknownKeyFor @NonNull @Initialized KryonDefinition kryonDefinition, @UnknownKeyFor @NonNull @Initialized KryonExecutor kryonExecutor, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized LogicExecutionContext, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MainLogicDecorator>> requestScopedDecoratorsSupplier, @UnknownKeyFor @NonNull @Initialized LogicDecorationOrdering logicDecorationOrdering, @UnknownKeyFor @NonNull @Initialized RequestIdGenerator requestIdGenerator) {
        super(kryonDefinition, kryonExecutor, requestScopedDecoratorsSupplier, logicDecorationOrdering, requestIdGenerator);
    }

    @Override
    public void executeCommand(@UnknownKeyFor @NonNull @Initialized Flush flushCommand) {
        this.flushedDependantChain.add(flushCommand.dependantChain());
        this.flushAllDependenciesIfNeeded(flushCommand.dependantChain());
        this.flushDecoratorsIfNeeded(flushCommand.dependantChain());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized BatchResponse> executeCommand(@UnknownKeyFor @NonNull @Initialized BatchCommand kryonCommand) {
        DependantChain dependantChain = kryonCommand.dependantChain();
        CompletableFuture resultForDepChain = this.resultsByDepChain.computeIfAbsent(dependantChain, r -> new CompletableFuture());
        try {
            if (kryonCommand instanceof ForwardBatch) {
                ForwardBatch forwardBatch = (ForwardBatch)kryonCommand;
                this.collectInputValues(forwardBatch);
            } else if (kryonCommand instanceof CallbackBatch) {
                CallbackBatch callbackBatch = (CallbackBatch)kryonCommand;
                this.collectDependencyValues(callbackBatch);
            }
            this.triggerDependencies(dependantChain, this.getTriggerableDependencies(dependantChain, kryonCommand.inputNames()));
            Optional<CompletableFuture<BatchResponse>> mainLogicFuture = this.executeMainLogicIfPossible(dependantChain);
            mainLogicFuture.ifPresent(f -> Futures.linkFutures((CompletableFuture)f, (CompletableFuture)resultForDepChain));
        }
        catch (Throwable e) {
            resultForDepChain.completeExceptionally(e);
        }
        return resultForDepChain;
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> getTriggerableDependencies(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> newInputNames) {
        Set<String> availableInputs = this.availableInputsByDepChain.getOrDefault(dependantChain, Set.of());
        Set<String> executedDeps = this.executedDependencies.getOrDefault(dependantChain, Set.of());
        LinkedHashSet dependencyInputNames = new LinkedHashSet();
        newInputNames.forEach(newInputName -> {
            if (this.resolverDefinitionsByInput.containsKey(Optional.of(newInputName))) {
                ((ImmutableSet)this.resolverDefinitionsByInput.get(Optional.of(newInputName))).forEach(resolverDefinition -> dependencyInputNames.add(resolverDefinition.dependencyName()));
            }
        });
        HashMap<String, Set<ResolverDefinition>> triggerableDependencies = new HashMap<String, Set<ResolverDefinition>>();
        for (String dependency : dependencyInputNames) {
            this.getDependenciesWithAllResolvers(availableInputs, executedDeps, triggerableDependencies, dependency);
        }
        for (String dependency : this.dependenciesWithNoResolvers) {
            this.getDependenciesWithAllResolvers(availableInputs, executedDeps, triggerableDependencies, dependency);
        }
        return triggerableDependencies;
    }

    private void getDependenciesWithAllResolvers(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> availableInputs, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> executedDeps, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> triggerableDependencies, @UnknownKeyFor @NonNull @Initialized String dependency) {
        if (!executedDeps.contains(dependency)) {
            ImmutableSet resolverDefinitions = (ImmutableSet)this.resolverDefinitionsByDependencies.get((Object)dependency);
            HashSet boundFrom = new HashSet();
            if (resolverDefinitions != null) {
                resolverDefinitions.forEach(resolverDefinition -> boundFrom.addAll(resolverDefinition.boundFrom()));
            }
            if (availableInputs.containsAll(boundFrom)) {
                triggerableDependencies.put(dependency, (Set)this.resolverDefinitionsByDependencies.getOrDefault((Object)dependency, (Object)ImmutableSet.of()));
            }
        }
    }

    private void triggerDependencies(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> triggerableDependencies) {
        ForwardBatch forwardBatch = this.getForwardCommand(dependantChain);
        Optional<MultiResolverDefinition> multiResolverOpt = this.kryonDefinition.multiResolverLogicId().map(kryonLogicId -> this.kryonDefinition.kryonDefinitionRegistry().logicDefinitionRegistry().getMultiResolver((KryonLogicId)kryonLogicId));
        ImmutableMap<RequestId, String> skippedRequests = forwardBatch.skippedRequests();
        ImmutableSet executableRequests = forwardBatch.executableRequests().keySet();
        LinkedHashMap<String, Map> commandsByDependency = new LinkedHashMap<String, Map>();
        if (!skippedRequests.isEmpty()) {
            ResolverCommand.SkipDependency skip = ResolverCommand.skip(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)skippedRequests.values()));
            for (String string : triggerableDependencies.keySet()) {
                commandsByDependency.computeIfAbsent(string, _k -> new LinkedHashMap()).put(skippedRequests.keySet(), skip);
            }
        }
        HashSet<String> dependenciesWithNoResolvers = new HashSet<String>();
        for (Map.Entry entry : triggerableDependencies.entrySet()) {
            if (!((Set)entry.getValue()).isEmpty()) continue;
            String key = (String)entry.getKey();
            dependenciesWithNoResolvers.add(key);
        }
        for (RequestId requestId : executableRequests) {
            dependenciesWithNoResolvers.forEach(depName -> commandsByDependency.computeIfAbsent((String)depName, _k -> new LinkedHashMap()).put(Set.of(requestId), ResolverCommand.multiExecuteWith((List<Inputs>)ImmutableList.of((Object)Inputs.empty()))));
            Inputs inputs = this.getInputsFor(dependantChain, requestId, BatchKryon.getInputsOfTriggerableDependency(triggerableDependencies));
            BatchKryon.getResolverCommandImmutableMap(triggerableDependencies, multiResolverOpt, inputs).forEach((depName, resolverCommand) -> commandsByDependency.computeIfAbsent((String)depName, _k -> new LinkedHashMap()).put(Set.of(requestId), resolverCommand));
        }
        for (Map.Entry entry : commandsByDependency.entrySet()) {
            String depName3 = (String)entry.getKey();
            Map resolverCommandsForDep = (Map)entry.getValue();
            this.triggerDependency(depName3, dependantChain, resolverCommandsForDep, triggerableDependencies.getOrDefault(depName3, (Set<ResolverDefinition>)ImmutableSet.of()));
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getInputsOfTriggerableDependency(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> triggerableDependencies) {
        HashSet<String> inputs = new HashSet<String>();
        triggerableDependencies.values().forEach(resolverDefinitionSet -> resolverDefinitionSet.forEach(resolverDefinition -> inputs.addAll((Collection<String>)resolverDefinition.boundFrom())));
        return inputs;
    }

    private static @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ResolverCommand> getResolverCommandImmutableMap(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> triggerableDependencies, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized MultiResolverDefinition> multiResolverOpt, @UnknownKeyFor @NonNull @Initialized Inputs inputs) {
        if (multiResolverOpt.isPresent()) {
            ArrayList<DependencyResolutionRequest> resolverRequestList = new ArrayList<DependencyResolutionRequest>();
            for (Map.Entry<String, Set<ResolverDefinition>> e : triggerableDependencies.entrySet()) {
                if (e.getValue().isEmpty()) continue;
                DependencyResolutionRequest dependencyResolutionRequest = new DependencyResolutionRequest(e.getKey(), e.getValue());
                resolverRequestList.add(dependencyResolutionRequest);
            }
            return ((MultiResolver)multiResolverOpt.get().logic()).resolve(resolverRequestList, inputs);
        }
        return ImmutableMap.of();
    }

    private @UnknownKeyFor @NonNull @Initialized ForwardBatch getForwardCommand(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        ForwardBatch forwardBatch = this.inputsValueCollector.get(dependantChain);
        if (forwardBatch == null) {
            throw new IllegalArgumentException("Missing Forward command. This should not be possible.");
        }
        return forwardBatch;
    }

    private void triggerDependency(@UnknownKeyFor @NonNull @Initialized String depName, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RequestId>, @UnknownKeyFor @NonNull @Initialized ResolverCommand> resolverCommandsByReq, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ResolverDefinition> resolverDefinitions) {
        KryonId depKryonId = (KryonId)this.kryonDefinition.dependencyKryons().get((Object)depName);
        if (depKryonId == null) {
            throw new AssertionError((Object)"This is a bug.");
        }
        LinkedHashMap<RequestId, Inputs> inputsByDepReq = new LinkedHashMap<RequestId, Inputs>();
        LinkedHashMap<RequestId, String> skipReasonsByReq = new LinkedHashMap<RequestId, String>();
        LinkedHashMap<RequestId, Set> depReqsByIncomingReq = new LinkedHashMap<RequestId, Set>();
        for (Map.Entry<Set<RequestId>, ResolverCommand> entry : resolverCommandsByReq.entrySet()) {
            Set<RequestId> incomingReqIds = entry.getKey();
            ResolverCommand resolverCommand = entry.getValue();
            if (resolverCommand instanceof ResolverCommand.SkipDependency) {
                ResolverCommand.SkipDependency skipDependency = (ResolverCommand.SkipDependency)resolverCommand;
                RequestId depReqId = this.requestIdGenerator.newSubRequest(incomingReqIds.iterator().next(), () -> "%s[skip]".formatted(depName));
                incomingReqIds.forEach(incomingReqId -> {
                    if (!depReqsByIncomingReq.containsKey(incomingReqId)) {
                        depReqsByIncomingReq.put((RequestId)incomingReqId, new LinkedHashSet());
                    }
                    ((Set)depReqsByIncomingReq.get(incomingReqId)).add(depReqId);
                });
                skipReasonsByReq.put(depReqId, skipDependency.reason());
                continue;
            }
            int count = 0;
            for (RequestId incomingReqId2 : incomingReqIds) {
                if (resolverCommand.getInputs().isEmpty()) {
                    RequestId depReqId = this.requestIdGenerator.newSubRequest(incomingReqId2, () -> "%s[skip]".formatted(depName));
                    skipReasonsByReq.put(depReqId, "Resolvers for dependency %s resolved to empty list".formatted(depName));
                    continue;
                }
                for (Inputs inputs : resolverCommand.getInputs()) {
                    int currentCount = count++;
                    RequestId depReqId = this.requestIdGenerator.newSubRequest(incomingReqId2, () -> "%s[%s]".formatted(depName, currentCount));
                    depReqsByIncomingReq.computeIfAbsent(incomingReqId2, _k -> new LinkedHashSet()).add(depReqId);
                    inputsByDepReq.put(depReqId, inputs);
                }
            }
        }
        this.executedDependencies.computeIfAbsent(dependantChain, _k -> new LinkedHashSet()).add(depName);
        CompletableFuture depResponse = this.kryonExecutor.executeCommand(new ForwardBatch(depKryonId, (ImmutableSet<String>)((ImmutableSet)resolverDefinitions.stream().map(ResolverDefinition::resolvedInputNames).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet())), (ImmutableMap<RequestId, Inputs>)ImmutableMap.copyOf(inputsByDepReq), dependantChain.extend(this.kryonId, depName), (ImmutableMap<RequestId, String>)ImmutableMap.copyOf(skipReasonsByReq)));
        depResponse.whenComplete((batchResponse, throwable) -> {
            LinkedHashSet requestIds = new LinkedHashSet();
            resolverCommandsByReq.keySet().forEach(requestIds::addAll);
            ImmutableMap results = (ImmutableMap)requestIds.stream().collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), requestId -> {
                if (throwable != null) {
                    return new Results(ImmutableMap.of((Object)Inputs.empty(), (Object)ValueOrError.withError((Throwable)throwable)));
                }
                Set depReqIds = depReqsByIncomingReq.getOrDefault(requestId, Set.of());
                return new Results((ImmutableMap)depReqIds.stream().collect(ImmutableMap.toImmutableMap(depReqId -> inputsByDepReq.getOrDefault(depReqId, Inputs.empty()), depReqId -> batchResponse.responses().getOrDefault(depReqId, (ValueOrError<Object>)ValueOrError.empty()))));
            }));
            KryonUtils.enqueueOrExecuteCommand(() -> new CallbackBatch(this.kryonId, depName, (ImmutableMap<RequestId, Results<Object>>)results, dependantChain), depKryonId, this.kryonDefinition, this.kryonExecutor);
        });
        this.flushDependencyIfNeeded(depName, dependantChain);
    }

    private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized BatchResponse>> executeMainLogicIfPossible(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        ForwardBatch forwardCommand = this.getForwardCommand(dependantChain);
        ImmutableSet<String> inputNames = this.kryonDefinition.getMainLogicDefinition().inputNames();
        if (this.availableInputsByDepChain.getOrDefault(dependantChain, (Set<String>)ImmutableSet.of()).containsAll((Collection<?>)inputNames)) {
            if (forwardCommand.shouldSkip()) {
                return Optional.of(CompletableFuture.failedFuture((Throwable)new SkippedExecutionException(BatchKryon.getSkipMessage(forwardCommand))));
            }
            return Optional.of(this.executeMainLogic((Set<RequestId>)forwardCommand.executableRequests().keySet(), dependantChain));
        }
        return Optional.empty();
    }

    private @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized BatchResponse> executeMainLogic(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RequestId> requestIds, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        MainLogicDefinition<Object> mainLogicDefinition = this.kryonDefinition.getMainLogicDefinition();
        LinkedHashMap<RequestId, MainLogicInputs> mainLogicInputs = new LinkedHashMap<RequestId, MainLogicInputs>();
        for (RequestId requestId : requestIds) {
            mainLogicInputs.put(requestId, this.getInputsForMainLogic(dependantChain, requestId));
        }
        CompletableFuture<BatchResponse> resultForBatch = new CompletableFuture<BatchResponse>();
        Map<RequestId, CompletableFuture<ValueOrError<Object>>> results = this.executeDecoratedMainLogic(mainLogicDefinition, mainLogicInputs, dependantChain);
        CompletableFuture.allOf((CompletableFuture[])results.values().toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> resultForBatch.complete(new BatchResponse((Map)mainLogicInputs.keySet().stream().collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), requestId -> results.getOrDefault(requestId, new CompletableFuture()).getNow(ValueOrError.empty()))))));
        this.mainLogicExecuted.put(dependantChain, true);
        this.flushDecoratorsIfNeeded(dependantChain);
        return resultForBatch;
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized ValueOrError<@UnknownKeyFor @NonNull @Initialized Object>>> executeDecoratedMainLogic(@UnknownKeyFor @NonNull @Initialized MainLogicDefinition<@UnknownKeyFor @NonNull @Initialized Object> mainLogicDefinition, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized MainLogicInputs> inputs, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        NavigableSet<MainLogicDecorator> sortedDecorators = this.getSortedDecorators(dependantChain);
        MainLogic logic = mainLogicDefinition::execute;
        for (MainLogicDecorator mainLogicDecorator : sortedDecorators) {
            logic = mainLogicDecorator.decorateLogic(logic, mainLogicDefinition);
        }
        MainLogic finalLogic = logic;
        LinkedHashMap<RequestId, CompletableFuture<ValueOrError<Object>>> resultsByRequest = new LinkedHashMap<RequestId, CompletableFuture<ValueOrError<Object>>>();
        inputs.forEach((requestId, mainLogicInputs) -> {
            @Nullable CompletableFuture cachedResult = this.resultsCache.get(mainLogicInputs.providedInputs());
            if (cachedResult == null) {
                cachedResult = (CompletableFuture)finalLogic.execute((ImmutableList<Inputs>)ImmutableList.of((Object)mainLogicInputs.allInputsAndDependencies())).values().iterator().next();
                this.resultsCache.put(mainLogicInputs.providedInputs(), cachedResult);
            }
            resultsByRequest.put((RequestId)requestId, (CompletableFuture<ValueOrError<Object>>)cachedResult.handle(ValueOrError::valueOrError));
        });
        return resultsByRequest;
    }

    private void flushAllDependenciesIfNeeded(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        this.kryonDefinition.dependencyKryons().keySet().forEach(dependencyName -> this.flushDependencyIfNeeded((String)dependencyName, dependantChain));
    }

    private void flushDependencyIfNeeded(@UnknownKeyFor @NonNull @Initialized String dependencyName, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        if (!this.flushedDependantChain.contains(dependantChain)) {
            return;
        }
        if (this.executedDependencies.getOrDefault(dependantChain, Set.of()).contains(dependencyName)) {
            this.kryonExecutor.executeCommand(new Flush(Optional.ofNullable((KryonId)this.kryonDefinition.dependencyKryons().get((Object)dependencyName)).orElseThrow(() -> new AssertionError((Object)("Could not find KryonId for dependency " + dependencyName + ". This is a bug"))), dependantChain.extend(this.kryonId, dependencyName)));
        }
    }

    private void flushDecoratorsIfNeeded(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        block6: {
            block5: {
                if (!this.flushedDependantChain.contains(dependantChain)) {
                    return;
                }
                if (this.mainLogicExecuted.getOrDefault(dependantChain, false).booleanValue()) break block5;
                if (!this.getForwardCommand(dependantChain).shouldSkip()) break block6;
            }
            Iterable reverseSortedDecorators = this.getSortedDecorators(dependantChain)::descendingIterator;
            for (MainLogicDecorator decorator : reverseSortedDecorators) {
                decorator.executeCommand(new FlushCommand(dependantChain));
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Inputs getInputsFor(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized RequestId requestId, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> boundFrom) {
        Inputs resolvableInputs = this.getResolvableInputs(dependantChain, requestId);
        Map depValues = this.dependencyValuesCollector.getOrDefault(dependantChain, Map.of());
        LinkedHashMap<String, InputValue> inputValues = new LinkedHashMap<String, InputValue>();
        for (String boundFromInput : boundFrom) {
            InputValue voe = (InputValue)resolvableInputs.values().get((Object)boundFromInput);
            if (voe == null) {
                CallbackBatch callbackBatch = (CallbackBatch)depValues.get(boundFromInput);
                if (callbackBatch == null) continue;
                inputValues.put(boundFromInput, (InputValue)callbackBatch.resultsByRequest().getOrDefault((Object)requestId, (Object)Results.empty()));
                continue;
            }
            inputValues.put(boundFromInput, voe);
        }
        return new Inputs(inputValues);
    }

    private @UnknownKeyFor @NonNull @Initialized Inputs getResolvableInputs(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized RequestId requestId) {
        ForwardBatch forwardBatch = this.inputsValueCollector.get(dependantChain);
        if (forwardBatch != null && forwardBatch.executableRequests().containsKey((Object)requestId)) {
            return (Inputs)forwardBatch.executableRequests().get((Object)requestId);
        }
        return Inputs.empty();
    }

    private @UnknownKeyFor @NonNull @Initialized MainLogicInputs getInputsForMainLogic(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized RequestId requestId) {
        ForwardBatch forwardBatch = this.inputsValueCollector.get(dependantChain);
        if (forwardBatch == null) {
            throw new AssertionError((Object)"Could not find forwardBatch. This is a bug.");
        }
        HashMap<String, Results> depValues = new HashMap<String, Results>();
        for (Map.Entry<String, CallbackBatch> entry : this.dependencyValuesCollector.getOrDefault(dependantChain, (Map<String, CallbackBatch>)ImmutableMap.of()).entrySet()) {
            String key = entry.getKey();
            CallbackBatch value = entry.getValue();
            depValues.put(key, (Results)value.resultsByRequest().getOrDefault((Object)requestId, (Object)Results.empty()));
        }
        Inputs inputValues = (Inputs)forwardBatch.executableRequests().getOrDefault((Object)requestId, (Object)Inputs.empty());
        Inputs allInputsAndDependencies = Inputs.union(depValues, (Map)inputValues.values());
        return new MainLogicInputs(inputValues, allInputsAndDependencies);
    }

    private void collectInputValues(@UnknownKeyFor @NonNull @Initialized ForwardBatch forwardBatch) {
        if (this.requestsByDependantChain.putIfAbsent(forwardBatch.dependantChain(), forwardBatch.requestIds()) != null) {
            throw new DuplicateRequestException("Duplicate batch request received for dependant chain %s".formatted(forwardBatch.dependantChain()));
        }
        ImmutableSet<String> inputNames = forwardBatch.inputNames();
        if (this.inputsValueCollector.get(forwardBatch.dependantChain()) != null) {
            throw new DuplicateRequestException("Duplicate data for inputs %s of kryon %s in dependant chain %s".formatted(inputNames, this.kryonId, forwardBatch.dependantChain()));
        }
        this.inputsValueCollector.put(forwardBatch.dependantChain(), forwardBatch);
        Sets.SetView resolvableInputNames = Sets.difference(this.kryonDefinition.getMainLogicDefinition().inputNames(), (Set)this.kryonDefinition.dependencyKryons().keySet());
        if (!inputNames.containsAll((Collection)resolvableInputNames)) {
            throw new IllegalArgumentException("Did not receive inputs " + Sets.difference((Set)resolvableInputNames, inputNames));
        }
        this.availableInputsByDepChain.computeIfAbsent(forwardBatch.dependantChain(), _k -> new LinkedHashSet()).addAll(inputNames);
    }

    private static @UnknownKeyFor @NonNull @Initialized String getSkipMessage(@UnknownKeyFor @NonNull @Initialized ForwardBatch forwardBatch) {
        return String.join((CharSequence)", ", (Iterable<? extends CharSequence>)forwardBatch.skippedRequests().values());
    }

    private void collectDependencyValues(@UnknownKeyFor @NonNull @Initialized CallbackBatch callbackBatch) {
        String dependencyName = callbackBatch.dependencyName();
        this.availableInputsByDepChain.computeIfAbsent(callbackBatch.dependantChain(), _k -> new LinkedHashSet()).add(dependencyName);
        if (this.dependencyValuesCollector.computeIfAbsent(callbackBatch.dependantChain(), k -> new LinkedHashMap()).putIfAbsent(dependencyName, callbackBatch) != null) {
            throw new DuplicateRequestException("Duplicate data for dependency %s of kryon %s in dependant chain %s".formatted(dependencyName, this.kryonId, callbackBatch.dependantChain()));
        }
    }
}

