/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.commands;

import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.krystex.commands.BatchCommand;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.model.DependantChain;
import com.flipkart.krystal.model.KryonId;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class ForwardBatch
extends Record
implements BatchCommand {
    private final @UnknownKeyFor @NonNull @Initialized KryonId kryonId;
    private final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> inputNames;
    private final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized Inputs> executableRequests;
    private final @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain;
    private final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized String> skippedRequests;

    public ForwardBatch(@UnknownKeyFor @NonNull @Initialized KryonId kryonId, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> inputNames, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized Inputs> executableRequests, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized String> skippedRequests) {
        this.kryonId = kryonId;
        this.inputNames = inputNames;
        this.executableRequests = executableRequests;
        this.dependantChain = dependantChain;
        this.skippedRequests = skippedRequests;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RequestId> requestIds() {
        return Sets.union((Set)this.executableRequests().keySet(), (Set)this.skippedRequests().keySet());
    }

    public @UnknownKeyFor @NonNull @Initialized boolean shouldSkip() {
        return this.executableRequests.isEmpty();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ForwardBatch.class, "kryonId;inputNames;executableRequests;dependantChain;skippedRequests", "kryonId", "inputNames", "executableRequests", "dependantChain", "skippedRequests"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ForwardBatch.class, "kryonId;inputNames;executableRequests;dependantChain;skippedRequests", "kryonId", "inputNames", "executableRequests", "dependantChain", "skippedRequests"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ForwardBatch.class, "kryonId;inputNames;executableRequests;dependantChain;skippedRequests", "kryonId", "inputNames", "executableRequests", "dependantChain", "skippedRequests"}, this, o);
    }

    @Override
    public KryonId kryonId() {
        return this.kryonId;
    }

    public ImmutableSet<String> inputNames() {
        return this.inputNames;
    }

    public ImmutableMap<RequestId, Inputs> executableRequests() {
        return this.executableRequests;
    }

    @Override
    public DependantChain dependantChain() {
        return this.dependantChain;
    }

    public ImmutableMap<RequestId, String> skippedRequests() {
        return this.skippedRequests;
    }
}

