/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.decorators.observability;

import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.krystex.decorators.observability.KryonExecutionReport;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.model.KryonId;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultKryonExecutionReport
implements KryonExecutionReport {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(DefaultKryonExecutionReport.class);
    private final @UnknownKeyFor @NonNull @Initialized Instant startTime;
    private final @UnknownKeyFor @NonNull @Initialized boolean verbose;
    private final @UnknownKeyFor @NonNull @Initialized Clock clock;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized KryonExecution, @UnknownKeyFor @NonNull @Initialized LogicExecInfo> mainLogicExecInfos = new LinkedHashMap<KryonExecution, LogicExecInfo>();

    public DefaultKryonExecutionReport(@UnknownKeyFor @NonNull @Initialized Clock clock) {
        this(clock, false);
    }

    public DefaultKryonExecutionReport(@UnknownKeyFor @NonNull @Initialized Clock clock, @UnknownKeyFor @NonNull @Initialized boolean verbose) {
        this.clock = clock;
        this.startTime = clock.instant();
        this.verbose = verbose;
    }

    @Override
    public void reportMainLogicStart(@UnknownKeyFor @NonNull @Initialized KryonId kryonId, @UnknownKeyFor @NonNull @Initialized KryonLogicId kryonLogicId, @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized Inputs> inputs) {
        KryonExecution kryonExecution = new KryonExecution(kryonId, (ImmutableList<ImmutableMap<String, Object>>)((ImmutableList)inputs.stream().map(this::extractAndConvertInputs).collect(ImmutableList.toImmutableList())));
        if (this.mainLogicExecInfos.containsKey(kryonExecution)) {
            log.error("Cannot start the same kryon execution multiple times: {}", (Object)kryonExecution);
            return;
        }
        this.mainLogicExecInfos.put(kryonExecution, new LogicExecInfo(this, kryonId, (ImmutableCollection<Inputs>)inputs, this.startTime.until(this.clock.instant(), ChronoUnit.MILLIS)));
    }

    @Override
    public void reportMainLogicEnd(@UnknownKeyFor @NonNull @Initialized KryonId kryonId, @UnknownKeyFor @NonNull @Initialized KryonLogicId kryonLogicId, @UnknownKeyFor @NonNull @Initialized Results<@UnknownKeyFor @NonNull @Initialized Object> result) {
        KryonExecution kryonExecution = new KryonExecution(kryonId, (ImmutableList<ImmutableMap<String, Object>>)((ImmutableList)result.values().keySet().stream().map(this::extractAndConvertInputs).collect(ImmutableList.toImmutableList())));
        LogicExecInfo logicExecInfo = this.mainLogicExecInfos.get(kryonExecution);
        if (logicExecInfo == null) {
            log.error("'reportMainLogicEnd' called without calling 'reportMainLogicStart' first for: {}", (Object)kryonExecution);
            return;
        }
        if (logicExecInfo.getResult() != null) {
            log.error("Cannot end the same kryon execution multiple times: {}", (Object)kryonExecution);
            return;
        }
        logicExecInfo.endTimeMs = this.startTime.until(this.clock.instant(), ChronoUnit.MILLIS);
        logicExecInfo.setResult(this.convertResult(result));
    }

    private @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> extractAndConvertInputs(@UnknownKeyFor @NonNull @Initialized Inputs inputs) {
        LinkedHashMap<String, Object> inputMap = new LinkedHashMap<String, Object>();
        for (Map.Entry e : inputs.values().entrySet()) {
            Object collect;
            InputValue value = (InputValue)e.getValue();
            if (!(value instanceof ValueOrError) || (collect = this.convertValueOrError((ValueOrError<Object>)((ValueOrError)value))) == null) continue;
            inputMap.put((String)e.getKey(), collect);
        }
        return ImmutableMap.copyOf(inputMap);
    }

    private @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> extractAndConvertDependencyResults(@UnknownKeyFor @NonNull @Initialized Inputs inputs) {
        LinkedHashMap<String, Map<ImmutableMap<String, Object>, Object>> inputMap = new LinkedHashMap<String, Map<ImmutableMap<String, Object>, Object>>();
        for (Map.Entry e : inputs.values().entrySet()) {
            InputValue value = (InputValue)e.getValue();
            if (!(value instanceof Results)) continue;
            Map<ImmutableMap<String, Object>, Object> collect = this.convertResult((Results<Object>)((Results)value));
            inputMap.put((String)e.getKey(), collect);
        }
        return ImmutableMap.copyOf(inputMap);
    }

    private @UnknownKeyFor @NonNull @Initialized Object convertValueOrError(@UnknownKeyFor @NonNull @Initialized ValueOrError<@UnknownKeyFor @NonNull @Initialized Object> voe) {
        if (voe.error().isPresent()) {
            Throwable throwable = (Throwable)voe.error().get();
            return this.verbose ? Throwables.getStackTraceAsString((Throwable)throwable) : throwable.toString();
        }
        return voe.value().orElse("null");
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>, @UnknownKeyFor @NonNull @Initialized Object> convertResult(@UnknownKeyFor @NonNull @Initialized Results<@UnknownKeyFor @NonNull @Initialized Object> results) {
        return results.values().entrySet().stream().collect(Collectors.toMap(e -> this.extractAndConvertInputs((Inputs)e.getKey()), e -> this.convertValueOrError((ValueOrError<Object>)((ValueOrError)e.getValue()))));
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "DefaultKryonExecutionReport(startTime=" + this.getStartTime() + ", verbose=" + this.verbose + ", clock=" + this.clock + ", mainLogicExecInfos=" + this.getMainLogicExecInfos() + ")";
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getStartTime() {
        return this.startTime;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized KryonExecution, @UnknownKeyFor @NonNull @Initialized LogicExecInfo> getMainLogicExecInfos() {
        return this.mainLogicExecInfos;
    }

    private record KryonExecution(@UnknownKeyFor @NonNull @Initialized KryonId kryonId, @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> inputs) {
        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "%s(%s)".formatted(this.kryonId.value(), this.inputs);
        }
    }

    static final class LogicExecInfo {
        private final @UnknownKeyFor @NonNull @Initialized String kryonId;
        private final @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> inputsList;
        private final @Nullable @UnknownKeyFor @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> dependencyResults;
        private @Nullable @UnknownKeyFor @Initialized Object result;
        private final @UnknownKeyFor @NonNull @Initialized long startTimeMs;
        private @UnknownKeyFor @NonNull @Initialized long endTimeMs;

        LogicExecInfo(@UnknownKeyFor @NonNull @Initialized DefaultKryonExecutionReport kryonExecutionReport, @UnknownKeyFor @NonNull @Initialized KryonId kryonId, @UnknownKeyFor @NonNull @Initialized ImmutableCollection<@UnknownKeyFor @NonNull @Initialized Inputs> inputList, @UnknownKeyFor @NonNull @Initialized long startTimeMs) {
            this.startTimeMs = startTimeMs;
            this.kryonId = kryonId.value();
            this.inputsList = (ImmutableList)inputList.stream().map(kryonExecutionReport::extractAndConvertInputs).collect(ImmutableList.toImmutableList());
            ImmutableList dependencyResults = (ImmutableList)inputList.stream().map(kryonExecutionReport::extractAndConvertDependencyResults).filter(map -> !map.isEmpty()).collect(ImmutableList.toImmutableList());
            this.dependencyResults = dependencyResults.isEmpty() ? null : dependencyResults;
        }

        public void setResult(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>, @UnknownKeyFor @NonNull @Initialized Object> result) {
            this.result = this.inputsList.size() <= 1 && result.size() == 1 ? result.values().iterator().next() : result;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "DefaultKryonExecutionReport.LogicExecInfo(kryonId=" + this.getKryonId() + ", inputsList=" + this.getInputsList() + ", dependencyResults=" + this.getDependencyResults() + ", result=" + this.getResult() + ", startTimeMs=" + this.getStartTimeMs() + ", endTimeMs=" + this.getEndTimeMs() + ")";
        }

        public @UnknownKeyFor @NonNull @Initialized String getKryonId() {
            return this.kryonId;
        }

        public @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> getInputsList() {
            return this.inputsList;
        }

        public @Nullable @UnknownKeyFor @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> getDependencyResults() {
            return this.dependencyResults;
        }

        public @Nullable @UnknownKeyFor @Initialized Object getResult() {
            return this.result;
        }

        public @UnknownKeyFor @NonNull @Initialized long getStartTimeMs() {
            return this.startTimeMs;
        }

        public @UnknownKeyFor @NonNull @Initialized long getEndTimeMs() {
            return this.endTimeMs;
        }
    }
}

