/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.decorators.resilience4j;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.decorators.resilience4j.R4JUtils;
import com.google.common.collect.ImmutableList;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerStateMachine;
import java.util.Optional;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class Resilience4JCircuitBreaker
implements MainLogicDecorator {
    public static final @UnknownKeyFor @NonNull @Initialized String DECORATOR_TYPE = Resilience4JCircuitBreaker.class.getName();
    private final @UnknownKeyFor @NonNull @Initialized String instanceId;
    private @Nullable @UnknownKeyFor @Initialized CircuitBreaker circuitBreaker;

    public Resilience4JCircuitBreaker(@UnknownKeyFor @NonNull @Initialized String instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MainLogic<@UnknownKeyFor @NonNull @Initialized Object> decorateLogic(@UnknownKeyFor @NonNull @Initialized MainLogic<@UnknownKeyFor @NonNull @Initialized Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized MainLogicDefinition<@UnknownKeyFor @NonNull @Initialized Object> originalLogicDefinition) {
        CircuitBreaker circuitBreaker = this.circuitBreaker;
        if (circuitBreaker != null) {
            return inputsList -> R4JUtils.extractResponseMap((ImmutableList<Inputs>)inputsList, R4JUtils.decorateAsyncExecute(logicToDecorate, (ImmutableList<Inputs>)inputsList).withCircuitBreaker(circuitBreaker).get());
        }
        return logicToDecorate;
    }

    public void onConfigUpdate(@UnknownKeyFor @NonNull @Initialized ConfigProvider configProvider) {
        this.updateCircuitBreaker(configProvider);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getId() {
        return this.instanceId;
    }

    private void init(@UnknownKeyFor @NonNull @Initialized ConfigProvider configProvider) {
        this.circuitBreaker = this.getCircuitBreakerConfig(configProvider).map(config -> new CircuitBreakerStateMachine(this.instanceId + ".circuit_breaker", config)).orElse(null);
    }

    private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized CircuitBreakerConfig> getCircuitBreakerConfig(@UnknownKeyFor @NonNull @Initialized ConfigProvider configProvider) {
        boolean circuitBreakerDisabled;
        boolean bl = circuitBreakerDisabled = configProvider.getConfig(this.instanceId + ".circuit_breaker.enabled").orElse(true) == false;
        if (circuitBreakerDisabled) {
            return Optional.empty();
        }
        return Optional.of(CircuitBreakerConfig.ofDefaults());
    }

    private void updateCircuitBreaker(@UnknownKeyFor @NonNull @Initialized ConfigProvider configProvider) {
        CircuitBreaker circuitBreaker = this.circuitBreaker;
        Optional<CircuitBreakerConfig> newConfig = this.getCircuitBreakerConfig(configProvider);
        if (!Optional.ofNullable(circuitBreaker).map(CircuitBreaker::getCircuitBreakerConfig).equals(newConfig)) {
            this.init(configProvider);
        }
    }
}

