/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.krystex.ComputeLogicDefinition;
import com.flipkart.krystal.krystex.IOLogicDefinition;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.krystex.resolution.ResolverDefinition;
import com.flipkart.krystal.model.KryonId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class KryonUtils {
    static void enqueueOrExecuteCommand(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized KryonCommand> commandGenerator, @UnknownKeyFor @NonNull @Initialized KryonId depKryonId, @UnknownKeyFor @NonNull @Initialized KryonDefinition kryonDefinition, @UnknownKeyFor @NonNull @Initialized KryonExecutor kryonExecutor) {
        MainLogicDefinition depMainLogic = kryonDefinition.kryonDefinitionRegistry().get(depKryonId).getMainLogicDefinition();
        if (depMainLogic instanceof IOLogicDefinition) {
            kryonExecutor.enqueueKryonCommand(commandGenerator);
        } else if (depMainLogic instanceof ComputeLogicDefinition) {
            kryonExecutor.executeCommand(commandGenerator.get());
        } else {
            throw new UnsupportedOperationException("Unknown logicDefinition type %s".formatted(depMainLogic.getClass()));
        }
    }

    static @UnknownKeyFor @NonNull @Initialized KryonDefinition.KryonDefinitionView toView(@UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ResolverDefinition> resolverDefinitions, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized KryonId> dependencyKryons) {
        ImmutableMap resolverDefinitionsByDependencies = ImmutableMap.copyOf(resolverDefinitions.stream().collect(Collectors.groupingBy(ResolverDefinition::dependencyName, ImmutableSet.toImmutableSet())));
        ImmutableSet dependenciesWithNoResolvers = (ImmutableSet)dependencyKryons.keySet().stream().filter(depName -> ((ImmutableSet)resolverDefinitionsByDependencies.getOrDefault(depName, (Object)ImmutableSet.of())).isEmpty()).collect(ImmutableSet.toImmutableSet());
        return new KryonDefinition.KryonDefinitionView(KryonUtils.createResolverDefinitionsByInputs(resolverDefinitions), (ImmutableMap<String, ImmutableSet<ResolverDefinition>>)resolverDefinitionsByDependencies, (ImmutableSet<String>)dependenciesWithNoResolvers);
    }

    private static @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> createResolverDefinitionsByInputs(@UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ResolverDefinition> resolverDefinitions) {
        LinkedHashMap resolverDefinitionsByInput = new LinkedHashMap();
        resolverDefinitions.forEach(resolverDefinition -> {
            if (!resolverDefinition.boundFrom().isEmpty()) {
                resolverDefinition.boundFrom().forEach(input -> resolverDefinitionsByInput.computeIfAbsent(Optional.of(input), s -> ImmutableSet.builder()).add(resolverDefinition));
            } else {
                resolverDefinitionsByInput.computeIfAbsent(Optional.empty(), s -> ImmutableSet.builder()).add(resolverDefinition);
            }
        });
        return (ImmutableMap)resolverDefinitionsByInput.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((ImmutableSet.Builder)e.getValue()).build()));
    }

    private KryonUtils() {
    }
}

