/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.krystex.LogicDefinition;
import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.logicdecoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.logicdecoration.MainLogicDecoratorConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MainLogicDefinition<@UnknownKeyFor T>
extends LogicDefinition<MainLogic<T>> {
    private @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MainLogicDecoratorConfig>> requestScopedLogicDecoratorConfigs = ImmutableMap.of();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MainLogicDecoratorConfig> sessionScopedLogicDecoratorConfigs = new HashMap<String, MainLogicDecoratorConfig>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MainLogicDecorator>> sessionScopedDecorators = new LinkedHashMap<String, Map<String, MainLogicDecorator>>();

    protected MainLogicDefinition(@UnknownKeyFor @NonNull @Initialized KryonLogicId kryonLogicId, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> inputs, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Tag> logicTags, @UnknownKeyFor @NonNull @Initialized MainLogic<T> mainLogic) {
        super(kryonLogicId, inputs, logicTags, mainLogic);
    }

    public final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Inputs, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable T>> execute(@UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized Inputs> inputs) {
        return ((MainLogic)this.logic()).execute(inputs);
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MainLogicDecorator> getSessionScopedLogicDecorators(@UnknownKeyFor @NonNull @Initialized KryonDefinition kryonDefinition, @UnknownKeyFor @NonNull @Initialized DependantChain dependants) {
        LinkedHashMap decorators = new LinkedHashMap();
        this.sessionScopedLogicDecoratorConfigs.forEach((s, decoratorConfig) -> {
            LogicExecutionContext logicExecutionContext = new LogicExecutionContext(kryonDefinition.kryonId(), this.logicTags(), dependants, kryonDefinition.kryonDefinitionRegistry());
            String instanceId = decoratorConfig.instanceIdGenerator().apply(logicExecutionContext);
            if (decoratorConfig.shouldDecorate().test(logicExecutionContext)) {
                decorators.put(s, this.sessionScopedDecorators.computeIfAbsent((String)s, k -> new LinkedHashMap()).computeIfAbsent(instanceId, k -> decoratorConfig.factory().apply(new MainLogicDecoratorConfig.DecoratorContext(instanceId, logicExecutionContext))));
            }
        });
        return ImmutableMap.copyOf(decorators);
    }

    public void registerRequestScopedDecorator(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized MainLogicDecoratorConfig> decoratorConfigs) {
        this.requestScopedLogicDecoratorConfigs = ImmutableMap.builderWithExpectedSize((int)(this.requestScopedLogicDecoratorConfigs.size() + decoratorConfigs.size())).putAll(this.requestScopedLogicDecoratorConfigs).putAll(this.getDecoratorConfigMap(decoratorConfigs)).build();
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MainLogicDecoratorConfig>> getDecoratorConfigMap(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized MainLogicDecoratorConfig> decoratorConfigs) {
        HashMap<String, List<MainLogicDecoratorConfig>> decoratorConfigMap = new HashMap<String, List<MainLogicDecoratorConfig>>();
        for (MainLogicDecoratorConfig mainLogicDecoratorConfig : decoratorConfigs) {
            decoratorConfigMap.putIfAbsent(mainLogicDecoratorConfig.decoratorType(), new ArrayList());
            ((List)decoratorConfigMap.get(mainLogicDecoratorConfig.decoratorType())).add(mainLogicDecoratorConfig);
        }
        return decoratorConfigMap;
    }

    public void registerSessionScopedLogicDecorator(@UnknownKeyFor @NonNull @Initialized MainLogicDecoratorConfig decoratorConfig) {
        this.sessionScopedLogicDecoratorConfigs.put(decoratorConfig.decoratorType(), decoratorConfig);
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MainLogicDecoratorConfig>> getRequestScopedLogicDecoratorConfigs() {
        return this.requestScopedLogicDecoratorConfigs;
    }
}

