/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.logicdecorators.resilience4j;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.logicdecoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.logicdecorators.resilience4j.R4JUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.decorators.Decorators;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class Resilience4JBulkhead
implements MainLogicDecorator {
    public static final @UnknownKeyFor @NonNull @Initialized String DECORATOR_TYPE = Resilience4JBulkhead.class.getName();
    private final @UnknownKeyFor @NonNull @Initialized String instanceId;
    private @UnknownKeyFor @NonNull @Initialized Resilience4JBulkhead. @Nullable @UnknownKeyFor @Initialized BulkheadAdapter adaptedBulkhead;

    public Resilience4JBulkhead(@UnknownKeyFor @NonNull @Initialized String instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MainLogic<@UnknownKeyFor @NonNull @Initialized Object> decorateLogic(@UnknownKeyFor @NonNull @Initialized MainLogic<@UnknownKeyFor @NonNull @Initialized Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized MainLogicDefinition<@UnknownKeyFor @NonNull @Initialized Object> originalLogicDefinition) {
        BulkheadAdapter bulkhead = this.adaptedBulkhead;
        if (bulkhead != null) {
            return inputsList -> R4JUtils.extractResponseMap((ImmutableList<Inputs>)inputsList, bulkhead.decorate(logicToDecorate, (ImmutableList<Inputs>)inputsList));
        }
        return logicToDecorate;
    }

    public void onConfigUpdate(@UnknownKeyFor @NonNull @Initialized ConfigProvider configProvider) {
        this.updateBulkhead(configProvider);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getId() {
        return this.instanceId;
    }

    private void updateBulkhead(@UnknownKeyFor @NonNull @Initialized ConfigProvider configProvider) {
        Optional<BulkheadAdapterConfig> newBulkheadConfig = this.getBulkheadConfig(configProvider);
        if (newBulkheadConfig.isPresent()) {
            BulkheadAdapter bulkhead = this.adaptedBulkhead;
            if (bulkhead == null) {
                this.adaptedBulkhead = new BulkheadAdapter(newBulkheadConfig.get());
            } else {
                bulkhead.changeConfig(newBulkheadConfig.get());
            }
        } else {
            this.adaptedBulkhead = null;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized BulkheadAdapterConfig> getBulkheadConfig(@UnknownKeyFor @NonNull @Initialized ConfigProvider configProvider) {
        boolean bulkheadEnabled = configProvider.getConfig(this.instanceId + ".bulkhead.enabled").orElse(true);
        if (!bulkheadEnabled) {
            return Optional.empty();
        }
        BulkheadType bulkheadType = configProvider.getConfig(this.instanceId + ".bulkhead.type").map(BulkheadType::valueOf).orElse(BulkheadType.SEMAPHORE);
        Optional maxConcurrency = configProvider.getConfig(this.instanceId + ".bulkhead.max_concurrency");
        switch (bulkheadType) {
            case SEMAPHORE: {
                BulkheadConfig.Builder builder = BulkheadConfig.custom().writableStackTraceEnabled(false);
                maxConcurrency.ifPresent(arg_0 -> ((BulkheadConfig.Builder)builder).maxConcurrentCalls(arg_0));
                return Optional.of(new BulkheadAdapterConfig(builder.build()));
            }
            case THREADPOOL: {
                ThreadPoolBulkheadConfig.Builder builder = ThreadPoolBulkheadConfig.custom().writableStackTraceEnabled(false).queueCapacity(0);
                maxConcurrency.ifPresent(arg_0 -> ((ThreadPoolBulkheadConfig.Builder)builder).maxThreadPoolSize(arg_0));
                maxConcurrency.ifPresent(arg_0 -> ((ThreadPoolBulkheadConfig.Builder)builder).coreThreadPoolSize(arg_0));
                return Optional.of(new BulkheadAdapterConfig(builder.build()));
            }
        }
        return Optional.empty();
    }

    private @UnknownKeyFor @NonNull @Initialized String getBulkheadId() {
        return this.instanceId + ".bulkhead";
    }

    private final class BulkheadAdapter {
        private @Nullable @UnknownKeyFor @Initialized Bulkhead bulkhead;
        private @Nullable @UnknownKeyFor @Initialized ThreadPoolBulkhead threadPoolBulkhead;

        private BulkheadAdapter(BulkheadAdapterConfig config) {
            BulkheadConfig bulkheadConfig = config.bulkheadConfig();
            if (bulkheadConfig != null) {
                this.bulkhead = Bulkhead.of((String)Resilience4JBulkhead.this.getBulkheadId(), (BulkheadConfig)bulkheadConfig);
            } else {
                ThreadPoolBulkheadConfig threadPoolBulkheadConfig = config.threadPoolBulkheadConfig();
                if (threadPoolBulkheadConfig != null) {
                    this.threadPoolBulkhead = BulkheadAdapter.newThreadPoolBulkhead(threadPoolBulkheadConfig, Resilience4JBulkhead.this.getBulkheadId());
                } else {
                    throw new IllegalArgumentException("Either bulkheadConfig or threadPoolBulkheadConfig must be non-null");
                }
            }
        }

        private void changeConfig(@UnknownKeyFor @NonNull @Initialized BulkheadAdapterConfig config) {
            Bulkhead localBulkHead = this.bulkhead;
            if (config.bulkheadConfig() != null && localBulkHead != null && !config.bulkheadConfig().equals(localBulkHead.getBulkheadConfig())) {
                localBulkHead.changeConfig(config.bulkheadConfig());
            } else {
                ThreadPoolBulkhead localTPBulkhead = this.threadPoolBulkhead;
                if (config.threadPoolBulkheadConfig() != null && localTPBulkhead != null && !config.threadPoolBulkheadConfig().equals(localTPBulkhead.getBulkheadConfig())) {
                    this.threadPoolBulkhead = BulkheadAdapter.newThreadPoolBulkhead(config.threadPoolBulkheadConfig(), Resilience4JBulkhead.this.getBulkheadId());
                }
            }
        }

        @UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Inputs, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable @UnknownKeyFor @Initialized Object>>> decorate(@UnknownKeyFor @NonNull @Initialized MainLogic<@UnknownKeyFor @NonNull @Initialized Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized Inputs> inputsList) {
            ThreadPoolBulkhead threadPoolBulkhead = this.threadPoolBulkhead;
            Bulkhead bulkhead = this.bulkhead;
            if (threadPoolBulkhead != null) {
                return threadPoolBulkhead.executeCallable(() -> logicToDecorate.execute(inputsList));
            }
            if (bulkhead != null) {
                return Decorators.ofCompletionStage(() -> {
                    ImmutableMap<Inputs, CompletableFuture<@Nullable T>> result = logicToDecorate.execute(inputsList);
                    return CompletableFuture.allOf((CompletableFuture[])result.values().toArray(CompletableFuture[]::new)).handle((unused, throwable) -> result);
                }).withBulkhead(bulkhead).get();
            }
            throw new IllegalStateException("Either bulkheadConfig or threadPoolBulkheadConfig must be non-null");
        }

        private static @UnknownKeyFor @NonNull @Initialized ThreadPoolBulkhead newThreadPoolBulkhead(@UnknownKeyFor @NonNull @Initialized ThreadPoolBulkheadConfig config, @UnknownKeyFor @NonNull @Initialized String bulkheadId) {
            return ThreadPoolBulkhead.of((String)bulkheadId, (ThreadPoolBulkheadConfig)config);
        }
    }

    private record BulkheadAdapterConfig(@Nullable @UnknownKeyFor @Initialized BulkheadConfig bulkheadConfig, @Nullable @UnknownKeyFor @Initialized ThreadPoolBulkheadConfig threadPoolBulkheadConfig) {
        BulkheadAdapterConfig(@Nullable @UnknownKeyFor @Initialized BulkheadConfig bulkheadConfig, @Nullable @UnknownKeyFor @Initialized ThreadPoolBulkheadConfig threadPoolBulkheadConfig) {
            Preconditions.checkArgument((bulkheadConfig == null || threadPoolBulkheadConfig == null ? 1 : 0) != 0);
            Preconditions.checkArgument((bulkheadConfig != null || threadPoolBulkheadConfig != null ? 1 : 0) != 0);
        }

        private BulkheadAdapterConfig(@UnknownKeyFor @NonNull @Initialized BulkheadConfig bulkheadConfig) {
            this(bulkheadConfig, null);
        }

        private BulkheadAdapterConfig(@UnknownKeyFor @NonNull @Initialized ThreadPoolBulkheadConfig threadPoolBulkheadConfig) {
            this(null, threadPoolBulkheadConfig);
        }
    }

    private static enum BulkheadType {
        THREADPOOL,
        SEMAPHORE;

    }
}

