/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.krystex.LogicDefinitionRegistry;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.kryon.DependantChainStart;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.resolution.ResolverDefinition;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class KryonDefinitionRegistry {
    private final @UnknownKeyFor @NonNull @Initialized LogicDefinitionRegistry logicDefinitionRegistry;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized KryonId, @UnknownKeyFor @NonNull @Initialized KryonDefinition> kryonDefinitions = new LinkedHashMap<KryonId, KryonDefinition>();
    private final @UnknownKeyFor @NonNull @Initialized DependantChainStart dependantChainStart = new DependantChainStart();

    public KryonDefinitionRegistry(@UnknownKeyFor @NonNull @Initialized LogicDefinitionRegistry logicDefinitionRegistry) {
        this.logicDefinitionRegistry = logicDefinitionRegistry;
    }

    public @UnknownKeyFor @NonNull @Initialized LogicDefinitionRegistry logicDefinitionRegistry() {
        return this.logicDefinitionRegistry;
    }

    public @UnknownKeyFor @NonNull @Initialized KryonDefinition get(@UnknownKeyFor @NonNull @Initialized KryonId kryonId) {
        KryonDefinition kryon = this.kryonDefinitions.get(kryonId);
        if (kryon == null) {
            throw new IllegalArgumentException("No Kryon with id %s found".formatted(kryonId));
        }
        return kryon;
    }

    public @UnknownKeyFor @NonNull @Initialized KryonDefinition newKryonDefinition(@UnknownKeyFor @NonNull @Initialized String kryonId, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> inputs, @UnknownKeyFor @NonNull @Initialized KryonLogicId outputLogicId) {
        return this.newKryonDefinition(kryonId, inputs, outputLogicId, (ImmutableMap<String, KryonId>)ImmutableMap.of());
    }

    public @UnknownKeyFor @NonNull @Initialized KryonDefinition newKryonDefinition(@UnknownKeyFor @NonNull @Initialized String kryonId, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> inputs, @UnknownKeyFor @NonNull @Initialized KryonLogicId outputLogicId, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized KryonId> dependencyKryons) {
        return this.newKryonDefinition(kryonId, inputs, outputLogicId, dependencyKryons, (ImmutableList<ResolverDefinition>)ImmutableList.of(), null);
    }

    public @UnknownKeyFor @NonNull @Initialized KryonDefinition newKryonDefinition(@UnknownKeyFor @NonNull @Initialized String kryonId, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> inputs, @UnknownKeyFor @NonNull @Initialized KryonLogicId outputLogicId, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized KryonId> dependencyKryons, @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ResolverDefinition> resolverDefinitions, @Nullable @UnknownKeyFor @Initialized KryonLogicId mulitResolverId) {
        if (!resolverDefinitions.isEmpty() && mulitResolverId == null) {
            throw new IllegalArgumentException("missing multi resolver logic");
        }
        KryonDefinition kryonDefinition = new KryonDefinition(new KryonId(kryonId), inputs, outputLogicId, dependencyKryons, resolverDefinitions, Optional.ofNullable(mulitResolverId), this);
        this.kryonDefinitions.put(kryonDefinition.kryonId(), kryonDefinition);
        return kryonDefinition;
    }

    public @UnknownKeyFor @NonNull @Initialized DependantChain getDependantChainsStart() {
        return this.dependantChainStart;
    }
}

