/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.caching;

import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.Facets;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.krystex.caching.CacheKey;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardBatch;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonResponse;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorationInput;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorator;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.utils.Futures;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLevelCache
implements KryonDecorator {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(RequestLevelCache.class);
    public static final @UnknownKeyFor @NonNull @Initialized String DECORATOR_TYPE = RequestLevelCache.class.getName();
    private static final @UnknownKeyFor @NonNull @Initialized Errable<@UnknownKeyFor @NonNull @Initialized Object> UNKNOWN_ERROR = Errable.withError((Throwable)new StackTracelessException("Unknown error in request cache"));
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized CacheKey, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable @UnknownKeyFor @Initialized Object>> cache = new LinkedHashMap<CacheKey, CompletableFuture<Object>>();

    @Override
    public @UnknownKeyFor @NonNull @Initialized Kryon<@UnknownKeyFor @NonNull @Initialized KryonCommand, @UnknownKeyFor @NonNull @Initialized KryonResponse> decorateKryon(@UnknownKeyFor @NonNull @Initialized KryonDecorationInput decorationInput) {
        return new CachingDecoratedKryon(decorationInput.kryon());
    }

    public void primeCache(@UnknownKeyFor @NonNull @Initialized String kryonId, @UnknownKeyFor @NonNull @Initialized Facets request, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable @UnknownKeyFor @Initialized Object> data) {
        this.cache.put(new CacheKey(new KryonId(kryonId), request), data);
    }

    private class CachingDecoratedKryon
    implements Kryon<KryonCommand, KryonResponse> {
        private final @UnknownKeyFor @NonNull @Initialized Kryon<@UnknownKeyFor @NonNull @Initialized KryonCommand, @UnknownKeyFor @NonNull @Initialized KryonResponse> kryon;

        private CachingDecoratedKryon(Kryon<KryonCommand, KryonResponse> kryon) {
            this.kryon = kryon;
        }

        @Override
        public void executeCommand(@UnknownKeyFor @NonNull @Initialized Flush flushCommand) {
            this.kryon.executeCommand(flushCommand);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized KryonDefinition getKryonDefinition() {
            return this.kryon.getKryonDefinition();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized KryonResponse> executeCommand(@UnknownKeyFor @NonNull @Initialized KryonCommand kryonCommand) {
            if (kryonCommand instanceof ForwardBatch) {
                ForwardBatch forwardBatch = (ForwardBatch)kryonCommand;
                return this.readFromCache(this.kryon, forwardBatch);
            }
            log.warn("Request Level cache only supports ForwardBatch command. Found {}", (Object)kryonCommand);
            return this.kryon.executeCommand(kryonCommand);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized KryonResponse> readFromCache(@UnknownKeyFor @NonNull @Initialized Kryon<@UnknownKeyFor @NonNull @Initialized KryonCommand, @UnknownKeyFor @NonNull @Initialized KryonResponse> kryon, @UnknownKeyFor @NonNull @Initialized ForwardBatch forwardBatch) {
            ImmutableMap<RequestId, Facets> executableRequests = forwardBatch.executableRequests();
            LinkedHashMap cacheMisses = new LinkedHashMap();
            LinkedHashMap<RequestId, @Nullable CompletableFuture> cacheHits = new LinkedHashMap<RequestId, CompletableFuture>();
            LinkedHashMap<K, @Nullable V> newCacheEntries = new LinkedHashMap();
            executableRequests.forEach((requestId, facets) -> {
                CacheKey cacheKey = new CacheKey(kryon.getKryonDefinition().kryonId(), (Facets)facets);
                CompletableFuture<Object> cachedFuture = RequestLevelCache.this.cache.get(cacheKey);
                if (cachedFuture == null) {
                    CompletableFuture placeHolderFuture = new CompletableFuture();
                    newCacheEntries.put(requestId, placeHolderFuture);
                    RequestLevelCache.this.cache.put(cacheKey, placeHolderFuture);
                    cacheMisses.put(requestId, facets);
                } else {
                    cacheHits.put((RequestId)requestId, cachedFuture);
                }
            });
            LinkedHashMap<RequestId, String> skippedRequests = new LinkedHashMap<RequestId, String>((Map<RequestId, String>)forwardBatch.skippedRequests());
            cacheHits.forEach((requestId, _f) -> skippedRequests.put((RequestId)requestId, "Skipping due to cache hit!"));
            CompletableFuture<KryonResponse> cacheMissesResponse = kryon.executeCommand(new ForwardBatch(forwardBatch.kryonId(), forwardBatch.inputNames(), (ImmutableMap<RequestId, Facets>)ImmutableMap.copyOf(cacheMisses), forwardBatch.dependantChain(), (ImmutableMap<RequestId, String>)ImmutableMap.copyOf(skippedRequests)));
            cacheMissesResponse.whenComplete((kryonResponse, throwable) -> {
                if (kryonResponse instanceof BatchResponse) {
                    BatchResponse batchResponse = (BatchResponse)kryonResponse;
                    ImmutableMap<RequestId, Errable<Object>> responses = batchResponse.responses();
                    responses.forEach((requestId, response) -> {
                        @Nullable CompletableFuture future = response.toFuture();
                        @Nullable CompletableFuture destinationFuture = newCacheEntries.computeIfAbsent(requestId, _r -> new CompletableFuture());
                        Futures.linkFutures((CompletableFuture)future, (CompletableFuture)destinationFuture);
                    });
                } else if (throwable != null) {
                    cacheMisses.forEach((requestId, response) -> newCacheEntries.computeIfAbsent(requestId, _r -> new CompletableFuture()).completeExceptionally((Throwable)throwable));
                } else {
                    @Nullable RuntimeException e = new RuntimeException("Exepecting BatchResponse. Found " + kryonResponse);
                    log.error("", (Throwable)e);
                    throw e;
                }
            });
            CompletableFuture<KryonResponse> finalResponse = new CompletableFuture<KryonResponse>();
            List allFutures = Stream.concat(cacheHits.entrySet().stream(), newCacheEntries.entrySet().stream()).toList();
            CompletableFuture[] allFuturesArray = new CompletableFuture[allFutures.size()];
            for (int i = 0; i < allFutures.size(); ++i) {
                allFuturesArray[i] = (CompletableFuture)((Map.Entry)allFutures.get(i)).getValue();
            }
            CompletableFuture.allOf(allFuturesArray).whenComplete((unused, throwable) -> finalResponse.complete(new BatchResponse((ImmutableMap<RequestId, Errable<Object>>)((ImmutableMap)allFutures.stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((CompletableFuture)((CompletableFuture)entry.getValue()).handle(Errable::errableFrom)).getNow(UNKNOWN_ERROR)))))));
            return finalResponse;
        }
    }
}

