/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.Facets;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.krystex.LogicDefinition;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.commands.BatchCommand;
import com.flipkart.krystal.krystex.commands.CallbackBatch;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardBatch;
import com.flipkart.krystal.krystex.kryon.AbstractKryon;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.kryon.DuplicateRequestException;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.kryon.KryonUtils;
import com.flipkart.krystal.krystex.kryon.OutputLogicFacets;
import com.flipkart.krystal.krystex.logicdecoration.FlushCommand;
import com.flipkart.krystal.krystex.logicdecoration.LogicDecorationOrdering;
import com.flipkart.krystal.krystex.logicdecoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.krystex.request.RequestIdGenerator;
import com.flipkart.krystal.krystex.resolution.DependencyResolutionRequest;
import com.flipkart.krystal.krystex.resolution.MultiResolverDefinition;
import com.flipkart.krystal.krystex.resolution.ResolverCommand;
import com.flipkart.krystal.krystex.resolution.ResolverDefinition;
import com.flipkart.krystal.utils.Futures;
import com.flipkart.krystal.utils.SkippedExecutionException;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BatchKryon
extends AbstractKryon<BatchCommand, BatchResponse> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(BatchKryon.class);
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> availableInputsByDepChain = new LinkedHashMap<DependantChain, Set<String>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized ForwardBatch> inputsValueCollector = new LinkedHashMap<DependantChain, ForwardBatch>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized CallbackBatch>> dependencyValuesCollector = new LinkedHashMap<DependantChain, Map<String, CallbackBatch>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized BatchResponse>> resultsByDepChain = new LinkedHashMap<DependantChain, CompletableFuture<BatchResponse>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> executedDependencies = new LinkedHashMap<DependantChain, Set<String>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RequestId>> requestsByDependantChain = new LinkedHashMap<DependantChain, Set<RequestId>>();
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized DependantChain> flushedDependantChain = new LinkedHashSet<DependantChain>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Boolean> outputLogicExecuted = new LinkedHashMap<DependantChain, Boolean>();

    BatchKryon(@UnknownKeyFor @NonNull @Initialized KryonDefinition kryonDefinition, @UnknownKeyFor @NonNull @Initialized KryonExecutor kryonExecutor, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized LogicExecutionContext, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized OutputLogicDecorator>> requestScopedDecoratorsSupplier, @UnknownKeyFor @NonNull @Initialized LogicDecorationOrdering logicDecorationOrdering, @UnknownKeyFor @NonNull @Initialized RequestIdGenerator requestIdGenerator) {
        super(kryonDefinition, kryonExecutor, requestScopedDecoratorsSupplier, logicDecorationOrdering, requestIdGenerator);
    }

    @Override
    public void executeCommand(@UnknownKeyFor @NonNull @Initialized Flush flushCommand) {
        this.flushedDependantChain.add(flushCommand.dependantChain());
        this.flushAllDependenciesIfNeeded(flushCommand.dependantChain());
        this.flushDecoratorsIfNeeded(flushCommand.dependantChain());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized BatchResponse> executeCommand(@UnknownKeyFor @NonNull @Initialized BatchCommand kryonCommand) {
        DependantChain dependantChain = kryonCommand.dependantChain();
        CompletableFuture resultForDepChain = this.resultsByDepChain.computeIfAbsent(dependantChain, r -> new CompletableFuture());
        try {
            if (kryonCommand instanceof ForwardBatch) {
                ForwardBatch forwardBatch = (ForwardBatch)kryonCommand;
                if (log.isDebugEnabled()) {
                    forwardBatch.executableRequests().forEach((requestId, facets) -> log.debug("Exec Ids - {}: {} invoked with inputs {}, in call path {}", new Object[]{requestId, this.kryonId, facets, forwardBatch.dependantChain()}));
                }
                this.collectInputValues(forwardBatch);
            } else if (kryonCommand instanceof CallbackBatch) {
                CallbackBatch callbackBatch = (CallbackBatch)kryonCommand;
                if (log.isDebugEnabled()) {
                    callbackBatch.resultsByRequest().forEach((requestId, results) -> log.debug("Exec Ids - {}: {} received response for dependency {} in call path {}. Response: {}", new Object[]{requestId, this.kryonId, callbackBatch.dependencyName(), callbackBatch.dependantChain(), results}));
                }
                this.collectDependencyValues(callbackBatch);
            }
            this.triggerDependencies(dependantChain, this.getTriggerableDependencies(dependantChain, kryonCommand.inputNames()));
            Optional<CompletableFuture<BatchResponse>> outputLogicFuture = this.executeOutputLogicIfPossible(dependantChain);
            outputLogicFuture.ifPresent(f -> Futures.linkFutures((CompletableFuture)f, (CompletableFuture)resultForDepChain));
        }
        catch (Throwable e) {
            resultForDepChain.completeExceptionally(e);
        }
        return resultForDepChain;
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> getTriggerableDependencies(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> newInputNames) {
        Set availableInputs = this.availableInputsByDepChain.getOrDefault(dependantChain, Set.of());
        Set executedDeps = this.executedDependencies.getOrDefault(dependantChain, Set.of());
        return Stream.concat(Stream.concat(Stream.of(Optional.empty()), newInputNames.stream().map(Optional::of)).map(key -> (ImmutableSet)this.kryonDefinition.resolverDefinitionsByInput().getOrDefault(key, (Object)ImmutableSet.of())).flatMap(Collection::stream).map(ResolverDefinition::dependencyName), this.kryonDefinition.dependenciesWithNoResolvers().stream()).distinct().filter(depName -> !executedDeps.contains(depName)).filter(depName -> ((ImmutableSet)this.kryonDefinition.resolverDefinitionsByDependencies().getOrDefault(depName, (Object)ImmutableSet.of())).stream().map(ResolverDefinition::boundFrom).flatMap(Collection::stream).allMatch(availableInputs::contains)).collect(Collectors.toMap(Functions.identity(), depName -> (Set)this.kryonDefinition.resolverDefinitionsByDependencies().getOrDefault(depName, (Object)ImmutableSet.of())));
    }

    private void triggerDependencies(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> triggerableDependencies) {
        ForwardBatch forwardBatch = this.getForwardCommand(dependantChain);
        if (log.isDebugEnabled()) {
            log.debug("Exec ids: {}. Computed triggerable dependencies: {} of {} in call path {}", new Object[]{forwardBatch.requestIds(), triggerableDependencies.keySet(), this.kryonId, forwardBatch.dependantChain()});
        }
        Optional<MultiResolverDefinition> multiResolverOpt = this.kryonDefinition.multiResolverLogicId().map(kryonLogicId -> this.kryonDefinition.kryonDefinitionRegistry().logicDefinitionRegistry().getMultiResolver((KryonLogicId)kryonLogicId));
        ImmutableMap<RequestId, String> skippedRequests = forwardBatch.skippedRequests();
        ImmutableSet executableRequests = forwardBatch.executableRequests().keySet();
        LinkedHashMap<String, Map> commandsByDependency = new LinkedHashMap<String, Map>();
        if (!skippedRequests.isEmpty()) {
            ResolverCommand.SkipDependency skip = ResolverCommand.skip(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)skippedRequests.values()));
            for (String string : triggerableDependencies.keySet()) {
                commandsByDependency.computeIfAbsent(string, _k -> new LinkedHashMap()).put(skippedRequests.keySet(), skip);
            }
        }
        Set<String> dependenciesWithNoResolvers = triggerableDependencies.entrySet().stream().filter(e -> ((Set)e.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
        for (RequestId requestId : executableRequests) {
            dependenciesWithNoResolvers.forEach(depName -> commandsByDependency.computeIfAbsent((String)depName, _k -> new LinkedHashMap()).put(Set.of(requestId), ResolverCommand.multiExecuteWith((ImmutableList<Facets>)ImmutableList.of((Object)Facets.empty()))));
            Facets facets = this.getInputsFor(dependantChain, requestId, triggerableDependencies.values().stream().flatMap(Collection::stream).map(ResolverDefinition::boundFrom).flatMap(Collection::stream).collect(Collectors.toSet()));
            multiResolverOpt.map(LogicDefinition::logic).map(logic -> logic.resolve(triggerableDependencies.entrySet().stream().filter(e -> !((Set)e.getValue()).isEmpty()).map(e -> new DependencyResolutionRequest((String)e.getKey(), (Set)e.getValue())).toList(), facets)).orElse(ImmutableMap.of()).forEach((depName, resolverCommand) -> commandsByDependency.computeIfAbsent((String)depName, _k -> new LinkedHashMap()).put(Set.of(requestId), resolverCommand));
        }
        for (Map.Entry entry : commandsByDependency.entrySet()) {
            String depName3 = (String)entry.getKey();
            Map resolverCommandsForDep = (Map)entry.getValue();
            this.triggerDependency(depName3, dependantChain, resolverCommandsForDep, triggerableDependencies.getOrDefault(depName3, (Set<ResolverDefinition>)ImmutableSet.of()));
        }
    }

    private @UnknownKeyFor @NonNull @Initialized ForwardBatch getForwardCommand(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        ForwardBatch forwardBatch = this.inputsValueCollector.get(dependantChain);
        if (forwardBatch == null) {
            throw new IllegalArgumentException("Missing Forward command. This should not be possible.");
        }
        return forwardBatch;
    }

    private void triggerDependency(@UnknownKeyFor @NonNull @Initialized String depName, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RequestId>, @UnknownKeyFor @NonNull @Initialized ResolverCommand> resolverCommandsByReq, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ResolverDefinition> resolverDefinitions) {
        if (this.executedDependencies.getOrDefault(dependantChain, Set.of()).contains(depName)) {
            return;
        }
        KryonId depKryonId = (KryonId)this.kryonDefinition.dependencyKryons().get((Object)depName);
        if (depKryonId == null) {
            throw new AssertionError((Object)"Could not find kryon mapped to dependency name %s in kryon %s.\nThis should not happen and is mostly a bug in the framework.\n".formatted(depName, this.kryonId));
        }
        LinkedHashMap<RequestId, Facets> inputsByDepReq = new LinkedHashMap<RequestId, Facets>();
        LinkedHashMap<RequestId, String> skipReasonsByReq = new LinkedHashMap<RequestId, String>();
        LinkedHashMap<RequestId, Set> depReqsByIncomingReq = new LinkedHashMap<RequestId, Set>();
        for (Map.Entry<Set<RequestId>, ResolverCommand> entry : resolverCommandsByReq.entrySet()) {
            Set<RequestId> incomingReqIds = entry.getKey();
            ResolverCommand resolverCommand = entry.getValue();
            if (resolverCommand instanceof ResolverCommand.SkipDependency) {
                ResolverCommand.SkipDependency skipDependency = (ResolverCommand.SkipDependency)resolverCommand;
                RequestId depReqId = this.requestIdGenerator.newSubRequest(incomingReqIds.iterator().next(), () -> "%s[skip]".formatted(depName));
                incomingReqIds.forEach(incomingReqId -> depReqsByIncomingReq.computeIfAbsent((RequestId)incomingReqId, _k -> new LinkedHashSet()).add(depReqId));
                skipReasonsByReq.put(depReqId, skipDependency.reason());
                continue;
            }
            int count = 0;
            for (RequestId incomingReqId2 : incomingReqIds) {
                if (resolverCommand.getInputs().isEmpty()) {
                    RequestId depReqId = this.requestIdGenerator.newSubRequest(incomingReqId2, () -> "%s[skip]".formatted(depName));
                    skipReasonsByReq.put(depReqId, "Resolvers for dependency %s resolved to empty list".formatted(depName));
                    continue;
                }
                for (Facets facets : resolverCommand.getInputs()) {
                    int currentCount = count++;
                    RequestId depReqId = this.requestIdGenerator.newSubRequest(incomingReqId2, () -> "%s[%s]".formatted(depName, currentCount));
                    depReqsByIncomingReq.computeIfAbsent(incomingReqId2, _k -> new LinkedHashSet()).add(depReqId);
                    inputsByDepReq.put(depReqId, facets);
                }
            }
        }
        this.executedDependencies.computeIfAbsent(dependantChain, _k -> new LinkedHashSet()).add(depName);
        if (log.isDebugEnabled()) {
            skipReasonsByReq.forEach((execId, reason) -> log.debug("Exec Ids: {}. Dependency {} of {} will be skipped due to reason {}", new Object[]{execId, depName, this.kryonId, reason}));
        }
        CompletableFuture depResponse = this.kryonExecutor.executeCommand(new ForwardBatch(depKryonId, (ImmutableSet<String>)((ImmutableSet)resolverDefinitions.stream().map(ResolverDefinition::resolvedInputNames).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet())), (ImmutableMap<RequestId, Facets>)ImmutableMap.copyOf(inputsByDepReq), dependantChain.extend(this.kryonId, depName), (ImmutableMap<RequestId, String>)ImmutableMap.copyOf(skipReasonsByReq)));
        depResponse.whenComplete((batchResponse, throwable) -> {
            Set requestIds = resolverCommandsByReq.keySet().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            ImmutableMap results = (ImmutableMap)requestIds.stream().collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), requestId -> {
                if (throwable != null) {
                    return new Results(ImmutableMap.of((Object)Facets.empty(), (Object)Errable.withError((Throwable)throwable)));
                }
                Set depReqIds = depReqsByIncomingReq.getOrDefault(requestId, Set.of());
                return new Results((ImmutableMap)depReqIds.stream().collect(ImmutableMap.toImmutableMap(depReqId -> inputsByDepReq.getOrDefault(depReqId, Facets.empty()), depReqId -> (Errable)batchResponse.responses().getOrDefault(depReqId, (Object)Errable.empty()))));
            }));
            KryonUtils.enqueueOrExecuteCommand(() -> new CallbackBatch(this.kryonId, depName, (ImmutableMap<RequestId, Results<Object>>)results, dependantChain), depKryonId, this.kryonDefinition, this.kryonExecutor);
        });
        if (log.isDebugEnabled()) {
            for (int timeout : List.of(Integer.valueOf(5), Integer.valueOf(10), Integer.valueOf(15))) {
                depResponse.orTimeout(timeout, TimeUnit.SECONDS).whenComplete((_r, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        log.debug("KryonId: {}, Dependency: {} on: {} with depChain: {}. Status: Waiting since {} {}", new Object[]{this.kryonId, depName, depKryonId, dependantChain, timeout, TimeUnit.SECONDS});
                    }
                });
            }
        }
        this.flushDependencyIfNeeded(depName, dependantChain);
    }

    private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized BatchResponse>> executeOutputLogicIfPossible(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        ForwardBatch forwardCommand = this.getForwardCommand(dependantChain);
        ImmutableSet<String> inputNames = this.kryonDefinition.getOutputLogicDefinition().inputNames();
        if (this.availableInputsByDepChain.getOrDefault(dependantChain, (Set<String>)ImmutableSet.of()).containsAll((Collection<?>)inputNames)) {
            if (forwardCommand.shouldSkip()) {
                return Optional.of(CompletableFuture.failedFuture((Throwable)new SkippedExecutionException(BatchKryon.getSkipMessage(forwardCommand))));
            }
            return Optional.of(this.executeOutputLogic((Set<RequestId>)forwardCommand.executableRequests().keySet(), dependantChain));
        }
        return Optional.empty();
    }

    private @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized BatchResponse> executeOutputLogic(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RequestId> requestIds, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        OutputLogicDefinition<Object> outputLogicDefinition = this.kryonDefinition.getOutputLogicDefinition();
        LinkedHashMap<RequestId, OutputLogicFacets> outputLogicInputs = new LinkedHashMap<RequestId, OutputLogicFacets>();
        for (RequestId requestId : requestIds) {
            outputLogicInputs.put(requestId, this.getFacetsForOutputLogic(dependantChain, requestId));
        }
        CompletableFuture<BatchResponse> resultForBatch = new CompletableFuture<BatchResponse>();
        Map<RequestId, CompletableFuture<Errable<Object>>> results = this.executeDecoratedOutputLogic(outputLogicDefinition, outputLogicInputs, dependantChain);
        CompletableFuture.allOf((CompletableFuture[])results.values().toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> resultForBatch.complete(new BatchResponse((ImmutableMap<RequestId, Errable<Object>>)((ImmutableMap)outputLogicInputs.keySet().stream().collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), requestId -> results.getOrDefault(requestId, new CompletableFuture()).getNow(Errable.empty())))))));
        this.outputLogicExecuted.put(dependantChain, true);
        this.flushDecoratorsIfNeeded(dependantChain);
        return resultForBatch;
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized Errable<@UnknownKeyFor @NonNull @Initialized Object>>> executeDecoratedOutputLogic(@UnknownKeyFor @NonNull @Initialized OutputLogicDefinition<@UnknownKeyFor @NonNull @Initialized Object> outputLogicDefinition, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized OutputLogicFacets> inputs, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        NavigableSet<OutputLogicDecorator> sortedDecorators = this.getSortedDecorators(dependantChain);
        OutputLogic logic = outputLogicDefinition::execute;
        for (OutputLogicDecorator outputLogicDecorator : sortedDecorators) {
            logic = outputLogicDecorator.decorateLogic(logic, outputLogicDefinition);
        }
        OutputLogic finalLogic = logic;
        LinkedHashMap<RequestId, CompletableFuture<Errable<Object>>> resultsByRequest = new LinkedHashMap<RequestId, CompletableFuture<Errable<Object>>>();
        inputs.forEach((requestId, outputLogicFacets) -> {
            CompletableFuture result;
            try {
                result = (CompletableFuture)finalLogic.execute((ImmutableList<Facets>)ImmutableList.of((Object)outputLogicFacets.allFacets())).values().iterator().next();
            }
            catch (Throwable e) {
                result = CompletableFuture.failedFuture(e);
            }
            resultsByRequest.put((RequestId)requestId, (CompletableFuture<Errable<Object>>)result.handle(Errable::errableFrom));
        });
        return resultsByRequest;
    }

    private void flushAllDependenciesIfNeeded(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        this.kryonDefinition.dependencyKryons().keySet().forEach(dependencyName -> this.flushDependencyIfNeeded((String)dependencyName, dependantChain));
    }

    private void flushDependencyIfNeeded(@UnknownKeyFor @NonNull @Initialized String dependencyName, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        if (!this.flushedDependantChain.contains(dependantChain)) {
            return;
        }
        if (this.executedDependencies.getOrDefault(dependantChain, Set.of()).contains(dependencyName)) {
            this.kryonExecutor.executeCommand(new Flush(Optional.ofNullable((KryonId)this.kryonDefinition.dependencyKryons().get((Object)dependencyName)).orElseThrow(() -> new AssertionError((Object)("Could not find KryonId for dependency " + dependencyName + ". This is a bug"))), dependantChain.extend(this.kryonId, dependencyName)));
        }
    }

    private void flushDecoratorsIfNeeded(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        block6: {
            block5: {
                if (!this.flushedDependantChain.contains(dependantChain)) {
                    return;
                }
                if (this.outputLogicExecuted.getOrDefault(dependantChain, false).booleanValue()) break block5;
                if (!this.getForwardCommand(dependantChain).shouldSkip()) break block6;
            }
            Iterable reverseSortedDecorators = this.getSortedDecorators(dependantChain)::descendingIterator;
            for (OutputLogicDecorator decorator : reverseSortedDecorators) {
                decorator.executeCommand(new FlushCommand(dependantChain));
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Facets getInputsFor(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized RequestId requestId, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> boundFrom) {
        Facets resolvableInputs = Optional.ofNullable(this.inputsValueCollector.get(dependantChain)).map(ForwardBatch::executableRequests).map(inputsByRequest -> (Facets)inputsByRequest.get((Object)requestId)).orElse(Facets.empty());
        Map depValues = this.dependencyValuesCollector.getOrDefault(dependantChain, Map.of());
        LinkedHashMap<String, FacetValue> inputValues = new LinkedHashMap<String, FacetValue>();
        for (String boundFromInput : boundFrom) {
            FacetValue voe = (FacetValue)resolvableInputs.values().get((Object)boundFromInput);
            if (voe == null) {
                CallbackBatch callbackBatch = (CallbackBatch)depValues.get(boundFromInput);
                if (callbackBatch == null) continue;
                inputValues.put(boundFromInput, (FacetValue)callbackBatch.resultsByRequest().getOrDefault((Object)requestId, (Object)Results.empty()));
                continue;
            }
            inputValues.put(boundFromInput, voe);
        }
        return new Facets(inputValues);
    }

    private @UnknownKeyFor @NonNull @Initialized OutputLogicFacets getFacetsForOutputLogic(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized RequestId requestId) {
        ForwardBatch forwardBatch = this.inputsValueCollector.get(dependantChain);
        if (forwardBatch == null) {
            throw new AssertionError((Object)"Could not find forwardBatch. This is a bug.");
        }
        ImmutableMap depValues = (ImmutableMap)this.dependencyValuesCollector.getOrDefault(dependantChain, (Map<String, CallbackBatch>)ImmutableMap.of()).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> (Results)((CallbackBatch)e.getValue()).resultsByRequest().getOrDefault((Object)requestId, (Object)Results.empty())));
        Facets inputValues = (Facets)forwardBatch.executableRequests().getOrDefault((Object)requestId, (Object)Facets.empty());
        Facets allFacets = Facets.union((Map)depValues, (Map)inputValues.values());
        return new OutputLogicFacets(inputValues, allFacets);
    }

    private void collectInputValues(@UnknownKeyFor @NonNull @Initialized ForwardBatch forwardBatch) {
        if (this.requestsByDependantChain.putIfAbsent(forwardBatch.dependantChain(), forwardBatch.requestIds()) != null) {
            throw new DuplicateRequestException("Duplicate batch request received for dependant chain %s".formatted(forwardBatch.dependantChain()));
        }
        ImmutableSet<String> inputNames = forwardBatch.inputNames();
        if (this.inputsValueCollector.putIfAbsent(forwardBatch.dependantChain(), forwardBatch) != null) {
            throw new DuplicateRequestException("Duplicate data for inputs %s of kryon %s in dependant chain %s".formatted(inputNames, this.kryonId, forwardBatch.dependantChain()));
        }
        Sets.SetView resolvableInputNames = Sets.difference(this.kryonDefinition.facetNames(), (Set)this.kryonDefinition.dependencyKryons().keySet());
        if (!inputNames.containsAll((Collection)resolvableInputNames)) {
            throw new IllegalArgumentException("Did not receive inputs " + Sets.difference((Set)resolvableInputNames, inputNames));
        }
        this.availableInputsByDepChain.computeIfAbsent(forwardBatch.dependantChain(), _k -> new LinkedHashSet()).addAll(inputNames);
    }

    private static @UnknownKeyFor @NonNull @Initialized String getSkipMessage(@UnknownKeyFor @NonNull @Initialized ForwardBatch forwardBatch) {
        return String.join((CharSequence)", ", (Iterable<? extends CharSequence>)forwardBatch.skippedRequests().values());
    }

    private void collectDependencyValues(@UnknownKeyFor @NonNull @Initialized CallbackBatch callbackBatch) {
        String dependencyName = callbackBatch.dependencyName();
        this.availableInputsByDepChain.computeIfAbsent(callbackBatch.dependantChain(), _k -> new LinkedHashSet()).add(dependencyName);
        if (this.dependencyValuesCollector.computeIfAbsent(callbackBatch.dependantChain(), k -> new LinkedHashMap()).putIfAbsent(dependencyName, callbackBatch) != null) {
            throw new DuplicateRequestException("Duplicate data for dependency %s of kryon %s in dependant chain %s".formatted(dependencyName, this.kryonId, callbackBatch.dependantChain()));
        }
    }
}

