/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.kryon.FacetType;
import com.flipkart.krystal.krystex.kryon.KryonDefinitionRegistry;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.resolution.ResolverDefinition;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public record KryonDefinition(@UnknownKeyFor @NonNull @Initialized KryonId kryonId, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> inputs, @UnknownKeyFor @NonNull @Initialized KryonLogicId outputLogicId, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized KryonId> dependencyKryons, @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ResolverDefinition> resolverDefinitions, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized KryonLogicId> multiResolverLogicId, @UnknownKeyFor @NonNull @Initialized KryonDefinitionRegistry kryonDefinitionRegistry, @UnknownKeyFor @NonNull @Initialized KryonDefinitionView view) {
    public KryonDefinition(@UnknownKeyFor @NonNull @Initialized KryonId kryonId, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> inputs, @UnknownKeyFor @NonNull @Initialized KryonLogicId outputLogicId, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized KryonId> dependencyKryons, @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ResolverDefinition> resolverDefinitions, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized KryonLogicId> multiResolverLogicId, @UnknownKeyFor @NonNull @Initialized KryonDefinitionRegistry kryonDefinitionRegistry) {
        this(kryonId, (ImmutableSet<String>)ImmutableSet.copyOf(inputs), outputLogicId, dependencyKryons, resolverDefinitions, multiResolverLogicId, kryonDefinitionRegistry, KryonDefinitionView.createView(inputs, resolverDefinitions, dependencyKryons));
    }

    public <T> @UnknownKeyFor @NonNull @Initialized OutputLogicDefinition<T> getOutputLogicDefinition() {
        return this.kryonDefinitionRegistry().logicDefinitionRegistry().getOutputLogic(this.outputLogicId());
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> facetsByType(@UnknownKeyFor @NonNull @Initialized FacetType facetType) {
        return (ImmutableSet)this.view.facetsByType().getOrDefault((Object)facetType, (Object)ImmutableSet.of());
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> resolverDefinitionsByInput() {
        return this.view.resolverDefinitionsByInput();
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> dependenciesWithNoResolvers() {
        return this.view.dependenciesWithNoResolvers();
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> dependenciesWithNoFacetResolvers() {
        return this.view.dependenciesWithNoFacetResolvers();
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> resolverDefinitionsByDependencies() {
        return this.view.resolverDefinitionsByDependencies();
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String>> dependencyToBoundFacetsMapping() {
        return this.view.dependencyToBoundFacetsMapping();
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String>> dependenciesByBoundFacet() {
        return this.view.dependenciesByBoundFacet();
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> facetNames() {
        return this.view.facetNames();
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> givenFacets() {
        return this.view.givenFacets();
    }

    private record KryonDefinitionView(@UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized FacetType, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String>> facetsByType, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> givenFacets, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> facetNames, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> resolverDefinitionsByInput, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> resolverDefinitionsByDependencies, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> dependenciesWithNoResolvers, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> dependenciesWithNoFacetResolvers, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String>> dependencyToBoundFacetsMapping, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String>> dependenciesByBoundFacet) {
        private static @UnknownKeyFor @NonNull @Initialized KryonDefinitionView createView(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> inputs, @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ResolverDefinition> resolverDefinitions, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized KryonId> dependencyKryons) {
            ImmutableMap resolverDefinitionsByDependencies = ImmutableMap.copyOf(resolverDefinitions.stream().collect(Collectors.groupingBy(ResolverDefinition::dependencyName, ImmutableSet.toImmutableSet())));
            ImmutableSet dependencyFacets = dependencyKryons.keySet();
            ImmutableSet dependenciesWithNoResolvers = (ImmutableSet)dependencyFacets.stream().filter(depName -> ((ImmutableSet)resolverDefinitionsByDependencies.getOrDefault(depName, (Object)ImmutableSet.of())).isEmpty()).collect(ImmutableSet.toImmutableSet());
            ImmutableMap<Optional<String>, ImmutableSet<ResolverDefinition>> resolverDefinitionsByFacets = KryonDefinitionView.createResolverDefinitionsByFacets(resolverDefinitions);
            return new KryonDefinitionView((ImmutableMap<FacetType, ImmutableSet<String>>)ImmutableMap.of((Object)((Object)FacetType.INPUT), (Object)ImmutableSet.copyOf(inputs), (Object)((Object)FacetType.DEPENDENCY), (Object)dependencyKryons.keySet()), (ImmutableSet<String>)ImmutableSet.copyOf(inputs), (ImmutableSet<String>)ImmutableSet.builder().addAll(inputs).addAll((Iterable)dependencyKryons.keySet()).build(), resolverDefinitionsByFacets, (ImmutableMap<String, ImmutableSet<ResolverDefinition>>)resolverDefinitionsByDependencies, (ImmutableSet<String>)dependenciesWithNoResolvers, (ImmutableSet<String>)((ImmutableSet)((ImmutableSet)resolverDefinitionsByFacets.getOrDefault(Optional.empty(), (Object)ImmutableSet.of())).stream().map(ResolverDefinition::dependencyName).collect(ImmutableSet.toImmutableSet())), KryonDefinitionView.getDependencyToBoundFacetsMapping((ImmutableMap<String, ImmutableSet<ResolverDefinition>>)resolverDefinitionsByDependencies), KryonDefinitionView.getDependenciesByBoundFacet(resolverDefinitionsByFacets));
        }

        private static @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String>> getDependenciesByBoundFacet(@UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> resolverDefinitionsByFacets) {
            LinkedHashMap<String, ImmutableSet> dependenciesByBoundFacet = new LinkedHashMap<String, ImmutableSet>();
            for (Map.Entry e : resolverDefinitionsByFacets.entrySet()) {
                Optional facetNameOpt = (Optional)e.getKey();
                if (facetNameOpt.isEmpty()) continue;
                String facetName = (String)facetNameOpt.get();
                LinkedHashSet<String> dependenciesForFacet = new LinkedHashSet<String>();
                for (ResolverDefinition resolverDefinition : (ImmutableSet)e.getValue()) {
                    dependenciesForFacet.add(resolverDefinition.dependencyName());
                }
                dependenciesByBoundFacet.put(facetName, ImmutableSet.copyOf(dependenciesForFacet));
            }
            return ImmutableMap.copyOf(dependenciesByBoundFacet);
        }

        private static @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String>> getDependencyToBoundFacetsMapping(@UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> resolverDefinitionsByDependencies) {
            LinkedHashMap<String, ImmutableSet> dependencyToBoundFacetsMapping = new LinkedHashMap<String, ImmutableSet>();
            for (Map.Entry e : resolverDefinitionsByDependencies.entrySet()) {
                String depName = (String)e.getKey();
                ImmutableSet resolvers = (ImmutableSet)e.getValue();
                LinkedHashSet<String> boundFromInputs = new LinkedHashSet<String>();
                for (ResolverDefinition resolverDefinition : resolvers) {
                    boundFromInputs.addAll((Collection<String>)resolverDefinition.boundFrom());
                }
                dependencyToBoundFacetsMapping.put(depName, ImmutableSet.copyOf(boundFromInputs));
            }
            return ImmutableMap.copyOf(dependencyToBoundFacetsMapping);
        }

        private static @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> createResolverDefinitionsByFacets(@UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ResolverDefinition> resolverDefinitions) {
            LinkedHashMap resolverDefinitionsByInput = new LinkedHashMap();
            resolverDefinitions.forEach(resolverDefinition -> {
                if (!resolverDefinition.boundFrom().isEmpty()) {
                    resolverDefinition.boundFrom().forEach(input -> resolverDefinitionsByInput.computeIfAbsent(Optional.of(input), s -> ImmutableSet.builder()).add(resolverDefinition));
                } else {
                    resolverDefinitionsByInput.computeIfAbsent(Optional.empty(), s -> ImmutableSet.builder()).add(resolverDefinition);
                }
            });
            return (ImmutableMap)resolverDefinitionsByInput.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((ImmutableSet.Builder)e.getValue()).build()));
        }
    }
}

