/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex;

import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.resolution.MultiResolverDefinition;
import com.flipkart.krystal.krystex.resolution.ResolverLogicDefinition;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class LogicDefinitionRegistry {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized KryonLogicId, @UnknownKeyFor @NonNull @Initialized OutputLogicDefinition<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputLogicDefinitions = new ConcurrentHashMap();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized KryonLogicId, @UnknownKeyFor @NonNull @Initialized ResolverLogicDefinition> resolverLogicDefinitions = new ConcurrentHashMap<KryonLogicId, ResolverLogicDefinition>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized KryonLogicId, @UnknownKeyFor @NonNull @Initialized MultiResolverDefinition> multiResolverDefinitions = new ConcurrentHashMap<KryonLogicId, MultiResolverDefinition>();

    public <T> @UnknownKeyFor @NonNull @Initialized OutputLogicDefinition<T> getOutputLogic(@UnknownKeyFor @NonNull @Initialized KryonLogicId kryonLogicId) {
        OutputLogicDefinition<?> outputLogicDefinition = this.outputLogicDefinitions.get(kryonLogicId);
        if (outputLogicDefinition == null) {
            throw new NoSuchElementException("Could not find outputLogicDefinition for " + kryonLogicId);
        }
        return outputLogicDefinition;
    }

    public @UnknownKeyFor @NonNull @Initialized MultiResolverDefinition getMultiResolver(@UnknownKeyFor @NonNull @Initialized KryonLogicId kryonLogicId) {
        MultiResolverDefinition multiResolverDefinition = this.multiResolverDefinitions.get(kryonLogicId);
        if (multiResolverDefinition == null) {
            throw new NoSuchElementException("Could not find multiResolverDefinition for " + kryonLogicId);
        }
        return multiResolverDefinition;
    }

    public void addOutputLogic(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized OutputLogicDefinition<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> outputLogicDefinition) {
        if (this.outputLogicDefinitions.containsKey(outputLogicDefinition.kryonLogicId())) {
            return;
        }
        this.outputLogicDefinitions.put(outputLogicDefinition.kryonLogicId(), outputLogicDefinition);
    }

    public void addResolver(@UnknownKeyFor @NonNull @Initialized ResolverLogicDefinition def) {
        if (this.resolverLogicDefinitions.containsKey(def.kryonLogicId())) {
            return;
        }
        this.resolverLogicDefinitions.put(def.kryonLogicId(), def);
    }

    public void addMultiResolver(@UnknownKeyFor @NonNull @Initialized MultiResolverDefinition def) {
        if (this.multiResolverDefinitions.containsKey(def.kryonLogicId())) {
            return;
        }
        this.multiResolverDefinitions.put(def.kryonLogicId(), def);
    }

    public void validate() {
    }
}

