/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.caching;

import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.Facets;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.krystex.caching.CacheKey;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardBatch;
import com.flipkart.krystal.krystex.commands.ForwardGranule;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonResponse;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorationInput;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorator;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.utils.Futures;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLevelCache
implements KryonDecorator {
    @Generated
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Logger log = LoggerFactory.getLogger(RequestLevelCache.class);
    public static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String DECORATOR_TYPE = RequestLevelCache.class.getName();
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Errable<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Object> UNKNOWN_ERROR = Errable.withError((Throwable)new StackTracelessException("Unknown error in request cache"));
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) CacheKey, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) CompletableFuture<@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) Object>> cache = new LinkedHashMap<CacheKey, CompletableFuture<Object>>();

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Kryon<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonCommand, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonResponse> decorateKryon(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonDecorationInput decorationInput) {
        return new CachingDecoratedKryon(decorationInput.kryon());
    }

    public void primeCache(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String kryonId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Facets request, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) CompletableFuture<@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) Object> data) {
        this.cache.put(new CacheKey(new KryonId(kryonId), request), data);
    }

    private class CachingDecoratedKryon
    implements Kryon<KryonCommand, KryonResponse> {
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Kryon<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonCommand, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonResponse> kryon;

        private CachingDecoratedKryon(Kryon<KryonCommand, KryonResponse> kryon) {
            this.kryon = kryon;
        }

        @Override
        public void executeCommand(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Flush flushCommand) {
            this.kryon.executeCommand(flushCommand);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonDefinition getKryonDefinition() {
            return this.kryon.getKryonDefinition();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) CompletableFuture<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonResponse> executeCommand(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonCommand kryonCommand) {
            if (kryonCommand instanceof ForwardBatch) {
                ForwardBatch forwardBatch = (ForwardBatch)kryonCommand;
                return this.readFromCache(this.kryon, forwardBatch);
            }
            if (kryonCommand instanceof ForwardGranule) {
                UnsupportedOperationException e = new UnsupportedOperationException("KryonInputInjector does not support KryonExecStrategy GRANULAR. Please use BATCH instead");
                log.error("", (Throwable)e);
                throw e;
            }
            return this.kryon.executeCommand(kryonCommand);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) CompletableFuture<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonResponse> readFromCache(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Kryon<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonCommand, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonResponse> kryon, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ForwardBatch forwardBatch) {
            ImmutableMap<RequestId, Facets> executableRequests = forwardBatch.executableRequests();
            LinkedHashMap<RequestId, Facets> cacheMisses = new LinkedHashMap<RequestId, Facets>();
            LinkedHashMap<RequestId, @Nullable CompletableFuture> cacheHits = new LinkedHashMap<RequestId, CompletableFuture>();
            executableRequests.forEach((requestId, facets) -> {
                CompletableFuture<Object> cachedFuture = RequestLevelCache.this.cache.get(new CacheKey(kryon.getKryonDefinition().kryonId(), (Facets)facets));
                if (cachedFuture == null) {
                    cacheMisses.put((RequestId)requestId, (Facets)facets);
                } else {
                    cacheHits.put((RequestId)requestId, cachedFuture);
                }
            });
            LinkedHashMap<RequestId, @Nullable CompletableFuture> newCacheEntries = new LinkedHashMap<RequestId, CompletableFuture>();
            LinkedHashMap<RequestId, String> skippedRequests = new LinkedHashMap<RequestId, String>((Map<RequestId, String>)forwardBatch.skippedRequests());
            cacheHits.forEach((requestId, _f) -> skippedRequests.put((RequestId)requestId, "Skipping due to cache hit!"));
            CompletableFuture<KryonResponse> cacheMissesResponse = kryon.executeCommand(new ForwardBatch(forwardBatch.kryonId(), forwardBatch.inputNames(), (ImmutableMap<RequestId, Facets>)ImmutableMap.copyOf(cacheMisses), forwardBatch.dependantChain(), (ImmutableMap<RequestId, String>)ImmutableMap.copyOf(skippedRequests)));
            cacheMisses.forEach((requestId, facets) -> newCacheEntries.put((RequestId)requestId, new CompletableFuture()));
            newCacheEntries.forEach((requestId, cacheInsert) -> {
                Facets facets = (Facets)cacheMisses.get(requestId);
                if (facets == null) {
                    @Nullable AssertionError e = new AssertionError((Object)"This should not happen since requestId will definitely be there in the cacheMisses map");
                    log.error("", (Throwable)((Object)e));
                    throw e;
                }
                RequestLevelCache.this.cache.put(new CacheKey(kryon.getKryonDefinition().kryonId(), facets), (CompletableFuture<Object>)cacheInsert);
            });
            cacheMissesResponse.whenComplete((kryonResponse, throwable) -> {
                if (kryonResponse instanceof BatchResponse) {
                    BatchResponse batchResponse = (BatchResponse)kryonResponse;
                    ImmutableMap<RequestId, Errable<Object>> responses = batchResponse.responses();
                    responses.forEach((requestId, response) -> {
                        @Nullable CompletableFuture future = response.toFuture();
                        @Nullable CompletableFuture destinationFuture = newCacheEntries.computeIfAbsent((RequestId)requestId, _r -> new CompletableFuture());
                        Futures.linkFutures((CompletableFuture)future, (CompletableFuture)destinationFuture);
                    });
                } else if (throwable != null) {
                    cacheMisses.forEach((requestId, response) -> newCacheEntries.computeIfAbsent((RequestId)requestId, _r -> new CompletableFuture()).completeExceptionally((Throwable)throwable));
                } else {
                    @Nullable RuntimeException e = new RuntimeException("Exepecting BatchResponse. Found " + kryonResponse);
                    log.error("", (Throwable)e);
                    throw e;
                }
            });
            CompletableFuture<KryonResponse> finalResponse = new CompletableFuture<KryonResponse>();
            List allFutures = Stream.concat(cacheHits.entrySet().stream(), newCacheEntries.entrySet().stream()).toList();
            CompletableFuture[] array = new CompletableFuture[allFutures.size()];
            for (int i = 0; i < allFutures.size(); ++i) {
                array[i] = (CompletableFuture)((Map.Entry)allFutures.get(i)).getValue();
            }
            CompletableFuture.allOf(array).whenComplete((unused, throwable) -> finalResponse.complete(new BatchResponse((ImmutableMap<RequestId, Errable<Object>>)((ImmutableMap)allFutures.stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((CompletableFuture)((CompletableFuture)entry.getValue()).handle(Errable::errableFrom)).getNow(UNKNOWN_ERROR)))))));
            return finalResponse;
        }
    }
}

