/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.caching;

import com.flipkart.krystal.concurrent.Futures;
import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.ImmutableFacetValuesContainer;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.krystex.caching.CacheKey;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardReceive;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonResponse;
import com.flipkart.krystal.krystex.kryon.VajramKryonDefinition;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorationInput;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorator;
import com.flipkart.krystal.krystex.request.RequestId;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLevelCache
implements KryonDecorator {
    @Generated
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Logger log = LoggerFactory.getLogger(RequestLevelCache.class);
    public static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String DECORATOR_TYPE = RequestLevelCache.class.getName();
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Errable<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> UNKNOWN_ERROR = Errable.withError((Throwable)new StackTracelessException("Unknown error in request cache"));
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CacheKey, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object>> cache = new LinkedHashMap<CacheKey, CompletableFuture<Object>>();

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Kryon<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommand, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonResponse> decorateKryon(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonDecorationInput decorationInput) {
        return new CachingDecoratedKryon(decorationInput.kryon());
    }

    public void primeCache(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String kryonId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetValues request, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> data) {
        this.cache.put(new CacheKey(new VajramID(kryonId), (ImmutableFacetValuesContainer)request._build()), data);
    }

    private class CachingDecoratedKryon
    implements Kryon<KryonCommand, KryonResponse> {
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Kryon<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommand, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonResponse> kryon;

        private CachingDecoratedKryon(Kryon<KryonCommand, KryonResponse> kryon) {
            this.kryon = kryon;
        }

        @Override
        public void executeCommand(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Flush flushCommand) {
            this.kryon.executeCommand(flushCommand);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramKryonDefinition getKryonDefinition() {
            return this.kryon.getKryonDefinition();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonResponse> executeCommand(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommand kryonCommand) {
            if (kryonCommand instanceof ForwardReceive) {
                ForwardReceive forwardBatch = (ForwardReceive)kryonCommand;
                return this.readFromCache(this.kryon, forwardBatch);
            }
            return this.kryon.executeCommand(kryonCommand);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonResponse> readFromCache(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Kryon<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommand, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonResponse> kryon, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ForwardReceive forwardBatch) {
            ImmutableMap<RequestId, ? extends FacetValues> executableRequests = forwardBatch.executableRequests();
            LinkedHashMap cacheMisses = new LinkedHashMap();
            LinkedHashMap<RequestId, @Nullable CompletableFuture> cacheHits = new LinkedHashMap<RequestId, CompletableFuture>();
            LinkedHashMap<K, @Nullable V> newCacheEntries = new LinkedHashMap();
            executableRequests.forEach((requestId, facets) -> {
                CacheKey cacheKey = new CacheKey(kryon.getKryonDefinition().vajramID(), (ImmutableFacetValuesContainer)facets._build());
                CompletableFuture<Object> cachedFuture = RequestLevelCache.this.cache.get(cacheKey);
                if (cachedFuture == null) {
                    CompletableFuture placeHolderFuture = new CompletableFuture();
                    newCacheEntries.put(requestId, placeHolderFuture);
                    RequestLevelCache.this.cache.put(cacheKey, placeHolderFuture);
                    cacheMisses.put(requestId, facets._build());
                } else {
                    cacheHits.put((RequestId)requestId, cachedFuture);
                }
            });
            LinkedHashMap<RequestId, String> skippedRequests = new LinkedHashMap<RequestId, String>((Map<RequestId, String>)forwardBatch.skippedRequests());
            cacheHits.forEach((requestId, _f) -> skippedRequests.put((RequestId)requestId, "Skipping due to cache hit!"));
            CompletableFuture<KryonResponse> cacheMissesResponse = kryon.executeCommand(new ForwardReceive(forwardBatch.vajramID(), (ImmutableMap<RequestId, ? extends FacetValues>)ImmutableMap.copyOf(cacheMisses), forwardBatch.dependantChain(), (ImmutableMap<RequestId, String>)ImmutableMap.copyOf(skippedRequests)));
            cacheMissesResponse.whenComplete((kryonResponse, throwable) -> {
                if (kryonResponse instanceof BatchResponse) {
                    BatchResponse batchResponse = (BatchResponse)kryonResponse;
                    ImmutableMap<RequestId, Errable<Object>> responses = batchResponse.responses();
                    responses.forEach((requestId, response) -> {
                        @Nullable CompletableFuture future = response.toFuture();
                        @Nullable CompletableFuture destinationFuture = newCacheEntries.computeIfAbsent(requestId, _r -> new CompletableFuture());
                        Futures.linkFutures((CompletableFuture)future, (CompletableFuture)destinationFuture);
                    });
                } else if (throwable != null) {
                    cacheMisses.forEach((requestId, response) -> newCacheEntries.computeIfAbsent(requestId, _r -> new CompletableFuture()).completeExceptionally((Throwable)throwable));
                } else {
                    @Nullable RuntimeException e = new RuntimeException("Exepecting BatchResponse. Found " + kryonResponse);
                    log.error("", (Throwable)e);
                    throw e;
                }
            });
            CompletableFuture<KryonResponse> finalResponse = new CompletableFuture<KryonResponse>();
            List allFutures = Stream.concat(cacheHits.entrySet().stream(), newCacheEntries.entrySet().stream()).toList();
            CompletableFuture[] allFuturesArray = new CompletableFuture[allFutures.size()];
            for (int i = 0; i < allFutures.size(); ++i) {
                allFuturesArray[i] = (CompletableFuture)((Map.Entry)allFutures.get(i)).getValue();
            }
            CompletableFuture.allOf(allFuturesArray).whenComplete((unused, throwable) -> finalResponse.complete(new BatchResponse((ImmutableMap<RequestId, Errable<Object>>)((ImmutableMap)allFutures.stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((CompletableFuture)((CompletableFuture)entry.getValue()).handle(Errable::errableFrom)).getNow(UNKNOWN_ERROR)))))));
            return finalResponse;
        }
    }
}

