/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.ext.grpc;

import com.flipkart.krystal.lattice.ext.grpc.GrpcServerSpec;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StandardHeadersInterceptor
implements ServerInterceptor {
    @Generated
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Logger log = LoggerFactory.getLogger(StandardHeadersInterceptor.class);
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Context.Key<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String> requestIdContextKey;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Metadata.Key<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String> requestIdMetadataKey;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Context.Key<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String> acceptHeaderContextKey;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Metadata.Key<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String> acceptMetadataKey;

    @Inject
    StandardHeadersInterceptor(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent GrpcServerSpec grpcServerSpec) {
        this.requestIdContextKey = grpcServerSpec.requestIdContextKey();
        this.requestIdMetadataKey = Metadata.Key.of((String)this.requestIdContextKey.toString(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        this.acceptHeaderContextKey = grpcServerSpec.acceptHeaderContextKey();
        this.acceptMetadataKey = Metadata.Key.of((String)this.acceptHeaderContextKey.toString(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    }

    public <ReqT, RespT> // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ServerCall.Listener<ReqT> interceptCall(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ServerCall<ReqT, RespT> call, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Metadata requestHeaders, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ServerCallHandler<ReqT, RespT> next) {
        String requestId = (String)requestHeaders.get(this.requestIdMetadataKey);
        log.info("requestId received from client: {}", (Object)requestId);
        String acceptHeader = (String)requestHeaders.get(this.acceptMetadataKey);
        log.info("Accept header received from client: {}", (Object)acceptHeader);
        Context contextWithHeader = Context.current().withValue(this.requestIdContextKey, (Object)requestId).withValue(this.acceptHeaderContextKey, (Object)acceptHeader);
        return Contexts.interceptCall((Context)contextWithHeader, call, (Metadata)requestHeaders, next);
    }
}

