/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.rest.codegen;

import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.codegen.common.spi.ModelProtocolConfigProvider;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenContext;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenUtils;
import com.flipkart.krystal.lattice.codegen.spi.LatticeCodeGeneratorProvider;
import com.flipkart.krystal.lattice.rest.RestService;
import com.flipkart.krystal.lattice.rest.RestServiceDopant;
import com.flipkart.krystal.lattice.rest.api.Body;
import com.flipkart.krystal.lattice.rest.api.Path;
import com.flipkart.krystal.lattice.rest.api.PathParam;
import com.flipkart.krystal.lattice.rest.api.QueryParam;
import com.flipkart.krystal.lattice.rest.api.methods.RestMethod;
import com.flipkart.krystal.model.SupportedModelProtocols;
import com.flipkart.krystal.serial.SerdeProtocol;
import com.flipkart.krystal.vajram.codegen.common.models.FacetGenModel;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

@AutoService(value={LatticeCodeGeneratorProvider.class})
public class JakartaRestServiceResourceGenProvider
implements LatticeCodeGeneratorProvider {
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenerator create(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent LatticeCodegenContext latticeCodegenContext) {
        return new JakartaRestServiceResourceGen(latticeCodegenContext);
    }

    private static class JakartaRestServiceResourceGen
    implements CodeGenerator {
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent LatticeCodegenContext context;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenUtility util;

        public JakartaRestServiceResourceGen(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent LatticeCodegenContext context) {
            this.context = context;
            this.util = context.codeGenUtility().codegenUtil();
        }

        public void generate() {
            if (!this.isApplicable()) {
                return;
            }
            TypeElement latticeAppElem = this.context.latticeAppTypeElement();
            List<ClassName> resourceClasses = this.resourceClasses(latticeAppElem);
            this.dopantImpl(latticeAppElem, resourceClasses);
        }

        private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName> resourceClasses(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement latticeAppElem) {
            RestService restService = latticeAppElem.getAnnotation(RestService.class);
            String pathPrefix = restService.pathPrefix().isEmpty() ? "" : "/" + restService.pathPrefix();
            ArrayList<ClassName> resourceClasses = new ArrayList<ClassName>();
            for (TypeElement vajramElem : this.util.getTypesFromAnnotationMember(() -> ((RestService)restService).resourceVajrams()).stream().map(typeMirror -> Objects.requireNonNull((TypeElement)this.util.processingEnv().getTypeUtils().asElement((TypeMirror)typeMirror))).toList()) {
                VajramInfo vajramInfo;
                List<MethodSpec> resourceMethods;
                Path path = vajramElem.getAnnotation(Path.class);
                if (path == null) continue;
                if (path.value().startsWith("/") || path.value().endsWith("/")) {
                    this.util.error("Path value in @Path annotation cannot start of end with '/'", new Element[]{vajramElem});
                }
                if ((resourceMethods = this.resourceMethods(vajramInfo = this.context.codeGenUtility().computeVajramInfo(vajramElem))).isEmpty()) continue;
                ClassName jaxRsResourceName = JakartaRestServiceResourceGen.getJaxRsResourceName(vajramInfo.lite().packageName(), vajramElem);
                TypeSpec.Builder resourceClassBuilder = this.util.classBuilder(jaxRsResourceName.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
                resourceClassBuilder.addField(RestServiceDopant.class, "_restServiceDopant", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addAnnotation(AnnotationSpec.builder(jakarta.ws.rs.Path.class).addMember("value", "$S", new Object[]{pathPrefix + "/" + path.value()}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(RestServiceDopant.class, "_restServiceDopant", new Modifier[0]).addStatement("this._restServiceDopant = _restServiceDopant", new Object[0]).build()).addMethods(resourceMethods);
                this.util.generateSourceFile(jaxRsResourceName.canonicalName(), JavaFile.builder((String)jaxRsResourceName.packageName(), (TypeSpec)resourceClassBuilder.build()).build(), latticeAppElem);
                resourceClasses.add(jaxRsResourceName);
            }
            return resourceClasses;
        }

        private static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName getJaxRsResourceName(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String packageName, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement vajramElem) {
            return ClassName.get((String)packageName, (String)(vajramElem.getSimpleName().toString() + "_JakartaRestResource"), (String[])new String[0]);
        }

        private void dopantImpl(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement latticeAppElem, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName> resourceClasses) {
            String packageName = this.util.processingEnv().getElementUtils().getPackageOf(latticeAppElem).getQualifiedName().toString();
            LatticeCodegenUtils latticeCodegenUtils = new LatticeCodegenUtils(this.util);
            ClassName dopantImplName = latticeCodegenUtils.getDopantImplName(latticeAppElem, RestServiceDopant.class);
            TypeSpec.Builder dopantImplBuilder = this.util.classBuilder(dopantImplName.simpleName()).addModifiers(new Modifier[]{Modifier.FINAL}).superclass(RestServiceDopant.class).addMethod(latticeCodegenUtils.dopantConstructorOverride(RestServiceDopant.class).build());
            if (!resourceClasses.isEmpty()) {
                dopantImplBuilder.addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethod(RestServiceDopant.class, RestServiceDopant.class.getMethod("getResources", new Class[0]).getName(), 0)).addStatement("return $T.of($L)", new Object[]{List.class, resourceClasses.stream().map(rc -> CodeBlock.of((String)"new $T(this)", (Object[])new Object[]{rc})).collect(CodeBlock.joining((String)",\n"))}).build());
            }
            this.util.generateSourceFile(dopantImplName.canonicalName(), JavaFile.builder((String)packageName, (TypeSpec)dopantImplBuilder.build()).build(), latticeAppElem);
        }

        private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent MethodSpec> resourceMethods(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo vajramInfo) {
            ArrayList<MethodSpec.Builder> resourceMethods = new ArrayList<MethodSpec.Builder>();
            @Nullable RestMethod jaxRsRestMethod = this.getJaxRsRestMethod(vajramInfo);
            if (jaxRsRestMethod == null) {
                this.util.error("A vajram with the @Path annotation must also have one of the rest method annotations: " + Arrays.stream(RestMethod.values()).map(RestMethod::latticeAnnotation).toList(), new Element[]{vajramInfo.vajramClassElem()});
                return List.of();
            }
            Map configProviders = ServiceLoader.load(ModelProtocolConfigProvider.class, this.getClass().getClassLoader()).stream().map(ServiceLoader.Provider::get).map(ModelProtocolConfigProvider::getConfig).map(ModelProtocolConfigProvider.ModelProtocolConfig::serdeProtocol).collect(Collectors.toMap(c -> Objects.requireNonNull(c.getClass().getCanonicalName()), Function.identity()));
            LinkedHashMap<FacetGenModel, FacetParamType> params = new LinkedHashMap<FacetGenModel, FacetParamType>();
            FacetGenModel body = null;
            for (FacetGenModel facet2 : vajramInfo.facetStream().toList()) {
                VariableElement facetField = facet2.facetField();
                if (facetField.getAnnotation(PathParam.class) != null) {
                    this.assignTypeToFacet(facet2, FacetParamType.PATH, params);
                }
                if (facetField.getAnnotation(QueryParam.class) != null) {
                    this.assignTypeToFacet(facet2, FacetParamType.QUERY, params);
                }
                if (facetField.getAnnotation(Body.class) == null) continue;
                this.assignTypeToFacet(facet2, FacetParamType.BODY, params);
                body = facet2;
            }
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)CodeGenUtility.lowerCaseFirstChar((String)vajramInfo.vajramName())).addAnnotation(jaxRsRestMethod.jakartaAnnotation()).addModifiers(new Modifier[]{Modifier.PUBLIC});
            ImmutableList requestSerdeProtocols = ImmutableList.of();
            for (Map.Entry entry : params.entrySet()) {
                FacetGenModel facet3 = (FacetGenModel)entry.getKey();
                FacetParamType facetParamType = (FacetParamType)((Object)entry.getValue());
                TypeMirror facetType = facet3.dataType().javaModelType(this.util.processingEnv());
                if (facetParamType == FacetParamType.PATH) {
                    methodBuilder.addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)facetType), (String)facet3.name(), (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(jakarta.ws.rs.PathParam.class).addMember("value", "$S", new Object[]{facet3.name()}).build()).build());
                    continue;
                }
                if (facetParamType == FacetParamType.QUERY) {
                    methodBuilder.addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)facetType), (String)facet3.name(), (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(jakarta.ws.rs.QueryParam.class).addMember("value", "$S", new Object[]{facet3.name()}).build()).build());
                    continue;
                }
                if (facetParamType != FacetParamType.BODY) continue;
                Element bodyTypeElem = Objects.requireNonNull(this.util.processingEnv().getTypeUtils().asElement(facetType));
                SupportedModelProtocols supportedModelProtocols = bodyTypeElem.getAnnotation(SupportedModelProtocols.class);
                if (supportedModelProtocols == null) {
                    this.util.error("Rest request Body facet " + facet3.name() + " doesn't support any ModelProtocol.", new Element[]{facet3.facetField()});
                    continue;
                }
                requestSerdeProtocols = (ImmutableList)this.util.getTypesFromAnnotationMember(() -> ((SupportedModelProtocols)supportedModelProtocols).value()).stream().filter(t -> this.util.isRawAssignable(t, SerdeProtocol.class)).map(typeMirror -> Objects.requireNonNull((TypeElement)this.util.processingEnv().getTypeUtils().asElement((TypeMirror)typeMirror))).collect(ImmutableList.toImmutableList());
                if (!requestSerdeProtocols.isEmpty()) continue;
                this.util.error("Rest request Body facet " + facet3.name() + " doesn't support any SerdeProtocols. Found: " + Arrays.toString(supportedModelProtocols.value()), new Element[]{facet3.facetField()});
            }
            methodBuilder.addParameter(ParameterSpec.builder(HttpHeaders.class, (String)"_httpHeaders", (Modifier[])new Modifier[0]).addAnnotation(Context.class).build()).addParameter(ParameterSpec.builder(UriInfo.class, (String)"_uriInfo", (Modifier[])new Modifier[0]).addAnnotation(Context.class).build());
            methodBuilder.addStatement("var _vajramRequest = $T._builder()\n  $L", new Object[]{vajramInfo.lite().immutReqPojoType(), params.keySet().stream().filter(p -> params.get(p) != FacetParamType.BODY).map(facet -> CodeBlock.builder().add(".$L($L)", new Object[]{facet.name(), facet.name()}).build()).collect(CodeBlock.joining((String)"\n"))});
            if (body != null) {
                if (!jaxRsRestMethod.supportsRequestBody()) {
                    this.util.error("Vajram %s is mapped to the rest method %s which doesn't support request body, but the vajram has a facet with the @Body annotation.".formatted(vajramInfo.vajramName(), jaxRsRestMethod), new Element[]{body.facetField()});
                }
                TypeElement requestClass = Objects.requireNonNull((TypeElement)this.util.processingEnv().getTypeUtils().asElement(body.dataType().javaModelType(this.util.processingEnv())));
                for (TypeElement serdeProtocolType : requestSerdeProtocols) {
                    SerdeProtocol serdeProtocol = (SerdeProtocol)configProviders.get(serdeProtocolType.getQualifiedName().toString());
                    if (serdeProtocol == null) continue;
                    MethodSpec.Builder serdeSpecificMethodBuilder = methodBuilder.build().toBuilder().setName(CodeGenUtility.lowerCaseFirstChar((String)vajramInfo.vajramName()) + "_" + serdeProtocol.modelClassesSuffix());
                    serdeSpecificMethodBuilder.addAnnotation(AnnotationSpec.builder(Consumes.class).addMember("value", "$S", new Object[]{serdeProtocol.contentType()}).build()).addParameter(ParameterSpec.builder(byte[].class, (String)body.name(), (Modifier[])new Modifier[0]).build());
                    serdeSpecificMethodBuilder.addStatement(CodeBlock.of((String)"_vajramRequest.$L(new $T($L))", (Object[])new Object[]{body.name(), this.util.getImmutSerdeClassName(requestClass, serdeProtocol), body.name()}));
                    resourceMethods.add(serdeSpecificMethodBuilder);
                }
            } else {
                resourceMethods.add(methodBuilder);
            }
            return resourceMethods.stream().map(r -> r.addStatement("return this._restServiceDopant.executeHttpRequest(_vajramRequest._build(), _httpHeaders, _uriInfo)", new Object[0])).map(b -> b.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(CompletionStage.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}))).map(MethodSpec.Builder::build).toList();
        }

        private @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RestMethod getJaxRsRestMethod(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo vajramInfo) {
            TypeElement typeElement = vajramInfo.vajramClassElem();
            for (RestMethod restMethod : RestMethod.values()) {
                Object annotation = typeElement.getAnnotation(restMethod.latticeAnnotation());
                if (annotation == null) continue;
                return restMethod;
            }
            return null;
        }

        private void assignTypeToFacet(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel facet, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetParamType type, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetParamType> params) {
            FacetParamType facetParamType = params.get(facet);
            if (facetParamType != null) {
                this.util.error("The facet " + facet.name() + " cannot be both " + facetParamType + " and " + type, new Element[]{facet.facetField()});
            } else {
                params.put(facet, type);
            }
        }

        private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isApplicable() {
            if (!CodegenPhase.FINAL.equals((Object)this.context.codegenPhase())) {
                this.util.note((CharSequence)"Skipping Lattice App Impl codegen current phase is not FINAL");
                return false;
            }
            return true;
        }

        static enum FacetParamType {
            PATH,
            QUERY,
            BODY;

        }
    }
}

