/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.ext.rest.quarkus.codegen;

import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenContext;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenUtils;
import com.flipkart.krystal.lattice.codegen.spi.LatticeCodeGeneratorProvider;
import com.flipkart.krystal.lattice.rest.RestService;
import com.flipkart.krystal.lattice.rest.api.Path;
import com.flipkart.krystal.model.SupportedModelProtocols;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfoLite;
import com.flipkart.krystal.vajram.json.Json;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import flipkart.krystal.lattice.ext.rest.quarkus.restServer.QuarkusRestServerDopant;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

@AutoService(value={LatticeCodeGeneratorProvider.class})
public class QuarkusRestServerDopantGenProvider
implements LatticeCodeGeneratorProvider {
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenerator create(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent LatticeCodegenContext latticeCodegenContext) {
        return new QuarkusRestServerDopantGen(latticeCodegenContext);
    }

    static class QuarkusRestServerDopantGen
    implements CodeGenerator {
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent LatticeCodegenContext context;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenUtility util;

        public QuarkusRestServerDopantGen(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent LatticeCodegenContext context) {
            this.context = context;
            this.util = context.codeGenUtility().codegenUtil();
        }

        public void generate() {
            CodegenPhase codegenPhase = this.context.codegenPhase();
            if (!CodegenPhase.FINAL.equals((Object)codegenPhase)) {
                this.util.note((CharSequence)("Skipping Quarkus Rest Server dopant impl generation because this is not codegen phase: " + CodegenPhase.FINAL));
                return;
            }
            TypeElement latticeAppElem = this.context.latticeAppTypeElement();
            String packageName = this.util.processingEnv().getElementUtils().getPackageOf(latticeAppElem).getQualifiedName().toString();
            LatticeCodegenUtils latticeCodegenUtils = new LatticeCodegenUtils(this.util);
            ClassName dopantImplName = latticeCodegenUtils.getDopantImplName(latticeAppElem, QuarkusRestServerDopant.class);
            TypeSpec.Builder classBuilder = this.util.classBuilder(dopantImplName.simpleName()).addModifiers(new Modifier[]{Modifier.FINAL}).superclass(QuarkusRestServerDopant.class);
            classBuilder.addMethod(latticeCodegenUtils.dopantConstructorOverride(QuarkusRestServerDopant.class).build());
            RestService restService = latticeAppElem.getAnnotation(RestService.class);
            this.addRoutes(restService, classBuilder);
            this.util.generateSourceFile(dopantImplName.canonicalName(), JavaFile.builder((String)packageName, (TypeSpec)classBuilder.build()).build(), latticeAppElem);
        }

        private void addRoutes(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RestService restService, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeSpec.Builder classBuilder) {
            List vajramTypes = this.util.getTypesFromAnnotationMember(() -> ((RestService)restService).resourceVajrams());
            MethodSpec.Builder methodSpec = MethodSpec.overriding((ExecutableElement)this.util.getMethod(QuarkusRestServerDopant.class, "addRoutes", 1));
            String pathPrefix = restService.pathPrefix().isEmpty() ? "" : "/" + restService.pathPrefix();
            for (TypeMirror vajramType : vajramTypes) {
                Path path;
                TypeElement vajramElement = (TypeElement)Objects.requireNonNull(this.util.processingEnv().getTypeUtils().asElement(vajramType));
                VajramInfoLite vajramInfoLite = this.context.codeGenUtility().computeVajramInfoLite(vajramElement);
                String packageName = this.util.processingEnv().getElementUtils().getPackageOf(vajramElement).getQualifiedName().toString();
                SupportedModelProtocols supportedModelProtocols = vajramElement.getAnnotation(SupportedModelProtocols.class);
                String vajramId = vajramInfoLite.vajramId().id();
                if (supportedModelProtocols != null) {
                    List modelProtocols = this.util.getTypesFromAnnotationMember(() -> ((SupportedModelProtocols)supportedModelProtocols).value());
                    if (modelProtocols.stream().anyMatch(typeMirror -> this.util.processingEnv().getTypeUtils().isSameType((TypeMirror)typeMirror, Objects.requireNonNull(this.util.processingEnv().getElementUtils().getTypeElement(Objects.requireNonNull(Json.class.getCanonicalName()))).asType()))) {
                        methodSpec.addCode("  router\n      .post($S)\n      .handler(\n          routingContext -> executeHttpRequest(\n            routingContext,\n            routingContext\n            .request()\n            .body()\n            .toCompletionStage()\n            .thenApply(\n                buffer -> new $T(buffer.getBytes()))));\n", new Object[]{pathPrefix + "/" + CodeGenUtility.lowerCaseFirstChar((String)vajramId), ClassName.get((String)packageName, (String)(vajramId + "_ReqImmut" + Json.JSON.modelClassesSuffix()), (String[])new String[0])});
                    }
                }
                if (!this.isSimplePath(path = vajramElement.getAnnotation(Path.class))) continue;
            }
            classBuilder.addMethod(methodSpec.build());
        }

        private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isSimplePath(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Path path) {
            if (path == null) {
                return false;
            }
            return path.value().matches("[\\w/]*");
        }
    }
}

