/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.mojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.flipkart.krystal.mojo.MultiProjectInfo;
import com.flipkart.krystal.mojo.ProjectInfo;
import com.flipkart.krystal.mojo.ProjectStageInfo;
import com.flipkart.krystal.mojo.PublishStage;
import com.flipkart.krystal.mojo.PublishTask;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.logging.Logger;
import org.gradle.api.publish.VariantVersionMappingStrategy;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.tasks.AbstractPublishToMaven;

final class Publisher {
    public static final String DEFAULT_VERSION = "0.0.0";
    private final Map<Project, Set<Project>> projectDependencies = new LinkedHashMap<Project, Set<Project>>();
    private final Map<Project, Set<Project>> projectToDependendents = new LinkedHashMap<Project, Set<Project>>();
    private final Map<Path, Project> absolutePathToProject = new LinkedHashMap<Path, Project>();
    private static final ObjectMapper OBJECT_MAPPER = new YAMLMapper(new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES)).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    private final Project rootProject;
    private MultiProjectInfo multiProjectInfo;
    private PublishStage publishStage;

    Publisher(Project project) {
        this.rootProject = project.getRootProject();
        this.scanAllProjects(project.getRootProject());
    }

    Map<Project, Semver> getCurrentProjectVersions(PublishStage publishStage) throws IOException {
        HashMap<Project, Semver> map = new HashMap<Project, Semver>();
        for (Project p : this.getAllProjects()) {
            if (map.put(p, Publisher.getCurrentProjectVersion(p, publishStage, this.getMultiProjectInfo())) == null) continue;
            throw new IllegalStateException("Duplicate key");
        }
        return map;
    }

    private MultiProjectInfo getMultiProjectInfo() throws IOException {
        if (this.multiProjectInfo == null) {
            this.multiProjectInfo = Publisher.readRepoInfoOrDefault(this.rootProject);
        }
        return this.multiProjectInfo;
    }

    private Set<Project> getAllProjects() {
        return this.projectDependencies.keySet();
    }

    String getMojoVersion(Project project) throws IOException {
        return Publisher.getCurrentProjectVersion(project, this.publishStage != null ? this.publishStage : Publisher.getLatestStage(Publisher.getProjectInfoOrDefault(this.getMultiProjectInfo(), project)), this.getMultiProjectInfo()).getValue();
    }

    void executePublish(PublishTask publishTask, PublishStage publishStage) throws IOException, GitAPIException {
        this.publishStage = publishStage;
        if (!this.isRootProject(publishTask.getProject())) {
            publishTask.getLogger().debug("This is not the root project, so this is a no-op");
            return;
        }
        Logger logger = this.rootProject.getLogger();
        Object[] objectArray = new Object[1];
        objectArray[0] = switch (publishStage) {
            default -> throw new IncompatibleClassChangeError();
            case PublishStage.DEV -> "MavenLocal";
            case PublishStage.PRODUCTION -> "MavenLocal, MavenCentral";
        };
        logger.lifecycle("Publish destinations: {}", objectArray);
        try (Git git = Git.open((File)((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(this.rootProject.getRootDir())).getGitDir());){
            this.validatePrePublish(git);
            LinkedHashSet<Project> projectsToPublish = new LinkedHashSet<Project>(this.findProjectsToPublish(publishStage, git));
            if (projectsToPublish.isEmpty()) {
                this.rootProject.getLogger().lifecycle("No projects have changed. Not publishing anything");
                return;
            }
            Optional<Project> nextProjectToRelease = this.getNextProjectReadyToPublish(projectsToPublish);
            while (nextProjectToRelease.isPresent()) {
                this.computePublishVersion(publishTask, nextProjectToRelease.get(), git, Publisher.getProjectInfoOrDefault(this.getMultiProjectInfo(), nextProjectToRelease.get()));
                nextProjectToRelease = this.getNextProjectReadyToPublish(projectsToPublish);
            }
            OBJECT_MAPPER.writeValue(Publisher.getProjectInfoAbsolutePath(this.rootProject).toFile(), (Object)this.getMultiProjectInfo());
        }
    }

    boolean isRootProject(Project project) {
        return this.rootProject.equals(project.getProject());
    }

    void cleanUpAfterLocalPublish(Project project) throws GitAPIException, IOException {
        if (!this.isRootProject(project)) {
            project.getLogger().debug("This is not a root project, hence not cleaning up");
            return;
        }
        File gitDir = ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(this.rootProject.getRootDir())).getGitDir();
        Path repoRoot = gitDir.toPath().getParent().toAbsolutePath();
        try (Git git = Git.open((File)gitDir);){
            this.rootProject.getLogger().lifecycle("Published only local... So undoing all local changes with git checkout -f");
            git.checkout().setForced(true).addPath(repoRoot.relativize(Publisher.getProjectInfoAbsolutePath(this.rootProject)).toString()).call();
        }
    }

    void cleanUpAfterAllPublish(Project project) throws IOException, GitAPIException {
        if (!this.isRootProject(project)) {
            project.getLogger().debug("This is not a root project, hence not cleaning up");
            return;
        }
        try (Git git = Git.open((File)((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(this.rootProject.getRootDir())).getGitDir());){
            this.rootProject.getLogger().lifecycle("Published to all repos (including remote)... So committing local changes local changes with git commit.\nYou can push the changes if you prefer, or squash multiple such commits before pushing");
            if (!git.status().call().isClean()) {
                git.commit().setAll(true).setMessage("[Mojo AutoPublish] Updating multi_project_info.mojo.yaml with latest auto-published versions. Root version: " + Publisher.getCurrentProjectVersion(this.rootProject, this.publishStage, this.getMultiProjectInfo()).getValue()).call();
            }
        }
    }

    private static Semver getCurrentProjectVersion(Project project, PublishStage publishStage, MultiProjectInfo multiProjectInfo) {
        ProjectInfo projectInfo = Publisher.getProjectInfoOrDefault(multiProjectInfo, project);
        return new Semver(projectInfo.getStageInfo(publishStage).map(ProjectStageInfo::getVersion).or(() -> projectInfo.getStageInfo(PublishStage.PRODUCTION).map(ProjectStageInfo::getVersion)).orElse(DEFAULT_VERSION));
    }

    void updatePublicationVersions(Project project) throws IOException {
        ProjectInfo projectInfo = Publisher.getProjectInfoOrDefault(this.getMultiProjectInfo(), project);
        Publisher.updatePublishTaskVersions(project, projectInfo.getStageInfo(Publisher.getLatestStage(projectInfo)).orElseThrow().getVersion());
    }

    private static PublishStage getLatestStage(ProjectInfo projectInfo) {
        return projectInfo.getStageInfos().stream().max(Comparator.comparing(projectStageInfo -> Optional.ofNullable(projectStageInfo.getPublishTime()).orElse(Instant.MIN))).orElseThrow().getStage();
    }

    private void validatePrePublish(Git git) throws GitAPIException {
        Preconditions.checkArgument((boolean)RepositoryState.SAFE.equals((Object)git.getRepository().getRepositoryState()), (Object)"Repository is not in stable state. Please finish any unfinished merge/rebase/revert etc.");
        Status status = git.status().call();
        Preconditions.checkArgument((status.isClean() || status.getModified().size() == 1 && this.isProjectInfoPath(Path.of((String)status.getModified().iterator().next(), new String[0]), git) && status.getUntracked().isEmpty() ? 1 : 0) != 0, (Object)"Cannot publish when git working tree is not clean.\nPlease make sure 'git status' reports a clean working tree before mojo publish");
    }

    private Optional<Project> getNextProjectReadyToPublish(Set<Project> projectsToPublish) {
        Optional<Project> project = projectsToPublish.stream().filter(p -> !this.hasDependencyPendingRelease((Project)p, projectsToPublish)).findAny();
        project.ifPresent(projectsToPublish::remove);
        return project;
    }

    private boolean hasDependencyPendingRelease(Project project, Set<Project> projectsToPublish) {
        return this.projectDependencies.getOrDefault(project, Set.of()).stream().anyMatch(p -> projectsToPublish.contains(p) || this.hasDependencyPendingRelease((Project)p, projectsToPublish));
    }

    private void scanAllProjects(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        Sets.SetView dependencies = Sets.union(Optional.ofNullable((Configuration)configurations.findByName("implementation")).map(Configuration::getAllDependencies).map(d -> d.withType(ProjectDependency.class)).orElse(Set.of()), Optional.ofNullable((Configuration)configurations.findByName("api")).map(Configuration::getAllDependencies).map(d -> d.withType(ProjectDependency.class)).orElse(Set.of()));
        this.projectDependencies.put(project, dependencies.stream().map(ProjectDependency::getDependencyProject).collect(Collectors.toSet()));
        this.absolutePathToProject.put(project.getProjectDir().toPath(), project);
        dependencies.forEach(p -> this.projectToDependendents.computeIfAbsent(p.getDependencyProject(), _p -> new LinkedHashSet()).add(project));
        project.getSubprojects().forEach(this::scanAllProjects);
    }

    private Set<Project> findProjectsToPublish(PublishStage publishStage, Git git) throws IOException, GitAPIException {
        ObjectReader reader = git.getRepository().newObjectReader();
        LinkedHashSet<Project> projectsToPublish = new LinkedHashSet<Project>();
        String baseCommitId = this.getMultiProjectInfo().getBaseCommitId();
        if (baseCommitId == null) {
            this.rootProject.getLogger().lifecycle("Base commit id is missing for {} in stage {}. Force publishing all projects", new Object[]{this.rootProject, publishStage});
            projectsToPublish.addAll(this.getAllProjects());
        } else {
            AbstractTreeIterator baseTree = this.getCanonicalTreeParser(git.getRepository().resolve(baseCommitId), reader, git);
            AbstractTreeIterator headTree = this.getCanonicalTreeParser(git.getRepository().resolve("HEAD"), reader, git);
            git.diff().setShowNameOnly(true).setOldTree(baseTree).setNewTree(headTree).call().stream().flatMap(d -> Stream.of(d.getOldPath(), d.getNewPath())).map(x$0 -> Path.of(x$0, new String[0])).distinct().filter(path -> !this.isProjectInfoPath((Path)path, git)).peek(path -> this.rootProject.getLogger().debug("Found changed file {}", path)).map(p -> this.getProjectOf((Path)p, git)).peek(p -> this.rootProject.getLogger().debug("Resolved project for the above path: {}", p)).filter(Optional::isPresent).map(Optional::get).distinct().forEach(project -> this.collectDependentsTransitively((Project)project, (Set<Project>)projectsToPublish));
        }
        return projectsToPublish;
    }

    private boolean isProjectInfoPath(Path path, Git git) {
        Path projectInfoAbsolutePath = Publisher.getProjectInfoAbsolutePath(this.rootProject);
        return path.equals(projectInfoAbsolutePath) || git.getRepository().getDirectory().toPath().getParent().relativize(projectInfoAbsolutePath).equals(path);
    }

    private AbstractTreeIterator getCanonicalTreeParser(ObjectId commitId, ObjectReader reader, Git git) throws IOException {
        try (RevWalk walk = new RevWalk(git.getRepository());){
            RevCommit commit = walk.parseCommit((AnyObjectId)commitId);
            ObjectId treeId = commit.getTree().getId();
            CanonicalTreeParser canonicalTreeParser = new CanonicalTreeParser(null, reader, (AnyObjectId)treeId);
            return canonicalTreeParser;
        }
    }

    private void collectDependentsTransitively(Project project, Set<Project> collector) {
        collector.add(project);
        for (Project p : this.projectToDependendents.getOrDefault(project, Set.of())) {
            this.collectDependentsTransitively(p, collector);
        }
    }

    private Optional<Project> getProjectOf(Path path, Git git) {
        Path repoRoot = git.getRepository().getDirectory().toPath().getParent().toAbsolutePath();
        do {
            Project project;
            if ((project = this.absolutePathToProject.get(repoRoot.resolve(path))) == null) continue;
            return Optional.of(project);
        } while ((path = path.getParent()) != null);
        return Optional.empty();
    }

    private void computePublishVersion(PublishTask publishTask, Project project, Git git, ProjectInfo projectInfo) throws IOException {
        Semver currentVersion = Publisher.getCurrentProjectVersion(project, this.publishStage, this.getMultiProjectInfo());
        boolean shouldIncrementVersion = PublishStage.PRODUCTION.equals((Object)projectInfo.getStageInfo(this.publishStage).map(ProjectStageInfo::getStage).orElse(PublishStage.PRODUCTION));
        Semver nextVersion = shouldIncrementVersion ? publishTask.getPublishLevel().toNextVersion(currentVersion) : currentVersion.withClearedSuffixAndBuild();
        String featureName = publishTask.getFeatureName();
        if (featureName == null) {
            featureName = git.getRepository().getBranch();
        }
        String semVerString = this.publishStage.decorateVersion(nextVersion, featureName).getValue();
        ProjectStageInfo projectStageInfo = projectInfo.getStageInfo(this.publishStage).orElseGet(() -> {
            ProjectStageInfo stageInfo = new ProjectStageInfo();
            stageInfo.setStage(this.publishStage);
            projectInfo.getStageInfos().add(stageInfo);
            return stageInfo;
        });
        projectStageInfo.setVersion(semVerString);
        String commitId = git.getRepository().resolve("HEAD").name();
        projectStageInfo.setCommitId(commitId);
        projectStageInfo.setPublishTime(Instant.now());
        if (PublishStage.PRODUCTION.equals((Object)this.publishStage)) {
            this.getMultiProjectInfo().setBaseCommitId(commitId);
            projectInfo.getStageInfos().removeIf(stageInfo -> PublishStage.DEV.equals((Object)stageInfo.getStage()));
        }
        project.getLogger().lifecycle("Publishing {} with version {}", new Object[]{project.getDisplayName(), semVerString});
    }

    private static void updatePublishTaskVersions(Project project, String versionString) {
        project.getLogger().lifecycle("Updating publications of {} to version {}", new Object[]{project, versionString});
        project.setVersion((Object)versionString);
        project.getTasks().withType(AbstractPublishToMaven.class).forEach(publishTask -> {
            MavenPublication publication = publishTask.getPublication();
            publication.setVersion(versionString);
            if (publication instanceof MavenPublicationInternal) {
                MavenPublicationInternal internalPublication = (MavenPublicationInternal)publication;
                internalPublication.getMavenProjectIdentity().getVersion().set((Object)versionString);
                internalPublication.getVersionMappingStrategy().allVariants(VariantVersionMappingStrategy::fromResolutionResult);
            }
        });
    }

    private static ProjectInfo getProjectInfoOrDefault(MultiProjectInfo multiProjectInfo, Project project) {
        String projectName = project.getName();
        List<ProjectInfo> projects = multiProjectInfo.getProjects();
        ProjectInfo projectInfo = projects.stream().filter(p -> projectName.equals(p.getName())).findAny().orElse(null);
        if (projectInfo == null) {
            projectInfo = new ProjectInfo(projectName);
            projectInfo.getStageInfos().add(new ProjectStageInfo(PublishStage.PRODUCTION, DEFAULT_VERSION, null, Instant.now()));
            projects.add(projectInfo);
        }
        return projectInfo;
    }

    private static MultiProjectInfo readRepoInfoOrDefault(Project project) throws IOException {
        File repoInfoFile = Publisher.getProjectInfoAbsolutePath(project).toFile();
        if (repoInfoFile.exists()) {
            return (MultiProjectInfo)OBJECT_MAPPER.readValue(repoInfoFile, MultiProjectInfo.class);
        }
        return new MultiProjectInfo();
    }

    private static Path getProjectInfoAbsolutePath(Project project) {
        return project.getRootDir().toPath().resolve("multi_project_info.mojo.yaml");
    }
}

