/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen;

import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.codegen.VajramCodeGenerator;
import com.flipkart.krystal.vajram.codegen.models.ParsedVajramData;
import com.flipkart.krystal.vajram.codegen.models.VajramInputFile;
import com.flipkart.krystal.vajram.codegen.models.VajramInputsDef;
import com.flipkart.krystal.vajram.codegen.utils.CodegenUtils;
import com.flipkart.krystal.vajram.codegen.utils.Constants;
import com.flipkart.krystal.vajram.das.DataAccessSpec;
import com.flipkart.krystal.vajram.exception.VajramValidationException;
import com.flipkart.krystal.vajram.inputs.Dependency;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VajramCodeGenFacade {
    private static final Logger log = LoggerFactory.getLogger(VajramCodeGenFacade.class);
    public static final String INPUTS_FILE_EXTENSION = ".vajram.yaml";
    private final List<Path> srcDirs;
    private final Path compiledClassesDir;
    private final Path generatedSrcDir;
    private Iterable<? extends File> compileClasspath;

    public static void main(String[] args) {
        Options options = new Options();
        String command = args[0];
        options.addOption(Option.builder((String)"j").longOpt("javaDir").hasArg().desc("Root Directory for all .java files").required().build());
        options.addOption(Option.builder((String)"v").longOpt("vajramFile").hasArg().desc("FilePath of the vajram input file for which request code will be generated").required().build());
        options.addOption(Option.builder((String)"g").longOpt("generatedSrcDir").hasArg().desc("Root Directory for generated source code").build());
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        if ("codeVajramModels".equals(command)) {
            try {
                Path generatedSrcDir;
                CommandLine cmd = parser.parse(options, Arrays.copyOfRange(args, 1, args.length));
                Path vajramInputFilePath = Path.of(cmd.getOptionValue("v"), new String[0]);
                if (!vajramInputFilePath.getFileName().toString().endsWith(INPUTS_FILE_EXTENSION)) {
                    return;
                }
                Path javaSrcDirPath = Path.of(cmd.getOptionValue("j"), new String[0]);
                if (cmd.getOptionValue("g") == null) {
                    Path sourceSetPath = javaSrcDirPath.getParent();
                    String sourceSetName = sourceSetPath.getFileName().toString();
                    generatedSrcDir = sourceSetPath.getParent().getParent().resolve(Path.of("build", "generated", "sources", "vajrams", sourceSetName, "java"));
                } else {
                    generatedSrcDir = Path.of(cmd.getOptionValue("g"), new String[0]);
                }
                new VajramCodeGenFacade(List.of(javaSrcDirPath), null, generatedSrcDir).codeGenModels(javaSrcDirPath, javaSrcDirPath.relativize(vajramInputFilePath));
            }
            catch (ParseException e) {
                log.error("Command line options could not be parsed", (Throwable)e);
                formatter.printHelp("Vajram Code Generator", options);
                System.exit(1);
            }
            catch (IOException e) {
                log.error("Error reading vajramInputFile", (Throwable)e);
                System.exit(1);
            }
        }
    }

    public static void codeGenModels(Set<? extends File> srcDirs, String destinationDir) throws Exception {
        new VajramCodeGenFacade(srcDirs.stream().map(File::toPath).toList(), null, Path.of(destinationDir, new String[0])).codeGenModels();
    }

    public static void codeGenVajramImpl(Set<? extends File> srcDirs, String compiledDir, String destinationDir, Iterable<? extends File> classpath) throws Exception {
        new VajramCodeGenFacade(srcDirs.stream().map(File::toPath).toList(), Path.of(compiledDir, new String[0]), Path.of(destinationDir, new String[0]), classpath).codeGenVajramImpl();
    }

    public VajramCodeGenFacade(List<Path> srcDirs, Path compiledClassesDir, Path generatedSrcDir) {
        this(srcDirs, compiledClassesDir, generatedSrcDir, Collections.emptyList());
    }

    public VajramCodeGenFacade(List<Path> srcDirs, Path compiledClassesDir, Path generatedSrcDir, Iterable<? extends File> compileClasspath) {
        this.compiledClassesDir = compiledClassesDir;
        this.srcDirs = Collections.unmodifiableList(srcDirs);
        this.generatedSrcDir = generatedSrcDir;
        this.compileClasspath = compileClasspath;
    }

    private void codeGenModels() throws Exception {
        ImmutableList<VajramInputFile> inputFiles = this.getInputDefinitions();
        for (VajramInputFile inputFile : inputFiles) {
            this.codeGenModels(inputFile);
        }
    }

    private void codeGenModels(Path srcDir, Path vajramInputRelativePath) throws IOException {
        this.codeGenModels(VajramCodeGenFacade.toVajramInputFile(new VajramInputsDef.InputFilePath(srcDir, vajramInputRelativePath)));
    }

    private void codeGenModels(VajramInputFile inputFile) {
        try {
            VajramCodeGenerator vajramCodeGenerator = new VajramCodeGenerator(inputFile, Collections.emptyMap(), Collections.emptyMap());
            this.codeGenRequest(vajramCodeGenerator);
            this.codeGenUtil(vajramCodeGenerator);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not generate code for file %s".formatted(inputFile.inputFilePath().relativeFilePath()), e);
        }
    }

    private void codeGenRequest(VajramCodeGenerator vajramCodeGenerator) throws IOException {
        File vajramJavaDir = Paths.get(this.generatedSrcDir.toString(), vajramCodeGenerator.getPackageName().split("\\.")).toFile();
        if (vajramJavaDir.isDirectory() || vajramJavaDir.mkdirs()) {
            String vajramRequestJavaCode = vajramCodeGenerator.codeGenVajramRequest();
            File vajramRequestSourceFile = new File(vajramJavaDir, vajramCodeGenerator.getRequestClassName() + ".java");
            Files.writeString(vajramRequestSourceFile.toPath(), (CharSequence)vajramRequestJavaCode, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
    }

    private void codeGenVajramImpl() throws Exception {
        ImmutableList<VajramInputFile> inputFiles = this.getInputDefinitions();
        ClassLoader systemClassLoader = VajramID.class.getClassLoader();
        ArrayList<URL> urls = new ArrayList<URL>();
        this.srcDirs.forEach(path -> {
            try {
                urls.add(path.toFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.error("Malformed url {}", (Object)path.toFile().toURI());
                throw new RuntimeException(e);
            }
        });
        this.compileClasspath.forEach(file -> {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.error("Malformed url {}", (Object)file.toURI());
                throw new RuntimeException(e);
            }
        });
        urls.add(this.compiledClassesDir.toFile().toURI().toURL());
        try (URLClassLoader urlcl = new URLClassLoader((URL[])urls.toArray(URL[]::new), systemClassLoader);){
            HashMap vajramDefs = new HashMap();
            HashMap vajramInputsDef = new HashMap();
            inputFiles.forEach(vajramInputFile -> {
                Optional<ParsedVajramData> parsedVajramData = ParsedVajramData.fromVajram(urlcl, vajramInputFile);
                if (parsedVajramData.isEmpty()) {
                    log.warn("VajramImpl codegen will be skipped for {}. ", (Object)vajramInputFile.vajramName());
                } else {
                    vajramDefs.put(parsedVajramData.get().vajramName(), parsedVajramData.get());
                    vajramInputsDef.put(vajramInputFile.vajramName(), vajramInputFile.vajramInputsDef().allInputsDefinitions());
                }
            });
            inputFiles.forEach(vajramInputFile -> vajramInputFile.vajramInputsDef().allInputsDefinitions().forEach(inputDef -> {
                Dependency dependency;
                DataAccessSpec patt10336$temp;
                if (inputDef instanceof Dependency && (patt10336$temp = (dependency = (Dependency)inputDef).dataAccessSpec()) instanceof VajramID) {
                    VajramID vajramID = (VajramID)patt10336$temp;
                    String depVajramClass = (String)vajramID.className().orElseThrow(() -> new VajramValidationException("Vajram class missing in VajramInputDefinition for :" + vajramID));
                    String[] splits = Constants.DOT_PATTERN.split(depVajramClass);
                    String depPackageName = Arrays.stream(splits, 0, splits.length - 1).collect(Collectors.joining("."));
                    String vajramName = splits[splits.length - 1];
                    if (!vajramDefs.containsKey(vajramName)) {
                        try {
                            Class<?> vajramClass = urlcl.loadClass(depVajramClass);
                            HashMap<String, Field> fields = new HashMap<String, Field>();
                            Arrays.stream(vajramClass.getDeclaredFields()).forEach(field -> fields.put(field.getName(), (Field)field));
                            ParsedVajramData parsedVajramData1 = new ParsedVajramData(vajramName, null, null, vajramClass, depPackageName, fields);
                            vajramDefs.put(vajramName, parsedVajramData1);
                            Class<?> parsedVajramImpl = urlcl.loadClass(depPackageName + "." + CodegenUtils.getVajramImplClassName(vajramName));
                            Method getInputDefinitions = parsedVajramImpl.getDeclaredMethod("getInputDefinitions", new Class[0]);
                            Vajram vajram = (Vajram)parsedVajramImpl.getConstructor(new Class[0]).newInstance(new Object[0]);
                            vajramInputsDef.put(vajramName, (ImmutableList)getInputDefinitions.invoke((Object)vajram, new Object[0]));
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }));
            inputFiles.forEach(inputFile -> {
                if (vajramDefs.containsKey(inputFile.vajramName())) {
                    try {
                        VajramCodeGenerator vajramCodeGenerator = new VajramCodeGenerator((VajramInputFile)inputFile, vajramDefs, vajramInputsDef);
                        this.codeGenVajramImpl(vajramCodeGenerator, urlcl);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not generate vajram impl for file %s".formatted(inputFile.inputFilePath().relativeFilePath()), e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while generating vajram impl", e);
        }
    }

    private void codeGenVajramImpl(VajramCodeGenerator vajramCodeGenerator, ClassLoader classLoader) throws IOException {
        File vajramJavaDir = Paths.get(this.generatedSrcDir.toString(), vajramCodeGenerator.getPackageName().split("\\.")).toFile();
        if (vajramJavaDir.isDirectory() || vajramJavaDir.mkdirs()) {
            String vajramImplCode = vajramCodeGenerator.codeGenVajramImpl(classLoader);
            File vajramImplSourceFile = new File(vajramJavaDir, CodegenUtils.getVajramImplClassName(vajramCodeGenerator.getVajramName()) + ".java");
            Files.writeString(vajramImplSourceFile.toPath(), (CharSequence)vajramImplCode, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
    }

    private void codeGenUtil(VajramCodeGenerator vajramCodeGenerator) throws IOException {
        File vajramJavaDir = Paths.get(this.generatedSrcDir.toString(), vajramCodeGenerator.getPackageName().split("\\.")).toFile();
        if (vajramJavaDir.isDirectory() || vajramJavaDir.mkdirs()) {
            String vajramRequestJavaCode = vajramCodeGenerator.codeGenInputUtil();
            File vajramImplSourceFile = new File(vajramJavaDir, CodegenUtils.getInputUtilClassName(vajramCodeGenerator.getVajramName()) + ".java");
            Files.writeString(vajramImplSourceFile.toPath(), (CharSequence)vajramRequestJavaCode, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
    }

    ImmutableList<VajramInputFile> getInputDefinitions() throws Exception {
        ArrayList<VajramInputFile> vajramInputFiles = new ArrayList<VajramInputFile>();
        Set<VajramInputsDef.InputFilePath> inputFiles = this.getInputsYamlFiles();
        for (VajramInputsDef.InputFilePath inputFile : inputFiles) {
            vajramInputFiles.add(VajramCodeGenFacade.toVajramInputFile(inputFile));
        }
        return ImmutableList.copyOf(vajramInputFiles);
    }

    private static VajramInputFile toVajramInputFile(VajramInputsDef.InputFilePath inputFile) throws IOException {
        String fileName = inputFile.relativeFilePath().getFileName().toString();
        String vajramName = fileName.substring(0, fileName.length() - INPUTS_FILE_EXTENSION.length());
        VajramInputFile vajramInputFile = new VajramInputFile(vajramName, inputFile, VajramInputsDef.from(inputFile.absolutePath().toFile()));
        return vajramInputFile;
    }

    private Set<VajramInputsDef.InputFilePath> getInputsYamlFiles() throws IOException {
        LinkedHashSet<VajramInputsDef.InputFilePath> inputFilePaths = new LinkedHashSet<VajramInputsDef.InputFilePath>();
        for (Path srcDir : this.srcDirs) {
            if (!srcDir.toFile().isDirectory()) continue;
            Stream<Path> vajramInputPathStream = Files.find(srcDir, 100, (path, fileAttributes) -> {
                if (!fileAttributes.isRegularFile()) {
                    return false;
                }
                return path.getFileName().toString().endsWith(INPUTS_FILE_EXTENSION);
            }, new FileVisitOption[0]);
            try {
                vajramInputPathStream.forEach(p -> inputFilePaths.add(new VajramInputsDef.InputFilePath(srcDir, srcDir.relativize((Path)p))));
            }
            finally {
                if (vajramInputPathStream == null) continue;
                vajramInputPathStream.close();
            }
        }
        return inputFilePaths;
    }
}

