/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.models;

import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.VajramLogic;
import com.flipkart.krystal.vajram.codegen.models.InputDef;
import com.flipkart.krystal.vajram.codegen.models.VajramInputFile;
import com.flipkart.krystal.vajram.codegen.utils.CodegenUtils;
import com.flipkart.krystal.vajram.exception.VajramValidationException;
import com.flipkart.krystal.vajram.inputs.Resolve;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ParsedVajramData(String vajramName, List<Method> resolveMethods, Method vajramLogic, Class vajramClass, String packageName, Map<String, Field> fields) {
    private static final Logger log = LoggerFactory.getLogger(ParsedVajramData.class);
    public static final String DOT_SEPARATOR = ".";

    public static Optional<ParsedVajramData> fromVajram(ClassLoader classLoader, VajramInputFile inputFile) {
        String packageName = CodegenUtils.getPackageFromPath(inputFile.inputFilePath().relativeFilePath());
        Class<?> result = null;
        ClassLoader systemClassLoader = VajramID.class.getClassLoader();
        HashMap<String, Field> fields = new HashMap<String, Field>();
        try {
            result = classLoader.loadClass(packageName + DOT_SEPARATOR + inputFile.vajramName());
            for (Method method : result.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(VajramLogic.class) && !method.isAnnotationPresent(Resolve.class) || Modifier.isStatic(method.getModifiers())) continue;
                throw new VajramValidationException("Vajram class %s has non-static method %s".formatted(inputFile.vajramName(), method.getName()));
            }
            String inputUtilClass = packageName + DOT_SEPARATOR + CodegenUtils.getInputUtilClassName(inputFile.vajramName());
            Class<?> inputUtilCls = classLoader.loadClass(inputUtilClass);
            boolean needsModulation = inputFile.vajramInputsDef().inputs().stream().anyMatch(InputDef::isNeedsModulation);
            if (needsModulation) {
                Class<?> inputsCls = classLoader.loadClass(packageName + DOT_SEPARATOR + CodegenUtils.getInputUtilClassName(inputFile.vajramName()) + "$" + CodegenUtils.getInputModulationClassname(inputFile.vajramName()));
                Arrays.stream(inputsCls.getDeclaredFields()).forEach(field -> fields.put(field.getName(), (Field)field));
            } else {
                Class<?> allInputsCls = classLoader.loadClass(packageName + DOT_SEPARATOR + CodegenUtils.getInputUtilClassName(inputFile.vajramName()) + "$" + CodegenUtils.getAllInputsClassname(inputFile.vajramName()));
                Arrays.stream(allInputsCls.getDeclaredFields()).forEach(field -> fields.put(field.getName(), (Field)field));
            }
            String requestClass = packageName + DOT_SEPARATOR + CodegenUtils.getRequestClassName(inputFile.vajramName());
            classLoader.loadClass(requestClass);
        }
        catch (ClassNotFoundException e) {
            log.warn("Vajram class not found for {}", (Object)inputFile.vajramName(), (Object)e);
            return Optional.empty();
        }
        ArrayList<Method> resolveMethods = new ArrayList<Method>();
        Method vajramLogic = null;
        for (Method method : result.getDeclaredMethods()) {
            if (method.isAnnotationPresent(Resolve.class)) {
                resolveMethods.add(method);
                continue;
            }
            if (!method.isAnnotationPresent(VajramLogic.class)) continue;
            if (vajramLogic == null) {
                vajramLogic = method;
                continue;
            }
            throw new RuntimeException("Multiple VajramLogic annotated methods found in " + result.getClass().getSimpleName());
        }
        return Optional.of(new ParsedVajramData(inputFile.vajramName(), resolveMethods, vajramLogic, result, packageName, fields));
    }
}

