/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.utils;

import com.flipkart.krystal.vajram.VajramRequest;
import com.flipkart.krystal.vajram.inputs.DependencyCommand;
import com.google.common.base.CaseFormat;
import com.google.common.primitives.Primitives;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodegenUtils {
    private static final Logger log = LoggerFactory.getLogger(CodegenUtils.class);
    public static final String DOT = ".";
    public static final String COMMA = ",";
    private static final Pattern COMPILE = Pattern.compile(".");
    public static final String REQUEST = "Request";
    public static final String IMPL = "Impl";
    public static final String INPUT_UTIL = "InputUtil";
    public static final String VAJRAM = "vajram";
    public static final String CONVERTER = "CONVERTER";

    private CodegenUtils() {
    }

    public static String getPackageFromPath(Path filePath) {
        Path parentDir = filePath.getParent();
        return IntStream.range(0, parentDir.getNameCount()).mapToObj(i -> parentDir.getName(i).toString()).collect(Collectors.joining(DOT));
    }

    public static String getInputUtilClassName(String vajramName) {
        return (vajramName.toLowerCase().endsWith(VAJRAM) ? vajramName.substring(0, vajramName.length() - 6) : vajramName) + INPUT_UTIL;
    }

    public static String getRequestClassName(String vajramName) {
        return (vajramName.toLowerCase().endsWith(VAJRAM) ? vajramName.substring(0, vajramName.length() - 6) : vajramName) + REQUEST;
    }

    public static String getVajramImplClassName(String vajramName) {
        return vajramName + IMPL;
    }

    public static String getVajramBaseName(String vajramName) {
        return vajramName.toLowerCase().endsWith(VAJRAM) ? vajramName.substring(0, vajramName.length() - 6) : vajramName;
    }

    public static String getVajramNameFromClass(String vajramClassFullName) {
        String[] splits = COMPILE.split(vajramClassFullName);
        return splits[splits.length - 1];
    }

    public static String toJavaName(String input) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, input);
    }

    public static String getAllInputsClassname(String vajramName) {
        return CodegenUtils.getVajramBaseName(vajramName) + "AllInputs";
    }

    public static String getCommonInputsClassname(String vajramName) {
        return CodegenUtils.getVajramBaseName(vajramName) + "CommonInputs";
    }

    public static String getInputModulationClassname(String vajramName) {
        return CodegenUtils.getVajramBaseName(vajramName) + "InputsNeedingModulation";
    }

    public static TypeName getMethodReturnType(Method method) {
        if (method.getGenericReturnType() instanceof ParameterizedType) {
            return CodegenUtils.getType(method.getGenericReturnType());
        }
        return TypeName.get(method.getReturnType());
    }

    public static TypeName getMethodGenericReturnType(Method method) {
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            ParameterizedType genericReturnType = (ParameterizedType)type;
            Type[] actualTypeArguments = genericReturnType.getActualTypeArguments();
            if (actualTypeArguments.length == 1) {
                if (actualTypeArguments[0] instanceof ParameterizedType) {
                    return ParameterizedTypeName.get((ClassName)((ClassName)CodegenUtils.getType(((ParameterizedType)actualTypeArguments[0]).getRawType())), (TypeName[])((TypeName[])Arrays.stream(((ParameterizedType)actualTypeArguments[0]).getActualTypeArguments()).map(CodegenUtils::getType).toArray(TypeName[]::new)));
                }
                return CodegenUtils.getType(actualTypeArguments[0]);
            }
            return ParameterizedTypeName.get((ClassName)((ClassName)CodegenUtils.getType(actualTypeArguments[0])), (TypeName[])((TypeName[])Arrays.stream(actualTypeArguments).skip(1L).map(CodegenUtils::getType).toArray(TypeName[]::new)));
        }
        return ClassName.get((Class)Primitives.wrap(method.getReturnType()));
    }

    public static TypeName getClassGenericArgumentsType(Class klass) {
        Type type = klass.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType genericReturnType = (ParameterizedType)type;
            Type typeArg = genericReturnType.getActualTypeArguments()[0];
            if (typeArg instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)typeArg;
                return CodegenUtils.getType(typeArg);
            }
            if (typeArg instanceof Class) {
                return ClassName.get((Class)Primitives.wrap((Class)((Class)typeArg)));
            }
            return ClassName.bestGuess((String)typeArg.getTypeName());
        }
        return TypeName.VOID;
    }

    public static TypeName getType(Type typeArg) {
        if (typeArg instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)typeArg;
            Type rawType = parameterizedType.getRawType();
            Type[] typeArgs = parameterizedType.getActualTypeArguments();
            return ParameterizedTypeName.get((ClassName)((ClassName)CodegenUtils.getType(rawType)), (TypeName[])((TypeName[])Arrays.stream(typeArgs).map(CodegenUtils::getType).toArray(TypeName[]::new)));
        }
        if (typeArg instanceof Class) {
            return ClassName.get((Class)Primitives.wrap((Class)((Class)typeArg)));
        }
        return ClassName.bestGuess((String)typeArg.getTypeName());
    }

    public static boolean isDepResolverFanout(Class dependencyVajram, Method resolverMethod, String[] inputs, Map<String, Field> fields) {
        TypeName classGenericArgumentsType = CodegenUtils.getClassGenericArgumentsType(dependencyVajram);
        TypeName methodGenericReturnType = CodegenUtils.getMethodReturnType(resolverMethod);
        if (methodGenericReturnType.equals((Object)classGenericArgumentsType)) {
            return false;
        }
        if (methodGenericReturnType instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)methodGenericReturnType;
            try {
                Class<?> methodRawType = null;
                methodRawType = Objects.nonNull(parameterizedTypeName.rawType.enclosingClassName()) ? Class.forName(parameterizedTypeName.rawType.enclosingClassName() + "$" + parameterizedTypeName.rawType.simpleName()) : Class.forName(parameterizedTypeName.rawType.canonicalName());
                TypeName typeName = (TypeName)parameterizedTypeName.typeArguments.get(0);
                if (DependencyCommand.class.isAssignableFrom(methodRawType)) {
                    return false;
                }
                if (Iterable.class.isAssignableFrom(methodRawType)) {
                    if (typeName instanceof ParameterizedTypeName && typeName.equals((Object)classGenericArgumentsType)) {
                        return true;
                    }
                    if (ClassName.get(VajramRequest.class).equals((Object)typeName) && Iterable.class.isAssignableFrom(methodRawType)) {
                        return true;
                    }
                    AtomicBoolean fanout = new AtomicBoolean(false);
                    Stream.of(inputs).forEach(input -> {
                        String key = CodegenUtils.toJavaName(input);
                        if (fields.containsKey(key)) {
                            Field field = (Field)fields.get(CodegenUtils.toJavaName(input));
                            if (typeName.equals((Object)CodegenUtils.getType(field.getType())) && !fanout.get()) {
                                fanout.set(true);
                            }
                        } else {
                            log.error("Field {} not found in {}", (Object)key, (Object)dependencyVajram.getName());
                            throw new RuntimeException(String.format("field %s not found in %s vajram", key, dependencyVajram.getName()));
                        }
                    });
                    return fanout.get();
                }
                assert (typeName instanceof ClassName);
                Class<?> typeClass = Class.forName(((ClassName)typeName).canonicalName());
                if (typeName.equals((Object)classGenericArgumentsType) && Iterable.class.isAssignableFrom(methodRawType)) {
                    return true;
                }
                if (VajramRequest.class.isAssignableFrom(typeClass) && Iterable.class.isAssignableFrom(methodRawType)) {
                    return true;
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }
}

