/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.datatypes.JavaType;
import com.flipkart.krystal.datatypes.TypeUtils;
import com.flipkart.krystal.utils.SkippedExecutionException;
import com.flipkart.krystal.vajram.DependencyResponse;
import com.flipkart.krystal.vajram.IOVajram;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.VajramRequest;
import com.flipkart.krystal.vajram.Vajrams;
import com.flipkart.krystal.vajram.codegen.models.AbstractInput;
import com.flipkart.krystal.vajram.codegen.models.DependencyDef;
import com.flipkart.krystal.vajram.codegen.models.InputDef;
import com.flipkart.krystal.vajram.codegen.models.ParsedVajramData;
import com.flipkart.krystal.vajram.codegen.models.VajramDependencyDef;
import com.flipkart.krystal.vajram.codegen.models.VajramInputFile;
import com.flipkart.krystal.vajram.codegen.models.VajramInputsDef;
import com.flipkart.krystal.vajram.codegen.utils.CodegenUtils;
import com.flipkart.krystal.vajram.codegen.utils.Constants;
import com.flipkart.krystal.vajram.das.DataAccessSpec;
import com.flipkart.krystal.vajram.exception.VajramValidationException;
import com.flipkart.krystal.vajram.inputs.Dependency;
import com.flipkart.krystal.vajram.inputs.DependencyCommand;
import com.flipkart.krystal.vajram.inputs.Input;
import com.flipkart.krystal.vajram.inputs.InputSource;
import com.flipkart.krystal.vajram.inputs.InputValuesAdaptor;
import com.flipkart.krystal.vajram.inputs.MultiExecute;
import com.flipkart.krystal.vajram.inputs.SingleExecute;
import com.flipkart.krystal.vajram.inputs.Using;
import com.flipkart.krystal.vajram.inputs.VajramDependencyTypeSpec;
import com.flipkart.krystal.vajram.inputs.VajramInputDefinition;
import com.flipkart.krystal.vajram.inputs.VajramInputTypeSpec;
import com.flipkart.krystal.vajram.inputs.resolution.Resolve;
import com.flipkart.krystal.vajram.modulation.InputsConverter;
import com.flipkart.krystal.vajram.modulation.ModulatedInput;
import com.flipkart.krystal.vajram.modulation.UnmodulatedInput;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VajramCodeGenerator {
    private static final Logger log = LoggerFactory.getLogger(VajramCodeGenerator.class);
    private final String packageName;
    private final String requestClassName;
    private final VajramInputFile vajramInputFile;
    private final String vajramName;
    private final Map<String, ParsedVajramData> vajramDefs;
    private final Map<String, ImmutableList<VajramInputDefinition>> vajramInputsDefinitions;
    private final Map<String, VajramInputDefinition> inputDefsMap;
    private final Map<String, ClassName> clsDeps = new HashMap<String, ClassName>();
    private final boolean needsModulation;

    public String getVajramName() {
        return this.vajramName;
    }

    public VajramCodeGenerator(VajramInputFile vajramInputFile, Map<String, ParsedVajramData> vajramDefs, Map<String, ImmutableList<VajramInputDefinition>> vajramInputsDefinitions) {
        this.vajramInputFile = vajramInputFile;
        Path filePath = vajramInputFile.inputFilePath().relativeFilePath();
        Path parentDir = filePath.getParent();
        this.vajramName = vajramInputFile.vajramName();
        this.packageName = IntStream.range(0, parentDir.getNameCount()).mapToObj(i -> parentDir.getName(i).toString()).collect(Collectors.joining("."));
        this.requestClassName = CodegenUtils.getRequestClassName(this.vajramName);
        this.vajramDefs = Collections.unmodifiableMap(vajramDefs);
        this.vajramInputsDefinitions = Collections.unmodifiableMap(vajramInputsDefinitions);
        this.inputDefsMap = vajramInputFile.vajramInputsDef().allInputsStream().map(AbstractInput::toInputDefinition).collect(Collectors.toMap(VajramInputDefinition::name, Function.identity(), (o1, o2) -> o1, LinkedHashMap::new));
        this.needsModulation = vajramInputFile.vajramInputsDef().inputs().stream().anyMatch(InputDef::isNeedsModulation);
        this.clsDeps.put("inputs", ClassName.get(Inputs.class));
        this.clsDeps.put("unmodInput", ClassName.get(UnmodulatedInput.class));
        this.clsDeps.put("modInput", ClassName.get(ModulatedInput.class));
        this.clsDeps.put("imMap", ClassName.get(ImmutableMap.class));
        this.clsDeps.put("imList", ClassName.get(ImmutableList.class));
        this.clsDeps.put("depCommand", ClassName.get(DependencyCommand.class));
        this.clsDeps.put("singleExecCmd", ClassName.get(SingleExecute.class));
        this.clsDeps.put("multiExecCmd", ClassName.get(MultiExecute.class));
        this.clsDeps.put("function", ClassName.get(Function.class));
        this.clsDeps.put("valErr", ClassName.get(ValueOrError.class));
        this.clsDeps.put("depResp", ClassName.get(DependencyResponse.class));
        this.clsDeps.put("inputSrc", ClassName.get(InputSource.class));
    }

    public String codeGenVajramImpl(ClassLoader classLoader) {
        TypeSpec.Builder vajramImplClass = this.createVajramImplClass();
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        vajramImplClass.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass(ClassName.bestGuess((String)this.vajramName).box()).build();
        HashMap<String, List> resolverMap = new HashMap<String, List>();
        ParsedVajramData parsedVajramData = this.vajramDefs.get(this.vajramName);
        for (Method resolve : parsedVajramData.resolveMethods()) {
            String key = resolve.getAnnotation(Resolve.class).depName();
            resolverMap.computeIfAbsent(key, _k -> new ArrayList()).add(resolve);
        }
        HashMap<String, Boolean> depFanoutMap = new HashMap<String, Boolean>();
        parsedVajramData.resolveMethods().forEach(method -> {
            Resolve resolve = method.getAnnotation(Resolve.class);
            String[] inputs = resolve.depInputs();
            String depName = resolve.depName();
            assert (depName != null);
            Optional<VajramInputDefinition> definition = this.vajramInputsDefinitions.get(parsedVajramData.vajramName()).stream().filter(vajramInputDefinition -> vajramInputDefinition.name().equals(depName)).findFirst();
            definition.ifPresent(def -> {
                Dependency dependency;
                DataAccessSpec patt13713$temp;
                if (def instanceof Dependency && (patt13713$temp = (dependency = (Dependency)def).dataAccessSpec()) instanceof VajramID) {
                    VajramID vajramID = (VajramID)patt13713$temp;
                    String depVajramClass = (String)vajramID.className().orElseThrow(() -> new VajramValidationException("Vajram class missing in VajramInputDefinition for :" + this.vajramName));
                    String[] splits = Constants.DOT_PATTERN.split(depVajramClass);
                    ParsedVajramData vajramData = this.vajramDefs.get(splits[splits.length - 1]);
                    depFanoutMap.put(depName, CodegenUtils.isDepResolverFanout(vajramData.vajramClass(), method, inputs, vajramData.fields()));
                }
            });
        });
        ClassName inputsNeedingModulation = ClassName.get((String)parsedVajramData.packageName(), (String)CodegenUtils.getInputUtilClassName(parsedVajramData.vajramName()), (String[])new String[]{CodegenUtils.getInputModulationClassname(this.vajramName)});
        ClassName commonInputs = ClassName.get((String)parsedVajramData.packageName(), (String)CodegenUtils.getInputUtilClassName(parsedVajramData.vajramName()), (String[])new String[]{CodegenUtils.getCommonInputsClassname(this.vajramName)});
        TypeName vajramResponseType = CodegenUtils.getClassGenericArgumentsType(parsedVajramData.vajramClass());
        MethodSpec inputDefinitionsMethod = this.createInputDefinitions(classLoader);
        methodSpecs.add(inputDefinitionsMethod);
        Optional<MethodSpec> inputResolverMethod = this.createResolvers(resolverMap, depFanoutMap);
        inputResolverMethod.ifPresent(methodSpecs::add);
        if (IOVajram.class.isAssignableFrom(parsedVajramData.vajramClass())) {
            methodSpecs.add(this.createIOVajramExecuteMethod(inputsNeedingModulation, commonInputs, vajramResponseType));
        } else {
            methodSpecs.add(this.createComputeVajramExecuteMethod(vajramResponseType, inputsNeedingModulation, commonInputs));
        }
        if (this.needsModulation) {
            methodSpecs.add(this.createInputConvertersMethod(inputsNeedingModulation, commonInputs));
        }
        StringWriter writer = new StringWriter();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)vajramImplClass.addMethods(methodSpecs).build()).indent("  ").build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private static ImmutableSet<String> getResolverSources(Method resolve) {
        return (ImmutableSet)Arrays.stream(resolve.getParameters()).filter(parameter -> ((Using[])parameter.getAnnotationsByType(Using.class)).length > 0).map(parameter -> parameter.getAnnotation(Using.class)).map(Using::value).collect(ImmutableSet.toImmutableSet());
    }

    private MethodSpec createComputeVajramExecuteMethod(TypeName vajramResponseType, ClassName inputsNeedingModulation, ClassName commonInputs) {
        MethodSpec.Builder executeBuilder = MethodSpec.methodBuilder((String)"executeCompute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{Inputs.class}), "inputsList", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableMap.class), (TypeName[])new TypeName[]{ClassName.get(Inputs.class), ParameterizedTypeName.get((ClassName)this.clsDeps.get("valErr"), (TypeName[])new TypeName[]{vajramResponseType})})).addAnnotation(Override.class);
        if (this.needsModulation) {
            CodeBlock.Builder codeBuilder = CodeBlock.builder();
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put("inputs", ClassName.get(Inputs.class));
            valueMap.put("unmodInput", ClassName.get(UnmodulatedInput.class));
            valueMap.put("inputModulation", inputsNeedingModulation);
            valueMap.put("commonInput", commonInputs);
            valueMap.put("returnType", vajramResponseType);
            valueMap.put("vajramLogicMethod", this.vajramDefs.get(this.vajramName).vajramLogic().getName());
            valueMap.put("modInput", ClassName.get(ModulatedInput.class));
            valueMap.put("imMap", ClassName.get(ImmutableMap.class));
            valueMap.put("imList", ClassName.get(ImmutableList.class));
            valueMap.put("hashMap", ClassName.get(HashMap.class));
            valueMap.put("arrayList", ClassName.get(ArrayList.class));
            valueMap.put("comFuture", ClassName.get(CompletableFuture.class));
            valueMap.put("linkHashMap", ClassName.get(LinkedHashMap.class));
            valueMap.put("map", ClassName.get(Map.class));
            valueMap.put("list", ClassName.get(List.class));
            valueMap.put("valErr", this.clsDeps.get("valErr"));
            assert (Map.class.isAssignableFrom(this.vajramDefs.get(this.vajramName).vajramLogic().getReturnType()));
            Type type = ((ParameterizedType)this.vajramDefs.get(this.vajramName).vajramLogic().getGenericReturnType()).getActualTypeArguments()[1];
            if (type instanceof ParameterizedType && CompletableFuture.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType())) {
                codeBuilder.addNamed("    $map:T<$inputModulation:T, $inputs:T> mapping = new $hashMap:T<>();\n    $list:T<$inputModulation:T> ims = new $arrayList:T<>();\n    $commonInput:T commonInputs = null;\n    for ($inputs:T inputs : inputsList) {\n      $unmodInput:T<$inputModulation:T, $commonInput:T> allInputs =\n          getInputsConvertor().apply(inputs);\n      commonInputs = allInputs.commonInputs();\n      $inputModulation:T im = allInputs.inputsNeedingModulation();\n      mapping.put(im, inputs);\n      ims.add(im);\n    }\n    $map:T<$inputs:T, $comFuture:T<$returnType:T>> returnValue = new $linkHashMap:T<>();\n\n    if (commonInputs != null) {\n      var results = $vajramLogicMethod:L(new $modInput:T<>($imList:T.copyOf(ims), commonInputs));\n      results.forEach((im, future) -> returnValue.put(mapping.get(im), future));\n    }\n    return $imMap:T.copyOf(returnValue);\n", valueMap);
            } else {
                codeBuilder.addNamed("    $map:T<$inputModulation:T, $inputs:T> mapping = new $hashMap:T<>();\n    $list:T<$inputModulation:T> ims = new $arrayList:T<>();\n    $commonInput:T commonInputs = null;\n    for ($inputs:T inputs : inputsList) {\n      $unmodInput:T<$inputModulation:T, $commonInput:T> allInputs =\n          getInputsConvertor().apply(inputs);\n      commonInputs = allInputs.commonInputs();\n      $inputModulation:T im = allInputs.inputsNeedingModulation();\n      mapping.put(im, inputs);\n      ims.add(im);\n    }\n    $map:T<$inputs:T, $valErr:T<$returnType:T>> returnValue = new $linkHashMap:T<>();\n\n    if (commonInputs != null) {\n      var results = $vajramLogicMethod:L(new $modInput:T<>($imList:T.copyOf(ims), commonInputs));\n      results.forEach((im, value) -> returnValue.put(mapping.get(im), $valErr:T.withValue(value)));\n    }\n    return $imMap:T.copyOf(returnValue);\n", valueMap);
            }
            executeBuilder.addCode(codeBuilder.build());
        } else {
            this.nonModulatedComputeMethodBuilder(executeBuilder, false);
        }
        return executeBuilder.build();
    }

    private void nonModulatedComputeMethodBuilder(MethodSpec.Builder executeBuilder, boolean isIOVajram) {
        CodeBlock.Builder returnBuilder = CodeBlock.builder().add("return inputsList.stream().collect(\n     $T.toImmutableMap($T.identity(),\n     element -> {\n", new Object[]{this.clsDeps.get("imMap"), this.clsDeps.get("function")});
        ArrayList inputCodeBlocks = new ArrayList();
        this.inputDefsMap.values().forEach(inputDef -> {
            if (inputDef instanceof Dependency) {
                Dependency inputDefDependency = (Dependency)inputDef;
                CodeBlock.Builder codeBlock = CodeBlock.builder();
                DataAccessSpec dataAccessSpec = inputDefDependency.dataAccessSpec();
                if (dataAccessSpec instanceof VajramID) {
                    VajramID vajramID = (VajramID)dataAccessSpec;
                    String depVajramClass = (String)vajramID.className().orElseThrow(() -> new VajramValidationException("Vajram class missing in VajramInputDefinition for :" + this.vajramName));
                    String[] splits = Constants.DOT_PATTERN.split(depVajramClass);
                    String depPackageName = Arrays.stream(splits, 0, splits.length - 1).collect(Collectors.joining("."));
                    String depRequestClass = CodegenUtils.getRequestClassName(splits[splits.length - 1]);
                    ParsedVajramData parsedVajramData = this.vajramDefs.get(splits[splits.length - 1]);
                    TypeName typeArgument = CodegenUtils.getClassGenericArgumentsType(parsedVajramData.vajramClass());
                    String variableName = CodegenUtils.toJavaName(inputDef.name());
                    String depVariableName = variableName + "Responses";
                    codeBlock.addNamed("$depResp:T<$request:T, $response:T> $depResponse:L =\n     new $depResp:T<>(\n         element.<$response:T>getDepValue($variable:S).values().entrySet().stream()\n             .filter(\n                 e ->\n                     e.getValue()\n                         .error()\n                         .filter(t -> t instanceof $skippedException:T)\n                         .isEmpty())\n             .collect(\n                 $imMap:T.toImmutableMap(\n                     e -> $request:T.from(e.getKey()), java.util.Map.Entry::getValue)));\n", (Map)ImmutableMap.of((Object)"depResp", (Object)this.clsDeps.get("depResp"), (Object)"request", (Object)ClassName.get((String)depPackageName, (String)depRequestClass, (String[])new String[0]), (Object)"response", (Object)typeArgument, (Object)"variable", (Object)inputDef.name(), (Object)"depResponse", (Object)depVariableName, (Object)"imMap", (Object)this.clsDeps.get("imMap"), (Object)"skippedException", SkippedExecutionException.class));
                    inputCodeBlocks.add(CodeBlock.builder().add(depVariableName, new Object[0]).build());
                }
                returnBuilder.add(codeBlock.build());
            } else if (inputDef.isMandatory()) {
                inputCodeBlocks.add(CodeBlock.builder().add("element.getInputValueOrThrow($S)", new Object[]{inputDef.name()}).build());
            } else {
                inputCodeBlocks.add(CodeBlock.builder().add("element.getInputValueOrDefault($S, null)", new Object[]{inputDef.name()}).build());
            }
        });
        if (isIOVajram) {
            Class<?> returnType = this.vajramDefs.get(this.vajramName).vajramLogic().getReturnType();
            if (!CompletableFuture.class.isAssignableFrom(returnType)) {
                throw new VajramValidationException("The VajramLogic of non-modulated IO vajram %s must return a CompletableFuture".formatted(this.vajramName));
            }
            returnBuilder.add("\nreturn ($L(new $T(\n", new Object[]{this.vajramDefs.get(this.vajramName).vajramLogic().getName(), ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{CodegenUtils.getAllInputsClassname(this.vajramName)})});
        } else {
            returnBuilder.add("\nreturn $T.valueOrError(() -> $L(new $T(\n", new Object[]{this.clsDeps.get("valErr"), this.vajramDefs.get(this.vajramName).vajramLogic().getName(), ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{CodegenUtils.getAllInputsClassname(this.vajramName)})});
        }
        for (int i = 0; i < inputCodeBlocks.size(); ++i) {
            returnBuilder.add("\t\t", new Object[0]);
            returnBuilder.add((CodeBlock)inputCodeBlocks.get(i));
            if (i == inputCodeBlocks.size() - 1) continue;
            returnBuilder.add(",\n", new Object[0]);
        }
        returnBuilder.add(")));\n", new Object[0]);
        returnBuilder.add("}));\n", new Object[0]);
        executeBuilder.addCode(returnBuilder.build());
    }

    private MethodSpec createInputConvertersMethod(ClassName inputsNeedingModulation, ClassName commonInputs) {
        MethodSpec.Builder inputConvertersBuilder = MethodSpec.methodBuilder((String)"getInputsConvertor").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(InputsConverter.class), (TypeName[])new TypeName[]{inputsNeedingModulation, commonInputs})).addAnnotation(Override.class);
        inputConvertersBuilder.addCode(CodeBlock.builder().addStatement("return $T.CONVERTER", new Object[]{ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[0])}).build());
        return inputConvertersBuilder.build();
    }

    private MethodSpec createIOVajramExecuteMethod(ClassName inputsNeedingModulation, ClassName commonInputs, TypeName vajramResponseType) {
        MethodSpec.Builder executeMethodBuilder = MethodSpec.methodBuilder((String)"execute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{Inputs.class}), "inputsList", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableMap.class), (TypeName[])new TypeName[]{ClassName.get(Inputs.class), ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{vajramResponseType})})).addAnnotation(Override.class);
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        if (this.needsModulation) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put("inputs", ClassName.get(Inputs.class));
            valueMap.put("unmodInput", ClassName.get(UnmodulatedInput.class));
            valueMap.put("inputModulation", inputsNeedingModulation);
            valueMap.put("commonInput", commonInputs);
            valueMap.put("returnType", vajramResponseType);
            valueMap.put("vajramLogicMethod", this.vajramDefs.get(this.vajramName).vajramLogic().getName());
            valueMap.put("modInput", ClassName.get(ModulatedInput.class));
            valueMap.put("imMap", ClassName.get(ImmutableMap.class));
            valueMap.put("imList", ClassName.get(ImmutableList.class));
            valueMap.put("hashMap", ClassName.get(HashMap.class));
            valueMap.put("arrayList", ClassName.get(ArrayList.class));
            valueMap.put("comFuture", ClassName.get(CompletableFuture.class));
            valueMap.put("linkHashMap", ClassName.get(LinkedHashMap.class));
            valueMap.put("map", ClassName.get(Map.class));
            valueMap.put("list", ClassName.get(List.class));
            valueMap.put("valErr", this.clsDeps.get("valErr"));
            assert (Map.class.isAssignableFrom(this.vajramDefs.get(this.vajramName).vajramLogic().getReturnType()));
            Type type = ((ParameterizedType)this.vajramDefs.get(this.vajramName).vajramLogic().getGenericReturnType()).getActualTypeArguments()[1];
            if (type instanceof ParameterizedType && CompletableFuture.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType())) {
                codeBuilder.addNamed("    $map:T<$inputModulation:T, $inputs:T> mapping = new $hashMap:T<>();\n    $list:T<$inputModulation:T> ims = new $arrayList:T<>();\n    $commonInput:T commonInputs = null;\n    for ($inputs:T inputs : inputsList) {\n      $unmodInput:T<$inputModulation:T, $commonInput:T> allInputs =\n          getInputsConvertor().apply(inputs);\n      commonInputs = allInputs.commonInputs();\n      $inputModulation:T im = allInputs.inputsNeedingModulation();\n      mapping.put(im, inputs);\n      ims.add(im);\n    }\n    $map:T<$inputs:T, $comFuture:T<$returnType:T>> returnValue = new $linkHashMap:T<>();\n\n    if (commonInputs != null) {\n      var results = $vajramLogicMethod:L(new $modInput:T<>($imList:T.copyOf(ims), commonInputs));\n      results.forEach((im, future) -> returnValue.put(mapping.get(im), future));\n    }\n    return $imMap:T.copyOf(returnValue);\n", valueMap);
            } else {
                codeBuilder.addNamed("    $map:T<$inputModulation:T, $inputs:T> mapping = new $hashMap:T<>();\n    $list:T<$inputModulation:T> ims = new $arrayList:T<>();\n    $commonInput:T commonInputs = null;\n    for ($inputs:T inputs : inputsList) {\n      $unmodInput:T<$inputModulation:T, $commonInput:T> allInputs =\n          getInputsConvertor().apply(inputs);\n      commonInputs = allInputs.commonInputs();\n      $inputModulation:T im = allInputs.inputsNeedingModulation();\n      mapping.put(im, inputs);\n      ims.add(im);\n    }\n    $map:T<$inputs:T, $valErr:T<$returnType:T>> returnValue = new $linkHashMap:T<>();\n\n    if (commonInputs != null) {\n      var results = $vajramLogicMethod:L(new $modInput:T<>($imList:T.copyOf(ims), commonInputs));\n      results.forEach((im, value) -> returnValue.put(mapping.get(im), $valErr:T.withValue(value)));\n    }\n    return $imMap:T.copyOf(returnValue);\n", valueMap);
            }
            executeMethodBuilder.addCode(codeBuilder.build());
        } else {
            this.nonModulatedComputeMethodBuilder(executeMethodBuilder, true);
        }
        return executeMethodBuilder.build();
    }

    private Optional<MethodSpec> createResolvers(Map<String, ? extends List<Method>> resolverMap, Map<String, Boolean> depFanoutMap) {
        String dependency = "dependency";
        MethodSpec.Builder resolveInputsBuilder = MethodSpec.methodBuilder((String)"resolveInputOfDependency").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, dependency, new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get(ImmutableSet.class, (Type[])new Type[]{String.class}), "resolvableInputs", new Modifier[0]).addParameter(Inputs.class, "inputs", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(DependencyCommand.class), (TypeName[])new TypeName[]{ClassName.get(Inputs.class)}));
        ParsedVajramData parsedVajramData = this.vajramDefs.get(this.vajramName);
        if (Objects.nonNull(parsedVajramData)) {
            resolveInputsBuilder.beginControlFlow("switch ($L) ", new Object[]{dependency});
            if (parsedVajramData.resolveMethods().isEmpty()) {
                return Optional.empty();
            }
            Set<String> resolvedVariables = resolverMap.keySet();
            resolverMap.forEach((variable, methods) -> {
                CodeBlock.Builder caseBuilder = CodeBlock.builder().beginControlFlow("case $S -> ", new Object[]{variable});
                methods.forEach(method -> {
                    AtomicBoolean fanout = new AtomicBoolean(false);
                    Arrays.stream(method.getParameters()).forEach(parameter -> {
                        String bindParamName = parameter.getAnnotation(Using.class).value();
                        if (!fanout.get() && depFanoutMap.containsKey(bindParamName)) {
                            fanout.set((Boolean)depFanoutMap.get(bindParamName));
                        }
                        if (!this.inputDefsMap.containsKey(bindParamName) && !resolvedVariables.contains(bindParamName)) {
                            throw new VajramValidationException("Parameter binding incorrect for input - " + bindParamName);
                        }
                    });
                    CodeBlock.Builder ifBlockBuilder = this.buildInputResolver((Method)method, depFanoutMap, fanout.get());
                    caseBuilder.add(ifBlockBuilder.build());
                });
                caseBuilder.endControlFlow();
                resolveInputsBuilder.addCode(caseBuilder.build());
            });
            resolveInputsBuilder.endControlFlow();
            resolveInputsBuilder.addStatement("throw new $T($S)", new Object[]{ClassName.get(VajramValidationException.class), "Unresolvable dependency"});
        } else {
            resolveInputsBuilder.addStatement("throw new $T($S)", new Object[]{ClassName.get(VajramValidationException.class), "Unresolvable dependency"});
        }
        return Optional.of(resolveInputsBuilder.build());
    }

    private CodeBlock.Builder buildInputResolver(Method method, Map<String, Boolean> depFanoutMap, boolean isParamFanoutDependency) {
        Resolve resolve = method.getAnnotation(Resolve.class);
        CharSequence[] inputs = resolve.depInputs();
        String depName = resolve.depName();
        CodeBlock.Builder ifBlockBuilder = CodeBlock.builder();
        ifBlockBuilder.beginControlFlow("if ($T.of($S).equals(resolvableInputs))", new Object[]{Set.class, String.join((CharSequence)",", inputs)});
        Arrays.stream(method.getParameters()).forEach(parameter -> {
            String usingInputName = parameter.getAnnotation(Using.class).value();
            if (this.inputDefsMap.get(usingInputName) instanceof Dependency) {
                this.generateDependencyResolutions(method, usingInputName, ifBlockBuilder, depFanoutMap, (Parameter)parameter);
                return;
            } else {
                if (!this.inputDefsMap.containsKey(usingInputName)) throw new VajramValidationException("No input resolver found for " + usingInputName);
                VajramInputDefinition inputDefinition = this.inputDefsMap.get(usingInputName);
                String variable = VajramCodeGenerator.toJavaName(usingInputName);
                TypeName parameterType = CodegenUtils.getType(parameter.getParameterizedType());
                if (inputDefinition.isMandatory()) {
                    ifBlockBuilder.add(CodeBlock.builder().addStatement("$T $L = $L.getInputValueOrThrow($S)", new Object[]{parameterType, variable, "inputs", usingInputName}).build());
                    return;
                } else {
                    if (!Optional.class.isAssignableFrom(parameter.getType())) throw new VajramValidationException(String.format("Optional input dependency %s must have type as Optional", usingInputName));
                    ifBlockBuilder.add(CodeBlock.builder().addStatement("$T $L = $L.getInputValueOpt($S)", new Object[]{parameterType, variable, "inputs", usingInputName}).build());
                }
            }
        });
        boolean isFanOut = isParamFanoutDependency || depFanoutMap.getOrDefault(depName, false) != false;
        this.buildFinalResolvers(method, (String[])inputs, ifBlockBuilder, isFanOut);
        ifBlockBuilder.endControlFlow();
        return ifBlockBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateDependencyResolutions(Method method, String usingInputName, CodeBlock.Builder ifBlockBuilder, Map<String, Boolean> depFanoutMap, Parameter parameter) {
        Dependency inputDefDependency;
        DataAccessSpec dataAccessSpec;
        VajramInputDefinition vajramInputDef = this.inputDefsMap.get(usingInputName);
        Resolve resolve = method.getAnnotation(Resolve.class);
        assert (resolve != null);
        String resolvedDep = resolve.depName();
        if (depFanoutMap.containsKey(usingInputName) && depFanoutMap.get(usingInputName).booleanValue() && !DependencyResponse.class.isAssignableFrom(parameter.getType())) {
            log.error("Dependency resolution of {} is fanout but the resolver method is not of type DependencyResponse.", (Object)resolvedDep);
            throw new VajramValidationException("Dependency resolution of " + resolvedDep + " is fanout but the resolver method is not of type DependencyResponse");
        }
        if (!(vajramInputDef instanceof Dependency) || !((dataAccessSpec = (inputDefDependency = (Dependency)vajramInputDef).dataAccessSpec()) instanceof VajramID)) return;
        VajramID vajramID = (VajramID)dataAccessSpec;
        String vajramClass = (String)vajramID.className().orElseThrow(() -> new VajramValidationException("Vajram class missing in vajram input definition"));
        String variableName = CodegenUtils.toJavaName(usingInputName);
        String[] splits = Constants.DOT_PATTERN.split(vajramClass);
        ParsedVajramData parsedVajramData = this.vajramDefs.get(splits[splits.length - 1]);
        String depPackageName = Arrays.stream(splits, 0, splits.length - 1).collect(Collectors.joining("."));
        String requestClass = CodegenUtils.getRequestClassName(splits[splits.length - 1]);
        TypeName usingDepType = CodegenUtils.getClassGenericArgumentsType(parsedVajramData.vajramClass());
        if (usingDepType.isBoxedPrimitive()) {
            usingDepType = usingDepType.unbox();
        }
        String resolverName = method.getName();
        if (DependencyResponse.class.isAssignableFrom(parameter.getType())) {
            String depValueAccessorCode = "$1T $2L =\n new $3T<>(inputs.<$4T>getDepValue($5S)\n      .values().entrySet().stream()\n      .collect($6T.toImmutableMap(e -> $7T.from(e.getKey()),\n      $8T::getValue)))";
            ifBlockBuilder.addStatement(depValueAccessorCode, new Object[]{ParameterizedTypeName.get((ClassName)this.clsDeps.get("depResp"), (TypeName[])new TypeName[]{ClassName.get((String)depPackageName, (String)requestClass, (String[])new String[0]), usingDepType}), variableName, this.clsDeps.get("depResp"), usingDepType, usingInputName, this.clsDeps.get("imMap"), ClassName.get((String)depPackageName, (String)requestClass, (String[])new String[0]), ClassName.get(Map.Entry.class)});
            return;
        } else {
            String depValueAccessorCode = "$1T $2L =\n  inputs.<$3T>getDepValue($4S)\n     .values()\n     .entrySet()\n     .iterator()\n     .next()\n     .getValue()";
            if (usingDepType.equals((Object)TypeName.get(parameter.getType()))) {
                if (!vajramInputDef.isMandatory()) throw new VajramValidationException("A resolver ('%s') must not access an optional dependency ('%s') directly.Use Optional<>, ValueOrError<>, or DependencyResponse<> instead".formatted(resolverName, usingInputName));
                String code = depValueAccessorCode + ".getValueOrThrow().orElseThrow(() ->\n    new $5T(\"Received null value for mandatory dependency '$6L' of vajram '$7L'\"))";
                ifBlockBuilder.addStatement(code, new Object[]{usingDepType, variableName, usingDepType, usingInputName, IllegalArgumentException.class, usingInputName, this.vajramName});
                return;
            } else if (ValueOrError.class.isAssignableFrom(parameter.getType())) {
                ifBlockBuilder.addStatement(depValueAccessorCode, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(ValueOrError.class), (TypeName[])new TypeName[]{usingDepType}), variableName, CodegenUtils.getMethodReturnType(method).box(), usingInputName});
                return;
            } else {
                if (!Optional.class.isAssignableFrom(parameter.getType())) throw new VajramValidationException("Unrecognized parameter type %s in resolver %s of vajram %s".formatted(parameter.getType(), resolverName, this.vajramName));
                String code = depValueAccessorCode + ".value()";
                ifBlockBuilder.addStatement(code, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{usingDepType}), variableName, CodegenUtils.getMethodReturnType(method).box(), usingInputName});
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildFinalResolvers(Method method, String[] inputs, CodeBlock.Builder ifBlockBuilder, boolean isFanOut) {
        Class klass;
        String variableName = "resolverResult";
        boolean controlFLowStarted = false;
        TypeName methodReturnType = CodegenUtils.getMethodReturnType(method);
        ifBlockBuilder.add("$T $L = $L(", new Object[]{methodReturnType, variableName, method.getName()});
        ImmutableList resolverSources = VajramCodeGenerator.getResolverSources(method).asList();
        for (int i = 0; i < resolverSources.size(); ++i) {
            String bindName = (String)resolverSources.get(i);
            ifBlockBuilder.add("$L", new Object[]{CodegenUtils.toJavaName(bindName)});
            if (i == method.getParameters().length - 1) continue;
            ifBlockBuilder.add(", ", new Object[0]);
        }
        ifBlockBuilder.add(");\n", new Object[0]);
        if (DependencyCommand.class.isAssignableFrom(method.getReturnType())) {
            ifBlockBuilder.beginControlFlow("if($L.shouldSkip())", new Object[]{variableName});
            ifBlockBuilder.addStatement("\t return $T.skipExecution($L.doc())", new Object[]{this.clsDeps.get("singleExecCmd"), variableName});
            ifBlockBuilder.add("} else {\n\t", new Object[0]);
            controlFLowStarted = true;
        }
        if (MultiExecute.class.isAssignableFrom(klass = Primitives.wrap(method.getReturnType()))) {
            code = "return $T.executeFanoutWith(\n    $L.inputs().stream()\n        .map(\n            element ->\n                new $T(\n                    $T.of($S, $T.withValue(element))))\n    .toList())";
            ifBlockBuilder.addStatement(code, new Object[]{this.clsDeps.get("multiExecCmd"), variableName, this.clsDeps.get("inputs"), this.clsDeps.get("imMap"), inputs[0], this.clsDeps.get("valErr")});
        } else if (isFanOut) {
            if (!Iterable.class.isAssignableFrom(klass)) throw new VajramValidationException("Incorrect vajram resolver " + this.vajramName + ": Fanout resolvers must return an iterable");
            if (VajramRequest.class.isAssignableFrom((Class)((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0])) {
                code = "return $T.executeFanoutWith(\n    $L.stream()\n        .map(\n            element ->\n                element.toInputValues()))\n    .toList())";
                ifBlockBuilder.addStatement(code, new Object[]{this.clsDeps.get("multiExecCmd"), variableName});
            } else {
                code = "return $T.executeFanoutWith(\n    $L.stream()\n        .map(\n            element ->\n                new $T(\n                    $T.of($S, $T.withValue(element))))\n    .toList())";
                ifBlockBuilder.addStatement(code, new Object[]{this.clsDeps.get("multiExecCmd"), variableName, this.clsDeps.get("inputs"), this.clsDeps.get("imMap"), inputs[0], this.clsDeps.get("valErr")});
            }
        } else if (VajramRequest.class.isAssignableFrom(klass)) {
            ifBlockBuilder.addStatement("return $T.executeWith($L.toInputValues())", new Object[]{this.clsDeps.get("singleExecCmd"), variableName});
        } else if (SingleExecute.class.isAssignableFrom(klass)) {
            ifBlockBuilder.addStatement("  return $T.executeWith(new Inputs(\n   $T.of($S, $T.withValue(\n      $L.inputs().iterator().next().orElse(null)))))\n", new Object[]{this.clsDeps.get("singleExecCmd"), this.clsDeps.get("imMap"), inputs[0], this.clsDeps.get("valErr"), variableName});
        } else {
            ifBlockBuilder.addStatement("return $T.executeWith(new Inputs(\n $T.of($S, $T.withValue($L))))", new Object[]{this.clsDeps.get("singleExecCmd"), this.clsDeps.get("imMap"), inputs[0], this.clsDeps.get("valErr"), variableName});
        }
        if (!controlFLowStarted) return;
        ifBlockBuilder.endControlFlow();
    }

    private MethodSpec createInputDefinitions(ClassLoader classLoader) {
        MethodSpec.Builder inputDefinitionsBuilder = MethodSpec.methodBuilder((String)"getInputDefinitions").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)this.clsDeps.get("imList"), (TypeName[])new TypeName[]{ClassName.get(VajramInputDefinition.class)}));
        ImmutableList<VajramInputDefinition> inputDefinitions = this.vajramInputsDefinitions.get(this.vajramName);
        ArrayList codeBlocks = new ArrayList(inputDefinitions.size());
        inputDefinitions.forEach(vajramInputDefinition -> {
            CodeBlock.Builder inputDefBuilder = CodeBlock.builder();
            if (vajramInputDefinition instanceof Input) {
                Input input = (Input)vajramInputDefinition;
                this.buildVajramInput(inputDefBuilder, input);
            } else if (vajramInputDefinition instanceof Dependency) {
                Dependency dependency = (Dependency)vajramInputDefinition;
                VajramCodeGenerator.buildVajramDependency(classLoader, inputDefBuilder, dependency);
            }
            codeBlocks.add(inputDefBuilder.build());
        });
        inputDefinitionsBuilder.beginControlFlow("if(this.$L == null)", new Object[]{"inputDefinitions"});
        inputDefinitionsBuilder.addCode(CodeBlock.builder().add("this.$L = $T.of(\n", new Object[]{"inputDefinitions", this.clsDeps.get("imList")}).add(CodeBlock.join(codeBlocks, (String)",\n\t")).add("\n);\n", new Object[0]).build());
        inputDefinitionsBuilder.endControlFlow();
        inputDefinitionsBuilder.addStatement("return $L", new Object[]{"inputDefinitions"});
        return inputDefinitionsBuilder.build();
    }

    private static void buildVajramDependency(ClassLoader classLoader, CodeBlock.Builder inputDefBuilder, Dependency<?> dependency) {
        inputDefBuilder.add("$T.builder()", new Object[]{ClassName.get(Dependency.class)}).add(".name($S)", new Object[]{dependency.name()});
        DataAccessSpec dataAccessSpec = dependency.dataAccessSpec();
        if (dataAccessSpec instanceof VajramID) {
            VajramID vajramID = (VajramID)dataAccessSpec;
            String code = ".dataAccessSpec($1T.vajramID($2S))";
            if (vajramID.className().isPresent()) {
                try {
                    Optional vajramId = Vajrams.getVajramIdString(classLoader.loadClass((String)vajramID.className().get()));
                    vajramId.ifPresent(s -> inputDefBuilder.add(code, new Object[]{ClassName.get(VajramID.class), s}));
                }
                catch (ClassNotFoundException e) {
                    throw new VajramValidationException((Throwable)e);
                }
            } else {
                inputDefBuilder.add(code, new Object[]{ClassName.get(VajramID.class), vajramID.vajramId()});
            }
        }
        if (dependency.isMandatory()) {
            inputDefBuilder.add(".isMandatory()", new Object[0]);
        }
        inputDefBuilder.add(".build()", new Object[0]);
    }

    private void buildVajramInput(CodeBlock.Builder inputDefBuilder, Input<?> input) {
        inputDefBuilder.add("$T.builder()", new Object[]{ClassName.get(Input.class)}).add(".name($S)", new Object[]{input.name()});
        ImmutableSet inputSources = input.sources();
        if (!inputSources.isEmpty()) {
            inputDefBuilder.add(".sources(", new Object[0]);
            String sources = inputSources.stream().map(inputSource -> {
                if (inputSource == InputSource.CLIENT) {
                    return "$inputSrc:T.CLIENT";
                }
                if (inputSource == InputSource.SESSION) {
                    return "$inputSrc:T.SESSION";
                }
                throw new IllegalArgumentException("Incorrect source defined in vajram config");
            }).collect(Collectors.joining(","));
            inputDefBuilder.addNamed(sources, (Map)ImmutableMap.of((Object)"inputSrc", (Object)this.clsDeps.get("inputSrc"))).add(")", new Object[0]);
        }
        DataType dataType = input.type();
        inputDefBuilder.add(".type(", new Object[0]);
        if (dataType instanceof JavaType) {
            ClassName className;
            JavaType javaType = (JavaType)dataType;
            if (!javaType.enclosingClasses().isEmpty() || javaType.simpleName().isPresent()) {
                assert (javaType.packageName().isPresent());
                className = ClassName.get((String)((String)javaType.packageName().get()), (String)String.join((CharSequence)".", (Iterable<? extends CharSequence>)javaType.enclosingClasses()), (String[])new String[]{(String)javaType.simpleName().get()});
            } else {
                className = ClassName.bestGuess((String)javaType.className());
            }
            inputDefBuilder.add("$1T.java($2T.class)", new Object[]{ClassName.get(JavaType.class), className});
        } else {
            TypeAndName typeName;
            String simpleName = dataType.getClass().getSimpleName();
            String name = simpleName.substring(0, simpleName.length() - 4).toLowerCase();
            if (simpleName.toLowerCase().contains("boolean")) {
                name = "bool";
            }
            if (ParameterizedTypeName.class.isAssignableFrom((typeName = VajramCodeGenerator.getTypeName(dataType)).typeName().getClass())) {
                TypeName innerType = (TypeName)((ParameterizedTypeName)typeName.typeName()).typeArguments.get(0);
                inputDefBuilder.add("$T.$L($T.$L())", new Object[]{ClassName.get((String)dataType.getClass().getPackageName(), (String)simpleName, (String[])new String[0]), name, ClassName.get((String)dataType.getClass().getPackageName(), (String)(((ClassName)innerType).simpleName() + "Type"), (String[])new String[0]), ((ClassName)innerType).simpleName().toLowerCase()});
            } else {
                inputDefBuilder.add("$T.$L()", new Object[]{ClassName.get((String)dataType.getClass().getPackageName(), (String)simpleName, (String[])new String[0]), name});
            }
        }
        inputDefBuilder.add(")", new Object[0]);
        if (input.isMandatory()) {
            inputDefBuilder.add(".isMandatory()", new Object[0]);
        }
        if (input.needsModulation()) {
            inputDefBuilder.add(".needsModulation()", new Object[0]);
        }
        if (input.tags() != null && !input.tags().isEmpty()) {
            inputDefBuilder.add(".tags($T.of(", new Object[]{ClassName.get(Map.class)});
            String tags = input.tags().entrySet().stream().filter(entry -> entry.getValue() != null && ((Tag)entry.getValue()).tagValue() != null).map(entry -> String.format("\"%s\", \"%s\"", ((Tag)entry.getValue()).tagKey(), ((Tag)entry.getValue()).tagValue())).collect(Collectors.joining(","));
            inputDefBuilder.add(tags, new Object[0]).add("))", new Object[0]);
        }
        inputDefBuilder.add(".build()", new Object[0]);
    }

    public String codeGenVajramRequest() {
        VajramInputsDef vajramInputsDef = this.vajramInputFile.vajramInputsDef();
        ImmutableList<InputDef> inputDefs = vajramInputsDef.inputs();
        MethodSpec.Builder requestConstructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
        ClassName builderClassType = ClassName.get((String)(this.packageName + "." + this.requestClassName), (String)"Builder", (String[])new String[0]);
        TypeSpec.Builder requestClass = TypeSpec.classBuilder((String)this.requestClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface(VajramRequest.class).addAnnotation(EqualsAndHashCode.class).addMethod(MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)builderClassType).addStatement("return new Builder()", new Object[0]).build());
        TypeSpec.Builder builderClass = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addAnnotation(EqualsAndHashCode.class).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        LinkedHashSet<String> inputNames = new LinkedHashSet<String>();
        List<AbstractInput> allInputs = vajramInputsDef.allInputsStream().toList();
        ArrayList<FieldSpec.Builder> inputNameFields = new ArrayList<FieldSpec.Builder>(allInputs.size());
        ArrayList<FieldSpec.Builder> inputSpecFields = new ArrayList<FieldSpec.Builder>(allInputs.size());
        for (AbstractInput abstractInput : allInputs) {
            InputDef input;
            FieldSpec.Builder inputSpecField;
            String inputJavaName = VajramCodeGenerator.toJavaName(abstractInput.getName());
            TypeAndName javaType = VajramCodeGenerator.getTypeName(abstractInput.toDataType());
            ClassName vajramClassName = ClassName.get((String)this.packageName, (String)this.vajramName, (String[])new String[0]);
            String inputNameFieldName = inputJavaName + "_n";
            FieldSpec.Builder inputNameField = FieldSpec.builder(String.class, (String)inputNameFieldName, (Modifier[])new Modifier[0]).initializer("\"$L\"", new Object[]{abstractInput.getName()});
            if (abstractInput instanceof VajramDependencyDef) {
                VajramDependencyDef vajramDepDef = (VajramDependencyDef)abstractInput;
                inputSpecField = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(VajramDependencyTypeSpec.class), (TypeName[])new TypeName[]{javaType.typeName(), vajramClassName, ClassName.bestGuess((String)vajramDepDef.getVajramClass())}), (String)(inputJavaName + "_s"), (Modifier[])new Modifier[0]).initializer("new $T<>($L, $T.class, $T.class)", new Object[]{VajramDependencyTypeSpec.class, inputNameFieldName, vajramClassName, ClassName.bestGuess((String)vajramDepDef.getVajramClass())});
            } else {
                inputSpecField = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(VajramInputTypeSpec.class), (TypeName[])new TypeName[]{javaType.typeName(), vajramClassName}), (String)(inputJavaName + "_s"), (Modifier[])new Modifier[0]).initializer("new $T<>($L, $T.class)", new Object[]{VajramInputTypeSpec.class, inputNameFieldName, vajramClassName});
            }
            inputNameFields.add(inputNameField.addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL}));
            inputSpecFields.add(inputSpecField.addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL}));
            if (!(abstractInput instanceof InputDef) || !(input = (InputDef)abstractInput).toInputDefinition().sources().contains((Object)InputSource.CLIENT)) continue;
            inputSpecField.addModifiers(new Modifier[]{Modifier.PUBLIC});
            inputNameField.addModifiers(new Modifier[]{Modifier.PUBLIC});
            inputNames.add(inputJavaName);
            requestClass.addField(FieldSpec.builder((TypeName)VajramCodeGenerator.wrapPrimitive(javaType).typeName(), (String)inputJavaName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            builderClass.addField(FieldSpec.builder((TypeName)javaType.typeName(), (String)inputJavaName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
            requestConstructor.addParameter(ParameterSpec.builder((TypeName)javaType.typeName(), (String)inputJavaName, (Modifier[])new Modifier[0]).build());
            requestConstructor.addStatement("this.$L = $L", new Object[]{inputJavaName, inputJavaName});
            requestClass.addMethod(VajramCodeGenerator.getterCodeForInput(input, inputJavaName, javaType));
            builderClass.addMethod(MethodSpec.methodBuilder((String)inputJavaName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(javaType.typeName()).addStatement("return this.$L", new Object[]{inputJavaName}).build());
            builderClass.addMethod(MethodSpec.methodBuilder((String)inputJavaName).returns((TypeName)builderClassType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)javaType.typeName(), (String)inputJavaName, (Modifier[])new Modifier[0]).build()).addStatement("this.$L = $L", new Object[]{inputJavaName, inputJavaName}).addStatement("return this", new Object[]{inputJavaName}).build());
        }
        requestClass.addFields(inputNameFields.stream().map(FieldSpec.Builder::build)::iterator);
        requestClass.addFields(inputSpecFields.stream().map(FieldSpec.Builder::build)::iterator);
        builderClass.addMethod(MethodSpec.methodBuilder((String)"build").returns((TypeName)ClassName.get((String)this.packageName, (String)this.requestClassName, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return new %s(%s)".formatted(this.requestClassName, String.join((CharSequence)", ", inputNames)), new Object[0]).build());
        StringWriter writer = new StringWriter();
        FromAndTo fromAndTo = this.fromAndToMethods(inputDefs.stream().filter(inputDef -> inputDef.toInputDefinition().sources().contains((Object)InputSource.CLIENT)).toList(), ClassName.get((String)this.packageName, (String)this.requestClassName, (String[])new String[0]));
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)requestClass.addMethod(requestConstructor.build()).addMethod(fromAndTo.from()).addMethod(fromAndTo.to()).addType(builderClass.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private static TypeAndName wrapPrimitive(TypeAndName javaType) {
        Type type;
        if (javaType.type().isPresent() && (type = javaType.type().get()) instanceof Class) {
            Class clazz = (Class)type;
            Class wrapped = Primitives.wrap((Class)clazz);
            return new TypeAndName((TypeName)ClassName.get((Class)wrapped), Optional.of(wrapped));
        }
        return javaType;
    }

    private static TypeAndName unwrapPrimitive(TypeAndName javaType) {
        Type type;
        if (javaType.type().isPresent() && (type = javaType.type().get()) instanceof Class) {
            Class clazz = (Class)type;
            Class unwrapped = Primitives.unwrap((Class)clazz);
            return new TypeAndName(TypeName.get((Type)unwrapped), Optional.of(unwrapped));
        }
        return javaType;
    }

    private FromAndTo fromAndToMethods(List<? extends AbstractInput> inputDefs, ClassName enclosingClass) {
        MethodSpec.Builder toInputValues = MethodSpec.methodBuilder((String)"toInputValues").returns(Inputs.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("$T builder = new $T<>($L)", new Object[]{new TypeToken<Map<String, InputValue<Object>>>(){}.getType(), new TypeToken<HashMap>(){}.getType(), inputDefs.size()});
        MethodSpec.Builder fromInputValues = MethodSpec.methodBuilder((String)"from").returns((TypeName)enclosingClass).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(Inputs.class, "values", new Modifier[0]);
        for (AbstractInput abstractInput : inputDefs) {
            String inputJavaName = VajramCodeGenerator.toJavaName(abstractInput.getName());
            toInputValues.addStatement("builder.put($S, $T.withValue($L()))", new Object[]{abstractInput.getName(), ValueOrError.class, inputJavaName});
        }
        toInputValues.addStatement("return new $T(builder)", new Object[]{Inputs.class});
        List<String> inputNames = inputDefs.stream().map(AbstractInput::getName).toList();
        fromInputValues.addStatement("return new $T(%s)".formatted(inputNames.stream().map(s -> "values.getInputValueOrDefault($S, null)").collect(Collectors.joining(", "))), Stream.concat(Stream.of(enclosingClass), inputNames.stream()).toArray());
        return new FromAndTo(fromInputValues.build(), toInputValues.build());
    }

    private static TypeAndName getTypeName(DataType dataType) {
        if (dataType instanceof JavaType) {
            ClassName className;
            JavaType javaType = (JavaType)dataType;
            Optional simpleName = javaType.simpleName();
            if (simpleName.isPresent()) {
                List<String> classNames = Stream.concat(javaType.enclosingClasses().stream(), Stream.of((String)simpleName.get())).toList();
                className = ClassName.get((String)javaType.packageName().orElse(""), (String)classNames.get(0), (String[])((String[])classNames.subList(1, classNames.size()).toArray(String[]::new)));
            } else {
                className = ClassName.bestGuess((String)javaType.className());
            }
            if (!javaType.typeParameters().isEmpty()) {
                return new TypeAndName((TypeName)ParameterizedTypeName.get((ClassName)className, (TypeName[])((TypeName[])javaType.typeParameters().stream().map(VajramCodeGenerator::getTypeName).map(TypeAndName::typeName).toArray(TypeName[]::new))));
            }
            return new TypeAndName((TypeName)className);
        }
        Optional javaType = TypeUtils.getJavaType((DataType)dataType);
        return new TypeAndName(javaType.map(type -> {
            Type type2;
            if (type instanceof Class) {
                Class clazz = (Class)type;
                type2 = Primitives.wrap((Class)clazz);
            } else {
                type2 = type;
            }
            return type2;
        }).map(TypeName::get).orElseThrow(() -> new IllegalArgumentException("Could not determine java Type of %s".formatted(dataType))), javaType);
    }

    private static MethodSpec getterCodeForInput(AbstractInput input, String name, TypeAndName typeAndName) {
        boolean wrapWithOptional = input instanceof InputDef && !input.isMandatory();
        return MethodSpec.methodBuilder((String)name).returns(wrapWithOptional ? VajramCodeGenerator.optional(VajramCodeGenerator.wrapPrimitive(typeAndName).typeName()) : VajramCodeGenerator.unwrapPrimitive(typeAndName).typeName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(wrapWithOptional ? CodeBlock.builder().addStatement("return $T.ofNullable(this.$L)", new Object[]{Optional.class, name}).build() : CodeBlock.builder().addStatement("return this.$L", new Object[]{name}).build()).build();
    }

    public String codeGenInputUtil() {
        boolean doInputsNeedModulation = this.vajramInputFile.vajramInputsDef().allInputsStream().map(AbstractInput::toInputDefinition).anyMatch(VajramInputDefinition::needsModulation);
        if (doInputsNeedModulation) {
            return this.codeGenModulatedInputUtil();
        }
        return this.codeGenSimpleInputUtil();
    }

    private String codeGenSimpleInputUtil() {
        TypeSpec.Builder inputUtilClass = this.createInputUtilClass();
        String className = CodegenUtils.getAllInputsClassname(this.vajramName);
        TypeSpec.Builder allInputsClass = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.STATIC}).addAnnotations(VajramCodeGenerator.recordAnnotations());
        ArrayList<FieldTypeName> fieldsList = new ArrayList<FieldTypeName>();
        VajramInputsDef vajramInputsDef = this.vajramInputFile.vajramInputsDef();
        vajramInputsDef.inputs().forEach(inputDef -> {
            String inputJavaName = VajramCodeGenerator.toJavaName(inputDef.getName());
            TypeAndName javaType = VajramCodeGenerator.getTypeName(inputDef.toInputDefinition().type());
            allInputsClass.addField(javaType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            allInputsClass.addMethod(VajramCodeGenerator.getterCodeForInput(inputDef, inputJavaName, javaType));
            fieldsList.add(new FieldTypeName(javaType.typeName(), inputJavaName));
        });
        vajramInputsDef.dependencies().forEach(dependencyDef -> {
            Optional<TypeName> javaType = VajramCodeGenerator.getDependencyOutputsType(dependencyDef);
            javaType.ifPresent(type -> {
                String inputJavaName = VajramCodeGenerator.toJavaName(dependencyDef.getName());
                allInputsClass.addField(type, inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                allInputsClass.addMethod(VajramCodeGenerator.getterCodeForInput(dependencyDef, inputJavaName, new TypeAndName((TypeName)type)));
                fieldsList.add(new FieldTypeName((TypeName)type, inputJavaName));
            });
        });
        this.generateConstructor(fieldsList).ifPresent(arg_0 -> ((TypeSpec.Builder)allInputsClass).addMethod(arg_0));
        StringWriter writer = new StringWriter();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)inputUtilClass.addType(allInputsClass.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private Optional<MethodSpec> generateConstructor(List<FieldTypeName> fieldsList) {
        if (fieldsList.isEmpty()) {
            return Optional.empty();
        }
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder();
        fieldsList.forEach(fieldTypeName -> {
            constructor.addParameter(fieldTypeName.typeName(), fieldTypeName.name(), new Modifier[0]);
            constructor.addCode(CodeBlock.builder().addStatement("this.$L = $L", new Object[]{fieldTypeName.name(), fieldTypeName.name()}).build());
        });
        return Optional.of(constructor.build());
    }

    private static Optional<TypeName> getDependencyOutputsType(DependencyDef dependencyDef) {
        if (dependencyDef instanceof VajramDependencyDef) {
            VajramDependencyDef vajramDepSpec = (VajramDependencyDef)dependencyDef;
            String depVajramClass = vajramDepSpec.getVajramClass();
            int lastDotIndex = depVajramClass.lastIndexOf(46);
            String depRequestClass = CodegenUtils.getRequestClassName(depVajramClass.substring(lastDotIndex + 1));
            String depPackageName = depVajramClass.substring(0, lastDotIndex);
            ParameterizedTypeName javaType = ParameterizedTypeName.get((ClassName)ClassName.get(DependencyResponse.class), (TypeName[])new TypeName[]{ClassName.get((String)depPackageName, (String)depRequestClass, (String[])new String[0]), VajramCodeGenerator.getTypeName(vajramDepSpec.toDataType()).typeName()});
            return Optional.of(javaType);
        }
        return Optional.empty();
    }

    private String codeGenModulatedInputUtil() {
        StringWriter writer = new StringWriter();
        try {
            TypeSpec.Builder inputUtilClass = this.createInputUtilClass();
            VajramInputsDef vajramInputsDef = this.vajramInputFile.vajramInputsDef();
            String imClassName = CodegenUtils.getInputModulationClassname(this.vajramName);
            String ciClassName = CodegenUtils.getCommonInputsClassname(this.vajramName);
            FromAndTo imFromAndTo = this.fromAndToMethods(vajramInputsDef.inputs().stream().filter(InputDef::isNeedsModulation).toList(), ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{imClassName}));
            TypeSpec.Builder inputsNeedingModulation = TypeSpec.classBuilder((String)imClassName).addModifiers(new Modifier[]{Modifier.STATIC}).addSuperinterface(InputValuesAdaptor.class).addAnnotations(VajramCodeGenerator.recordAnnotations()).addMethod(imFromAndTo.to()).addMethod(imFromAndTo.from());
            FromAndTo ciFromAndTo = this.fromAndToMethods(Stream.concat(vajramInputsDef.inputs().stream().filter(input -> !input.isNeedsModulation()), vajramInputsDef.dependencies().stream()).toList(), ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{ciClassName}));
            TypeSpec.Builder commonInputs = TypeSpec.classBuilder((String)ciClassName).addModifiers(new Modifier[]{Modifier.STATIC}).addSuperinterface(InputValuesAdaptor.class).addAnnotations(VajramCodeGenerator.recordAnnotations()).addMethod(ciFromAndTo.to()).addMethod(ciFromAndTo.from());
            ClassName imType = ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{imClassName});
            ClassName ciType = ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{ciClassName});
            ArrayList<FieldTypeName> ciFieldsList = new ArrayList<FieldTypeName>();
            ArrayList<FieldTypeName> imFieldsList = new ArrayList<FieldTypeName>();
            vajramInputsDef.inputs().forEach(inputDef -> {
                String inputJavaName = VajramCodeGenerator.toJavaName(inputDef.getName());
                TypeAndName javaType = VajramCodeGenerator.getTypeName(inputDef.toInputDefinition().type());
                if (inputDef.isNeedsModulation()) {
                    inputsNeedingModulation.addField(javaType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                    inputsNeedingModulation.addMethod(VajramCodeGenerator.getterCodeForInput(inputDef, inputJavaName, javaType));
                    imFieldsList.add(new FieldTypeName(javaType.typeName(), inputJavaName));
                } else {
                    commonInputs.addField(javaType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                    commonInputs.addMethod(VajramCodeGenerator.getterCodeForInput(inputDef, inputJavaName, javaType));
                    ciFieldsList.add(new FieldTypeName(javaType.typeName(), inputJavaName));
                }
            });
            vajramInputsDef.dependencies().forEach(dependencyDef -> {
                Optional<TypeName> javaTypeName = VajramCodeGenerator.getDependencyOutputsType(dependencyDef);
                javaTypeName.ifPresent(type -> {
                    String inputJavaName = VajramCodeGenerator.toJavaName(dependencyDef.getName());
                    commonInputs.addField(type, inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                    commonInputs.addMethod(VajramCodeGenerator.getterCodeForInput(dependencyDef, inputJavaName, new TypeAndName((TypeName)type)));
                    ciFieldsList.add(new FieldTypeName((TypeName)type, inputJavaName));
                });
            });
            this.generateConstructor(ciFieldsList).ifPresent(arg_0 -> ((TypeSpec.Builder)commonInputs).addMethod(arg_0));
            this.generateConstructor(imFieldsList).ifPresent(arg_0 -> ((TypeSpec.Builder)inputsNeedingModulation).addMethod(arg_0));
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(InputsConverter.class), (TypeName[])new TypeName[]{imType, ciType});
            CodeBlock.Builder initializer = CodeBlock.builder().add("$L", new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)parameterizedTypeName).addMethod(MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(UnmodulatedInput.class), (TypeName[])new TypeName[]{imType, ciType})).addParameter(Inputs.class, "inputValues", new Modifier[0]).addStatement("return new $T<>($T.from(inputValues),$T.from(inputValues))", new Object[]{UnmodulatedInput.class, imType, ciType}).build()).build()});
            FieldSpec.Builder converter = FieldSpec.builder((TypeName)parameterizedTypeName, (String)"CONVERTER", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC}).initializer(initializer.build());
            JavaFile.builder((String)this.packageName, (TypeSpec)inputUtilClass.addType(inputsNeedingModulation.build()).addType(commonInputs.build()).addField(converter.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private static List<AnnotationSpec> recordAnnotations() {
        return VajramCodeGenerator.annotations(EqualsAndHashCode.class, ToString.class);
    }

    private static List<AnnotationSpec> annotations(Class<?> ... annotations) {
        return Arrays.stream(annotations).map(aClass -> AnnotationSpec.builder((Class)aClass).build()).toList();
    }

    private TypeSpec.Builder createInputUtilClass() {
        return TypeSpec.classBuilder((String)CodegenUtils.getInputUtilClassName(this.vajramName)).addModifiers(new Modifier[]{Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
    }

    private TypeSpec.Builder createVajramImplClass() {
        return TypeSpec.classBuilder((String)CodegenUtils.getVajramImplClassName(this.vajramName)).addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{VajramInputDefinition.class}), (String)"inputDefinitions", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
    }

    public String getRequestClassName() {
        return this.requestClassName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    private static String toJavaName(String inputName) {
        if (!inputName.contains("_")) {
            return inputName;
        }
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, inputName);
    }

    private static TypeName optional(TypeName javaType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{javaType});
    }

    private record TypeAndName(TypeName typeName, Optional<Type> type) {
        private TypeAndName(TypeName typeName) {
            this(typeName, Optional.empty());
        }
    }

    private record FromAndTo(MethodSpec from, MethodSpec to) {
    }

    private record FieldTypeName(TypeName typeName, String name) {
    }
}

