/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen;

import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.codegen.VajramCodeGenerator;
import com.flipkart.krystal.vajram.codegen.models.AbstractInput;
import com.flipkart.krystal.vajram.codegen.models.ParsedVajramData;
import com.flipkart.krystal.vajram.codegen.models.VajramInputFile;
import com.flipkart.krystal.vajram.codegen.models.VajramInputsDef;
import com.flipkart.krystal.vajram.codegen.utils.CodegenUtils;
import com.flipkart.krystal.vajram.codegen.utils.Constants;
import com.flipkart.krystal.vajram.das.DataAccessSpec;
import com.flipkart.krystal.vajram.exception.VajramValidationException;
import com.flipkart.krystal.vajram.inputs.Dependency;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VajramCodeGenFacade {
    private static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(VajramCodeGenFacade.class);
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String INPUTS_FILE_EXTENSION = ".vajram.yaml";
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path> srcDirs;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path compiledClassesDir;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path generatedSrcDir;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Iterable<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized File> compileClasspath;

    public static void main(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized [] args) {
        Options options = new Options();
        String command = args[0];
        options.addOption(Option.builder((String)"j").longOpt("javaDir").hasArg().desc("Root Directory for all .java files").required().build());
        options.addOption(Option.builder((String)"v").longOpt("vajramFile").hasArg().desc("FilePath of the vajram input file for which request code will be generated").required().build());
        options.addOption(Option.builder((String)"g").longOpt("generatedSrcDir").hasArg().desc("Root Directory for generated source code").build());
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        if ("codeVajramModels".equals(command)) {
            try {
                List<String> arguments = List.of(args).subList(1, args.length);
                CommandLine cmd = parser.parse(options, (String[])arguments.toArray(String[]::new));
                Path vajramInputFilePath = Path.of(cmd.getOptionValue("v"), new String[0]);
                Path vajramInputFileName = vajramInputFilePath.getFileName();
                if (vajramInputFileName == null || !vajramInputFileName.toString().endsWith(INPUTS_FILE_EXTENSION)) {
                    return;
                }
                Path javaSrcDirPath = Path.of(cmd.getOptionValue("j"), new String[0]);
                Path sourceSetPath = Optional.ofNullable(javaSrcDirPath.getParent()).orElseThrow(() -> new IllegalStateException("Java src dir does not have a parent"));
                String sourceSetName = Optional.ofNullable(sourceSetPath.getFileName()).map(Path::toString).orElseThrow();
                Path projectDir = Optional.ofNullable(sourceSetPath.getParent()).map(Path::getParent).orElseThrow();
                Path generatedSrcDir = cmd.getOptionValue("g") == null ? projectDir.resolve(Path.of("build", "generated", "sources", "vajrams", sourceSetName, "java")) : Path.of(cmd.getOptionValue("g"), new String[0]);
                new VajramCodeGenFacade(List.of(javaSrcDirPath), projectDir.resolve(Path.of("build", "classes", "java", sourceSetName)), generatedSrcDir).codeGenModels(javaSrcDirPath, javaSrcDirPath.relativize(vajramInputFilePath));
            }
            catch (ParseException e) {
                log.error("Command line options could not be parsed", (Throwable)e);
                formatter.printHelp("Vajram Code Generator", options);
                System.exit(1);
            }
            catch (IOException e) {
                log.error("Error reading vajramInputFile", (Throwable)e);
                System.exit(1);
            }
        }
    }

    public static void codeGenModels(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Set<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized File> srcDirs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String compileDir, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String destinationDir) throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Exception {
        new VajramCodeGenFacade(srcDirs.stream().map(File::toPath).toList(), Path.of(compileDir, new String[0]), Path.of(destinationDir, new String[0])).codeGenModels();
    }

    public static void codeGenVajramImpl(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Set<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized File> srcDirs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String compiledDir, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String destinationDir, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Iterable<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized File> classpath) throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Exception {
        new VajramCodeGenFacade(srcDirs.stream().map(File::toPath).toList(), Path.of(compiledDir, new String[0]), Path.of(destinationDir, new String[0]), classpath).codeGenVajramImpl();
    }

    public VajramCodeGenFacade(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path> srcDirs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path compiledClassesDir, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path generatedSrcDir) {
        this(srcDirs, compiledClassesDir, generatedSrcDir, Collections.emptyList());
    }

    public VajramCodeGenFacade(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path> srcDirs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path compiledClassesDir, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path generatedSrcDir, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Iterable<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized File> compileClasspath) {
        this.compiledClassesDir = compiledClassesDir;
        this.srcDirs = Collections.unmodifiableList(srcDirs);
        this.generatedSrcDir = generatedSrcDir;
        this.compileClasspath = compileClasspath;
    }

    private void codeGenModels() throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Exception {
        ImmutableList<VajramInputFile> inputFiles = this.getInputDefinitions();
        for (VajramInputFile inputFile : inputFiles) {
            this.codeGenModels(inputFile);
        }
    }

    private void codeGenModels(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path srcDir, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path vajramInputRelativePath) throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized IOException {
        this.codeGenModels(VajramCodeGenFacade.toVajramInputFile(new VajramInputsDef.InputFilePath(srcDir, vajramInputRelativePath)));
    }

    private void codeGenModels(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInputFile inputFile) {
        try {
            VajramCodeGenerator vajramCodeGenerator = new VajramCodeGenerator(inputFile, Collections.emptyMap(), Collections.emptyMap());
            this.codeGenRequest(vajramCodeGenerator);
            this.codeGenUtil(vajramCodeGenerator);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not generate code for file %s".formatted(inputFile.inputFilePath().relativeFilePath()), e);
        }
    }

    private void codeGenRequest(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramCodeGenerator vajramCodeGenerator) throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized IOException {
        File vajramJavaDir = Paths.get(this.generatedSrcDir.toString(), vajramCodeGenerator.getPackageName().split("\\.")).toFile();
        if (vajramJavaDir.isDirectory() || vajramJavaDir.mkdirs()) {
            String vajramRequestJavaCode = vajramCodeGenerator.codeGenVajramRequest();
            File vajramRequestSourceFile = new File(vajramJavaDir, vajramCodeGenerator.getRequestClassName() + ".java");
            Files.writeString(vajramRequestSourceFile.toPath(), (CharSequence)vajramRequestJavaCode, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
    }

    private void codeGenVajramImpl() throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Exception {
        ImmutableList<VajramInputFile> inputFiles = this.getInputDefinitions();
        ClassLoader systemClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)VajramID.class.getClassLoader());
        ArrayList<URL> urls = new ArrayList<URL>();
        this.srcDirs.forEach(path -> {
            try {
                urls.add(path.toFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.error("Malformed url {}", (Object)path.toFile().toURI());
                throw new RuntimeException(e);
            }
        });
        this.compileClasspath.forEach(file -> {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.error("Malformed url {}", (Object)file.toURI());
                throw new RuntimeException(e);
            }
        });
        urls.add(this.compiledClassesDir.toFile().toURI().toURL());
        try (URLClassLoader urlcl = new URLClassLoader((URL[])urls.toArray(URL[]::new), systemClassLoader);){
            HashMap vajramDefs = new HashMap();
            HashMap vajramInputsDef = new HashMap();
            inputFiles.forEach(vajramInputFile -> {
                Optional<ParsedVajramData> parsedVajramData = ParsedVajramData.fromVajram(urlcl, vajramInputFile);
                if (parsedVajramData.isEmpty()) {
                    log.warn("VajramImpl codegen will be skipped for {}. ", (Object)vajramInputFile.vajramName());
                } else {
                    vajramDefs.put(parsedVajramData.get().vajramName(), parsedVajramData.get());
                    vajramInputsDef.put(vajramInputFile.vajramName(), (ImmutableList)vajramInputFile.vajramInputsDef().allInputsStream().map(AbstractInput::toInputDefinition).collect(ImmutableList.toImmutableList()));
                }
            });
            inputFiles.forEach(vajramInputFile -> vajramInputFile.vajramInputsDef().allInputsStream().map(AbstractInput::toInputDefinition).forEach(inputDef -> {
                Dependency dependency;
                DataAccessSpec patt11311$temp;
                if (inputDef instanceof Dependency && (patt11311$temp = (dependency = (Dependency)inputDef).dataAccessSpec()) instanceof VajramID) {
                    VajramID vajramID = (VajramID)patt11311$temp;
                    String depVajramClass = (String)vajramID.className().orElseThrow(() -> new VajramValidationException("Vajram class missing in VajramInputDefinition for :" + vajramID));
                    String[] splits = Constants.DOT_PATTERN.split(depVajramClass);
                    String depPackageName = Arrays.stream(splits, 0, splits.length - 1).collect(Collectors.joining("."));
                    String vajramName = splits[splits.length - 1];
                    if (!vajramDefs.containsKey(vajramName)) {
                        try {
                            Class<?> vajramClass = urlcl.loadClass(depVajramClass);
                            HashMap<String, Field> fields = new HashMap<String, Field>();
                            Arrays.stream(vajramClass.getDeclaredFields()).forEach(field -> fields.put(field.getName(), (Field)field));
                            ArrayList<Method> resolveMethods = new ArrayList<Method>();
                            Method vajramLogic = ParsedVajramData.getVajramLogicAndResolverMethods(vajramClass, resolveMethods);
                            vajramDefs.put(vajramName, new ParsedVajramData(vajramName, resolveMethods, vajramLogic, vajramClass, depPackageName, fields));
                            Class<?> parsedVajramImpl = urlcl.loadClass(depPackageName + "." + CodegenUtils.getVajramImplClassName(vajramName));
                            Method getInputDefinitions = parsedVajramImpl.getDeclaredMethod("getInputDefinitions", new Class[0]);
                            Vajram vajram = (Vajram)parsedVajramImpl.getConstructor(new Class[0]).newInstance(new Object[0]);
                            vajramInputsDef.put(vajramName, (ImmutableList)Optional.ofNullable(getInputDefinitions.invoke((Object)vajram, new Object[0])).orElse(ImmutableList.of()));
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }));
            inputFiles.forEach(inputFile -> {
                if (vajramDefs.containsKey(inputFile.vajramName())) {
                    try {
                        VajramCodeGenerator vajramCodeGenerator = new VajramCodeGenerator((VajramInputFile)inputFile, vajramDefs, vajramInputsDef);
                        this.codeGenVajramImpl(vajramCodeGenerator, urlcl);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("Could not generate vajram impl for file %s".formatted(inputFile.inputFilePath().relativeFilePath()), e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while generating vajram impl", e);
        }
    }

    private void codeGenVajramImpl(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramCodeGenerator vajramCodeGenerator, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassLoader classLoader) throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized IOException {
        File vajramJavaDir = Paths.get(this.generatedSrcDir.toString(), vajramCodeGenerator.getPackageName().split("\\.")).toFile();
        if (vajramJavaDir.isDirectory() || vajramJavaDir.mkdirs()) {
            String vajramImplCode = vajramCodeGenerator.codeGenVajramImpl(classLoader);
            File vajramImplSourceFile = new File(vajramJavaDir, CodegenUtils.getVajramImplClassName(vajramCodeGenerator.getVajramName()) + ".java");
            Files.writeString(vajramImplSourceFile.toPath(), (CharSequence)vajramImplCode, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
    }

    private void codeGenUtil(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramCodeGenerator vajramCodeGenerator) throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized IOException {
        File vajramJavaDir = Paths.get(this.generatedSrcDir.toString(), vajramCodeGenerator.getPackageName().split("\\.")).toFile();
        if (vajramJavaDir.isDirectory() || vajramJavaDir.mkdirs()) {
            String inputUtilJavaCode = vajramCodeGenerator.codeGenInputUtil();
            File inputUtilSourceFile = new File(vajramJavaDir, CodegenUtils.getInputUtilClassName(vajramCodeGenerator.getVajramName()) + ".java");
            Files.writeString(inputUtilSourceFile.toPath(), (CharSequence)inputUtilJavaCode, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
    }

    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInputFile> getInputDefinitions() throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList<VajramInputFile> vajramInputFiles = new ArrayList<VajramInputFile>();
        Set<VajramInputsDef.InputFilePath> inputFiles = this.getInputsYamlFiles();
        for (VajramInputsDef.InputFilePath inputFile : inputFiles) {
            vajramInputFiles.add(VajramCodeGenFacade.toVajramInputFile(inputFile));
        }
        return ImmutableList.copyOf(vajramInputFiles);
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInputFile toVajramInputFile(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInputsDef.InputFilePath inputFile) throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized IOException {
        String fileName = String.valueOf(Preconditions.checkNotNull((Object)inputFile.relativeFilePath().getFileName()));
        String vajramName = fileName.substring(0, fileName.length() - INPUTS_FILE_EXTENSION.length());
        return new VajramInputFile(vajramName, inputFile, VajramInputsDef.from(inputFile.absolutePath().toFile()));
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Set<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInputsDef.InputFilePath> getInputsYamlFiles() throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized IOException {
        LinkedHashSet<VajramInputsDef.InputFilePath> inputFilePaths = new LinkedHashSet<VajramInputsDef.InputFilePath>();
        for (Path srcDir : this.srcDirs) {
            if (!srcDir.toFile().isDirectory()) continue;
            Stream<Path> vajramInputPathStream = Files.find(srcDir, 100, (path, fileAttributes) -> {
                if (!fileAttributes.isRegularFile()) {
                    return false;
                }
                Path fileName = path.getFileName();
                return fileName != null && fileName.toString().endsWith(INPUTS_FILE_EXTENSION);
            }, new FileVisitOption[0]);
            try {
                vajramInputPathStream.forEach(p -> inputFilePaths.add(new VajramInputsDef.InputFilePath(srcDir, srcDir.relativize((Path)p))));
            }
            finally {
                if (vajramInputPathStream == null) continue;
                vajramInputPathStream.close();
            }
        }
        return inputFilePaths;
    }
}

