/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.models;

import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramLogic;
import com.flipkart.krystal.vajram.codegen.models.InputDef;
import com.flipkart.krystal.vajram.codegen.models.VajramInputFile;
import com.flipkart.krystal.vajram.codegen.utils.CodegenUtils;
import com.flipkart.krystal.vajram.exception.VajramValidationException;
import com.flipkart.krystal.vajram.inputs.resolution.Resolve;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ParsedVajramData(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Method> resolveMethods, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Method vajramLogic, /*
 * Issues handling annotations - annotations may be inaccurate
 */
@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Class<@BottomVal @ClassValBottom @MethodValBottom @UnknownKeyFor @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> vajramClass, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String packageName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Field> fields) {
    private static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(ParsedVajramData.class);
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String DOT_SEPARATOR = ".";

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ParsedVajramData> fromVajram(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassLoader classLoader, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInputFile inputFile) {
        Class<?> result;
        String packageName = CodegenUtils.getPackageFromPath(inputFile.inputFilePath().relativeFilePath());
        HashMap<String, Field> fields = new HashMap<String, Field>();
        try {
            result = classLoader.loadClass(packageName + DOT_SEPARATOR + inputFile.vajramName());
            for (Method method : result.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(VajramLogic.class) && !method.isAnnotationPresent(Resolve.class) || Modifier.isStatic(method.getModifiers())) continue;
                throw new VajramValidationException("Vajram class %s has non-static method %s".formatted(inputFile.vajramName(), method.getName()));
            }
            boolean needsModulation = false;
            for (InputDef inputDef : inputFile.vajramInputsDef().inputs()) {
                if (!inputDef.isNeedsModulation()) continue;
                needsModulation = true;
                break;
            }
            if (needsModulation) {
                Class<?> inputsCls = classLoader.loadClass(packageName + DOT_SEPARATOR + CodegenUtils.getInputUtilClassName(inputFile.vajramName()) + "$" + CodegenUtils.getInputModulationClassname(inputFile.vajramName()));
                for (Field field : inputsCls.getDeclaredFields()) {
                    fields.put(field.getName(), field);
                }
            } else {
                Class<?> allInputsCls = classLoader.loadClass(packageName + DOT_SEPARATOR + CodegenUtils.getInputUtilClassName(inputFile.vajramName()) + "$" + CodegenUtils.getAllInputsClassname(inputFile.vajramName()));
                for (Field field : allInputsCls.getDeclaredFields()) {
                    fields.put(field.getName(), field);
                }
            }
            String requestClass = packageName + DOT_SEPARATOR + CodegenUtils.getRequestClassName(inputFile.vajramName());
            classLoader.loadClass(requestClass);
        }
        catch (ClassNotFoundException e) {
            log.warn("Vajram class not found for {}", (Object)inputFile.vajramName(), (Object)e);
            return Optional.empty();
        }
        ArrayList<Method> resolveMethods = new ArrayList<Method>();
        Method vajramLogic = ParsedVajramData.getVajramLogicAndResolverMethods(result, resolveMethods);
        return Optional.of(new ParsedVajramData(inputFile.vajramName(), resolveMethods, vajramLogic, result, packageName, fields));
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Method getVajramLogicAndResolverMethods(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Class<@BottomVal @ClassValBottom @MethodValBottom @UnknownKeyFor @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> vajramCalss, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Method> resolveMethods) {
        Method vajramLogic = null;
        for (Method method : vajramCalss.getDeclaredMethods()) {
            if (method.isAnnotationPresent(Resolve.class)) {
                resolveMethods.add(method);
                continue;
            }
            if (!method.isAnnotationPresent(VajramLogic.class)) continue;
            if (vajramLogic == null) {
                vajramLogic = method;
                continue;
            }
            throw new VajramValidationException("Multiple VajramLogic annotated methods found in " + vajramCalss.getSimpleName());
        }
        if (vajramLogic == null) {
            throw new VajramValidationException("Missing vajram logic method");
        }
        return vajramLogic;
    }
}

