/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.gen.caramel;

import com.flipkart.krystal.caramel.model.ImplAs;
import com.flipkart.krystal.gen.caramel.CaramelCodeGenerator;
import com.google.auto.service.AutoService;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;

@SupportedAnnotationTypes(value={"com.flipkart.krystal.caramel.model.CaramelPayload"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@AutoService(value={Processor.class})
public class CaramelAnnotationProcessor
extends AbstractProcessor {
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String DEFINITION_SUFFIX = "Definition";

    @Override
    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean process(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Set<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement> annotations, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set payloadDefinitions = roundEnv.getElementsAnnotatedWith(typeElement).stream().filter(element -> element.getKind() == ElementKind.INTERFACE).map(executableElement -> (TypeElement)executableElement).collect(Collectors.toSet());
            if (payloadDefinitions.isEmpty()) continue;
            for (TypeElement payloadDefinition : payloadDefinitions) {
                JavaFileObject builderFile;
                Optional<String> payloadDefinitionName = CaramelAnnotationProcessor.getPayloadClassName(payloadDefinition, this.processingEnv);
                if (payloadDefinitionName.isEmpty()) continue;
                if (payloadDefinition.getNestingKind().isNested()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Payload definition interface should not be nested", payloadDefinition);
                }
                CaramelCodeGenerator caramelCodeGenerator = new CaramelCodeGenerator(payloadDefinition, payloadDefinitionName.get(), this.processingEnv);
                try {
                    builderFile = this.processingEnv.getFiler().createSourceFile(caramelCodeGenerator.getPayloadImplPackageName() + "." + payloadDefinitionName.get(), payloadDefinition);
                }
                catch (IOException e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not create java source file for payload implementation" + Throwables.getStackTraceAsString((Throwable)e), payloadDefinition);
                    continue;
                }
                try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
                    out.println(caramelCodeGenerator.generatePayloadImpl());
                }
                catch (IOException e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error opening writer", payloadDefinition);
                }
            }
        }
        return true;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String> getPayloadClassName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement payloadDefinitionIface, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ProcessingEnvironment processingEnv) {
        Optional<String> payloadClassName;
        String payloadDefinitionName = payloadDefinitionIface.getQualifiedName().toString();
        Optional<ImplAs> implAs = Optional.ofNullable(payloadDefinitionIface.getAnnotation(ImplAs.class));
        if (implAs.isPresent()) {
            payloadClassName = Optional.of(implAs.get().value());
        } else if (!payloadDefinitionName.endsWith(DEFINITION_SUFFIX)) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Caramel Payload definition class must either be annotedWith '%s' or must have a name ending in 'Definition'".formatted(ImplAs.class), payloadDefinitionIface);
            payloadClassName = Optional.empty();
        } else {
            payloadClassName = Optional.of(payloadDefinitionName.substring(0, payloadDefinitionName.length() - DEFINITION_SUFFIX.length()));
        }
        return payloadClassName;
    }
}

