/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen;

import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.datatypes.CustomType;
import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.utils.SkippedExecutionException;
import com.flipkart.krystal.vajram.DependencyResponse;
import com.flipkart.krystal.vajram.IOVajram;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.VajramRequest;
import com.flipkart.krystal.vajram.Vajrams;
import com.flipkart.krystal.vajram.codegen.models.ParsedVajramData;
import com.flipkart.krystal.vajram.codegen.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.models.VajramInfoLite;
import com.flipkart.krystal.vajram.codegen.utils.CodegenUtils;
import com.flipkart.krystal.vajram.codegen.utils.Constants;
import com.flipkart.krystal.vajram.das.DataAccessSpec;
import com.flipkart.krystal.vajram.exception.VajramValidationException;
import com.flipkart.krystal.vajram.inputs.Dependency;
import com.flipkart.krystal.vajram.inputs.DependencyCommand;
import com.flipkart.krystal.vajram.inputs.Input;
import com.flipkart.krystal.vajram.inputs.InputSource;
import com.flipkart.krystal.vajram.inputs.InputValuesAdaptor;
import com.flipkart.krystal.vajram.inputs.MultiExecute;
import com.flipkart.krystal.vajram.inputs.SingleExecute;
import com.flipkart.krystal.vajram.inputs.Using;
import com.flipkart.krystal.vajram.inputs.VajramDepFanoutTypeSpec;
import com.flipkart.krystal.vajram.inputs.VajramDepSingleTypeSpec;
import com.flipkart.krystal.vajram.inputs.VajramInputDefinition;
import com.flipkart.krystal.vajram.inputs.VajramInputTypeSpec;
import com.flipkart.krystal.vajram.inputs.resolution.Resolve;
import com.flipkart.krystal.vajram.modulation.InputsConverter;
import com.flipkart.krystal.vajram.modulation.ModulatedInput;
import com.flipkart.krystal.vajram.modulation.UnmodulatedInput;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VajramCodeGenerator {
    private static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(VajramCodeGenerator.class);
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String packageName;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String requestClassName;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfo vajramInfo;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfoLite> vajramDefs;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInputDefinition> inputDefsMap;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName> clsDeps = new HashMap<String, ClassName>();
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean needsModulation;
    private @MonotonicNonNull @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Initialized ParsedVajramData parsedVajramData;

    public VajramCodeGenerator(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfo vajramInfo, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfoLite> vajramDefs) {
        this.vajramInfo = vajramInfo;
        this.vajramName = vajramInfo.vajramName();
        this.packageName = vajramInfo.packageName();
        this.requestClassName = CodegenUtils.getRequestClassName(this.vajramName);
        this.vajramDefs = Collections.unmodifiableMap(vajramDefs);
        this.inputDefsMap = vajramInfo.allInputsStream().collect(Collectors.toMap(VajramInputDefinition::name, Function.identity(), (o1, o2) -> o1, LinkedHashMap::new));
        this.needsModulation = vajramInfo.inputs().stream().anyMatch(Input::needsModulation);
        this.clsDeps.put("inputs", ClassName.get(Inputs.class));
        this.clsDeps.put("unmodInput", ClassName.get(UnmodulatedInput.class));
        this.clsDeps.put("modInput", ClassName.get(ModulatedInput.class));
        this.clsDeps.put("imMap", ClassName.get(ImmutableMap.class));
        this.clsDeps.put("imList", ClassName.get(ImmutableList.class));
        this.clsDeps.put("depCommand", ClassName.get(DependencyCommand.class));
        this.clsDeps.put("singleExecCmd", ClassName.get(SingleExecute.class));
        this.clsDeps.put("multiExecCmd", ClassName.get(MultiExecute.class));
        this.clsDeps.put("function", ClassName.get(Function.class));
        this.clsDeps.put("valErr", ClassName.get(ValueOrError.class));
        this.clsDeps.put("depResp", ClassName.get(DependencyResponse.class));
        this.clsDeps.put("inputSrc", ClassName.get(InputSource.class));
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getVajramName() {
        return this.vajramName;
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String codeGenVajramImpl(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassLoader classLoader) {
        this.initParsedVajramData(classLoader);
        TypeSpec.Builder vajramImplClass = this.createVajramImplClass();
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        vajramImplClass.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass(ClassName.bestGuess((String)this.vajramName).box()).build();
        HashMap<String, List> resolverMap = new HashMap<String, List>();
        for (Method resolve : this.getParsedVajramData().resolveMethods()) {
            String key = ((Resolve)Preconditions.checkNotNull((Object)resolve.getAnnotation(Resolve.class))).depName();
            resolverMap.computeIfAbsent(key, _k -> new ArrayList()).add(resolve);
        }
        Map<String, Boolean> depFanoutMap = this.vajramInfo.dependencies().stream().collect(Collectors.toMap(Dependency::name, Dependency::canFanout));
        ClassName inputsNeedingModulation = ClassName.get((String)this.getParsedVajramData().packageName(), (String)CodegenUtils.getInputUtilClassName(this.getParsedVajramData().vajramName()), (String[])new String[]{CodegenUtils.getInputModulationClassname(this.vajramName)});
        ClassName commonInputs = ClassName.get((String)this.getParsedVajramData().packageName(), (String)CodegenUtils.getInputUtilClassName(this.getParsedVajramData().vajramName()), (String[])new String[]{CodegenUtils.getCommonInputsClassname(this.vajramName)});
        TypeName vajramResponseType = CodegenUtils.getClassGenericArgumentsType(this.getParsedVajramData().vajramClass());
        MethodSpec inputDefinitionsMethod = this.createInputDefinitions(classLoader);
        methodSpecs.add(inputDefinitionsMethod);
        Optional<MethodSpec> inputResolverMethod = this.createResolvers(resolverMap, depFanoutMap);
        inputResolverMethod.ifPresent(methodSpecs::add);
        if (IOVajram.class.isAssignableFrom(this.getParsedVajramData().vajramClass())) {
            methodSpecs.add(this.createIOVajramExecuteMethod(inputsNeedingModulation, commonInputs, vajramResponseType.annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()})));
        } else {
            methodSpecs.add(this.createComputeVajramExecuteMethod(vajramResponseType, inputsNeedingModulation, commonInputs));
        }
        if (this.needsModulation) {
            methodSpecs.add(this.createInputConvertersMethod(inputsNeedingModulation, commonInputs));
        }
        StringWriter writer = new StringWriter();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)vajramImplClass.addMethods(methodSpecs).build()).indent("  ").build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private @NonNull @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Initialized ParsedVajramData initParsedVajramData(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassLoader classLoader) {
        if (this.parsedVajramData == null) {
            this.parsedVajramData = ParsedVajramData.fromVajram(classLoader, this.vajramInfo).orElseThrow(() -> new VajramValidationException("Could not load Vajram class for vajram %s.\nParsedVajram Data should never be accessed in model generation phase.".formatted(this.vajramInfo.vajramName())));
        }
        return this.parsedVajramData;
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ParsedVajramData getParsedVajramData() {
        return Optional.ofNullable(this.parsedVajramData).orElseGet(() -> this.initParsedVajramData(Optional.ofNullable(this.getClass().getClassLoader()).orElseThrow()));
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String> getResolverSources(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Method resolve) {
        return (ImmutableSet)Arrays.stream(resolve.getParameters()).filter(parameter -> ((Using[])parameter.getAnnotationsByType(Using.class)).length > 0).map(parameter -> parameter.getAnnotation(Using.class)).map(Using::value).collect(ImmutableSet.toImmutableSet());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec createComputeVajramExecuteMethod(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName vajramResponseType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName inputsNeedingModulation, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName commonInputs) {
        MethodSpec.Builder executeBuilder = MethodSpec.methodBuilder((String)"executeCompute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{Inputs.class}), "inputsList", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableMap.class), (TypeName[])new TypeName[]{ClassName.get(Inputs.class), ParameterizedTypeName.get((ClassName)ClassName.get(ValueOrError.class), (TypeName[])new TypeName[]{vajramResponseType})})).addAnnotation(Override.class);
        if (this.needsModulation) {
            CodeBlock.Builder codeBuilder = CodeBlock.builder();
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put("inputs", ClassName.get(Inputs.class));
            valueMap.put("unmodInput", ClassName.get(UnmodulatedInput.class));
            valueMap.put("inputModulation", inputsNeedingModulation);
            valueMap.put("commonInput", commonInputs);
            valueMap.put("returnType", vajramResponseType);
            valueMap.put("vajramLogicMethod", this.getParsedVajramData().vajramLogic().getName());
            valueMap.put("modInput", ClassName.get(ModulatedInput.class));
            valueMap.put("imMap", ClassName.get(ImmutableMap.class));
            valueMap.put("imList", ClassName.get(ImmutableList.class));
            valueMap.put("hashMap", ClassName.get(HashMap.class));
            valueMap.put("arrayList", ClassName.get(ArrayList.class));
            valueMap.put("comFuture", ClassName.get(CompletableFuture.class));
            valueMap.put("linkHashMap", ClassName.get(LinkedHashMap.class));
            valueMap.put("map", ClassName.get(Map.class));
            valueMap.put("list", ClassName.get(List.class));
            valueMap.put("valErr", ValueOrError.class);
            valueMap.put("function", ClassName.get(Function.class));
            valueMap.put("optional", ClassName.get(Optional.class));
            Preconditions.checkState((boolean)Map.class.isAssignableFrom(this.getParsedVajramData().vajramLogic().getReturnType()), (String)"Any vajram supporting input modulation must return map", (Object)this.vajramName);
            Type type = ((ParameterizedType)this.getParsedVajramData().vajramLogic().getGenericReturnType()).getActualTypeArguments()[1];
            if (type instanceof ParameterizedType && CompletableFuture.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType())) {
                codeBuilder.addNamed("    $map:T<$inputModulation:T, $inputs:T> mapping = new $hashMap:T<>();\n    $commonInput:T commonInputs = null;\n    for ($inputs:T inputs : inputsList) {\n      $unmodInput:T<$inputModulation:T, $commonInput:T> allInputs =\n          getInputsConvertor().apply(inputs);\n      commonInputs = allInputs.commonInputs();\n      $inputModulation:T im = allInputs.inputsNeedingModulation();\n      mapping.put(im, inputs);\n    }\n    $map:T<$inputs:T, $comFuture:T<$returnType:T>> returnValue = new $linkHashMap:T<>();\n\n    if (commonInputs != null) {\n      var results = $vajramLogicMethod:L(new $modInput:T<>($imList:T.copyOf(mapping.keySet()), commonInputs));\n      results.forEach((im, future) -> returnValue.put(\n            $optional:T.ofNullable(mapping.get(im)).orElseThrow(),\n            future.<$returnType:T>thenApply($function:T.identity())));\n    }\n    return $imMap:T.copyOf(returnValue);\n", valueMap);
            } else {
                codeBuilder.addNamed("    $map:T<$inputModulation:T, $inputs:T> mapping = new $hashMap:T<>();\n    $commonInput:T commonInputs = null;\n    for ($inputs:T inputs : inputsList) {\n      $unmodInput:T<$inputModulation:T, $commonInput:T> allInputs =\n          getInputsConvertor().apply(inputs);\n      commonInputs = allInputs.commonInputs();\n      $inputModulation:T im = allInputs.inputsNeedingModulation();\n      mapping.put(im, inputs);\n    }\n    $map:T<$inputs:T, $valErr:T<$returnType:T>> returnValue = new $linkHashMap:T<>();\n\n    if (commonInputs != null) {\n      var results = $vajramLogicMethod:L(new $modInput:T<>($imList:T.copyOf(mapping.keySet()), commonInputs));\n      results.forEach((im, value) -> returnValue.put(\n           $optional:T.ofNullable(mapping.get(im)).orElseThrow(),\n           $valErr:T.withValue(value)));\n    }\n    return $imMap:T.copyOf(returnValue);\n", valueMap);
            }
            executeBuilder.addCode(codeBuilder.build());
        } else {
            this.nonModulatedComputeMethodBuilder(executeBuilder, false);
        }
        return executeBuilder.build();
    }

    private void nonModulatedComputeMethodBuilder(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec.Builder executeBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean isIOVajram) {
        CodeBlock.Builder returnBuilder = CodeBlock.builder().add("return inputsList.stream().collect(\n     $T.toImmutableMap($T.identity(),\n     element -> {\n", new Object[]{ImmutableMap.class, Function.class});
        ArrayList inputCodeBlocks = new ArrayList();
        this.inputDefsMap.values().forEach(inputDef -> {
            if (inputDef instanceof Dependency) {
                Dependency inputDefDependency = (Dependency)inputDef;
                DataAccessSpec depAccessSpec = inputDefDependency.dataAccessSpec();
                if (!(depAccessSpec instanceof VajramID)) throw new UnsupportedOperationException("Unknown data access spec %s".formatted(depAccessSpec));
                VajramID depVajramId = (VajramID)depAccessSpec;
                String depVajramClass = (String)depVajramId.className().orElseThrow(() -> new VajramValidationException("Vajram class missing in VajramInputDefinition for :" + this.vajramName));
                String[] splits = Constants.DOT_PATTERN.split(depVajramClass);
                String depPackageName = Arrays.stream(splits, 0, splits.length - 1).collect(Collectors.joining("."));
                String depVajramClassName = splits[splits.length - 1];
                String depRequestClass = CodegenUtils.getRequestClassName(depVajramClassName);
                VajramInfoLite vajramInfoLite = (VajramInfoLite)Preconditions.checkNotNull((Object)this.vajramDefs.get(depVajramClassName), (String)"Could not find ParsedVajramData for %s", (Object)depVajramClass);
                TypeName boxedResponseType = vajramInfoLite.responseType().box();
                String variableName = CodegenUtils.toJavaName(inputDef.name());
                String depVariableName = variableName + "Responses";
                if (inputDefDependency.canFanout()) {
                    CodeBlock.Builder codeBlock = CodeBlock.builder();
                    codeBlock.addNamed("$depResp:T<$request:T, $response:T> $depResponse:L =\n     new $depResp:T<>(\n         element.<$response:T>getDepValue($variable:S).values().entrySet().stream()\n             .filter(\n                 e ->\n                     e.getValue()\n                         .error()\n                         .filter(t -> t instanceof $skippedException:T)\n                         .isEmpty())\n             .collect(\n                 $imMap:T.toImmutableMap(\n                     e -> $request:T.from(e.getKey()), java.util.Map.Entry::getValue)));\n", (Map)ImmutableMap.of((Object)"depResp", DependencyResponse.class, (Object)"request", (Object)ClassName.get((String)depPackageName, (String)depRequestClass, (String[])new String[0]), (Object)"response", (Object)boxedResponseType, (Object)"variable", (Object)inputDef.name(), (Object)"depResponse", (Object)depVariableName, (Object)"imMap", ImmutableMap.class, (Object)"skippedException", SkippedExecutionException.class));
                    inputCodeBlocks.add(CodeBlock.builder().add(depVariableName, new Object[0]).build());
                    returnBuilder.add(codeBlock.build());
                    return;
                } else if (inputDefDependency.isMandatory()) {
                    inputCodeBlocks.add(CodeBlock.builder().addNamed("element.<$response:T>getDepValue($variable:S)\n    .values()\n    .entrySet()\n    .iterator()\n    .next()\n    .getValue()\n    .getValueOrThrow()\n    .orElseThrow(() -> new $illegalArgument:T(\"Missing mandatory dependency '$variable:L' in vajram '$vajram:L'\"))", (Map)ImmutableMap.of((Object)"response", (Object)boxedResponseType, (Object)"variable", (Object)inputDef.name(), (Object)"illegalArgument", IllegalArgumentException.class, (Object)"vajram", (Object)this.vajramName)).build());
                    return;
                } else {
                    inputCodeBlocks.add(CodeBlock.builder().addNamed("element.<$response:T>getDepValue($variable:S)\n    .values()\n    .entrySet()\n    .iterator()\n    .next()\n    .getValue()\n    .value()\n    .orElse(null)", (Map)ImmutableMap.of((Object)"response", (Object)boxedResponseType, (Object)"variable", (Object)inputDef.name())).build());
                }
                return;
            } else if (inputDef.isMandatory()) {
                inputCodeBlocks.add(CodeBlock.builder().add("element.getInputValueOrThrow($S)", new Object[]{inputDef.name()}).build());
                return;
            } else {
                inputCodeBlocks.add(CodeBlock.builder().add("element.getInputValueOrDefault($S, null)", new Object[]{inputDef.name()}).build());
            }
        });
        if (isIOVajram) {
            Class<?> returnType = this.getParsedVajramData().vajramLogic().getReturnType();
            if (!CompletableFuture.class.isAssignableFrom(returnType)) {
                throw new VajramValidationException("The VajramLogic of non-modulated IO vajram %s must return a CompletableFuture".formatted(this.vajramName));
            }
            returnBuilder.add("\nreturn ($L(new $T(\n", new Object[]{this.getParsedVajramData().vajramLogic().getName(), ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{CodegenUtils.getAllInputsClassname(this.vajramName)})});
        } else {
            returnBuilder.add("\nreturn $T.valueOrError(() -> $L(new $T(\n", new Object[]{ValueOrError.class, this.getParsedVajramData().vajramLogic().getName(), ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{CodegenUtils.getAllInputsClassname(this.vajramName)})});
        }
        for (int i = 0; i < inputCodeBlocks.size(); ++i) {
            returnBuilder.add("\t\t", new Object[0]);
            returnBuilder.add((CodeBlock)inputCodeBlocks.get(i));
            if (i == inputCodeBlocks.size() - 1) continue;
            returnBuilder.add(",\n", new Object[0]);
        }
        returnBuilder.add(")));\n", new Object[0]);
        returnBuilder.add("}));\n", new Object[0]);
        executeBuilder.addCode(returnBuilder.build());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec createInputConvertersMethod(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName inputsNeedingModulation, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName commonInputs) {
        MethodSpec.Builder inputConvertersBuilder = MethodSpec.methodBuilder((String)"getInputsConvertor").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(InputsConverter.class), (TypeName[])new TypeName[]{inputsNeedingModulation, commonInputs})).addAnnotation(Override.class);
        inputConvertersBuilder.addCode(CodeBlock.builder().addStatement("return $T.CONVERTER", new Object[]{ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[0])}).build());
        return inputConvertersBuilder.build();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec createIOVajramExecuteMethod(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName inputsNeedingModulation, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName commonInputs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName vajramResponseType) {
        MethodSpec.Builder executeMethodBuilder = MethodSpec.methodBuilder((String)"execute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{Inputs.class}), "inputsList", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableMap.class), (TypeName[])new TypeName[]{ClassName.get(Inputs.class), ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{vajramResponseType})})).addAnnotation(Override.class);
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        if (this.needsModulation) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put("inputs", ClassName.get(Inputs.class));
            valueMap.put("unmodInput", ClassName.get(UnmodulatedInput.class));
            valueMap.put("inputModulation", inputsNeedingModulation);
            valueMap.put("commonInput", commonInputs);
            valueMap.put("returnType", vajramResponseType);
            valueMap.put("vajramLogicMethod", this.getParsedVajramData().vajramLogic().getName());
            valueMap.put("modInput", ClassName.get(ModulatedInput.class));
            valueMap.put("imMap", ClassName.get(ImmutableMap.class));
            valueMap.put("imList", ClassName.get(ImmutableList.class));
            valueMap.put("hashMap", ClassName.get(HashMap.class));
            valueMap.put("arrayList", ClassName.get(ArrayList.class));
            valueMap.put("comFuture", ClassName.get(CompletableFuture.class));
            valueMap.put("linkHashMap", ClassName.get(LinkedHashMap.class));
            valueMap.put("map", ClassName.get(Map.class));
            valueMap.put("list", ClassName.get(List.class));
            valueMap.put("valErr", ValueOrError.class);
            valueMap.put("function", ClassName.get(Function.class));
            valueMap.put("optional", ClassName.get(Optional.class));
            Preconditions.checkState((boolean)Map.class.isAssignableFrom(this.getParsedVajramData().vajramLogic().getReturnType()), (String)"Any vajram supporting input modulation must return map. Vajram: %s", (Object)this.getParsedVajramData().vajramName());
            Type type = ((ParameterizedType)this.getParsedVajramData().vajramLogic().getGenericReturnType()).getActualTypeArguments()[1];
            if (type instanceof ParameterizedType && CompletableFuture.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType())) {
                codeBuilder.addNamed("    $map:T<$inputModulation:T, $inputs:T> mapping = new $hashMap:T<>();\n    $commonInput:T commonInputs = null;\n    for ($inputs:T inputs : inputsList) {\n      $unmodInput:T<$inputModulation:T, $commonInput:T> allInputs =\n          getInputsConvertor().apply(inputs);\n      commonInputs = allInputs.commonInputs();\n      $inputModulation:T im = allInputs.inputsNeedingModulation();\n      mapping.put(im, inputs);\n    }\n    $map:T<$inputs:T, $comFuture:T<$returnType:T>> returnValue = new $linkHashMap:T<>();\n\n    if (commonInputs != null) {\n      var results = $vajramLogicMethod:L(new $modInput:T<>($imList:T.copyOf(mapping.keySet()), commonInputs));\n      results.forEach((im, future) -> returnValue.put(\n            $optional:T.ofNullable(mapping.get(im)).orElseThrow(),\n            future.<$returnType:T>thenApply($function:T.identity())));\n    }\n    return $imMap:T.copyOf(returnValue);\n", valueMap);
            } else {
                codeBuilder.addNamed("    $map:T<$inputModulation:T, $inputs:T> mapping = new $hashMap:T<>();\n    $commonInput:T commonInputs = null;\n    for ($inputs:T inputs : inputsList) {\n      $unmodInput:T<$inputModulation:T, $commonInput:T> allInputs =\n          getInputsConvertor().apply(inputs);\n      commonInputs = allInputs.commonInputs();\n      $inputModulation:T im = allInputs.inputsNeedingModulation();\n      mapping.put(im, inputs);\n    }\n    $map:T<$inputs:T, $valErr:T<$returnType:T>> returnValue = new $linkHashMap:T<>();\n\n    if (commonInputs != null) {\n      var results = $vajramLogicMethod:L(new $modInput:T<>($imList:T.copyOf(mapping.keySet()), commonInputs));\n      results.forEach((im, value) -> returnValue.put(\n           $optional:T.ofNullable(mapping.get(im)).orElseThrow(),\n           $valErr:T.withValue(value)));\n    }\n    return $imMap:T.copyOf(returnValue);\n", valueMap);
            }
            executeMethodBuilder.addCode(codeBuilder.build());
        } else {
            this.nonModulatedComputeMethodBuilder(executeMethodBuilder, true);
        }
        return executeMethodBuilder.build();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec> createResolvers(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Method>> resolverMap, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Boolean> depFanoutMap) {
        String dependency = "dependency";
        MethodSpec.Builder resolveInputsBuilder = MethodSpec.methodBuilder((String)"resolveInputOfDependency").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, dependency, new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get(ImmutableSet.class, (Type[])new Type[]{String.class}), "resolvableInputs", new Modifier[0]).addParameter(Inputs.class, "inputs", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(DependencyCommand.class), (TypeName[])new TypeName[]{ClassName.get(Inputs.class)}));
        if (Objects.nonNull(this.getParsedVajramData())) {
            resolveInputsBuilder.beginControlFlow("switch ($L) ", new Object[]{dependency});
            if (this.getParsedVajramData().resolveMethods().isEmpty()) {
                return Optional.empty();
            }
            Set<String> resolvedVariables = resolverMap.keySet();
            resolverMap.forEach((variable, methods) -> {
                CodeBlock.Builder caseBuilder = CodeBlock.builder().beginControlFlow("case $S -> ", new Object[]{variable});
                methods.forEach(method -> {
                    AtomicBoolean fanout = new AtomicBoolean(false);
                    Arrays.stream(method.getParameters()).forEach(parameter -> {
                        String bindParamName = ((Using)Preconditions.checkNotNull((Object)parameter.getAnnotation(Using.class))).value();
                        if (!fanout.get() && depFanoutMap.containsKey(bindParamName)) {
                            fanout.set((Boolean)depFanoutMap.get(bindParamName));
                        }
                        if (!this.inputDefsMap.containsKey(bindParamName) && !resolvedVariables.contains(bindParamName)) {
                            throw new VajramValidationException("Parameter binding incorrect for input - " + bindParamName);
                        }
                    });
                    CodeBlock.Builder ifBlockBuilder = this.buildInputResolver((Method)method, depFanoutMap, fanout.get());
                    caseBuilder.add(ifBlockBuilder.build());
                });
                caseBuilder.endControlFlow();
                resolveInputsBuilder.addCode(caseBuilder.build());
            });
            resolveInputsBuilder.endControlFlow();
            resolveInputsBuilder.addStatement("throw new $T($S)", new Object[]{ClassName.get(VajramValidationException.class), "Unresolvable dependency"});
        } else {
            resolveInputsBuilder.addStatement("throw new $T($S)", new Object[]{ClassName.get(VajramValidationException.class), "Unresolvable dependency"});
        }
        return Optional.of(resolveInputsBuilder.build());
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CodeBlock.Builder buildInputResolver(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Method method, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Boolean> depFanoutMap, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean isParamFanoutDependency) {
        Resolve resolve = (Resolve)Preconditions.checkNotNull((Object)method.getAnnotation(Resolve.class), (Object)"Resolver method must have 'Resolve' annotation");
        CharSequence[] inputs = resolve.depInputs();
        String depName = resolve.depName();
        CodeBlock.Builder ifBlockBuilder = CodeBlock.builder();
        ifBlockBuilder.beginControlFlow("if ($T.of($S).equals(resolvableInputs))", new Object[]{Set.class, String.join((CharSequence)",", inputs)});
        Arrays.stream(method.getParameters()).forEach(parameter -> {
            String usingInputName = ((Using)Preconditions.checkNotNull((Object)parameter.getAnnotation(Using.class), (String)"Resolver method params must have 'Using' annotation. Vajram: %s, method %s, param: %s", (Object)this.vajramName, (Object)method.getName(), (Object)parameter.getName())).value();
            if (this.inputDefsMap.get(usingInputName) instanceof Dependency) {
                this.generateDependencyResolutions(method, usingInputName, ifBlockBuilder, depFanoutMap, (Parameter)parameter);
                return;
            } else {
                if (!this.inputDefsMap.containsKey(usingInputName)) throw new VajramValidationException("No input resolver found for " + usingInputName);
                VajramInputDefinition inputDefinition = this.inputDefsMap.get(usingInputName);
                String variable = VajramCodeGenerator.toJavaName(usingInputName);
                TypeName parameterType = CodegenUtils.getType(parameter.getParameterizedType());
                if (inputDefinition.isMandatory()) {
                    ifBlockBuilder.add(CodeBlock.builder().addStatement("$T $L = $L.getInputValueOrThrow($S)", new Object[]{parameterType, variable, "inputs", usingInputName}).build());
                    return;
                } else {
                    if (!Optional.class.isAssignableFrom(parameter.getType())) throw new VajramValidationException(String.format("Optional input dependency %s must have type as Optional", usingInputName));
                    ifBlockBuilder.add(CodeBlock.builder().addStatement("$T $L = $L.getInputValueOpt($S)", new Object[]{parameterType, variable, "inputs", usingInputName}).build());
                }
            }
        });
        boolean isFanOut = isParamFanoutDependency || depFanoutMap.getOrDefault(depName, false) != false;
        this.buildFinalResolvers(method, (String[])inputs, ifBlockBuilder, isFanOut);
        ifBlockBuilder.endControlFlow();
        return ifBlockBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateDependencyResolutions(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Method method, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String usingInputName, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CodeBlock.Builder ifBlockBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Boolean> depFanoutMap, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Parameter parameter) {
        Dependency inputDefDependency;
        DataAccessSpec dataAccessSpec;
        VajramInputDefinition vajramInputDef = this.inputDefsMap.get(usingInputName);
        Resolve resolve = (Resolve)Preconditions.checkNotNull((Object)method.getAnnotation(Resolve.class), (Object)"Resolver method cannot be null");
        String resolvedDep = resolve.depName();
        if (depFanoutMap.containsKey(usingInputName) && depFanoutMap.get(usingInputName).booleanValue() && !DependencyResponse.class.isAssignableFrom(parameter.getType())) {
            log.error("Dependency resolution of {} is fanout but the resolver method is not of type DependencyResponse.", (Object)resolvedDep);
            throw new VajramValidationException("Dependency resolution of " + resolvedDep + " is fanout but the resolver method is not of type DependencyResponse");
        }
        if (!(vajramInputDef instanceof Dependency) || !((dataAccessSpec = (inputDefDependency = (Dependency)vajramInputDef).dataAccessSpec()) instanceof VajramID)) return;
        VajramID vajramID = (VajramID)dataAccessSpec;
        String depVajramClass = (String)vajramID.className().orElseThrow(() -> new VajramValidationException("Vajram class missing in vajram input definition"));
        String variableName = CodegenUtils.toJavaName(usingInputName);
        String[] splits = Constants.DOT_PATTERN.split(depVajramClass);
        String depVajramClassName = splits[splits.length - 1];
        VajramInfoLite parsedVajramData = (VajramInfoLite)Preconditions.checkNotNull((Object)this.vajramDefs.get(depVajramClassName), (String)"Could not find parsed vajram data for class %s", (Object)depVajramClassName);
        String depPackageName = Arrays.stream(splits, 0, splits.length - 1).collect(Collectors.joining("."));
        String requestClass = CodegenUtils.getRequestClassName(depVajramClassName);
        TypeName usingDepType = parsedVajramData.responseType();
        if (usingDepType.isBoxedPrimitive()) {
            usingDepType = usingDepType.unbox();
        }
        String resolverName = method.getName();
        if (DependencyResponse.class.isAssignableFrom(parameter.getType())) {
            String depValueAccessorCode = "$1T $2L =\n new $3T<>(inputs.<$4T>getDepValue($5S)\n      .values().entrySet().stream()\n      .collect($6T.toImmutableMap(e -> $7T.from(e.getKey()),\n      $8T::getValue)))";
            ifBlockBuilder.addStatement(depValueAccessorCode, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(DependencyResponse.class), (TypeName[])new TypeName[]{ClassName.get((String)depPackageName, (String)requestClass, (String[])new String[0]), usingDepType}), variableName, DependencyResponse.class, usingDepType, usingInputName, ImmutableMap.class, ClassName.get((String)depPackageName, (String)requestClass, (String[])new String[0]), ClassName.get(Map.Entry.class)});
            return;
        } else {
            String depValueAccessorCode = "$1T $2L =\n  inputs.<$3T>getDepValue($4S)\n     .values()\n     .entrySet()\n     .iterator()\n     .next()\n     .getValue()";
            if (usingDepType.equals((Object)TypeName.get(parameter.getType()))) {
                if (!vajramInputDef.isMandatory()) throw new VajramValidationException("A resolver ('%s') must not access an optional dependency ('%s') directly.Use Optional<>, ValueOrError<>, or DependencyResponse<> instead".formatted(resolverName, usingInputName));
                String code = depValueAccessorCode + ".getValueOrThrow().orElseThrow(() ->\n    new $5T(\"Received null value for mandatory dependency '$6L' of vajram '$7L'\"))";
                ifBlockBuilder.addStatement(code, new Object[]{usingDepType, variableName, usingDepType, usingInputName, IllegalArgumentException.class, usingInputName, this.vajramName});
                return;
            } else if (ValueOrError.class.isAssignableFrom(parameter.getType())) {
                ifBlockBuilder.addStatement(depValueAccessorCode, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(ValueOrError.class), (TypeName[])new TypeName[]{usingDepType}), variableName, CodegenUtils.getMethodReturnType(method).box(), usingInputName});
                return;
            } else {
                if (!Optional.class.isAssignableFrom(parameter.getType())) throw new VajramValidationException("Unrecognized parameter type %s in resolver %s of vajram %s".formatted(parameter.getType(), resolverName, this.vajramName));
                String code = depValueAccessorCode + ".value()";
                ifBlockBuilder.addStatement(code, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{usingDepType}), variableName, CodegenUtils.getMethodReturnType(method).box(), usingInputName});
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildFinalResolvers(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Method method, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized [] inputs, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CodeBlock.Builder ifBlockBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean isFanOut) {
        Class klass;
        String variableName = "resolverResult";
        boolean controlFLowStarted = false;
        TypeName methodReturnType = CodegenUtils.getMethodReturnType(method);
        ifBlockBuilder.add("$T $L = $L(", new Object[]{methodReturnType, variableName, method.getName()});
        ImmutableList resolverSources = VajramCodeGenerator.getResolverSources(method).asList();
        for (int i = 0; i < resolverSources.size(); ++i) {
            String bindName = (String)resolverSources.get(i);
            ifBlockBuilder.add("$L", new Object[]{CodegenUtils.toJavaName(bindName)});
            if (i == method.getParameters().length - 1) continue;
            ifBlockBuilder.add(", ", new Object[0]);
        }
        ifBlockBuilder.add(");\n", new Object[0]);
        if (DependencyCommand.class.isAssignableFrom(method.getReturnType())) {
            ifBlockBuilder.beginControlFlow("if($L.shouldSkip())", new Object[]{variableName});
            ifBlockBuilder.addStatement("\t return $T.skipExecution($L.doc())", new Object[]{SingleExecute.class, variableName});
            ifBlockBuilder.add("} else {\n\t", new Object[0]);
            controlFLowStarted = true;
        }
        if (MultiExecute.class.isAssignableFrom(klass = Primitives.wrap(method.getReturnType()))) {
            code = "return $T.executeFanoutWith(\n    $L.inputs().stream()\n        .map(\n            element ->\n                new $T(\n                    $T.of($S, $T.withValue(element))))\n    .toList())";
            ifBlockBuilder.addStatement(code, new Object[]{MultiExecute.class, variableName, Inputs.class, ImmutableMap.class, inputs[0], ValueOrError.class});
        } else if (isFanOut) {
            if (!Iterable.class.isAssignableFrom(klass)) throw new VajramValidationException("Incorrect vajram resolver " + this.vajramName + ": Fanout resolvers must return an iterable");
            if (VajramRequest.class.isAssignableFrom((Class)((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0])) {
                code = "return $T.executeFanoutWith(\n    $L.stream()\n        .map(\n            element ->\n                element.toInputValues()))\n    .toList())";
                ifBlockBuilder.addStatement(code, new Object[]{MultiExecute.class, variableName});
            } else {
                code = "return $T.executeFanoutWith(\n    $L.stream()\n        .map(\n            element ->\n                new $T(\n                    $T.of($S, $T.withValue(element))))\n    .toList())";
                ifBlockBuilder.addStatement(code, new Object[]{MultiExecute.class, variableName, Inputs.class, ImmutableMap.class, inputs[0], ValueOrError.class});
            }
        } else if (VajramRequest.class.isAssignableFrom(klass)) {
            ifBlockBuilder.addStatement("return $T.executeWith($L.toInputValues())", new Object[]{SingleExecute.class, variableName});
        } else if (SingleExecute.class.isAssignableFrom(klass)) {
            ifBlockBuilder.addStatement("  return $T.executeWith(new Inputs(\n   $T.of($S, $T.withValue(\n      $L.inputs().iterator().next().orElse(null)))))\n", new Object[]{SingleExecute.class, ImmutableMap.class, inputs[0], ValueOrError.class, variableName});
        } else {
            ifBlockBuilder.addStatement("return $T.executeWith(new Inputs(\n $T.of($S, $T.withValue($L))))", new Object[]{SingleExecute.class, ImmutableMap.class, inputs[0], ValueOrError.class, variableName});
        }
        if (!controlFLowStarted) return;
        ifBlockBuilder.endControlFlow();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec createInputDefinitions(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassLoader classLoader) {
        MethodSpec.Builder inputDefinitionsBuilder = MethodSpec.methodBuilder((String)"getInputDefinitions").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{VajramInputDefinition.class}));
        List<VajramInputDefinition> inputDefinitions = this.vajramInfo.allInputsStream().toList();
        ArrayList codeBlocks = new ArrayList(inputDefinitions.size());
        inputDefinitions.forEach(vajramInputDefinition -> {
            CodeBlock.Builder inputDefBuilder = CodeBlock.builder();
            if (vajramInputDefinition instanceof Input) {
                Input input = (Input)vajramInputDefinition;
                this.buildVajramInput(inputDefBuilder, input);
            } else if (vajramInputDefinition instanceof Dependency) {
                Dependency dependency = (Dependency)vajramInputDefinition;
                VajramCodeGenerator.buildVajramDependency(classLoader, inputDefBuilder, dependency);
            }
            codeBlocks.add(inputDefBuilder.build());
        });
        inputDefinitionsBuilder.beginControlFlow("if(this.$L == null)", new Object[]{"inputDefinitions"});
        inputDefinitionsBuilder.addCode(CodeBlock.builder().add("this.$L = $T.of(\n", new Object[]{"inputDefinitions", ImmutableList.class}).add(CodeBlock.join(codeBlocks, (String)",\n\t")).add("\n);\n", new Object[0]).build());
        inputDefinitionsBuilder.endControlFlow();
        inputDefinitionsBuilder.addStatement("return $L", new Object[]{"inputDefinitions"});
        return inputDefinitionsBuilder.build();
    }

    private static void buildVajramDependency(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassLoader classLoader, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CodeBlock.Builder inputDefBuilder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Dependency<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dependency) {
        inputDefBuilder.add("$T.builder()", new Object[]{ClassName.get(Dependency.class)}).add(".name($S)", new Object[]{dependency.name()});
        DataAccessSpec dataAccessSpec = dependency.dataAccessSpec();
        if (dataAccessSpec instanceof VajramID) {
            VajramID vajramID = (VajramID)dataAccessSpec;
            String code = ".dataAccessSpec($1T.vajramID($2S))";
            if (vajramID.className().isPresent()) {
                try {
                    Optional vajramId = Vajrams.getVajramIdString(classLoader.loadClass((String)vajramID.className().get()));
                    vajramId.ifPresent(s -> inputDefBuilder.add(code, new Object[]{ClassName.get(VajramID.class), s}));
                }
                catch (ClassNotFoundException e) {
                    throw new VajramValidationException((Throwable)e);
                }
            } else {
                inputDefBuilder.add(code, new Object[]{ClassName.get(VajramID.class), vajramID.vajramId()});
            }
        }
        inputDefBuilder.add(".isMandatory($L)", new Object[]{dependency.isMandatory()});
        inputDefBuilder.add(".build()", new Object[0]);
    }

    private void buildVajramInput(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CodeBlock.Builder inputDefBuilder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Input<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> input) {
        inputDefBuilder.add("$T.builder()", new Object[]{ClassName.get(Input.class)}).add(".name($S)", new Object[]{input.name()});
        ImmutableSet inputSources = input.sources();
        if (!inputSources.isEmpty()) {
            inputDefBuilder.add(".sources(", new Object[0]);
            String sources = inputSources.stream().map(inputSource -> {
                if (inputSource == InputSource.CLIENT) {
                    return "$inputSrc:T.CLIENT";
                }
                if (inputSource == InputSource.SESSION) {
                    return "$inputSrc:T.SESSION";
                }
                throw new IllegalArgumentException("Incorrect source defined in vajram config");
            }).collect(Collectors.joining(","));
            inputDefBuilder.addNamed(sources, (Map)ImmutableMap.of((Object)"inputSrc", InputSource.class)).add(")", new Object[0]);
        }
        DataType dataType = input.type();
        inputDefBuilder.add(".type(", new Object[0]);
        if (dataType instanceof CustomType) {
            ClassName className;
            CustomType javaType = (CustomType)dataType;
            if (!javaType.enclosingClasses().isEmpty() || javaType.simpleName().isPresent()) {
                assert (javaType.packageName().isPresent());
                className = ClassName.get((String)((String)javaType.packageName().get()), (String)String.join((CharSequence)".", (Iterable<? extends CharSequence>)javaType.enclosingClasses()), (String[])new String[]{(String)javaType.simpleName().get()});
            } else {
                className = ClassName.bestGuess((String)javaType.className());
            }
            inputDefBuilder.add("$1T.create($2T.class)", new Object[]{ClassName.get(CustomType.class), className});
        } else {
            TypeAndName typeName;
            String simpleName = dataType.getClass().getSimpleName();
            String name = simpleName.substring(0, simpleName.length() - 4).toLowerCase();
            if (simpleName.toLowerCase().contains("boolean")) {
                name = "bool";
            }
            if (ParameterizedTypeName.class.isAssignableFrom((typeName = VajramCodeGenerator.getTypeName(dataType)).typeName().getClass())) {
                TypeName innerType = (TypeName)((ParameterizedTypeName)typeName.typeName()).typeArguments.get(0);
                inputDefBuilder.add("$T.$L($T.$L())", new Object[]{ClassName.get((String)dataType.getClass().getPackageName(), (String)simpleName, (String[])new String[0]), name, ClassName.get((String)dataType.getClass().getPackageName(), (String)(((ClassName)innerType).simpleName() + "Type"), (String[])new String[0]), ((ClassName)innerType).simpleName().toLowerCase()});
            } else {
                inputDefBuilder.add("$T.$L()", new Object[]{ClassName.get((String)dataType.getClass().getPackageName(), (String)simpleName, (String[])new String[0]), name});
            }
        }
        inputDefBuilder.add(")", new Object[0]);
        inputDefBuilder.add(".isMandatory($L)", new Object[]{input.isMandatory()});
        inputDefBuilder.add(".needsModulation($L)", new Object[]{input.needsModulation()});
        if (input.tags() != null && !input.tags().isEmpty()) {
            inputDefBuilder.add(".tags($T.of(", new Object[]{ClassName.get(Map.class)});
            String tags = input.tags().values().stream().filter(tag -> tag != null && tag.tagValue() != null).map(tag -> String.format("\"%s\", \"%s\"", tag.tagKey(), tag.tagValue())).collect(Collectors.joining(","));
            inputDefBuilder.add(tags, new Object[0]).add("))", new Object[0]);
        }
        inputDefBuilder.add(".build()", new Object[0]);
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String codeGenVajramRequest() {
        ImmutableList<Input<?>> inputDefs = this.vajramInfo.inputs();
        MethodSpec.Builder requestConstructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
        ClassName builderClassType = ClassName.get((String)(this.packageName + "." + this.requestClassName), (String)"Builder", (String[])new String[0]);
        TypeSpec.Builder requestClass = TypeSpec.classBuilder((String)this.requestClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(VajramRequest.class), (TypeName[])new TypeName[]{this.vajramInfo.responseType().box()})).addAnnotation(EqualsAndHashCode.class).addMethod(MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)builderClassType).addStatement("return new Builder()", new Object[0]).build());
        TypeSpec.Builder builderClass = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addAnnotation(EqualsAndHashCode.class).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        LinkedHashSet<String> inputNames = new LinkedHashSet<String>();
        List<VajramInputDefinition> allInputs = this.vajramInfo.allInputsStream().toList();
        ArrayList<FieldSpec.Builder> inputNameFields = new ArrayList<FieldSpec.Builder>(allInputs.size());
        ArrayList<FieldSpec.Builder> inputSpecFields = new ArrayList<FieldSpec.Builder>(allInputs.size());
        for (VajramInputDefinition abstractInput : allInputs) {
            Input input;
            FieldSpec.Builder inputSpecField;
            Dependency vajramDepDef;
            DataAccessSpec dataAccessSpec;
            String inputJavaName = VajramCodeGenerator.toJavaName(abstractInput.name());
            TypeAndName javaType = VajramCodeGenerator.getTypeName(this.getDataType(abstractInput));
            ClassName vajramClassName = ClassName.get((String)this.packageName, (String)this.vajramName, (String[])new String[0]);
            String inputNameFieldName = inputJavaName + "_n";
            FieldSpec.Builder inputNameField = FieldSpec.builder(String.class, (String)inputNameFieldName, (Modifier[])new Modifier[0]).initializer("\"$L\"", new Object[]{abstractInput.name()});
            if (abstractInput instanceof Dependency && (dataAccessSpec = (vajramDepDef = (Dependency)abstractInput).dataAccessSpec()) instanceof VajramID) {
                VajramID vajramID = (VajramID)dataAccessSpec;
                ClassName specType = ClassName.get(vajramDepDef.canFanout() ? VajramDepFanoutTypeSpec.class : VajramDepSingleTypeSpec.class);
                ClassName depVajramClass = ClassName.bestGuess((String)((String)vajramID.className().orElseThrow()));
                inputSpecField = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)specType, (TypeName[])new TypeName[]{javaType.typeName(), vajramClassName, depVajramClass}), (String)(inputJavaName + "_s"), (Modifier[])new Modifier[0]).initializer("new $T<>($L, $T.class, $T.class)", new Object[]{specType, inputNameFieldName, vajramClassName, depVajramClass});
            } else {
                inputSpecField = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(VajramInputTypeSpec.class), (TypeName[])new TypeName[]{javaType.typeName(), vajramClassName}), (String)(inputJavaName + "_s"), (Modifier[])new Modifier[0]).initializer("new $T<>($L, $T.class)", new Object[]{VajramInputTypeSpec.class, inputNameFieldName, vajramClassName});
            }
            inputNameFields.add(inputNameField.addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL}));
            inputSpecFields.add(inputSpecField.addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL}));
            if (!(abstractInput instanceof Input) || !(input = (Input)abstractInput).sources().contains((Object)InputSource.CLIENT)) continue;
            inputSpecField.addModifiers(new Modifier[]{Modifier.PUBLIC});
            inputNameField.addModifiers(new Modifier[]{Modifier.PUBLIC});
            inputNames.add(inputJavaName);
            requestClass.addField(FieldSpec.builder((TypeName)VajramCodeGenerator.wrapPrimitive(javaType).typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)inputJavaName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            builderClass.addField(FieldSpec.builder((TypeName)javaType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)inputJavaName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
            requestConstructor.addParameter(ParameterSpec.builder((TypeName)javaType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)inputJavaName, (Modifier[])new Modifier[0]).build());
            requestConstructor.addStatement("this.$L = $L", new Object[]{inputJavaName, inputJavaName});
            requestClass.addMethod(VajramCodeGenerator.getterCodeForInput((VajramInputDefinition)input, inputJavaName, javaType));
            builderClass.addMethod(MethodSpec.methodBuilder((String)inputJavaName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(javaType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()})).addStatement("return this.$L", new Object[]{inputJavaName}).build());
            builderClass.addMethod(MethodSpec.methodBuilder((String)inputJavaName).returns((TypeName)builderClassType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)javaType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)inputJavaName, (Modifier[])new Modifier[0]).build()).addStatement("this.$L = $L", new Object[]{inputJavaName, inputJavaName}).addStatement("return this", new Object[]{inputJavaName}).build());
        }
        requestClass.addFields(inputNameFields.stream().map(FieldSpec.Builder::build)::iterator);
        requestClass.addFields(inputSpecFields.stream().map(FieldSpec.Builder::build)::iterator);
        builderClass.addMethod(MethodSpec.methodBuilder((String)"build").returns((TypeName)ClassName.get((String)this.packageName, (String)this.requestClassName, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return new %s(%s)".formatted(this.requestClassName, String.join((CharSequence)", ", inputNames)), new Object[0]).build());
        StringWriter writer = new StringWriter();
        FromAndTo fromAndTo = this.fromAndToMethods(inputDefs.stream().filter(inputDef -> inputDef.sources().contains((Object)InputSource.CLIENT)).toList(), ClassName.get((String)this.packageName, (String)this.requestClassName, (String[])new String[0]));
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)requestClass.addMethod(requestConstructor.build()).addMethod(fromAndTo.from()).addMethod(fromAndTo.to()).addType(builderClass.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getDataType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInputDefinition abstractInput) {
        Dependency dep;
        DataAccessSpec dataAccessSpec;
        if (abstractInput instanceof Input) {
            Input input = (Input)abstractInput;
            return input.type();
        }
        if (abstractInput instanceof Dependency && (dataAccessSpec = (dep = (Dependency)abstractInput).dataAccessSpec()) instanceof VajramID) {
            VajramID vajramID = (VajramID)dataAccessSpec;
            return vajramID.responseType();
        }
        throw new UnsupportedOperationException("Unable to extract datatype from facet : %s".formatted(abstractInput));
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName wrapPrimitive(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName javaType) {
        Type type;
        if (javaType.type().isPresent() && (type = javaType.type().get()) instanceof Class) {
            Class clazz = (Class)type;
            Class wrapped = Primitives.wrap((Class)clazz);
            return new TypeAndName((TypeName)ClassName.get((Class)wrapped), Optional.of(wrapped));
        }
        return javaType;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName unwrapPrimitive(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName javaType) {
        Type type;
        if (javaType.type().isPresent() && (type = javaType.type().get()) instanceof Class) {
            Class clazz = (Class)type;
            Class unwrapped = Primitives.unwrap((Class)clazz);
            return new TypeAndName(TypeName.get((Type)unwrapped), Optional.of(unwrapped));
        }
        return javaType;
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized FromAndTo fromAndToMethods(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInputDefinition> inputDefs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName enclosingClass) {
        MethodSpec.Builder toInputValues = MethodSpec.methodBuilder((String)"toInputValues").returns(Inputs.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("$T builder = new $T<>($L)", new Object[]{new TypeToken<Map<String, InputValue<Object>>>(){}.getType(), new TypeToken<HashMap>(){}.getType(), inputDefs.size()});
        MethodSpec.Builder fromInputValues = MethodSpec.methodBuilder((String)"from").returns((TypeName)enclosingClass).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(Inputs.class, "values", new Modifier[0]);
        for (VajramInputDefinition vajramInputDefinition : inputDefs) {
            String inputJavaName = VajramCodeGenerator.toJavaName(vajramInputDefinition.name());
            toInputValues.addStatement("builder.put($S, $T.withValue(this.$L))", new Object[]{vajramInputDefinition.name(), ValueOrError.class, inputJavaName});
        }
        toInputValues.addStatement("return new $T(builder)", new Object[]{Inputs.class});
        List<String> inputNames = inputDefs.stream().map(VajramInputDefinition::name).toList();
        fromInputValues.addStatement("return new $T(%s)".formatted(inputNames.stream().map(s -> "values.getInputValueOrDefault($S, null)").collect(Collectors.joining(", "))), Stream.concat(Stream.of(enclosingClass), inputNames.stream()).toArray());
        return new FromAndTo(fromInputValues.build(), toInputValues.build());
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName getTypeName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dataType) {
        return VajramCodeGenerator.getTypeName(dataType, List.of());
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName getTypeName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dataType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized AnnotationSpec> typeAnnotations) {
        if (dataType instanceof CustomType) {
            ClassName className;
            CustomType customType = (CustomType)dataType;
            Optional simpleName = customType.simpleName();
            if (simpleName.isPresent()) {
                List<String> classNames = Stream.concat(customType.enclosingClasses().stream(), Stream.of((String)simpleName.get())).toList();
                className = ClassName.get((String)customType.packageName().orElse(""), (String)classNames.get(0), (String[])((String[])classNames.subList(1, classNames.size()).toArray(String[]::new)));
            } else {
                className = ClassName.bestGuess((String)customType.className());
            }
            if (!customType.typeParameters().isEmpty()) {
                return new TypeAndName((TypeName)ParameterizedTypeName.get((ClassName)className, (TypeName[])((TypeName[])customType.typeParameters().stream().map(VajramCodeGenerator::getTypeName).map(TypeAndName::typeName).toArray(TypeName[]::new))).annotated(typeAnnotations));
            }
            return new TypeAndName((TypeName)className.annotated(typeAnnotations));
        }
        Optional javaType = dataType.javaType();
        return new TypeAndName(javaType.map(type -> {
            Type type2;
            if (type instanceof Class) {
                Class clazz = (Class)type;
                type2 = Primitives.wrap((Class)clazz);
            } else {
                type2 = type;
            }
            return type2;
        }).map(TypeName::get).orElseThrow(() -> new IllegalArgumentException("Could not determine java Type of %s".formatted(dataType))).annotated(typeAnnotations), javaType);
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec getterCodeForInput(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInputDefinition input, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String name, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName typeAndName) {
        Dependency dependencyDef;
        boolean wrapWithOptional = !input.isMandatory() && (input instanceof Input || input instanceof Dependency && !(dependencyDef = (Dependency)input).canFanout());
        return MethodSpec.methodBuilder((String)name).returns(wrapWithOptional ? VajramCodeGenerator.optional(VajramCodeGenerator.wrapPrimitive(typeAndName).typeName().withoutAnnotations()) : VajramCodeGenerator.unwrapPrimitive(typeAndName).typeName().withoutAnnotations()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(!wrapWithOptional ? CodeBlock.of((String)"if($L == null) {\n  throw new IllegalStateException(\"The input '$L' is not optional, but has null value. This should not happen\");\n}", (Object[])new Object[]{name, name}) : CodeBlock.builder().build()).addCode(wrapWithOptional ? CodeBlock.builder().addStatement("return $T.ofNullable(this.$L)", new Object[]{Optional.class, name}).build() : CodeBlock.builder().addStatement("return this.$L", new Object[]{name}).build()).build();
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String codeGenInputUtil() {
        boolean doInputsNeedModulation = this.vajramInfo.allInputsStream().anyMatch(VajramInputDefinition::needsModulation);
        if (doInputsNeedModulation) {
            return this.codeGenModulatedInputUtil();
        }
        return this.codeGenSimpleInputUtil();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String codeGenSimpleInputUtil() {
        TypeSpec.Builder inputUtilClass = this.createInputUtilClass();
        String className = CodegenUtils.getAllInputsClassname(this.vajramName);
        TypeSpec.Builder allInputsClass = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.STATIC}).addAnnotations(VajramCodeGenerator.recordAnnotations());
        ArrayList<FieldTypeName> fieldsList = new ArrayList<FieldTypeName>();
        this.vajramInfo.inputs().forEach(inputDef -> {
            String inputJavaName = VajramCodeGenerator.toJavaName(inputDef.name());
            TypeAndName javaType = VajramCodeGenerator.getTypeName(inputDef.type(), List.of(AnnotationSpec.builder(Nullable.class).build()));
            allInputsClass.addField(javaType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            allInputsClass.addMethod(VajramCodeGenerator.getterCodeForInput((VajramInputDefinition)inputDef, inputJavaName, javaType));
            fieldsList.add(new FieldTypeName(javaType.typeName(), inputJavaName));
        });
        this.vajramInfo.dependencies().forEach(dependencyDef -> {
            TypeAndName typeAndName = VajramCodeGenerator.getDependencyOutputsType(dependencyDef);
            String inputJavaName = VajramCodeGenerator.toJavaName(dependencyDef.name());
            allInputsClass.addField(typeAndName.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            allInputsClass.addMethod(VajramCodeGenerator.getterCodeForInput((VajramInputDefinition)dependencyDef, inputJavaName, typeAndName));
            fieldsList.add(new FieldTypeName(typeAndName.typeName(), inputJavaName));
        });
        this.generateConstructor(fieldsList).ifPresent(arg_0 -> ((TypeSpec.Builder)allInputsClass).addMethod(arg_0));
        StringWriter writer = new StringWriter();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)inputUtilClass.addType(allInputsClass.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec> generateConstructor(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized FieldTypeName> fieldsList) {
        if (fieldsList.isEmpty()) {
            return Optional.empty();
        }
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder();
        fieldsList.forEach(fieldTypeName -> {
            constructor.addParameter(fieldTypeName.typeName(), fieldTypeName.name(), new Modifier[0]);
            constructor.addCode(CodeBlock.builder().addStatement("this.$L = $L", new Object[]{fieldTypeName.name(), fieldTypeName.name()}).build());
        });
        return Optional.of(constructor.build());
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName getDependencyOutputsType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Dependency<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dependencyDef) {
        DataAccessSpec dataAccessSpec = dependencyDef.dataAccessSpec();
        if (dataAccessSpec instanceof VajramID) {
            VajramID vajramID = (VajramID)dataAccessSpec;
            if (dependencyDef.canFanout()) {
                String depVajramClass = (String)vajramID.className().orElseThrow();
                int lastDotIndex = depVajramClass.lastIndexOf(46);
                String depRequestClass = CodegenUtils.getRequestClassName(depVajramClass.substring(lastDotIndex + 1));
                String depPackageName = depVajramClass.substring(0, lastDotIndex);
                return new TypeAndName((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(DependencyResponse.class), (TypeName[])new TypeName[]{ClassName.get((String)depPackageName, (String)depRequestClass, (String[])new String[0]), VajramCodeGenerator.getTypeName(vajramID.responseType()).typeName()}));
            }
            return VajramCodeGenerator.getTypeName(vajramID.responseType(), List.of(AnnotationSpec.builder(Nullable.class).build()));
        }
        throw new UnsupportedOperationException("Unknown dependency type %s".formatted(dependencyDef.getClass()));
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String codeGenModulatedInputUtil() {
        StringWriter writer = new StringWriter();
        try {
            TypeSpec.Builder inputUtilClass = this.createInputUtilClass();
            VajramInfo vajramFacetsDef = this.vajramInfo;
            String imClassName = CodegenUtils.getInputModulationClassname(this.vajramName);
            String ciClassName = CodegenUtils.getCommonInputsClassname(this.vajramName);
            FromAndTo imFromAndTo = this.fromAndToMethods(vajramFacetsDef.inputs().stream().filter(Input::needsModulation).toList(), ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{imClassName}));
            TypeSpec.Builder inputsNeedingModulation = TypeSpec.classBuilder((String)imClassName).addModifiers(new Modifier[]{Modifier.STATIC}).addSuperinterface(InputValuesAdaptor.class).addAnnotations(VajramCodeGenerator.recordAnnotations()).addMethod(imFromAndTo.to()).addMethod(imFromAndTo.from());
            FromAndTo ciFromAndTo = this.fromAndToMethods(Stream.concat(vajramFacetsDef.inputs().stream().filter(input -> !input.needsModulation()), vajramFacetsDef.dependencies().stream()).toList(), ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{ciClassName}));
            TypeSpec.Builder commonInputs = TypeSpec.classBuilder((String)ciClassName).addModifiers(new Modifier[]{Modifier.STATIC}).addSuperinterface(InputValuesAdaptor.class).addAnnotations(VajramCodeGenerator.recordAnnotations()).addMethod(ciFromAndTo.to()).addMethod(ciFromAndTo.from());
            ClassName imType = ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{imClassName});
            ClassName ciType = ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{ciClassName});
            ArrayList<FieldTypeName> ciFieldsList = new ArrayList<FieldTypeName>();
            ArrayList<FieldTypeName> imFieldsList = new ArrayList<FieldTypeName>();
            vajramFacetsDef.inputs().forEach(inputDef -> {
                String inputJavaName = VajramCodeGenerator.toJavaName(inputDef.name());
                TypeAndName javaType = VajramCodeGenerator.getTypeName(inputDef.type(), List.of(AnnotationSpec.builder(Nullable.class).build()));
                if (inputDef.needsModulation()) {
                    inputsNeedingModulation.addField(javaType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                    inputsNeedingModulation.addMethod(VajramCodeGenerator.getterCodeForInput((VajramInputDefinition)inputDef, inputJavaName, javaType));
                    imFieldsList.add(new FieldTypeName(javaType.typeName(), inputJavaName));
                } else {
                    commonInputs.addField(javaType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                    commonInputs.addMethod(VajramCodeGenerator.getterCodeForInput((VajramInputDefinition)inputDef, inputJavaName, javaType));
                    ciFieldsList.add(new FieldTypeName(javaType.typeName(), inputJavaName));
                }
            });
            vajramFacetsDef.dependencies().forEach(dependencyDef -> {
                TypeAndName typeAndName = VajramCodeGenerator.getDependencyOutputsType(dependencyDef);
                String inputJavaName = VajramCodeGenerator.toJavaName(dependencyDef.name());
                commonInputs.addField(typeAndName.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                commonInputs.addMethod(VajramCodeGenerator.getterCodeForInput((VajramInputDefinition)dependencyDef, inputJavaName, typeAndName));
                ciFieldsList.add(new FieldTypeName(typeAndName.typeName(), inputJavaName));
            });
            this.generateConstructor(ciFieldsList).ifPresent(arg_0 -> ((TypeSpec.Builder)commonInputs).addMethod(arg_0));
            this.generateConstructor(imFieldsList).ifPresent(arg_0 -> ((TypeSpec.Builder)inputsNeedingModulation).addMethod(arg_0));
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(InputsConverter.class), (TypeName[])new TypeName[]{imType, ciType});
            CodeBlock.Builder initializer = CodeBlock.builder().add("$L", new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)parameterizedTypeName).addMethod(MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(UnmodulatedInput.class), (TypeName[])new TypeName[]{imType, ciType})).addParameter(Inputs.class, "inputValues", new Modifier[0]).addStatement("return new $T<>($T.from(inputValues),$T.from(inputValues))", new Object[]{UnmodulatedInput.class, imType, ciType}).build()).build()});
            FieldSpec.Builder converter = FieldSpec.builder((TypeName)parameterizedTypeName, (String)"CONVERTER", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC}).initializer(initializer.build());
            JavaFile.builder((String)this.packageName, (TypeSpec)inputUtilClass.addType(inputsNeedingModulation.build()).addType(commonInputs.build()).addField(converter.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized AnnotationSpec> recordAnnotations() {
        return VajramCodeGenerator.annotations(EqualsAndHashCode.class, ToString.class);
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized AnnotationSpec> annotations(Class<?> ... annotations) {
        return Arrays.stream(annotations).map(aClass -> AnnotationSpec.builder((Class)aClass).build()).toList();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeSpec.Builder createInputUtilClass() {
        return TypeSpec.classBuilder((String)CodegenUtils.getInputUtilClassName(this.vajramName)).addModifiers(new Modifier[]{Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeSpec.Builder createVajramImplClass() {
        return TypeSpec.classBuilder((String)CodegenUtils.getVajramImplClassName(this.vajramName)).addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{VajramInputDefinition.class}).annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)"inputDefinitions", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getRequestClassName() {
        return this.requestClassName;
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getPackageName() {
        return this.packageName;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String toJavaName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String inputName) {
        if (!inputName.contains("_")) {
            return inputName;
        }
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, inputName);
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName optional(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName javaType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{javaType});
    }

    private record TypeAndName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName typeName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Type> type) {
        private TypeAndName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName typeName) {
            this(typeName, Optional.empty());
        }
    }

    private record FromAndTo(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec from, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec to) {
    }

    private record FieldTypeName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName typeName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String name) {
    }
}

