/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen;

import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.vajram.Dependency;
import com.flipkart.krystal.vajram.Input;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramDef;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.codegen.FacetFieldTypeVisitor;
import com.flipkart.krystal.vajram.codegen.VajramCodeGenFacade;
import com.flipkart.krystal.vajram.codegen.VajramCodeGenerator;
import com.flipkart.krystal.vajram.codegen.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.utils.CodegenUtils;
import com.flipkart.krystal.vajram.das.DataAccessSpec;
import com.flipkart.krystal.vajram.inputs.Dependency;
import com.flipkart.krystal.vajram.inputs.Input;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.TypeName;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;

@SupportedAnnotationTypes(value={"com.flipkart.krystal.vajram.VajramDef"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@AutoService(value={Processor.class})
public class VajramModelGenProcessor
extends AbstractProcessor {
    @Override
    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean process(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Set<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement> annotations, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized RoundEnvironment roundEnv) {
        List<TypeElement> vajramDefinitions = roundEnv.getElementsAnnotatedWith(VajramDef.class).stream().filter(element -> element.getKind() == ElementKind.CLASS).map(executableElement -> (TypeElement)executableElement).toList();
        this.note("Vajram Defs received by VajramAnnoProcessor: %s".formatted(vajramDefinitions.stream().map(Objects::toString).collect(Collectors.joining(System.lineSeparator(), "[" + System.lineSeparator(), System.lineSeparator() + "]"))));
        for (TypeElement vajramDefinition : vajramDefinitions) {
            VajramInfo vajramInfo;
            String qualifiedVajramClassName = vajramDefinition.getQualifiedName().toString();
            try {
                String packageName = qualifiedVajramClassName.substring(0, qualifiedVajramClassName.lastIndexOf(46));
                String vajramName = qualifiedVajramClassName.substring(qualifiedVajramClassName.lastIndexOf(46) + 1);
                File vajramInputFile = new File(this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, packageName, vajramName + ".vajram.yaml").toUri());
                vajramInfo = VajramCodeGenFacade.toVajramInfo(vajramInputFile, vajramName, packageName);
                this.note("Found .vajram.yaml file: %s. Falling back to yaml based model generation".formatted(vajramInputFile));
            }
            catch (IOException ignored) {
                vajramInfo = null;
            }
            if (vajramInfo == null) {
                this.note("Did not find .vajram.yaml file. Will use annotated fields to generate models");
                List<? extends Element> enclosedElements = vajramDefinition.getEnclosedElements();
                List<VariableElement> fields = ElementFilter.fieldsIn(enclosedElements);
                List<VariableElement> inputFields = fields.stream().filter(variableElement -> variableElement.getAnnotation(Input.class) != null).toList();
                List<VariableElement> dependencyFields = fields.stream().filter(variableElement -> variableElement.getAnnotation(Dependency.class) != null).toList();
                PackageElement enclosingElement = (PackageElement)vajramDefinition.getEnclosingElement();
                String packageName = enclosingElement.getQualifiedName().toString();
                vajramInfo = new VajramInfo(vajramDefinition.getSimpleName().toString(), packageName, (ImmutableList)inputFields.stream().map(inputField -> {
                    Input.InputBuilder inputBuilder = com.flipkart.krystal.vajram.inputs.Input.builder();
                    inputBuilder.name(inputField.getSimpleName().toString());
                    inputBuilder.isMandatory(!FacetFieldTypeVisitor.isOptional(inputField.asType(), this.processingEnv));
                    DataType dataType = (DataType)inputField.asType().accept(new FacetFieldTypeVisitor(this.processingEnv, true, (Element)inputField), null);
                    inputBuilder.type(dataType);
                    inputBuilder.needsModulation(inputField.getAnnotation(Input.class).modulated());
                    return inputBuilder.build();
                }).collect(ImmutableList.toImmutableList()), (ImmutableList)dependencyFields.stream().map(inputField -> {
                    Dependency.DependencyBuilder depBuilder = com.flipkart.krystal.vajram.inputs.Dependency.builder();
                    depBuilder.name(inputField.getSimpleName().toString());
                    depBuilder.isMandatory(!FacetFieldTypeVisitor.isOptional(inputField.asType(), this.processingEnv));
                    DataType dataType = (DataType)inputField.asType().accept(new FacetFieldTypeVisitor(this.processingEnv, true, (Element)inputField), null);
                    Dependency dependency = inputField.getAnnotation(Dependency.class);
                    Dependency.DependencyType type = dependency.type();
                    if (!Dependency.DependencyType.VAJRAM.equals((Object)type)) {
                        throw new UnsupportedOperationException("Unknown dependency type '%s'".formatted(type));
                    }
                    depBuilder.dataAccessSpec((DataAccessSpec)VajramID.vajramID((String)dependency.value(), (DataType)dataType)).canFanout(dependency.canFanout());
                    return depBuilder.build();
                }).collect(ImmutableList.toImmutableList()), this.getResponseType(vajramDefinition));
                this.note("VajramInfo: %s".formatted(vajramInfo));
            }
            VajramCodeGenerator vajramCodeGenerator = new VajramCodeGenerator(vajramInfo, Map.of());
            this.generateSourceFile(vajramCodeGenerator.getPackageName() + "." + vajramCodeGenerator.getRequestClassName(), vajramCodeGenerator.codeGenVajramRequest(), vajramDefinition);
            this.generateSourceFile(vajramCodeGenerator.getPackageName() + "." + CodegenUtils.getInputUtilClassName(vajramCodeGenerator.getVajramName()), vajramCodeGenerator.codeGenInputUtil(), vajramDefinition);
        }
        return true;
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName getResponseType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement vajramDef) {
        List<TypeMirror> currentTypes = List.of(vajramDef.asType());
        this.note("VajramDef: %s".formatted(vajramDef));
        Types typeUtils = this.processingEnv.getTypeUtils();
        DeclaredType vajramInterface = null;
        do {
            ArrayList<TypeMirror> newSuperTypes = new ArrayList<TypeMirror>();
            for (TypeMirror currentType : currentTypes) {
                List<DeclaredType> superTypes = this.processingEnv.getTypeUtils().directSupertypes(currentType).stream().filter(t -> t instanceof DeclaredType).map(t -> (DeclaredType)t).toList();
                newSuperTypes.addAll(superTypes);
                for (DeclaredType superType : superTypes) {
                    this.note("SuperType: %s [%s]".formatted(superType, superType.getClass()));
                    Element element = typeUtils.asElement(superType);
                    if (!(element instanceof TypeElement)) continue;
                    TypeElement typeElement = (TypeElement)element;
                    this.note("Element qualified name: %s".formatted(typeElement.getQualifiedName()));
                    if (!typeElement.getQualifiedName().contentEquals(Vajram.class.getName())) continue;
                    vajramInterface = superType;
                    break;
                }
                this.note("CurrentElement: %s".formatted(currentType));
            }
            if (vajramInterface != null) continue;
            currentTypes = newSuperTypes;
        } while (!currentTypes.isEmpty() && vajramInterface == null);
        if (vajramInterface != null) {
            List<? extends TypeMirror> typeParameters = vajramInterface.getTypeArguments();
            if (typeParameters.size() == 1) {
                return TypeName.get((TypeMirror)typeParameters.get(0));
            }
            this.log(Diagnostic.Kind.ERROR, "Incorrect number of parameter types on Vajram interface. Expected 1, Found %s".formatted(typeParameters), vajramDef);
        }
        this.log(Diagnostic.Kind.ERROR, "Unable to infer response type for Vajram", vajramDef);
        throw new RuntimeException();
    }

    private void generateSourceFile(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String className, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String code, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement vajramDefinition) {
        try {
            JavaFileObject requestFile = this.processingEnv.getFiler().createSourceFile(className, vajramDefinition);
            this.note("Successfully Create source file %s".formatted(className));
            try (PrintWriter out = new PrintWriter(requestFile.openWriter());){
                out.println(code);
            }
        }
        catch (Exception e) {
            this.log(Diagnostic.Kind.WARNING, "Error creating java file for className: %s. Error: %s".formatted(className, e), vajramDefinition);
        }
    }

    private void note(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CharSequence message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
    }

    private void log( @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Diagnostic.Kind kind, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String message, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement element) {
        this.processingEnv.getMessager().printMessage(kind, message, element);
    }
}

