/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.gen.caramel;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.value.qual.UnknownVal;

public class CaramelCodeGenerator {
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement payloadDefinitionIface;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ProcessingEnvironment processingEnv;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String payloadImplClassName;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized PackageElement payloadPackage;

    public CaramelCodeGenerator(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement payloadDefinitionIface, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String payloadImplClassName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ProcessingEnvironment processingEnv) {
        if (payloadDefinitionIface.getNestingKind().isNested()) {
            throw new IllegalArgumentException("Payload definition class cannot be nested");
        }
        this.payloadDefinitionIface = payloadDefinitionIface;
        this.processingEnv = processingEnv;
        this.payloadImplClassName = payloadImplClassName;
        this.payloadPackage = (PackageElement)payloadDefinitionIface.getEnclosingElement();
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String> getPayloadImplClassName() {
        return Optional.ofNullable(this.payloadImplClassName);
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getPayloadImplPackageName() {
        return this.payloadPackage.getQualifiedName().toString();
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String generatePayloadImpl() throws @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized IOException {
        Set executableElements = ElementFilter.methodsIn(Set.of(this.payloadDefinitionIface)).stream().filter(executableElement -> executableElement.getParameters().isEmpty()).collect(Collectors.toSet());
        StringWriter writer = new StringWriter();
        TypeSpec.Builder payloadImplClass = TypeSpec.classBuilder((String)this.payloadImplClassName).addModifiers(new Modifier[]{Modifier.FINAL});
        JavaFile.builder((String)this.payloadPackage.getQualifiedName().toString(), (TypeSpec)payloadImplClass.build()).build().writeTo((Appendable)writer);
        return writer.toString();
    }
}

