/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen;

import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.datatypes.CustomType;
import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.utils.SkippedExecutionException;
import com.flipkart.krystal.vajram.DependencyResponse;
import com.flipkart.krystal.vajram.IOVajram;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.VajramRequest;
import com.flipkart.krystal.vajram.codegen.CodegenUtils;
import com.flipkart.krystal.vajram.codegen.models.DependencyModel;
import com.flipkart.krystal.vajram.codegen.models.FacetGenModel;
import com.flipkart.krystal.vajram.codegen.models.InputModel;
import com.flipkart.krystal.vajram.codegen.models.ParsedVajramData;
import com.flipkart.krystal.vajram.codegen.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.models.VajramInfoLite;
import com.flipkart.krystal.vajram.exception.VajramValidationException;
import com.flipkart.krystal.vajram.inputs.Dependency;
import com.flipkart.krystal.vajram.inputs.DependencyCommand;
import com.flipkart.krystal.vajram.inputs.Input;
import com.flipkart.krystal.vajram.inputs.InputSource;
import com.flipkart.krystal.vajram.inputs.InputValuesAdaptor;
import com.flipkart.krystal.vajram.inputs.MultiExecute;
import com.flipkart.krystal.vajram.inputs.SingleExecute;
import com.flipkart.krystal.vajram.inputs.Using;
import com.flipkart.krystal.vajram.inputs.VajramDepFanoutTypeSpec;
import com.flipkart.krystal.vajram.inputs.VajramDepSingleTypeSpec;
import com.flipkart.krystal.vajram.inputs.VajramFacetDefinition;
import com.flipkart.krystal.vajram.inputs.VajramFacetSpec;
import com.flipkart.krystal.vajram.inputs.resolution.Resolve;
import com.flipkart.krystal.vajram.modulation.InputsConverter;
import com.flipkart.krystal.vajram.modulation.ModulatedInput;
import com.flipkart.krystal.vajram.modulation.UnmodulatedInput;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VajramCodeGenerator {
    private static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(VajramCodeGenerator.class);
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String packageName;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ProcessingEnvironment processingEnv;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String requestClassName;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfo vajramInfo;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramID, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfoLite> vajramDefs;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized FacetGenModel> facetModels;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean needsModulation;
    private @MonotonicNonNull @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Initialized ParsedVajramData parsedVajramData;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CodegenUtils util;

    public VajramCodeGenerator(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfo vajramInfo, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramID, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfoLite> vajramDefs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ProcessingEnvironment processingEnv) {
        this.vajramInfo = vajramInfo;
        this.vajramName = vajramInfo.vajramId().vajramId();
        this.packageName = vajramInfo.packageName();
        this.processingEnv = processingEnv;
        this.util = new CodegenUtils(processingEnv);
        this.requestClassName = CodegenUtils.getRequestClassName(this.vajramName);
        this.vajramDefs = Collections.unmodifiableMap(vajramDefs);
        this.facetModels = vajramInfo.facetStream().collect(Collectors.toMap(FacetGenModel::name, Function.identity(), (o1, o2) -> o1, LinkedHashMap::new));
        this.needsModulation = vajramInfo.inputs().stream().anyMatch(InputModel::needsModulation);
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getVajramName() {
        return this.vajramName;
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String codeGenVajramImpl() {
        this.initParsedVajramData();
        TypeSpec.Builder vajramImplClass = this.createVajramImplClass();
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        vajramImplClass.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass(ClassName.get((TypeElement)this.vajramInfo.vajramClass()).box()).build();
        HashMap<String, List> resolverMap = new HashMap<String, List>();
        for (ExecutableElement resolver : this.getParsedVajramData().resolvers()) {
            String key = ((Resolve)Preconditions.checkNotNull((Object)resolver.getAnnotation(Resolve.class))).depName();
            resolverMap.computeIfAbsent(key, _k -> new ArrayList()).add(resolver);
        }
        Map<String, Boolean> depFanoutMap = this.vajramInfo.dependencies().stream().collect(Collectors.toMap(DependencyModel::name, DependencyModel::canFanout));
        ClassName inputsNeedingModulation = ClassName.get((String)this.getParsedVajramData().packageName(), (String)CodegenUtils.getInputUtilClassName(this.getParsedVajramData().vajramName()), (String[])new String[]{CodegenUtils.getInputModulationClassname(this.vajramName)});
        ClassName commonInputs = ClassName.get((String)this.getParsedVajramData().packageName(), (String)CodegenUtils.getInputUtilClassName(this.getParsedVajramData().vajramName()), (String[])new String[]{CodegenUtils.getCommonInputsClassname(this.vajramName)});
        TypeName vajramResponseType = this.util.toTypeName(this.getParsedVajramData().responseType());
        MethodSpec inputDefinitionsMethod = this.createInputDefinitions();
        methodSpecs.add(inputDefinitionsMethod);
        Optional<MethodSpec> inputResolverMethod = this.createResolvers(resolverMap, depFanoutMap);
        inputResolverMethod.ifPresent(methodSpecs::add);
        if (this.util.isRawAssignable(this.getParsedVajramData().vajramClass().asType(), IOVajram.class)) {
            methodSpecs.add(this.createIOVajramExecuteMethod(inputsNeedingModulation, commonInputs, vajramResponseType.annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()})));
        } else {
            methodSpecs.add(this.createComputeVajramExecuteMethod(vajramResponseType, inputsNeedingModulation, commonInputs));
        }
        if (this.needsModulation) {
            methodSpecs.add(this.createInputConvertersMethod(inputsNeedingModulation, commonInputs));
        }
        StringWriter writer = new StringWriter();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)vajramImplClass.addMethods(methodSpecs).build()).indent("  ").build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private @NonNull @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Initialized ParsedVajramData initParsedVajramData() {
        if (this.parsedVajramData == null) {
            this.parsedVajramData = ParsedVajramData.fromVajram(this.vajramInfo).orElseThrow(() -> new VajramValidationException("Could not load Vajram class for vajram %s.\nParsedVajram Data should never be accessed in model generation phase.".formatted(this.vajramInfo.vajramId())));
        }
        return this.parsedVajramData;
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ParsedVajramData getParsedVajramData() {
        return Optional.ofNullable(this.parsedVajramData).orElseGet(this::initParsedVajramData);
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String> getResolverSources(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement resolve) {
        return (ImmutableSet)resolve.getParameters().stream().filter(parameter -> ((Using[])parameter.getAnnotationsByType(Using.class)).length > 0).map(parameter -> parameter.getAnnotation(Using.class)).map(Using::value).collect(ImmutableSet.toImmutableSet());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec createComputeVajramExecuteMethod(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName vajramResponseType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName inputsNeedingModulation, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName commonInputs) {
        MethodSpec.Builder executeBuilder = MethodSpec.methodBuilder((String)"executeCompute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{Inputs.class}), "inputsList", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableMap.class), (TypeName[])new TypeName[]{ClassName.get(Inputs.class), ParameterizedTypeName.get((ClassName)ClassName.get(ValueOrError.class), (TypeName[])new TypeName[]{vajramResponseType.box()})})).addAnnotation(Override.class);
        if (this.needsModulation) {
            CodeBlock.Builder codeBuilder = CodeBlock.builder();
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put("inputs", ClassName.get(Inputs.class));
            valueMap.put("unmodInput", ClassName.get(UnmodulatedInput.class));
            valueMap.put("inputModulation", inputsNeedingModulation);
            valueMap.put("commonInput", commonInputs);
            valueMap.put("returnType", vajramResponseType.box());
            valueMap.put("vajramLogicMethod", this.getParsedVajramData().outputLogic().getSimpleName());
            valueMap.put("modInput", ClassName.get(ModulatedInput.class));
            valueMap.put("imMap", ClassName.get(ImmutableMap.class));
            valueMap.put("imList", ClassName.get(ImmutableList.class));
            valueMap.put("hashMap", ClassName.get(HashMap.class));
            valueMap.put("arrayList", ClassName.get(ArrayList.class));
            valueMap.put("comFuture", ClassName.get(CompletableFuture.class));
            valueMap.put("linkHashMap", ClassName.get(LinkedHashMap.class));
            valueMap.put("map", ClassName.get(Map.class));
            valueMap.put("list", ClassName.get(List.class));
            valueMap.put("valErr", ValueOrError.class);
            valueMap.put("function", ClassName.get(Function.class));
            valueMap.put("optional", ClassName.get(Optional.class));
            TypeMirror returnType = this.getParsedVajramData().outputLogic().getReturnType();
            Preconditions.checkState((boolean)this.util.isRawAssignable(returnType, Map.class), (String)"Any vajram supporting input modulation must return map. Vajram: %s", (Object)this.vajramName);
            TypeMirror mapValue = CodegenUtils.getTypeParameters(returnType).get(1);
            if (this.util.isRawAssignable(mapValue, CompletableFuture.class)) {
                codeBuilder.addNamed("    $map:T<$inputModulation:T, $inputs:T> mapping = new $hashMap:T<>();\n    $commonInput:T commonInputs = null;\n    for ($inputs:T inputs : inputsList) {\n      $unmodInput:T<$inputModulation:T, $commonInput:T> allInputs =\n          getInputsConvertor().apply(inputs);\n      commonInputs = allInputs.commonInputs();\n      $inputModulation:T im = allInputs.inputsNeedingModulation();\n      mapping.put(im, inputs);\n    }\n    $map:T<$inputs:T, $comFuture:T<$returnType:T>> returnValue = new $linkHashMap:T<>();\n\n    if (commonInputs != null) {\n      var results = $vajramLogicMethod:L(new $modInput:T<>($imList:T.copyOf(mapping.keySet()), commonInputs));\n      results.forEach((im, future) -> returnValue.put(\n            $optional:T.ofNullable(mapping.get(im)).orElseThrow(),\n            future.<$returnType:T>thenApply($function:T.identity())));\n    }\n    return $imMap:T.copyOf(returnValue);\n", valueMap);
            } else {
                codeBuilder.addNamed("    $map:T<$inputModulation:T, $inputs:T> mapping = new $hashMap:T<>();\n    $commonInput:T commonInputs = null;\n    for ($inputs:T inputs : inputsList) {\n      $unmodInput:T<$inputModulation:T, $commonInput:T> allInputs =\n          getInputsConvertor().apply(inputs);\n      commonInputs = allInputs.commonInputs();\n      $inputModulation:T im = allInputs.inputsNeedingModulation();\n      mapping.put(im, inputs);\n    }\n    $map:T<$inputs:T, $valErr:T<$returnType:T>> returnValue = new $linkHashMap:T<>();\n\n    if (commonInputs != null) {\n      var results = $vajramLogicMethod:L(new $modInput:T<>($imList:T.copyOf(mapping.keySet()), commonInputs));\n      results.forEach((im, value) -> returnValue.put(\n           $optional:T.ofNullable(mapping.get(im)).orElseThrow(),\n           $valErr:T.withValue(value)));\n    }\n    return $imMap:T.copyOf(returnValue);\n", valueMap);
            }
            executeBuilder.addCode(codeBuilder.build());
        } else {
            this.nonModulatedComputeMethodBuilder(executeBuilder, false);
        }
        return executeBuilder.build();
    }

    private void nonModulatedComputeMethodBuilder(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec.Builder executeBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean isIOVajram) {
        CodeBlock.Builder returnBuilder = CodeBlock.builder().add("return inputsList.stream().collect(\n     $T.toImmutableMap($T.identity(),\n     element -> {\n", new Object[]{ImmutableMap.class, Function.class});
        ArrayList inputCodeBlocks = new ArrayList();
        this.facetModels.values().forEach(inputDef -> {
            if (inputDef instanceof DependencyModel) {
                DependencyModel dependencyModel = (DependencyModel)inputDef;
                VajramID depVajramId = dependencyModel.depVajramId();
                String depRequestClass = dependencyModel.depReqClassName();
                VajramInfoLite depVajramInfo = (VajramInfoLite)Preconditions.checkNotNull((Object)this.vajramDefs.get(depVajramId), (String)"Could not find ParsedVajramData for %s", (Object)depVajramId);
                TypeName boxedResponseType = this.util.toTypeName(depVajramInfo.responseType()).box();
                String variableName = VajramCodeGenerator.toJavaName(inputDef.name());
                String depVariableName = variableName + "Responses";
                if (dependencyModel.canFanout()) {
                    CodeBlock.Builder codeBlock = CodeBlock.builder();
                    codeBlock.addNamed("$depResp:T<$request:T, $response:T> $depResponse:L =\n     new $depResp:T<>(\n         element.<$response:T>getDepValue($variable:S).values().entrySet().stream()\n             .filter(\n                 e ->\n                     e.getValue()\n                         .error()\n                         .filter(t -> t instanceof $skippedException:T)\n                         .isEmpty())\n             .collect(\n                 $imMap:T.toImmutableMap(\n                     e -> $request:T.from(e.getKey()), java.util.Map.Entry::getValue)));\n", (Map)ImmutableMap.of((Object)"depResp", DependencyResponse.class, (Object)"request", (Object)VajramCodeGenerator.toClassName(depRequestClass), (Object)"response", (Object)boxedResponseType, (Object)"variable", (Object)inputDef.name(), (Object)"depResponse", (Object)depVariableName, (Object)"imMap", ImmutableMap.class, (Object)"skippedException", SkippedExecutionException.class));
                    inputCodeBlocks.add(CodeBlock.builder().add(depVariableName, new Object[0]).build());
                    returnBuilder.add(codeBlock.build());
                } else if (dependencyModel.isMandatory()) {
                    inputCodeBlocks.add(CodeBlock.builder().addNamed("element.<$response:T>getDepValue($variable:S)\n    .values()\n    .entrySet()\n    .iterator()\n    .next()\n    .getValue()\n    .getValueOrThrow()\n    .orElseThrow(() -> new $illegalArgument:T(\"Missing mandatory dependency '$variable:L' in vajram '$vajram:L'\"))", (Map)ImmutableMap.of((Object)"response", (Object)boxedResponseType, (Object)"variable", (Object)inputDef.name(), (Object)"illegalArgument", IllegalArgumentException.class, (Object)"vajram", (Object)this.vajramName)).build());
                } else {
                    inputCodeBlocks.add(CodeBlock.builder().addNamed("element.<$response:T>getDepValue($variable:S)\n    .values()\n    .entrySet()\n    .iterator()\n    .next()\n    .getValue()\n    .value()\n    .orElse(null)", (Map)ImmutableMap.of((Object)"response", (Object)boxedResponseType, (Object)"variable", (Object)inputDef.name())).build());
                }
            } else if (inputDef.isMandatory()) {
                inputCodeBlocks.add(CodeBlock.builder().add("element.getInputValueOrThrow($S)", new Object[]{inputDef.name()}).build());
            } else {
                inputCodeBlocks.add(CodeBlock.builder().add("element.getInputValueOrDefault($S, null)", new Object[]{inputDef.name()}).build());
            }
        });
        if (isIOVajram) {
            TypeMirror returnType = this.getParsedVajramData().outputLogic().getReturnType();
            if (!this.util.isRawAssignable(returnType, CompletableFuture.class)) {
                throw new VajramValidationException("The VajramLogic of non-modulated IO vajram %s must return a CompletableFuture".formatted(this.vajramName));
            }
            returnBuilder.add("\nreturn ($L(new $T(\n", new Object[]{this.getParsedVajramData().outputLogic().getSimpleName(), ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{CodegenUtils.getAllInputsClassname(this.vajramName)})});
        } else {
            returnBuilder.add("\nreturn $T.valueOrError(() -> $L(new $T(\n", new Object[]{ValueOrError.class, this.getParsedVajramData().outputLogic().getSimpleName(), ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{CodegenUtils.getAllInputsClassname(this.vajramName)})});
        }
        for (int i = 0; i < inputCodeBlocks.size(); ++i) {
            returnBuilder.add("\t\t", new Object[0]);
            returnBuilder.add((CodeBlock)inputCodeBlocks.get(i));
            if (i == inputCodeBlocks.size() - 1) continue;
            returnBuilder.add(",\n", new Object[0]);
        }
        returnBuilder.add(")));\n", new Object[0]);
        returnBuilder.add("}));\n", new Object[0]);
        executeBuilder.addCode(returnBuilder.build());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec createInputConvertersMethod(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName inputsNeedingModulation, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName commonInputs) {
        MethodSpec.Builder inputConvertersBuilder = MethodSpec.methodBuilder((String)"getInputsConvertor").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(InputsConverter.class), (TypeName[])new TypeName[]{inputsNeedingModulation, commonInputs})).addAnnotation(Override.class);
        inputConvertersBuilder.addCode(CodeBlock.builder().addStatement("return $T.CONVERTER", new Object[]{ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[0])}).build());
        return inputConvertersBuilder.build();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec createIOVajramExecuteMethod(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName inputsNeedingModulation, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName commonInputs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName vajramResponseType) {
        MethodSpec.Builder executeMethodBuilder = MethodSpec.methodBuilder((String)"execute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{Inputs.class}), "inputsList", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableMap.class), (TypeName[])new TypeName[]{ClassName.get(Inputs.class), ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{vajramResponseType})})).addAnnotation(Override.class);
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        if (this.needsModulation) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put("inputs", ClassName.get(Inputs.class));
            valueMap.put("unmodInput", ClassName.get(UnmodulatedInput.class));
            valueMap.put("inputModulation", inputsNeedingModulation);
            valueMap.put("commonInput", commonInputs);
            valueMap.put("returnType", vajramResponseType);
            valueMap.put("vajramLogicMethod", this.getParsedVajramData().outputLogic().getSimpleName());
            valueMap.put("modInput", ClassName.get(ModulatedInput.class));
            valueMap.put("imMap", ClassName.get(ImmutableMap.class));
            valueMap.put("imList", ClassName.get(ImmutableList.class));
            valueMap.put("hashMap", ClassName.get(HashMap.class));
            valueMap.put("arrayList", ClassName.get(ArrayList.class));
            valueMap.put("comFuture", ClassName.get(CompletableFuture.class));
            valueMap.put("linkHashMap", ClassName.get(LinkedHashMap.class));
            valueMap.put("map", ClassName.get(Map.class));
            valueMap.put("list", ClassName.get(List.class));
            valueMap.put("valErr", ValueOrError.class);
            valueMap.put("function", ClassName.get(Function.class));
            valueMap.put("optional", ClassName.get(Optional.class));
            TypeMirror returnType = this.getParsedVajramData().outputLogic().getReturnType();
            Preconditions.checkState((boolean)this.util.isRawAssignable(this.processingEnv.getTypeUtils().erasure(returnType), Map.class), (String)"Any vajram supporting input modulation must return map. Vajram: %s", (Object)this.vajramName);
            TypeMirror mapValue = CodegenUtils.getTypeParameters(returnType).get(1);
            if (this.util.isRawAssignable(mapValue, CompletableFuture.class)) {
                codeBuilder.addNamed("    $map:T<$inputModulation:T, $inputs:T> mapping = new $hashMap:T<>();\n    $commonInput:T commonInputs = null;\n    for ($inputs:T inputs : inputsList) {\n      $unmodInput:T<$inputModulation:T, $commonInput:T> allInputs =\n          getInputsConvertor().apply(inputs);\n      commonInputs = allInputs.commonInputs();\n      $inputModulation:T im = allInputs.inputsNeedingModulation();\n      mapping.put(im, inputs);\n    }\n    $map:T<$inputs:T, $comFuture:T<$returnType:T>> returnValue = new $linkHashMap:T<>();\n\n    if (commonInputs != null) {\n      var results = $vajramLogicMethod:L(new $modInput:T<>($imList:T.copyOf(mapping.keySet()), commonInputs));\n      results.forEach((im, future) -> returnValue.put(\n            $optional:T.ofNullable(mapping.get(im)).orElseThrow(),\n            future.<$returnType:T>thenApply($function:T.identity())));\n    }\n    return $imMap:T.copyOf(returnValue);\n", valueMap);
            } else {
                codeBuilder.addNamed("    $map:T<$inputModulation:T, $inputs:T> mapping = new $hashMap:T<>();\n    $commonInput:T commonInputs = null;\n    for ($inputs:T inputs : inputsList) {\n      $unmodInput:T<$inputModulation:T, $commonInput:T> allInputs =\n          getInputsConvertor().apply(inputs);\n      commonInputs = allInputs.commonInputs();\n      $inputModulation:T im = allInputs.inputsNeedingModulation();\n      mapping.put(im, inputs);\n    }\n    $map:T<$inputs:T, $valErr:T<$returnType:T>> returnValue = new $linkHashMap:T<>();\n\n    if (commonInputs != null) {\n      var results = $vajramLogicMethod:L(new $modInput:T<>($imList:T.copyOf(mapping.keySet()), commonInputs));\n      results.forEach((im, value) -> returnValue.put(\n           $optional:T.ofNullable(mapping.get(im)).orElseThrow(),\n           $valErr:T.withValue(value)));\n    }\n    return $imMap:T.copyOf(returnValue);\n", valueMap);
            }
            executeMethodBuilder.addCode(codeBuilder.build());
        } else {
            this.nonModulatedComputeMethodBuilder(executeMethodBuilder, true);
        }
        return executeMethodBuilder.build();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec> createResolvers(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement>> resolverMap, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Boolean> depFanoutMap) {
        String dependency = "dependency";
        MethodSpec.Builder resolveInputsBuilder = MethodSpec.methodBuilder((String)"resolveInputOfDependency").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, dependency, new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get(ImmutableSet.class, (Type[])new Type[]{String.class}), "resolvableInputs", new Modifier[0]).addParameter(Inputs.class, "inputs", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(DependencyCommand.class), (TypeName[])new TypeName[]{ClassName.get(Inputs.class)}));
        if (Objects.nonNull(this.getParsedVajramData())) {
            resolveInputsBuilder.beginControlFlow("switch ($L) ", new Object[]{dependency});
            if (this.getParsedVajramData().resolvers().isEmpty()) {
                return Optional.empty();
            }
            Set<String> resolvedVariables = resolverMap.keySet();
            resolverMap.forEach((variable, methods) -> {
                CodeBlock.Builder caseBuilder = CodeBlock.builder().beginControlFlow("case $S -> ", new Object[]{variable});
                methods.forEach(method -> {
                    AtomicBoolean fanout = new AtomicBoolean(false);
                    method.getParameters().forEach(parameter -> {
                        String bindParamName = ((Using)Preconditions.checkNotNull((Object)parameter.getAnnotation(Using.class))).value();
                        if (!fanout.get() && depFanoutMap.containsKey(bindParamName)) {
                            fanout.set((Boolean)depFanoutMap.get(bindParamName));
                        }
                        if (!this.facetModels.containsKey(bindParamName) && !resolvedVariables.contains(bindParamName)) {
                            throw new VajramValidationException("Parameter binding incorrect for input - " + bindParamName);
                        }
                    });
                    CodeBlock.Builder ifBlockBuilder = this.buildInputResolver((ExecutableElement)method, depFanoutMap, fanout.get());
                    caseBuilder.add(ifBlockBuilder.build());
                });
                caseBuilder.endControlFlow();
                resolveInputsBuilder.addCode(caseBuilder.build());
            });
            resolveInputsBuilder.endControlFlow();
            resolveInputsBuilder.addStatement("throw new $T($S)", new Object[]{ClassName.get(VajramValidationException.class), "Unresolvable dependency"});
        } else {
            resolveInputsBuilder.addStatement("throw new $T($S)", new Object[]{ClassName.get(VajramValidationException.class), "Unresolvable dependency"});
        }
        return Optional.of(resolveInputsBuilder.build());
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CodeBlock.Builder buildInputResolver(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Boolean> depFanoutMap, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean isParamFanoutDependency) {
        Resolve resolve = (Resolve)Preconditions.checkNotNull((Object)method.getAnnotation(Resolve.class), (Object)"Resolver method must have 'Resolve' annotation");
        CharSequence[] inputs = resolve.depInputs();
        String depName = resolve.depName();
        CodeBlock.Builder ifBlockBuilder = CodeBlock.builder();
        ifBlockBuilder.beginControlFlow("if ($T.of($S).equals(resolvableInputs))", new Object[]{Set.class, String.join((CharSequence)",", inputs)});
        method.getParameters().forEach(parameter -> {
            String usingInputName = ((Using)Preconditions.checkNotNull((Object)parameter.getAnnotation(Using.class), (String)"Resolver method params must have 'Using' annotation. Vajram: %s, method %s, param: %s", (Object)this.vajramName, (Object)method.getSimpleName(), (Object)parameter.getSimpleName())).value();
            if (this.facetModels.get(usingInputName) instanceof DependencyModel) {
                this.generateDependencyResolutions(method, usingInputName, ifBlockBuilder, depFanoutMap, (VariableElement)parameter);
                return;
            } else {
                if (!this.facetModels.containsKey(usingInputName)) throw new VajramValidationException("No input resolver found for " + usingInputName);
                FacetGenModel inputDefinition = this.facetModels.get(usingInputName);
                String variable = VajramCodeGenerator.toJavaName(usingInputName);
                TypeName parameterType = TypeName.get((TypeMirror)parameter.asType());
                if (inputDefinition.isMandatory()) {
                    ifBlockBuilder.add(CodeBlock.builder().addStatement("$T $L = $L.getInputValueOrThrow($S)", new Object[]{parameterType, variable, "inputs", usingInputName}).build());
                    return;
                } else {
                    if (!this.util.isRawAssignable(parameter.asType(), Optional.class)) throw new VajramValidationException(String.format("Optional input dependency %s must have type as Optional", usingInputName));
                    ifBlockBuilder.add(CodeBlock.builder().addStatement("$T $L = $L.getInputValueOpt($S)", new Object[]{parameterType, variable, "inputs", usingInputName}).build());
                }
            }
        });
        boolean isFanOut = isParamFanoutDependency || depFanoutMap.getOrDefault(depName, false) != false;
        this.buildFinalResolvers(method, (String[])inputs, ifBlockBuilder, isFanOut);
        ifBlockBuilder.endControlFlow();
        return ifBlockBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateDependencyResolutions(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String usingInputName, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CodeBlock.Builder ifBlockBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Boolean> depFanoutMap, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VariableElement parameter) {
        FacetGenModel vajramInputDef = this.facetModels.get(usingInputName);
        Resolve resolve = (Resolve)Preconditions.checkNotNull((Object)method.getAnnotation(Resolve.class), (Object)"Resolver method cannot be null");
        String resolvedDep = resolve.depName();
        if (depFanoutMap.containsKey(usingInputName) && depFanoutMap.get(usingInputName).booleanValue() && this.util.isRawAssignable(parameter.asType(), DependencyResponse.class)) {
            log.error("Dependency resolution of {} is fanout but the resolver method is not of type DependencyResponse.", (Object)resolvedDep);
            throw new VajramValidationException("Dependency resolution of " + resolvedDep + " is fanout but the resolver method is not of type DependencyResponse");
        }
        if (!(vajramInputDef instanceof DependencyModel)) return;
        DependencyModel dependencyModel = (DependencyModel)vajramInputDef;
        String variableName = VajramCodeGenerator.toJavaName(usingInputName);
        VajramInfoLite vajramInfoLite = (VajramInfoLite)Preconditions.checkNotNull((Object)this.vajramDefs.get(dependencyModel.depVajramId()), (String)"Could not find parsed vajram data for class %s", (Object)dependencyModel.depVajramId());
        String requestClass = dependencyModel.depReqClassName();
        TypeName usingDepType = this.util.toTypeName(vajramInfoLite.responseType());
        if (usingDepType.isBoxedPrimitive()) {
            usingDepType = usingDepType.unbox();
        }
        String resolverName = method.getSimpleName().toString();
        if (this.util.isRawAssignable(parameter.asType(), DependencyResponse.class)) {
            String depValueAccessorCode = "$1T $2L =\n new $3T<>(inputs.<$4T>getDepValue($5S)\n      .values().entrySet().stream()\n      .collect($6T.toImmutableMap(e -> $7T.from(e.getKey()),\n      $8T::getValue)))";
            ifBlockBuilder.addStatement(depValueAccessorCode, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(DependencyResponse.class), (TypeName[])new TypeName[]{VajramCodeGenerator.toClassName(requestClass), usingDepType}), variableName, DependencyResponse.class, usingDepType, usingInputName, ImmutableMap.class, VajramCodeGenerator.toClassName(requestClass), ClassName.get(Map.Entry.class)});
            return;
        } else {
            String depValueAccessorCode = "$1T $2L =\n  inputs.<$3T>getDepValue($4S)\n     .values()\n     .entrySet()\n     .iterator()\n     .next()\n     .getValue()";
            if (usingDepType.equals((Object)TypeName.get((TypeMirror)parameter.asType()))) {
                if (!vajramInputDef.isMandatory()) throw new VajramValidationException("A resolver ('%s') must not access an optional dependency ('%s') directly.Use Optional<>, ValueOrError<>, or DependencyResponse<> instead".formatted(resolverName, usingInputName));
                String code = depValueAccessorCode + ".getValueOrThrow().orElseThrow(() ->\n    new $5T(\"Received null value for mandatory dependency '$6L' of vajram '$7L'\"))";
                ifBlockBuilder.addStatement(code, new Object[]{usingDepType, variableName, usingDepType, usingInputName, IllegalArgumentException.class, usingInputName, this.vajramName});
                return;
            } else if (this.util.isRawAssignable(parameter.asType(), ValueOrError.class)) {
                ifBlockBuilder.addStatement(depValueAccessorCode, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(ValueOrError.class), (TypeName[])new TypeName[]{usingDepType}), variableName, usingDepType, usingInputName});
                return;
            } else {
                if (!this.util.isRawAssignable(parameter.asType(), Optional.class)) throw new VajramValidationException("Unrecognized parameter type %s in resolver %s of vajram %s".formatted(parameter.asType(), resolverName, this.vajramName));
                String code = depValueAccessorCode + ".value()";
                ifBlockBuilder.addStatement(code, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{usingDepType}), variableName, usingDepType, usingInputName});
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildFinalResolvers(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized [] inputs, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CodeBlock.Builder ifBlockBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean isFanOut) {
        TypeMirror returnType;
        String variableName = "resolverResult";
        boolean controlFLowStarted = false;
        TypeName methodReturnType = TypeName.get((TypeMirror)method.getReturnType());
        ifBlockBuilder.add("$T $L = $L(", new Object[]{methodReturnType, variableName, method.getSimpleName()});
        ImmutableList resolverSources = VajramCodeGenerator.getResolverSources(method).asList();
        for (int i = 0; i < resolverSources.size(); ++i) {
            String bindName = (String)resolverSources.get(i);
            ifBlockBuilder.add("$L", new Object[]{VajramCodeGenerator.toJavaName(bindName)});
            if (i == method.getParameters().size() - 1) continue;
            ifBlockBuilder.add(", ", new Object[0]);
        }
        ifBlockBuilder.add(");\n", new Object[0]);
        if (this.util.isRawAssignable(method.getReturnType(), DependencyCommand.class)) {
            ifBlockBuilder.beginControlFlow("if($L.shouldSkip())", new Object[]{variableName});
            ifBlockBuilder.addStatement("\t return $T.skipExecution($L.doc())", new Object[]{SingleExecute.class, variableName});
            ifBlockBuilder.add("} else {\n\t", new Object[0]);
            controlFLowStarted = true;
        }
        if (this.util.isRawAssignable(returnType = this.util.box(method.getReturnType()), MultiExecute.class)) {
            code = "return $T.executeFanoutWith(\n    $L.inputs().stream()\n        .map(\n            element ->\n                new $T(\n                    $T.of($S, $T.withValue(element))))\n    .toList())";
            ifBlockBuilder.addStatement(code, new Object[]{MultiExecute.class, variableName, Inputs.class, ImmutableMap.class, inputs[0], ValueOrError.class});
        } else if (isFanOut) {
            if (!this.util.isRawAssignable(returnType, Iterable.class)) throw new VajramValidationException("Incorrect vajram resolver " + this.vajramName + ": Fanout resolvers must return an iterable");
            if (this.util.isRawAssignable(CodegenUtils.getTypeParameters(returnType).get(0), VajramRequest.class)) {
                code = "return $T.executeFanoutWith(\n    $L.stream()\n        .map(\n            element ->\n                element.toInputValues()))\n    .toList())";
                ifBlockBuilder.addStatement(code, new Object[]{MultiExecute.class, variableName});
            } else {
                code = "return $T.executeFanoutWith(\n    $L.stream()\n        .map(\n            element ->\n                new $T(\n                    $T.of($S, $T.withValue(element))))\n    .toList())";
                ifBlockBuilder.addStatement(code, new Object[]{MultiExecute.class, variableName, Inputs.class, ImmutableMap.class, inputs[0], ValueOrError.class});
            }
        } else if (this.util.isRawAssignable(returnType, VajramRequest.class)) {
            ifBlockBuilder.addStatement("return $T.executeWith($L.toInputValues())", new Object[]{SingleExecute.class, variableName});
        } else if (this.util.isRawAssignable(returnType, SingleExecute.class)) {
            ifBlockBuilder.addStatement("  return $T.executeWith(new Inputs(\n   $T.of($S, $T.withValue(\n      $L.inputs().iterator().next().orElse(null)))))\n", new Object[]{SingleExecute.class, ImmutableMap.class, inputs[0], ValueOrError.class, variableName});
        } else {
            ifBlockBuilder.addStatement("return $T.executeWith(new Inputs(\n $T.of($S, $T.withValue($L))))", new Object[]{SingleExecute.class, ImmutableMap.class, inputs[0], ValueOrError.class, variableName});
        }
        if (!controlFLowStarted) return;
        ifBlockBuilder.endControlFlow();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec createInputDefinitions() {
        MethodSpec.Builder inputDefinitionsBuilder = MethodSpec.methodBuilder((String)"getInputDefinitions").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{VajramFacetDefinition.class}));
        List<FacetGenModel> inputDefinitions = this.vajramInfo.facetStream().toList();
        ArrayList codeBlocks = new ArrayList(inputDefinitions.size());
        inputDefinitions.forEach(vajramInputDefinition -> {
            CodeBlock.Builder inputDefBuilder = CodeBlock.builder();
            if (vajramInputDefinition instanceof InputModel) {
                InputModel input = (InputModel)vajramInputDefinition;
                this.buildVajramInput(inputDefBuilder, input);
            } else if (vajramInputDefinition instanceof DependencyModel) {
                DependencyModel dependency = (DependencyModel)vajramInputDefinition;
                VajramCodeGenerator.buildVajramDependency(inputDefBuilder, dependency);
            }
            codeBlocks.add(inputDefBuilder.build());
        });
        inputDefinitionsBuilder.beginControlFlow("if(this.$L == null)", new Object[]{"inputDefinitions"});
        inputDefinitionsBuilder.addCode(CodeBlock.builder().add("this.$L = $T.of(\n", new Object[]{"inputDefinitions", ImmutableList.class}).add(CodeBlock.join(codeBlocks, (String)",\n\t")).add("\n);\n", new Object[0]).build());
        inputDefinitionsBuilder.endControlFlow();
        inputDefinitionsBuilder.addStatement("return $L", new Object[]{"inputDefinitions"});
        return inputDefinitionsBuilder.build();
    }

    private static void buildVajramDependency(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CodeBlock.Builder inputDefBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DependencyModel dependency) {
        inputDefBuilder.add("$T.builder()", new Object[]{ClassName.get(Dependency.class)}).add(".name($S)", new Object[]{dependency.name()});
        String code = ".dataAccessSpec($1T.vajramID($2S))";
        inputDefBuilder.add(code, new Object[]{ClassName.get(VajramID.class), dependency.depVajramId().vajramId()});
        inputDefBuilder.add(".isMandatory($L)", new Object[]{dependency.isMandatory()});
        inputDefBuilder.add(".build()", new Object[0]);
    }

    private void buildVajramInput(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CodeBlock.Builder inputDefBuilder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized InputModel<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> input) {
        inputDefBuilder.add("$T.builder()", new Object[]{ClassName.get(Input.class)}).add(".name($S)", new Object[]{input.name()});
        ImmutableSet<InputSource> inputSources = input.sources();
        if (!inputSources.isEmpty()) {
            inputDefBuilder.add(".sources(", new Object[0]);
            String sources = inputSources.stream().map(inputSource -> {
                if (inputSource == InputSource.CLIENT) {
                    return "$inputSrc:T.CLIENT";
                }
                if (inputSource == InputSource.SESSION) {
                    return "$inputSrc:T.SESSION";
                }
                throw new IllegalArgumentException("Incorrect source defined in vajram config");
            }).collect(Collectors.joining(","));
            inputDefBuilder.addNamed(sources, (Map)ImmutableMap.of((Object)"inputSrc", InputSource.class)).add(")", new Object[0]);
        }
        DataType<?> inputType = input.type();
        inputDefBuilder.add(".type(", new Object[0]);
        if (inputType instanceof CustomType) {
            TypeName className;
            CustomType javaType = (CustomType)inputType;
            if (!javaType.enclosingClasses().isEmpty() || javaType.simpleName().isPresent()) {
                assert (javaType.packageName().isPresent());
                className = ClassName.get((String)((String)javaType.packageName().get()), (String)String.join((CharSequence)".", (Iterable<? extends CharSequence>)javaType.enclosingClasses()), (String[])new String[]{(String)javaType.simpleName().get()});
            } else {
                className = TypeName.get((TypeMirror)javaType.javaModelType(this.processingEnv));
            }
            inputDefBuilder.add("$1T.create($2T.class)", new Object[]{ClassName.get(CustomType.class), className});
        } else {
            TypeAndName typeName;
            String simpleName = inputType.getClass().getSimpleName();
            String name = simpleName.substring(0, simpleName.length() - 4).toLowerCase();
            if (simpleName.toLowerCase().contains("boolean")) {
                name = "bool";
            }
            if (ParameterizedTypeName.class.isAssignableFrom((typeName = this.getTypeName(inputType)).typeName().getClass())) {
                TypeName innerType = (TypeName)((ParameterizedTypeName)typeName.typeName()).typeArguments.get(0);
                inputDefBuilder.add("$T.$L($T.$L())", new Object[]{ClassName.get((String)inputType.getClass().getPackageName(), (String)simpleName, (String[])new String[0]), name, ClassName.get((String)inputType.getClass().getPackageName(), (String)(((ClassName)innerType).simpleName() + "Type"), (String[])new String[0]), ((ClassName)innerType).simpleName().toLowerCase()});
            } else {
                inputDefBuilder.add("$T.$L()", new Object[]{ClassName.get((String)inputType.getClass().getPackageName(), (String)simpleName, (String[])new String[0]), name});
            }
        }
        inputDefBuilder.add(")", new Object[0]);
        inputDefBuilder.add(".isMandatory($L)", new Object[]{input.isMandatory()});
        inputDefBuilder.add(".needsModulation($L)", new Object[]{input.needsModulation()});
        inputDefBuilder.add(".build()", new Object[0]);
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String codeGenVajramRequest() {
        ImmutableList<InputModel<?>> inputDefs = this.vajramInfo.inputs();
        MethodSpec.Builder requestConstructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
        ClassName builderClassType = ClassName.get((String)(this.packageName + "." + this.requestClassName), (String)"Builder", (String[])new String[0]);
        TypeSpec.Builder requestClass = TypeSpec.classBuilder((String)this.requestClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(VajramRequest.class), (TypeName[])new TypeName[]{this.util.toTypeName(this.vajramInfo.responseType()).box()})).addAnnotation(EqualsAndHashCode.class).addMethod(MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)builderClassType).addStatement("return new Builder()", new Object[0]).build());
        TypeSpec.Builder builderClass = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addAnnotation(EqualsAndHashCode.class).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        LinkedHashSet<String> inputNames = new LinkedHashSet<String>();
        List<FacetGenModel> facets = this.vajramInfo.facetStream().toList();
        ArrayList<FieldSpec.Builder> inputNameFields = new ArrayList<FieldSpec.Builder>(facets.size());
        ArrayList<FieldSpec.Builder> inputSpecFields = new ArrayList<FieldSpec.Builder>(facets.size());
        for (FacetGenModel facet : facets) {
            InputModel input;
            FieldSpec.Builder inputSpecField;
            String facetJavaName = VajramCodeGenerator.toJavaName(facet.name());
            TypeAndName facetType = this.getTypeName(this.getDataType(facet));
            TypeAndName boxedFacetType = this.boxPrimitive(facetType);
            ClassName vajramClassName = ClassName.get((String)this.packageName, (String)this.vajramName, (String[])new String[0]);
            String inputNameFieldName = facetJavaName + "_n";
            FieldSpec.Builder inputNameField = FieldSpec.builder(String.class, (String)inputNameFieldName, (Modifier[])new Modifier[0]).initializer("\"$L\"", new Object[]{facet.name()});
            if (facet instanceof DependencyModel) {
                DependencyModel vajramDepDef = (DependencyModel)facet;
                ClassName specType = ClassName.get(vajramDepDef.canFanout() ? VajramDepFanoutTypeSpec.class : VajramDepSingleTypeSpec.class);
                inputSpecField = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)specType, (TypeName[])new TypeName[]{boxedFacetType.typeName(), vajramClassName}), (String)(facetJavaName + "_s"), (Modifier[])new Modifier[0]).initializer("new $T<>($L, $T.class)", new Object[]{specType, inputNameFieldName, vajramClassName});
            } else {
                inputSpecField = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(VajramFacetSpec.class), (TypeName[])new TypeName[]{boxedFacetType.typeName()}), (String)(facetJavaName + "_s"), (Modifier[])new Modifier[0]).initializer("new $T<>($L)", new Object[]{VajramFacetSpec.class, inputNameFieldName});
            }
            inputNameFields.add(inputNameField.addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL}));
            inputSpecFields.add(inputSpecField.addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL}));
            if (!(facet instanceof InputModel) || !(input = (InputModel)facet).sources().contains((Object)InputSource.CLIENT)) continue;
            inputSpecField.addModifiers(new Modifier[]{Modifier.PUBLIC});
            inputNameField.addModifiers(new Modifier[]{Modifier.PUBLIC});
            inputNames.add(facetJavaName);
            requestClass.addField(FieldSpec.builder((TypeName)boxedFacetType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)facetJavaName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            builderClass.addField(FieldSpec.builder((TypeName)boxedFacetType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)facetJavaName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
            requestConstructor.addParameter(ParameterSpec.builder((TypeName)boxedFacetType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)facetJavaName, (Modifier[])new Modifier[0]).build());
            requestConstructor.addStatement("this.$L = $L", new Object[]{facetJavaName, facetJavaName});
            requestClass.addMethod(this.getterCodeForInput(input, facetJavaName, facetType));
            builderClass.addMethod(MethodSpec.methodBuilder((String)facetJavaName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(boxedFacetType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()})).addStatement("return this.$L", new Object[]{facetJavaName}).build());
            builderClass.addMethod(MethodSpec.methodBuilder((String)facetJavaName).returns((TypeName)builderClassType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)boxedFacetType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)facetJavaName, (Modifier[])new Modifier[0]).build()).addStatement("this.$L = $L", new Object[]{facetJavaName, facetJavaName}).addStatement("return this", new Object[]{facetJavaName}).build());
        }
        requestClass.addFields(inputNameFields.stream().map(FieldSpec.Builder::build)::iterator);
        requestClass.addFields(inputSpecFields.stream().map(FieldSpec.Builder::build)::iterator);
        builderClass.addMethod(MethodSpec.methodBuilder((String)"build").returns((TypeName)ClassName.get((String)this.packageName, (String)this.requestClassName, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return new %s(%s)".formatted(this.requestClassName, String.join((CharSequence)", ", inputNames)), new Object[0]).build());
        StringWriter writer = new StringWriter();
        FromAndTo fromAndTo = this.fromAndToMethods(inputDefs.stream().filter(inputDef -> inputDef.sources().contains((Object)InputSource.CLIENT)).toList(), ClassName.get((String)this.packageName, (String)this.requestClassName, (String[])new String[0]));
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)requestClass.addMethod(requestConstructor.build()).addMethod(fromAndTo.from()).addMethod(fromAndTo.to()).addType(builderClass.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getDataType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized FacetGenModel abstractInput) {
        if (abstractInput instanceof InputModel) {
            InputModel input = (InputModel)abstractInput;
            return input.type();
        }
        if (abstractInput instanceof DependencyModel) {
            DependencyModel dep = (DependencyModel)abstractInput;
            return dep.responseType();
        }
        throw new UnsupportedOperationException("Unable to extract datatype from facet : %s".formatted(abstractInput));
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName boxPrimitive(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName javaType) {
        if (javaType.type().isPresent() && javaType.type().get().getKind().isPrimitive()) {
            TypeMirror boxed = this.processingEnv.getTypeUtils().boxedClass((PrimitiveType)javaType.type().get()).asType();
            return new TypeAndName(TypeName.get((TypeMirror)boxed).annotated(javaType.annotationSpecs()), Optional.of(boxed), javaType.annotationSpecs());
        }
        return javaType;
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName unboxPrimitive(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName javaType) {
        if (javaType.type().isPresent()) {
            PrimitiveType primitiveType;
            try {
                primitiveType = this.processingEnv.getTypeUtils().unboxedType(javaType.type().get());
            }
            catch (IllegalArgumentException ignored) {
                return javaType;
            }
            return new TypeAndName(TypeName.get((TypeMirror)primitiveType), Optional.of(primitiveType), javaType.annotationSpecs());
        }
        return javaType;
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized FromAndTo fromAndToMethods(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized FacetGenModel> inputDefs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName enclosingClass) {
        MethodSpec.Builder toInputValues = MethodSpec.methodBuilder((String)"toInputValues").returns(Inputs.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("$T builder = new $T<>($L)", new Object[]{new TypeToken<Map<String, InputValue<Object>>>(){}.getType(), new TypeToken<HashMap>(){}.getType(), inputDefs.size()});
        MethodSpec.Builder fromInputValues = MethodSpec.methodBuilder((String)"from").returns((TypeName)enclosingClass).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(Inputs.class, "values", new Modifier[0]);
        for (FacetGenModel facetGenModel : inputDefs) {
            String inputJavaName = VajramCodeGenerator.toJavaName(facetGenModel.name());
            toInputValues.addStatement("builder.put($S, $T.withValue(this.$L))", new Object[]{facetGenModel.name(), ValueOrError.class, inputJavaName});
        }
        toInputValues.addStatement("return new $T(builder)", new Object[]{Inputs.class});
        List<String> inputNames = inputDefs.stream().map(FacetGenModel::name).toList();
        fromInputValues.addStatement("return new $T(%s)".formatted(inputNames.stream().map(s -> "values.getInputValueOrDefault($S, null)").collect(Collectors.joining(", "))), Stream.concat(Stream.of(enclosingClass), inputNames.stream()).toArray());
        return new FromAndTo(fromInputValues.build(), toInputValues.build());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName getTypeName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dataType) {
        return this.getTypeName(dataType, List.of());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName getTypeName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dataType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized AnnotationSpec> typeAnnotations) {
        TypeMirror javaModelType = dataType.javaModelType(this.processingEnv);
        return new TypeAndName(TypeName.get((TypeMirror)javaModelType).annotated(typeAnnotations), Optional.of(javaModelType), typeAnnotations);
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec getterCodeForInput(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized FacetGenModel facet, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String name, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName typeAndName) {
        DependencyModel dependencyDef;
        boolean wrapWithOptional = !facet.isMandatory() && (facet instanceof InputModel || facet instanceof DependencyModel && !(dependencyDef = (DependencyModel)facet).canFanout());
        return MethodSpec.methodBuilder((String)name).returns(wrapWithOptional ? VajramCodeGenerator.optional(this.boxPrimitive(typeAndName).typeName().withoutAnnotations()) : this.unboxPrimitive(typeAndName).typeName().withoutAnnotations()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(!wrapWithOptional ? CodeBlock.of((String)"if($L == null) {\n  throw new IllegalStateException(\"The input '$L' is not optional, but has null value. This should not happen\");\n}", (Object[])new Object[]{name, name}) : CodeBlock.builder().build()).addCode(wrapWithOptional ? CodeBlock.builder().addStatement("return $T.ofNullable(this.$L)", new Object[]{Optional.class, name}).build() : CodeBlock.builder().addStatement("return this.$L", new Object[]{name}).build()).build();
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String codeGenInputUtil() {
        boolean doInputsNeedModulation = this.vajramInfo.facetStream().filter(d -> d instanceof InputModel).map(d -> (InputModel)d).anyMatch(InputModel::needsModulation);
        if (doInputsNeedModulation) {
            return this.codeGenModulatedInputUtil();
        }
        return this.codeGenSimpleInputUtil();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String codeGenSimpleInputUtil() {
        TypeSpec.Builder inputUtilClass = this.createInputUtilClass();
        String className = CodegenUtils.getAllInputsClassname(this.vajramName);
        TypeSpec.Builder allInputsClass = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.STATIC}).addAnnotations(VajramCodeGenerator.recordAnnotations());
        ArrayList<FieldTypeName> fieldsList = new ArrayList<FieldTypeName>();
        this.vajramInfo.inputs().forEach(inputDef -> {
            String inputJavaName = VajramCodeGenerator.toJavaName(inputDef.name());
            TypeAndName inputType = this.getTypeName(inputDef.type(), List.of(AnnotationSpec.builder(Nullable.class).build()));
            TypeAndName boxedInputType = this.boxPrimitive(inputType);
            allInputsClass.addField(boxedInputType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            allInputsClass.addMethod(this.getterCodeForInput((FacetGenModel)inputDef, inputJavaName, inputType));
            fieldsList.add(new FieldTypeName(boxedInputType.typeName(), inputJavaName));
        });
        this.vajramInfo.dependencies().forEach(dependencyDef -> {
            String inputJavaName = VajramCodeGenerator.toJavaName(dependencyDef.name());
            TypeAndName depType = this.getDependencyOutputsType((DependencyModel)dependencyDef);
            TypeAndName boxedDepType = this.boxPrimitive(depType);
            allInputsClass.addField(boxedDepType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            allInputsClass.addMethod(this.getterCodeForInput((FacetGenModel)dependencyDef, inputJavaName, depType));
            fieldsList.add(new FieldTypeName(boxedDepType.typeName(), inputJavaName));
        });
        this.generateConstructor(fieldsList).ifPresent(arg_0 -> ((TypeSpec.Builder)allInputsClass).addMethod(arg_0));
        StringWriter writer = new StringWriter();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)inputUtilClass.addType(allInputsClass.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec> generateConstructor(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized FieldTypeName> fieldsList) {
        if (fieldsList.isEmpty()) {
            return Optional.empty();
        }
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder();
        fieldsList.forEach(fieldTypeName -> {
            constructor.addParameter(fieldTypeName.typeName(), fieldTypeName.name(), new Modifier[0]);
            constructor.addCode(CodeBlock.builder().addStatement("this.$L = $L", new Object[]{fieldTypeName.name(), fieldTypeName.name()}).build());
        });
        return Optional.of(constructor.build());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName getDependencyOutputsType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DependencyModel dependencyDef) {
        DataType<?> depResponseType = dependencyDef.responseType();
        if (dependencyDef.canFanout()) {
            return new TypeAndName((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(DependencyResponse.class), (TypeName[])new TypeName[]{VajramCodeGenerator.toClassName(dependencyDef.depReqClassName()), this.boxPrimitive(this.getTypeName(depResponseType)).typeName()}));
        }
        return this.getTypeName(depResponseType, List.of(AnnotationSpec.builder(Nullable.class).build()));
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName toClassName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String depReqClassName) {
        int lastDotIndex = depReqClassName.lastIndexOf(".");
        return ClassName.get((String)depReqClassName.substring(0, lastDotIndex), (String)depReqClassName.substring(lastDotIndex + 1), (String[])new String[0]);
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String codeGenModulatedInputUtil() {
        StringWriter writer = new StringWriter();
        try {
            TypeSpec.Builder inputUtilClass = this.createInputUtilClass();
            VajramInfo vajramFacetsDef = this.vajramInfo;
            String imClassName = CodegenUtils.getInputModulationClassname(this.vajramName);
            String ciClassName = CodegenUtils.getCommonInputsClassname(this.vajramName);
            FromAndTo imFromAndTo = this.fromAndToMethods(vajramFacetsDef.inputs().stream().filter(InputModel::needsModulation).toList(), ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{imClassName}));
            TypeSpec.Builder inputsNeedingModulation = TypeSpec.classBuilder((String)imClassName).addModifiers(new Modifier[]{Modifier.STATIC}).addSuperinterface(InputValuesAdaptor.class).addAnnotations(VajramCodeGenerator.recordAnnotations()).addMethod(imFromAndTo.to()).addMethod(imFromAndTo.from());
            FromAndTo ciFromAndTo = this.fromAndToMethods(Stream.concat(vajramFacetsDef.inputs().stream().filter(input -> !input.needsModulation()), vajramFacetsDef.dependencies().stream()).toList(), ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{ciClassName}));
            TypeSpec.Builder commonInputs = TypeSpec.classBuilder((String)ciClassName).addModifiers(new Modifier[]{Modifier.STATIC}).addSuperinterface(InputValuesAdaptor.class).addAnnotations(VajramCodeGenerator.recordAnnotations()).addMethod(ciFromAndTo.to()).addMethod(ciFromAndTo.from());
            ClassName imType = ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{imClassName});
            ClassName ciType = ClassName.get((String)this.packageName, (String)CodegenUtils.getInputUtilClassName(this.vajramName), (String[])new String[]{ciClassName});
            ArrayList<FieldTypeName> ciFieldsList = new ArrayList<FieldTypeName>();
            ArrayList<FieldTypeName> imFieldsList = new ArrayList<FieldTypeName>();
            vajramFacetsDef.inputs().forEach(inputDef -> {
                String inputJavaName = VajramCodeGenerator.toJavaName(inputDef.name());
                TypeAndName inputType = this.getTypeName(inputDef.type(), List.of(AnnotationSpec.builder(Nullable.class).build()));
                TypeAndName boxedInputType = this.boxPrimitive(inputType);
                if (inputDef.needsModulation()) {
                    inputsNeedingModulation.addField(boxedInputType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                    inputsNeedingModulation.addMethod(this.getterCodeForInput((FacetGenModel)inputDef, inputJavaName, inputType));
                    imFieldsList.add(new FieldTypeName(boxedInputType.typeName(), inputJavaName));
                } else {
                    commonInputs.addField(boxedInputType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                    commonInputs.addMethod(this.getterCodeForInput((FacetGenModel)inputDef, inputJavaName, inputType));
                    ciFieldsList.add(new FieldTypeName(boxedInputType.typeName(), inputJavaName));
                }
            });
            vajramFacetsDef.dependencies().forEach(dependencyDef -> {
                TypeAndName depType = this.getDependencyOutputsType((DependencyModel)dependencyDef);
                String inputJavaName = VajramCodeGenerator.toJavaName(dependencyDef.name());
                TypeAndName boxedDepType = this.boxPrimitive(depType);
                commonInputs.addField(boxedDepType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                commonInputs.addMethod(this.getterCodeForInput((FacetGenModel)dependencyDef, inputJavaName, depType));
                ciFieldsList.add(new FieldTypeName(boxedDepType.typeName(), inputJavaName));
            });
            this.generateConstructor(ciFieldsList).ifPresent(arg_0 -> ((TypeSpec.Builder)commonInputs).addMethod(arg_0));
            this.generateConstructor(imFieldsList).ifPresent(arg_0 -> ((TypeSpec.Builder)inputsNeedingModulation).addMethod(arg_0));
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(InputsConverter.class), (TypeName[])new TypeName[]{imType, ciType});
            CodeBlock.Builder initializer = CodeBlock.builder().add("$L", new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)parameterizedTypeName).addMethod(MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(UnmodulatedInput.class), (TypeName[])new TypeName[]{imType, ciType})).addParameter(Inputs.class, "inputValues", new Modifier[0]).addStatement("return new $T<>($T.from(inputValues),$T.from(inputValues))", new Object[]{UnmodulatedInput.class, imType, ciType}).build()).build()});
            FieldSpec.Builder converter = FieldSpec.builder((TypeName)parameterizedTypeName, (String)"CONVERTER", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC}).initializer(initializer.build());
            JavaFile.builder((String)this.packageName, (TypeSpec)inputUtilClass.addType(inputsNeedingModulation.build()).addType(commonInputs.build()).addField(converter.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized AnnotationSpec> recordAnnotations() {
        return VajramCodeGenerator.annotations(EqualsAndHashCode.class, ToString.class);
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized AnnotationSpec> annotations(Class<?> ... annotations) {
        return Arrays.stream(annotations).map(aClass -> AnnotationSpec.builder((Class)aClass).build()).toList();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeSpec.Builder createInputUtilClass() {
        return TypeSpec.classBuilder((String)CodegenUtils.getInputUtilClassName(this.vajramName)).addModifiers(new Modifier[]{Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeSpec.Builder createVajramImplClass() {
        return TypeSpec.classBuilder((String)CodegenUtils.getVajramImplClassName(this.vajramName)).addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{VajramFacetDefinition.class}).annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)"inputDefinitions", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getRequestClassName() {
        return this.requestClassName;
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getPackageName() {
        return this.packageName;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String toJavaName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String inputName) {
        if (!inputName.contains("_")) {
            return inputName;
        }
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, inputName);
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName optional(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName javaType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{javaType});
    }

    private record TypeAndName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName typeName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror> type, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized AnnotationSpec> annotationSpecs) {
        private TypeAndName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName typeName) {
            this(typeName, Optional.empty(), List.of());
        }
    }

    private record FromAndTo(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec from, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec to) {
    }

    private record FieldTypeName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName typeName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String name) {
    }
}

