package com.flipkart.krystal.vajram


import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.tasks.compile.JavaCompile

import static com.flipkart.krystal.vajram.codegen.Constants.COGENGEN_PHASE_KEY
import static com.flipkart.krystal.vajram.codegen.models.CodegenPhase.IMPLS
import static com.flipkart.krystal.vajram.codegen.models.CodegenPhase.MODELS

class VajramPlugin implements Plugin<Project> {

    void apply(Project project) {


        def srcGenDir = '/generated/sources/annotationProcessor/java'
        // Vajram models are generated in a different directory to keep the build phase inputs and outputs separate -
        // This enables better caching and to deterministically reuse previous build's outputs
        def vajramModelsGenDir = '/generated/sources/annotationProcessor/vajramModels/java'

        String mainSrcDir = 'src/main/java'
        String testSrcDir = 'src/test/java'

        String mainModelsGenDir = project.buildDir.getPath() + vajramModelsGenDir + '/main'
        String mainImplsGenDir = project.buildDir.getPath() + srcGenDir + '/main'

        String testModelsGenDir = project.buildDir.getPath() + vajramModelsGenDir + '/test'
        String testImplsGenDir = project.buildDir.getPath() + srcGenDir + '/test'

        project.sourceSets {
            main {
                java {
                    srcDirs = [mainSrcDir, mainModelsGenDir, mainImplsGenDir]
                }
            }
            test {
                java {
                    srcDirs = [testSrcDir, testModelsGenDir, testImplsGenDir]
                }
            }
        }

        project.tasks.register('codeGenVajramModels', JavaCompile) {
            //Compile the generatedCode
            group = 'krystal'
            source mainSrcDir
            classpath = project.configurations.compileClasspath
            destinationDirectory = project.tasks.compileJava.destinationDirectory
            //For lombok processing of EqualsAndHashCode
            options.annotationProcessorPath = project.tasks.compileJava.options.annotationProcessorPath
            options.generatedSourceOutputDirectory.fileValue(project.file(mainModelsGenDir))
            options.compilerArgs += ['-proc:only', '-A' + COGENGEN_PHASE_KEY + '=' + MODELS]
        }

        project.tasks.register('codeGenVajramImpls', JavaCompile) {
            //Compile the generatedCode
            group = 'krystal'
            dependsOn 'codeGenVajramModels'
            source project.sourceSets.main.allSource.srcDirs
            classpath = project.configurations.compileClasspath
            destinationDirectory = project.tasks.compileJava.destinationDirectory
            //For lombok processing of EqualsAndHashCode
            options.annotationProcessorPath = project.tasks.compileJava.options.annotationProcessorPath
            options.generatedSourceOutputDirectory.fileValue(project.file(mainImplsGenDir))
            options.compilerArgs += ['-proc:only', '-processor',
                                     'lombok.launch.AnnotationProcessorHider$AnnotationProcessor,com.flipkart.krystal.vajram.codegen.VajramImplGenProcessor',
                                     '-A' + COGENGEN_PHASE_KEY + '=' + IMPLS]
        }

        project.tasks.compileJava.dependsOn 'codeGenVajramImpls'

        project.tasks.register('testCodeGenVajramModels', JavaCompile) {
            //Compile the generatedCode
            group = 'krystal'
            mustRunAfter it.project.tasks.compileJava
            source mainSrcDir, testSrcDir
            classpath = project.configurations.testCompileClasspath + project.configurations.compileClasspath
            destinationDirectory = project.tasks.compileTestJava.destinationDirectory
            //For lombok processing of EqualsAndHashCode
            options.annotationProcessorPath = project.tasks.compileTestJava.options.annotationProcessorPath
            options.generatedSourceOutputDirectory.fileValue(project.file(testModelsGenDir))
            options.compilerArgs += ['-A' + COGENGEN_PHASE_KEY + '=' + MODELS]
        }

        project.tasks.register('testCodeGenVajramImpls', JavaCompile) {
            //Compile the generatedCode
            group = 'krystal'
            dependsOn 'testCodeGenVajramModels'
            source project.sourceSets.test.allSource.srcDirs + project.sourceSets.main.allSource.srcDirs
            classpath = project.configurations.testCompileClasspath + project.configurations.compileClasspath
            destinationDirectory = project.tasks.compileTestJava.destinationDirectory
            //For lombok processing of EqualsAndHashCode
            options.annotationProcessorPath = project.tasks.compileTestJava.options.annotationProcessorPath
            options.generatedSourceOutputDirectory.fileValue(project.file(testImplsGenDir))
            options.compilerArgs += ['-proc:only', '-processor',
                                     'lombok.launch.AnnotationProcessorHider$AnnotationProcessor,com.flipkart.krystal.vajram.codegen.VajramImplGenProcessor',
                                     '-A' + COGENGEN_PHASE_KEY + '=' + IMPLS]
        }

        project.tasks.named("jar").configure { it.dependsOn("compileJava") }
    }
}