/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen;

import com.flipkart.krystal.vajram.codegen.Utils;
import com.flipkart.krystal.vajram.codegen.VajramCodeGenerator;
import com.flipkart.krystal.vajram.codegen.models.CodegenPhase;
import com.flipkart.krystal.vajram.codegen.models.VajramInfo;
import com.google.auto.service.AutoService;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;

@SupportedAnnotationTypes(value={"com.flipkart.krystal.vajram.VajramDef"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@SupportedOptions(value={"krystal.vajram.codegen.phase"})
@AutoService(value={Processor.class})
public class VajramImplGenProcessor
extends AbstractProcessor {
    @Override
    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean process(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Set<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement> annotations, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized RoundEnvironment roundEnv) {
        Utils util = new Utils(this.processingEnv, this.getClass());
        String phaseString = this.processingEnv.getOptions().get("krystal.vajram.codegen.phase");
        try {
            if (phaseString == null || !CodegenPhase.IMPLS.equals((Object)CodegenPhase.valueOf(phaseString))) {
                util.note("Skipping VajramImplGenProcessor since codegen phase is %s".formatted(String.valueOf(phaseString)));
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            util.error("VajramImplGenProcessor could not parse phase string '%s'. Exactly one of %s must be passed as value to java compiler via the annotation processor argument '-A%s='".formatted(String.valueOf(phaseString), Arrays.toString((Object[])CodegenPhase.values()), "krystal.vajram.codegen.phase"), null);
        }
        List<TypeElement> vajramDefinitions = util.getVajramClasses(roundEnv);
        util.note("Vajram Defs received by VajramImplGenProcessor: %s".formatted(vajramDefinitions.stream().map(Objects::toString).collect(Collectors.joining(System.lineSeparator(), "[" + System.lineSeparator(), System.lineSeparator() + "]"))));
        for (TypeElement vajramClass : vajramDefinitions) {
            VajramInfo vajramInfo = util.computeVajramInfo(vajramClass);
            VajramCodeGenerator vajramCodeGenerator = util.createCodeGenerator(vajramInfo);
            String className = vajramCodeGenerator.getPackageName() + "." + Utils.getVajramImplClassName(vajramInfo.vajramId().vajramId());
            try {
                util.generateSourceFile(className, vajramCodeGenerator.codeGenVajramImpl(), vajramClass);
            }
            catch (Exception e) {
                util.note("Error while generating file for class %s. Ignoring the error as it should be skipped in subsequent runs. Exception: %s".formatted(className, e));
            }
        }
        return true;
    }
}

