/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen;

import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.Facets;
import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.datatypes.JavaType;
import com.flipkart.krystal.utils.SkippedExecutionException;
import com.flipkart.krystal.vajram.DependencyResponse;
import com.flipkart.krystal.vajram.IOVajram;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.VajramRequest;
import com.flipkart.krystal.vajram.batching.BatchedFacets;
import com.flipkart.krystal.vajram.batching.FacetsConverter;
import com.flipkart.krystal.vajram.batching.UnBatchedFacets;
import com.flipkart.krystal.vajram.codegen.Utils;
import com.flipkart.krystal.vajram.codegen.models.DependencyModel;
import com.flipkart.krystal.vajram.codegen.models.FacetGenModel;
import com.flipkart.krystal.vajram.codegen.models.InputModel;
import com.flipkart.krystal.vajram.codegen.models.ParsedVajramData;
import com.flipkart.krystal.vajram.codegen.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.models.VajramInfoLite;
import com.flipkart.krystal.vajram.exception.VajramValidationException;
import com.flipkart.krystal.vajram.facets.DependencyCommand;
import com.flipkart.krystal.vajram.facets.DependencyDef;
import com.flipkart.krystal.vajram.facets.FacetContainer;
import com.flipkart.krystal.vajram.facets.FacetValuesAdaptor;
import com.flipkart.krystal.vajram.facets.InputDef;
import com.flipkart.krystal.vajram.facets.InputSource;
import com.flipkart.krystal.vajram.facets.MultiExecute;
import com.flipkart.krystal.vajram.facets.SingleExecute;
import com.flipkart.krystal.vajram.facets.VajramDepFanoutTypeSpec;
import com.flipkart.krystal.vajram.facets.VajramDepSingleTypeSpec;
import com.flipkart.krystal.vajram.facets.VajramFacetDefinition;
import com.flipkart.krystal.vajram.facets.VajramFacetSpec;
import com.flipkart.krystal.vajram.facets.resolution.sdk.Resolve;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import lombok.EqualsAndHashCode;
import lombok.Generated;
import lombok.ToString;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VajramCodeGenerator {
    @Generated
    private static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Logger log = LoggerFactory.getLogger(VajramCodeGenerator.class);
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String packageName;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ProcessingEnvironment processingEnv;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String requestClassName;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) VajramInfo vajramInfo;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String vajramName;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) VajramID, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) VajramInfoLite> vajramDefs;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) FacetGenModel> facetModels;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) boolean needsBatching;
    private @MonotonicNonNull @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) ParsedVajramData parsedVajramData;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Utils util;

    public VajramCodeGenerator(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) VajramInfo vajramInfo, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) VajramID, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) VajramInfoLite> vajramDefs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ProcessingEnvironment processingEnv, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Utils util) {
        this.vajramInfo = vajramInfo;
        this.vajramName = vajramInfo.vajramId().vajramId();
        this.packageName = vajramInfo.packageName();
        this.processingEnv = processingEnv;
        this.util = util;
        this.requestClassName = Utils.getRequestClassName(this.vajramName);
        this.vajramDefs = Collections.unmodifiableMap(vajramDefs);
        this.facetModels = vajramInfo.facetStream().collect(Collectors.toMap(FacetGenModel::name, Function.identity(), (o1, o2) -> o1, LinkedHashMap::new));
        this.needsBatching = vajramInfo.inputs().stream().anyMatch(InputModel::isBatched);
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String getVajramName() {
        return this.vajramName;
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String codeGenVajramImpl() {
        this.initParsedVajramData();
        TypeSpec.Builder vajramImplClass = this.util.classBuilder(Utils.getVajramImplClassName(this.vajramName)).addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{VajramFacetDefinition.class}).annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)"facetDefinitions", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        vajramImplClass.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass(ClassName.get((TypeElement)this.vajramInfo.vajramClass()).box()).build();
        HashMap<String, List> resolverMap = new HashMap<String, List>();
        for (ExecutableElement resolver : this.getParsedVajramData().resolvers()) {
            String key = ((Resolve)Preconditions.checkNotNull((Object)resolver.getAnnotation(Resolve.class))).depName();
            resolverMap.computeIfAbsent(key, _k -> new ArrayList()).add(resolver);
        }
        Map<String, Boolean> depFanoutMap = this.vajramInfo.dependencies().stream().collect(Collectors.toMap(DependencyModel::name, DependencyModel::canFanout));
        ClassName inputBatch = ClassName.get((String)this.getParsedVajramData().packageName(), (String)Utils.getFacetUtilClassName(this.getParsedVajramData().vajramInfo().vajramId().vajramId()), (String[])new String[]{Utils.getBatchedFacetsClassname(this.vajramName)});
        ClassName commonInputs = ClassName.get((String)this.getParsedVajramData().packageName(), (String)Utils.getFacetUtilClassName(this.getParsedVajramData().vajramInfo().vajramId().vajramId()), (String[])new String[]{Utils.getCommonFacetsClassname(this.vajramName)});
        TypeName vajramResponseType = this.util.toTypeName(this.getParsedVajramData().vajramInfo().responseType());
        MethodSpec facetDefinitionsMethod = this.createFacetDefinitions();
        methodSpecs.add(facetDefinitionsMethod);
        Optional<MethodSpec> inputResolverMethod = this.createResolvers(resolverMap, depFanoutMap);
        inputResolverMethod.ifPresent(methodSpecs::add);
        if (this.util.isRawAssignable(this.getParsedVajramData().vajramInfo().vajramClass().asType(), IOVajram.class)) {
            methodSpecs.add(this.createIOVajramExecuteMethod(inputBatch, commonInputs, vajramResponseType.box().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()})));
        } else {
            methodSpecs.add(this.createComputeVajramExecuteMethod(vajramResponseType));
        }
        if (this.needsBatching) {
            methodSpecs.add(this.createBatchFacetConvertersMethod(inputBatch, commonInputs));
        }
        StringWriter writer = new StringWriter();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)vajramImplClass.addMethods(methodSpecs).build()).indent("  ").build().writeTo((Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    private @NonNull @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) ParsedVajramData initParsedVajramData() {
        if (this.parsedVajramData == null) {
            this.parsedVajramData = ParsedVajramData.fromVajram(this.vajramInfo, this.util).orElseThrow(() -> new VajramValidationException("Could not load Vajram class for vajram %s.\nParsedVajram Data should never be accessed in model generation phase.".formatted(this.vajramInfo.vajramId())));
        }
        return this.parsedVajramData;
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ParsedVajramData getParsedVajramData() {
        return Optional.ofNullable(this.parsedVajramData).orElseGet(this::initParsedVajramData);
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableSet<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String> getResolverSources(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ExecutableElement resolve) {
        return (ImmutableSet)resolve.getParameters().stream().map(parameter -> this.util.inferFacetName((VariableElement)parameter)).collect(ImmutableSet.toImmutableSet());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) MethodSpec createComputeVajramExecuteMethod(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeName vajramResponseType) {
        MethodSpec.Builder executeBuilder = MethodSpec.methodBuilder((String)"executeCompute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{Facets.class}), "facetsList", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableMap.class), (TypeName[])new TypeName[]{ClassName.get(Facets.class), ParameterizedTypeName.get((ClassName)ClassName.get(Errable.class), (TypeName[])new TypeName[]{vajramResponseType.box()})})).addAnnotation(Override.class);
        if (this.needsBatching) {
            String message = "Batching is not supported in ComputeVajrams";
            this.util.error(message, this.getParsedVajramData().vajramInfo().inputs().stream().filter(InputModel::isBatched).findAny().map(InputModel::facetField).orElse(this.getParsedVajramData().vajramInfo().vajramClass()));
            throw new VajramValidationException(message);
        }
        this.nonBatchedExecuteMethodBuilder(executeBuilder, false);
        return executeBuilder.build();
    }

    private void nonBatchedExecuteMethodBuilder(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) MethodSpec.Builder executeBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) boolean isIOVajram) {
        String methodCallSuffix;
        boolean outputLogicNeedsAllFacetsObject;
        List<FacetGenModel> neededFacetsInOrder;
        CodeBlock.Builder returnBuilder = CodeBlock.builder().add("return facetsList.stream().collect(\n     $T.toImmutableMap($T.identity(),\n     element -> {\n", new Object[]{ImmutableMap.class, Function.class});
        ArrayList inputCodeBlocks = new ArrayList();
        ClassName allFacetsClass = ClassName.get((String)this.packageName, (String)Utils.getFacetUtilClassName(this.vajramName), (String[])new String[]{Utils.getAllFacetsClassname(this.vajramName)});
        List<? extends VariableElement> outputLogicParams = this.getParsedVajramData().outputLogic().getParameters();
        if (outputLogicParams.size() == 1 && this.util.getProcessingEnv().getTypeUtils().isAssignable(outputLogicParams.get(0).asType(), this.util.getTypeElement(allFacetsClass.canonicalName()).asType())) {
            neededFacetsInOrder = this.facetModels.values().stream().toList();
            outputLogicNeedsAllFacetsObject = true;
        } else {
            neededFacetsInOrder = outputLogicParams.stream().map(param -> {
                String facetName = this.util.inferFacetName((VariableElement)param);
                FacetGenModel facet = this.facetModels.get(facetName);
                if (facet == null) {
                    String message = "Could not find a facet with name %s".formatted(facetName);
                    this.util.error(message, (Element)param);
                    throw new VajramValidationException(message);
                }
                return facet;
            }).toList();
            outputLogicNeedsAllFacetsObject = false;
        }
        neededFacetsInOrder.forEach(inputDef -> {
            if (inputDef instanceof DependencyModel) {
                DependencyModel dependencyModel = (DependencyModel)inputDef;
                VajramID depVajramId = dependencyModel.depVajramId();
                String depRequestClass = dependencyModel.depReqClassQualifiedName();
                VajramInfoLite depVajramInfo = (VajramInfoLite)Preconditions.checkNotNull((Object)this.vajramDefs.get(depVajramId), (String)"Could not find ParsedVajramData for %s", (Object)depVajramId);
                TypeName boxedResponseType = this.util.toTypeName(depVajramInfo.responseType()).box();
                String variableName = VajramCodeGenerator.toJavaName(inputDef.name());
                String depVariableName = variableName + "Responses";
                if (dependencyModel.canFanout()) {
                    CodeBlock.Builder codeBlock = CodeBlock.builder();
                    codeBlock.addNamed("$depResp:T<$request:T, $response:T> $depResponse:L =\n     new $depResp:T<>(\n         element.<$response:T>getDepValue($variable:S).values().entrySet().stream()\n             .filter(\n                 e ->\n                     e.getValue()\n                         .error()\n                         .filter(t -> t instanceof $skippedException:T)\n                         .isEmpty())\n             .collect(\n                 $imMap:T.toImmutableMap(\n                     e -> $request:T.from(e.getKey()), java.util.Map.Entry::getValue)));\n", (Map)ImmutableMap.of((Object)"depResp", DependencyResponse.class, (Object)"request", (Object)VajramCodeGenerator.toClassName(depRequestClass), (Object)"response", (Object)boxedResponseType, (Object)"variable", (Object)inputDef.name(), (Object)"depResponse", (Object)depVariableName, (Object)"imMap", ImmutableMap.class, (Object)"skippedException", SkippedExecutionException.class));
                    inputCodeBlocks.add(CodeBlock.builder().add(depVariableName, new Object[0]).build());
                    returnBuilder.add(codeBlock.build());
                } else if (dependencyModel.isMandatory()) {
                    inputCodeBlocks.add(CodeBlock.builder().addNamed("element.<$response:T>getDepValue($variable:S)\n    .values()\n    .entrySet()\n    .iterator()\n    .next()\n    .getValue()\n    .getValueOrThrow()\n    .orElseThrow(() -> new $illegalArgument:T(\"Missing mandatory dependencyDef '$variable:L' in vajram '$vajram:L'\"))", (Map)ImmutableMap.of((Object)"response", (Object)boxedResponseType, (Object)"variable", (Object)inputDef.name(), (Object)"illegalArgument", IllegalArgumentException.class, (Object)"vajram", (Object)this.vajramName)).build());
                } else {
                    inputCodeBlocks.add(CodeBlock.builder().addNamed("element.<$response:T>getDepValue($variable:S)\n    .values()\n    .entrySet()\n    .iterator()\n    .next()\n    .getValue()\n    .value()\n    .orElse(null)", (Map)ImmutableMap.of((Object)"response", (Object)boxedResponseType, (Object)"variable", (Object)inputDef.name())).build());
                }
            } else if (inputDef.isMandatory()) {
                inputCodeBlocks.add(CodeBlock.builder().add("element.getInputValueOrThrow($S)", new Object[]{inputDef.name()}).build());
            } else {
                inputCodeBlocks.add(CodeBlock.builder().add("element.getInputValueOrDefault($S, null)", new Object[]{inputDef.name()}).build());
            }
        });
        if (isIOVajram) {
            TypeMirror returnType = this.getParsedVajramData().outputLogic().getReturnType();
            if (!this.util.isRawAssignable(returnType, CompletableFuture.class)) {
                String errorMessage = "The OutputLogic of non-batched IO vajram %s must return a CompletableFuture".formatted(this.vajramName);
                this.util.error(errorMessage, this.getParsedVajramData().outputLogic());
                throw new VajramValidationException(errorMessage);
            }
            if (outputLogicNeedsAllFacetsObject) {
                returnBuilder.add("\nreturn ($L(new $T(\n", new Object[]{this.getParsedVajramData().outputLogic().getSimpleName(), allFacetsClass});
                methodCallSuffix = ")));\n";
            } else {
                returnBuilder.add("\nreturn $L(\n", new Object[]{this.getParsedVajramData().outputLogic().getSimpleName()});
                methodCallSuffix = ");\n";
            }
        } else if (outputLogicNeedsAllFacetsObject) {
            returnBuilder.add("\nreturn $T.errableFrom(() -> $L(new $T(\n", new Object[]{Errable.class, this.getParsedVajramData().outputLogic().getSimpleName(), allFacetsClass});
            methodCallSuffix = ")));\n";
        } else {
            returnBuilder.add("\nreturn $T.errableFrom(() -> $L(\n", new Object[]{Errable.class, this.getParsedVajramData().outputLogic().getSimpleName()});
            methodCallSuffix = "));\n";
        }
        for (int i = 0; i < inputCodeBlocks.size(); ++i) {
            returnBuilder.add("\t\t", new Object[0]);
            returnBuilder.add((CodeBlock)inputCodeBlocks.get(i));
            if (i == inputCodeBlocks.size() - 1) continue;
            returnBuilder.add(",\n", new Object[0]);
        }
        returnBuilder.add(methodCallSuffix, new Object[0]);
        returnBuilder.add("}));\n", new Object[0]);
        executeBuilder.addCode(returnBuilder.build());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) MethodSpec createBatchFacetConvertersMethod(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ClassName batchableInputs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ClassName commonInputs) {
        MethodSpec.Builder inputConvertersBuilder = MethodSpec.methodBuilder((String)"getBatchFacetsConvertor").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(FacetsConverter.class), (TypeName[])new TypeName[]{batchableInputs, commonInputs})})).addAnnotation(Override.class);
        inputConvertersBuilder.addCode(CodeBlock.builder().addStatement("return $T.of($T.%s)".formatted("BATCH_CONVERTER"), new Object[]{Optional.class, ClassName.get((String)this.packageName, (String)Utils.getFacetUtilClassName(this.vajramName), (String[])new String[0])}).build());
        return inputConvertersBuilder.build();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) MethodSpec createIOVajramExecuteMethod(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ClassName batchableInputs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ClassName commonFacets, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeName vajramResponseType) {
        MethodSpec.Builder executeMethodBuilder = MethodSpec.methodBuilder((String)"execute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{Facets.class}), "facetsList", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableMap.class), (TypeName[])new TypeName[]{ClassName.get(Facets.class), ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{vajramResponseType})})).addAnnotation(Override.class);
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        if (this.needsBatching) {
            ExecutableElement outputLogic = this.getParsedVajramData().outputLogic();
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put("facets", ClassName.get(Facets.class));
            valueMap.put("unmodInput", ClassName.get(UnBatchedFacets.class));
            valueMap.put("inputBatching", batchableInputs);
            valueMap.put("facetUtil", ClassName.get((String)this.packageName, (String)Utils.getFacetUtilClassName(this.vajramName), (String[])new String[0]));
            valueMap.put("commonInput", commonFacets);
            valueMap.put("returnType", vajramResponseType);
            valueMap.put("outputLogicMethod", outputLogic.getSimpleName());
            valueMap.put("modInput", ClassName.get(BatchedFacets.class));
            valueMap.put("imMap", ClassName.get(ImmutableMap.class));
            valueMap.put("imList", ClassName.get(ImmutableList.class));
            valueMap.put("hashMap", ClassName.get(HashMap.class));
            valueMap.put("arrayList", ClassName.get(ArrayList.class));
            valueMap.put("comFuture", ClassName.get(CompletableFuture.class));
            valueMap.put("linkHashMap", ClassName.get(LinkedHashMap.class));
            valueMap.put("map", ClassName.get(Map.class));
            valueMap.put("list", ClassName.get(List.class));
            valueMap.put("valErr", Errable.class);
            valueMap.put("function", ClassName.get(Function.class));
            valueMap.put("optional", ClassName.get(Optional.class));
            TypeMirror returnType = outputLogic.getReturnType();
            Preconditions.checkState((boolean)this.util.isRawAssignable(this.processingEnv.getTypeUtils().erasure(returnType), Map.class), (String)"A vajram supporting input batching must return map. Vajram: %s", (Object)this.vajramName);
            TypeMirror mapValue = Utils.getTypeParameters(returnType).get(1);
            if (!this.util.isRawAssignable(mapValue, CompletableFuture.class)) {
                String message = "Batched IO Vajram should return a map whose value type must be `CompletableFuture`.\nViolating vajram: %s".formatted(this.vajramName);
                this.util.error(message, outputLogic);
                throw new VajramValidationException(message);
            }
            codeBuilder.addNamed("    $map:T<$inputBatching:T, $facets:T> mapping = new $hashMap:T<>();\n    $commonInput:T commonFacets = null;\n    for ($facets:T facets : facetsList) {\n      $unmodInput:T<$inputBatching:T, $commonInput:T> allInputs =\n          new $unmodInput:T($facetUtil:T.BATCH_CONVERTER.getBatched(facets)\n                            ,$facetUtil:T.BATCH_CONVERTER.getCommon(facets));\n      commonFacets = allInputs.commonFacets();\n      $inputBatching:T im = allInputs.batchedInputs();\n      mapping.put(im, facets);\n    }\n    $map:T<$facets:T, $comFuture:T<$returnType:T>> returnValue = new $linkHashMap:T<>();\n\n    if (commonFacets != null) {\n      var results = $outputLogicMethod:L(new $modInput:T<>($imList:T.copyOf(mapping.keySet()), commonFacets));\n      results.forEach((im, future) -> returnValue.put(\n            $optional:T.ofNullable(mapping.get(im)).orElseThrow(),\n            future.<$returnType:T>thenApply($function:T.identity())));\n    }\n    return $imMap:T.copyOf(returnValue);\n", valueMap);
            executeMethodBuilder.addCode(codeBuilder.build());
        } else {
            this.nonBatchedExecuteMethodBuilder(executeMethodBuilder, true);
        }
        return executeMethodBuilder.build();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) MethodSpec> createResolvers(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ExecutableElement>> resolverMap, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Boolean> depFanoutMap) {
        String dependencyDef = "dependencyDef";
        MethodSpec.Builder resolveInputsBuilder = MethodSpec.methodBuilder((String)"resolveInputOfDependency").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, dependencyDef, new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get(ImmutableSet.class, (Type[])new Type[]{String.class}), "resolvableInputs", new Modifier[0]).addParameter(Facets.class, "facets", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(DependencyCommand.class), (TypeName[])new TypeName[]{ClassName.get(Facets.class)}));
        if (Objects.nonNull(this.getParsedVajramData())) {
            resolveInputsBuilder.beginControlFlow("switch ($L) ", new Object[]{dependencyDef});
            if (this.getParsedVajramData().resolvers().isEmpty()) {
                return Optional.empty();
            }
            Set<String> resolvedVariables = resolverMap.keySet();
            resolverMap.forEach((variable, methods) -> {
                CodeBlock.Builder caseBuilder = CodeBlock.builder().beginControlFlow("case $S -> ", new Object[]{variable});
                methods.forEach(method -> {
                    AtomicBoolean fanout = new AtomicBoolean(false);
                    method.getParameters().forEach(parameter -> {
                        String bindParamName = this.util.inferFacetName((VariableElement)parameter);
                        if (!fanout.get() && depFanoutMap.containsKey(bindParamName)) {
                            fanout.set((Boolean)depFanoutMap.get(bindParamName));
                        }
                        if (!this.facetModels.containsKey(bindParamName) && !resolvedVariables.contains(bindParamName)) {
                            String message = "Parameter binding incorrect for inputDef - " + bindParamName;
                            this.util.error(message, (Element)parameter);
                            throw new VajramValidationException(message);
                        }
                    });
                    CodeBlock.Builder ifBlockBuilder = this.buildInputResolver((ExecutableElement)method, depFanoutMap, fanout.get());
                    caseBuilder.add(ifBlockBuilder.build());
                });
                caseBuilder.endControlFlow();
                resolveInputsBuilder.addCode(caseBuilder.build());
            });
            resolveInputsBuilder.endControlFlow();
            resolveInputsBuilder.addStatement("throw new $T($S)", new Object[]{ClassName.get(VajramValidationException.class), "Unresolvable dependencyDef"});
        } else {
            resolveInputsBuilder.addStatement("throw new $T($S)", new Object[]{ClassName.get(VajramValidationException.class), "Unresolvable dependencyDef"});
        }
        return Optional.of(resolveInputsBuilder.build());
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) CodeBlock.Builder buildInputResolver(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ExecutableElement method, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Boolean> depFanoutMap, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) boolean isParamFanoutDependency) {
        Resolve resolve = (Resolve)Preconditions.checkNotNull((Object)method.getAnnotation(Resolve.class), (Object)"Resolver method must have 'Resolve' annotation");
        CharSequence[] facets = resolve.depInputs();
        String depName = resolve.depName();
        CodeBlock.Builder ifBlockBuilder = CodeBlock.builder();
        ifBlockBuilder.beginControlFlow("if ($T.of($S).equals(resolvableInputs))", new Object[]{Set.class, String.join((CharSequence)",", facets)});
        method.getParameters().forEach(parameter -> {
            String usingInputName = this.util.inferFacetName((VariableElement)parameter);
            if (this.facetModels.get(usingInputName) instanceof DependencyModel) {
                this.generateDependencyResolutions(method, usingInputName, ifBlockBuilder, depFanoutMap, (VariableElement)parameter);
                return;
            }
            if (!this.facetModels.containsKey(usingInputName)) {
                String message = "No inputDef resolver found for " + usingInputName;
                this.util.error(message, (Element)parameter);
                throw new VajramValidationException(message);
            }
            FacetGenModel facetGenModel = this.facetModels.get(usingInputName);
            String variable = VajramCodeGenerator.toJavaName(usingInputName);
            TypeName parameterType = TypeName.get((TypeMirror)parameter.asType());
            if (facetGenModel.isMandatory()) {
                ifBlockBuilder.add(CodeBlock.builder().addStatement("$T $L = $L.getInputValueOrThrow($S)", new Object[]{parameterType, variable, "facets", usingInputName}).build());
                return;
            }
            if (this.util.isRawAssignable(parameter.asType(), Optional.class)) {
                ifBlockBuilder.add(CodeBlock.builder().addStatement("$T $L = $L.getInputValueOpt($S)", new Object[]{parameterType, variable, "facets", usingInputName}).build());
                return;
            }
            String message = String.format("Optional inputDef dependencyDef %s must have type as Optional", usingInputName);
            this.util.error(message, (Element)parameter);
            throw new VajramValidationException(message);
        });
        boolean isFanOut = isParamFanoutDependency || depFanoutMap.getOrDefault(depName, false) != false;
        this.buildFinalResolvers(method, (String[])facets, ifBlockBuilder, isFanOut);
        ifBlockBuilder.endControlFlow();
        return ifBlockBuilder;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void generateDependencyResolutions(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ExecutableElement method, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String usingInputName, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) CodeBlock.Builder ifBlockBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Boolean> depFanoutMap, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) VariableElement parameter) {
        FacetGenModel facetDef = this.facetModels.get(usingInputName);
        Resolve resolve = (Resolve)Preconditions.checkNotNull((Object)method.getAnnotation(Resolve.class), (Object)"Resolver method cannot be null");
        String resolvedDep = resolve.depName();
        if (depFanoutMap.containsKey(usingInputName) && depFanoutMap.get(usingInputName).booleanValue() && this.util.isRawAssignable(parameter.asType(), DependencyResponse.class)) {
            String message = "Dependency resolution of %s is fanout but the resolver method is not of type DependencyResponse".formatted(resolvedDep);
            this.util.error(message, method);
            throw new VajramValidationException(message);
        }
        if (!(facetDef instanceof DependencyModel)) return;
        DependencyModel dependencyModel = (DependencyModel)facetDef;
        String variableName = VajramCodeGenerator.toJavaName(usingInputName);
        VajramInfoLite vajramInfoLite = (VajramInfoLite)Preconditions.checkNotNull((Object)this.vajramDefs.get(dependencyModel.depVajramId()), (String)"Could not find parsed vajram data for class %s", (Object)dependencyModel.depVajramId());
        String requestClass = dependencyModel.depReqClassQualifiedName();
        TypeName boxedDepType = this.util.toTypeName(vajramInfoLite.responseType()).box();
        TypeName unboxedDepType = boxedDepType.isBoxedPrimitive() ? boxedDepType.unbox() : boxedDepType;
        String resolverName = method.getSimpleName().toString();
        if (this.util.isRawAssignable(parameter.asType(), DependencyResponse.class)) {
            String depValueAccessorCode = "$1T $2L =\n new $3T<>(facets.<$4T>getDepValue($5S)\n      .values().entrySet().stream()\n      .collect($6T.toImmutableMap(e -> $7T.from(e.getKey()),\n      $8T::getValue)))";
            ifBlockBuilder.addStatement(depValueAccessorCode, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(DependencyResponse.class), (TypeName[])new TypeName[]{VajramCodeGenerator.toClassName(requestClass), boxedDepType}), variableName, DependencyResponse.class, boxedDepType, usingInputName, ImmutableMap.class, VajramCodeGenerator.toClassName(requestClass), ClassName.get(Map.Entry.class)});
            return;
        }
        String depValueAccessorCode = "$1T $2L =\n  facets.<$3T>getDepValue($4S)\n     .values()\n     .entrySet()\n     .iterator()\n     .next()\n     .getValue()";
        if (facetDef.isMandatory()) {
            if (unboxedDepType.equals((Object)TypeName.get((TypeMirror)parameter.asType()))) {
                String code = depValueAccessorCode + ".getValueOrThrow().orElseThrow(() ->\n    new $5T(\"Received null value for mandatory dependencyDef '$6L' of vajram '$7L'\"))";
                ifBlockBuilder.addStatement(code, new Object[]{unboxedDepType, variableName, boxedDepType, usingInputName, IllegalArgumentException.class, usingInputName, this.vajramName});
                return;
            }
            String message = "A resolver ('%s') must not access an optional dependencyDef ('%s') directly.Use Optional<>, Errable<>, or DependencyResponse<> instead".formatted(resolverName, usingInputName);
            this.util.error(message, parameter);
            throw new VajramValidationException(message);
        }
        if (this.util.isRawAssignable(parameter.asType(), Errable.class)) {
            ifBlockBuilder.addStatement(depValueAccessorCode, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Errable.class), (TypeName[])new TypeName[]{boxedDepType}), variableName, boxedDepType, usingInputName});
            return;
        }
        if (this.util.isRawAssignable(parameter.asType(), Optional.class)) {
            String code = depValueAccessorCode + ".value()";
            ifBlockBuilder.addStatement(code, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{boxedDepType}), variableName, boxedDepType, usingInputName});
            return;
        }
        String message = "Unrecognized parameter type %s in resolver %s of vajram %s".formatted(parameter.asType(), resolverName, this.vajramName);
        this.util.error(message, parameter);
        throw new VajramValidationException(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void buildFinalResolvers(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ExecutableElement method, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) [] facets, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) CodeBlock.Builder ifBlockBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) boolean isFanOut) {
        TypeMirror returnType;
        String variableName = "resolverResult";
        boolean controlFLowStarted = false;
        TypeName methodReturnType = TypeName.get((TypeMirror)method.getReturnType());
        ifBlockBuilder.add("$T $L = $L(", new Object[]{methodReturnType, variableName, method.getSimpleName()});
        ImmutableList resolverSources = this.getResolverSources(method).asList();
        for (int i = 0; i < resolverSources.size(); ++i) {
            String bindName = (String)resolverSources.get(i);
            ifBlockBuilder.add("$L", new Object[]{VajramCodeGenerator.toJavaName(bindName)});
            if (i == method.getParameters().size() - 1) continue;
            ifBlockBuilder.add(", ", new Object[0]);
        }
        ifBlockBuilder.add(");\n", new Object[0]);
        if (this.util.isRawAssignable(method.getReturnType(), DependencyCommand.class)) {
            ifBlockBuilder.beginControlFlow("if($L.shouldSkip())", new Object[]{variableName});
            ifBlockBuilder.addStatement("\t return $T.skipExecution($L.doc())", new Object[]{SingleExecute.class, variableName});
            ifBlockBuilder.add("} else {\n\t", new Object[0]);
            controlFLowStarted = true;
        }
        if (this.util.isRawAssignable(returnType = this.util.box(method.getReturnType()), MultiExecute.class)) {
            code = "return $T.executeFanoutWith(\n    $L.inputs().stream()\n        .map(\n            element ->\n                new $T(\n                    $T.of($S, $T.withValue(element))))\n    .toList())";
            ifBlockBuilder.addStatement(code, new Object[]{MultiExecute.class, variableName, Facets.class, ImmutableMap.class, facets[0], Errable.class});
        } else if (isFanOut) {
            if (!this.util.isRawAssignable(returnType, Iterable.class)) {
                String message = "Incorrect vajram resolver " + this.vajramName + ": Fanout resolvers must return an iterable";
                this.util.error(message, method);
                throw new VajramValidationException(message);
            }
            if (this.util.isRawAssignable(Utils.getTypeParameters(returnType).get(0), VajramRequest.class)) {
                code = "return $T.executeFanoutWith(\n    $L.stream()\n        .map(\n            element ->\n                element.toInputValues()))\n    .toList())";
                ifBlockBuilder.addStatement(code, new Object[]{MultiExecute.class, variableName});
            } else {
                code = "return $T.executeFanoutWith(\n    $L.stream()\n        .map(\n            element ->\n                new $T(\n                    $T.of($S, $T.withValue(element))))\n    .toList())";
                ifBlockBuilder.addStatement(code, new Object[]{MultiExecute.class, variableName, Facets.class, ImmutableMap.class, facets[0], Errable.class});
            }
        } else if (this.util.isRawAssignable(returnType, VajramRequest.class)) {
            ifBlockBuilder.addStatement("return $T.executeWith($L.toInputValues())", new Object[]{SingleExecute.class, variableName});
        } else if (this.util.isRawAssignable(returnType, SingleExecute.class)) {
            ifBlockBuilder.addStatement("  return $T.executeWith(new $T(\n   $T.of($S, $T.withValue(\n      $L.inputs().iterator().next().orElse(null)))))\n", new Object[]{SingleExecute.class, Facets.class, ImmutableMap.class, facets[0], Errable.class, variableName});
        } else {
            ifBlockBuilder.addStatement("return $T.executeWith(new $T(\n $T.of($S, $T.withValue($L))))", new Object[]{SingleExecute.class, Facets.class, ImmutableMap.class, facets[0], Errable.class, variableName});
        }
        if (controlFLowStarted) {
            ifBlockBuilder.endControlFlow();
        }
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) MethodSpec createFacetDefinitions() {
        MethodSpec.Builder facetDefinitionsBuilder = MethodSpec.methodBuilder((String)"getFacetDefinitions").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{VajramFacetDefinition.class})).addAnnotation(Override.class);
        List<FacetGenModel> facetGenModels = this.vajramInfo.facetStream().toList();
        ArrayList codeBlocks = new ArrayList(facetGenModels.size());
        facetGenModels.forEach(facetGenModel -> {
            CodeBlock.Builder inputDefBuilder = CodeBlock.builder();
            if (facetGenModel instanceof InputModel) {
                InputModel inputDef = (InputModel)facetGenModel;
                this.buildVajramInput(inputDefBuilder, inputDef);
            } else if (facetGenModel instanceof DependencyModel) {
                DependencyModel dependencyDef = (DependencyModel)facetGenModel;
                VajramCodeGenerator.buildVajramDependency(inputDefBuilder, dependencyDef);
            }
            codeBlocks.add(inputDefBuilder.build());
        });
        facetDefinitionsBuilder.beginControlFlow("if(this.$L == null)", new Object[]{"facetDefinitions"});
        facetDefinitionsBuilder.addCode(CodeBlock.builder().add("this.$L = $T.of(\n", new Object[]{"facetDefinitions", ImmutableList.class}).add(CodeBlock.join(codeBlocks, (String)",\n\t")).add("\n);\n", new Object[0]).build());
        facetDefinitionsBuilder.endControlFlow();
        facetDefinitionsBuilder.addStatement("return $L", new Object[]{"facetDefinitions"});
        return facetDefinitionsBuilder.build();
    }

    private static void buildVajramDependency(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) CodeBlock.Builder inputDefBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) DependencyModel dependencyDef) {
        inputDefBuilder.add("$T.builder()", new Object[]{ClassName.get(DependencyDef.class)}).add(".name($S)", new Object[]{dependencyDef.name()});
        String code = ".dataAccessSpec($1T.vajramID($2S))";
        inputDefBuilder.add(code, new Object[]{ClassName.get(VajramID.class), dependencyDef.depVajramId().vajramId()});
        inputDefBuilder.add(".isMandatory($L)", new Object[]{dependencyDef.isMandatory()});
        inputDefBuilder.add(".build()", new Object[0]);
    }

    private void buildVajramInput(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) CodeBlock.Builder inputDefBuilder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) InputModel<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom ?> inputDef) {
        inputDefBuilder.add("$T.builder()", new Object[]{ClassName.get(InputDef.class)}).add(".name($S)", new Object[]{inputDef.name()});
        ImmutableSet<InputSource> inputSources = inputDef.sources();
        if (!inputSources.isEmpty()) {
            inputDefBuilder.add(".sources(", new Object[0]);
            String sources = inputSources.stream().map(inputSource -> {
                if (inputSource == InputSource.CLIENT) {
                    return "$inputSrc:T.CLIENT";
                }
                if (inputSource == InputSource.SESSION) {
                    return "$inputSrc:T.SESSION";
                }
                throw new IllegalArgumentException("Incorrect source defined in vajram config");
            }).collect(Collectors.joining(","));
            inputDefBuilder.addNamed(sources, (Map)ImmutableMap.of((Object)"inputSrc", InputSource.class)).add(")", new Object[0]);
        }
        DataType<?> inputType = inputDef.type();
        inputDefBuilder.add(".type(", new Object[0]);
        if (inputType instanceof JavaType) {
            JavaType javaType = (JavaType)inputType;
            ArrayList<TypeName> collectClassNames = new ArrayList<TypeName>();
            inputDefBuilder.add(this.getJavaTypeCreationCode(javaType, collectClassNames, inputDef.facetField()), (Object[])collectClassNames.toArray(TypeName[]::new));
        } else {
            this.util.error("Unrecognised data type %s".formatted(inputType), inputDef.facetField());
        }
        inputDefBuilder.add(")", new Object[0]);
        inputDefBuilder.add(".isMandatory($L)", new Object[]{inputDef.isMandatory()});
        inputDefBuilder.add(".isBatched($L)", new Object[]{inputDef.isBatched()});
        inputDefBuilder.add(".build()", new Object[0]);
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String getJavaTypeCreationCode(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) JavaType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom ?> javaType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeName> collectClassNames, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) VariableElement facetField) {
        TypeMirror typeMirror = javaType.javaModelType(this.processingEnv);
        collectClassNames.add((TypeName)ClassName.get(JavaType.class));
        if (javaType.typeParameters().isEmpty()) {
            collectClassNames.add(TypeName.get((TypeMirror)typeMirror));
            return "$T.create($T.class)";
        }
        collectClassNames.add(TypeName.get((TypeMirror)this.processingEnv.getTypeUtils().erasure(typeMirror)));
        collectClassNames.add((TypeName)ClassName.get(List.class));
        return "$T.create($T.class, $T.of(" + javaType.typeParameters().stream().map(dataType -> {
            if (!(dataType instanceof JavaType)) {
                this.util.error("Unrecognised data type %s".formatted(dataType), facetField);
                return "";
            }
            JavaType typeParamType = (JavaType)dataType;
            return this.getJavaTypeCreationCode(typeParamType, collectClassNames, facetField);
        }).collect(Collectors.joining(",")) + "))";
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String codeGenVajramRequest() {
        ImmutableList<InputModel<?>> inputDefs = this.vajramInfo.inputs();
        MethodSpec.Builder requestConstructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
        ClassName builderClassType = ClassName.get((String)(this.packageName + "." + this.requestClassName), (String)"Builder", (String[])new String[0]);
        TypeSpec.Builder requestClass = this.util.classBuilder(this.requestClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(VajramRequest.class), (TypeName[])new TypeName[]{this.util.toTypeName(this.vajramInfo.responseType()).box()})).addAnnotation(EqualsAndHashCode.class).addMethod(MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)builderClassType).addStatement("return new Builder()", new Object[0]).build());
        TypeSpec.Builder builderClass = this.util.classBuilder("Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addAnnotation(EqualsAndHashCode.class).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        LinkedHashSet<String> inputNames = new LinkedHashSet<String>();
        List<FacetGenModel> facets = this.vajramInfo.facetStream().toList();
        ArrayList<FieldSpec.Builder> inputNameFields = new ArrayList<FieldSpec.Builder>(facets.size());
        ArrayList<FieldSpec.Builder> inputSpecFields = new ArrayList<FieldSpec.Builder>(facets.size());
        for (FacetGenModel facet : facets) {
            InputModel inputDef2;
            String facetJavaName = VajramCodeGenerator.toJavaName(facet.name());
            TypeAndName facetType = this.getTypeName(this.getDataType(facet));
            TypeAndName boxedFacetType = this.boxPrimitive(facetType);
            ClassName vajramReqClass = ClassName.get((String)this.packageName, (String)this.requestClassName, (String[])new String[0]);
            String inputNameFieldName = facetJavaName + "_n";
            FieldSpec.Builder inputNameField = FieldSpec.builder(String.class, (String)inputNameFieldName, (Modifier[])new Modifier[0]).initializer("\"$L\"", new Object[]{facet.name()});
            FieldSpec.Builder inputSpecField = null;
            if (!(facet instanceof DependencyModel)) {
                inputSpecField = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(VajramFacetSpec.class), (TypeName[])new TypeName[]{boxedFacetType.typeName(), vajramReqClass}), (String)(facetJavaName + "_s"), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL}).initializer("new $T<>($L, $T.class)", new Object[]{VajramFacetSpec.class, inputNameFieldName, vajramReqClass});
                inputSpecFields.add(inputSpecField);
            }
            inputNameFields.add(inputNameField.addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL}));
            if (!(facet instanceof InputModel) || !(inputDef2 = (InputModel)facet).sources().contains((Object)InputSource.CLIENT)) continue;
            if (inputSpecField != null) {
                inputSpecField.addModifiers(new Modifier[]{Modifier.PUBLIC});
            }
            inputNameField.addModifiers(new Modifier[]{Modifier.PUBLIC});
            inputNames.add(facetJavaName);
            requestClass.addField(FieldSpec.builder((TypeName)boxedFacetType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)facetJavaName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            builderClass.addField(FieldSpec.builder((TypeName)boxedFacetType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)facetJavaName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
            requestConstructor.addParameter(ParameterSpec.builder((TypeName)boxedFacetType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)facetJavaName, (Modifier[])new Modifier[0]).build());
            requestConstructor.addStatement("this.$L = $L", new Object[]{facetJavaName, facetJavaName});
            requestClass.addMethod(this.getterCodeForInput(inputDef2, facetJavaName, facetType));
            builderClass.addMethod(MethodSpec.methodBuilder((String)facetJavaName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(boxedFacetType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()})).addStatement("return this.$L", new Object[]{facetJavaName}).build());
            builderClass.addMethod(MethodSpec.methodBuilder((String)facetJavaName).returns((TypeName)builderClassType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)boxedFacetType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)facetJavaName, (Modifier[])new Modifier[0]).build()).addStatement("this.$L = $L", new Object[]{facetJavaName, facetJavaName}).addStatement("return this", new Object[]{facetJavaName}).build());
        }
        requestClass.addFields(inputNameFields.stream().map(FieldSpec.Builder::build).toList());
        requestClass.addFields(inputSpecFields.stream().map(FieldSpec.Builder::build).toList());
        builderClass.addMethod(MethodSpec.methodBuilder((String)"build").returns((TypeName)ClassName.get((String)this.packageName, (String)this.requestClassName, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return new %s(%s)".formatted(this.requestClassName, String.join((CharSequence)", ", inputNames)), new Object[0]).build());
        StringWriter writer = new StringWriter();
        FromAndTo fromAndTo = this.fromAndToMethods(inputDefs.stream().filter(inputDef -> inputDef.sources().contains((Object)InputSource.CLIENT)).toList(), ClassName.get((String)this.packageName, (String)this.requestClassName, (String[])new String[0]));
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)requestClass.addMethod(requestConstructor.build()).addMethod(fromAndTo.from()).addMethod(fromAndTo.to()).addType(builderClass.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom ?> getDataType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) FacetGenModel abstractInput) {
        if (abstractInput instanceof InputModel) {
            InputModel inputDef = (InputModel)abstractInput;
            return inputDef.type();
        }
        if (abstractInput instanceof DependencyModel) {
            DependencyModel dep = (DependencyModel)abstractInput;
            return dep.responseType();
        }
        throw new UnsupportedOperationException("Unable to extract datatype from facet : %s".formatted(abstractInput));
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeAndName boxPrimitive(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeAndName javaType) {
        if (javaType.type().isPresent() && javaType.type().get().getKind().isPrimitive()) {
            TypeMirror boxed = this.processingEnv.getTypeUtils().boxedClass((PrimitiveType)javaType.type().get()).asType();
            return new TypeAndName(TypeName.get((TypeMirror)boxed).annotated(javaType.annotationSpecs()), Optional.of(boxed), javaType.annotationSpecs());
        }
        return javaType;
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeAndName unboxPrimitive(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeAndName javaType) {
        if (javaType.type().isPresent()) {
            PrimitiveType primitiveType;
            try {
                primitiveType = this.processingEnv.getTypeUtils().unboxedType(javaType.type().get());
            }
            catch (IllegalArgumentException e) {
                log.info("", (Throwable)e);
                return javaType;
            }
            return new TypeAndName(TypeName.get((TypeMirror)primitiveType), Optional.of(primitiveType), javaType.annotationSpecs());
        }
        return javaType;
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) FromAndTo fromAndToMethods(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) FacetGenModel> facetDefs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ClassName enclosingClass) {
        MethodSpec.Builder toFacetValues = MethodSpec.methodBuilder((String)"toFacetValues").returns(Facets.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return new $T($T.of(%s))".formatted(facetDefs.stream().map(f -> "$S, $T.withValue(this.$L)").collect(Collectors.joining(","))), Stream.of(Stream.of(Facets.class, ImmutableMap.class), facetDefs.stream().flatMap(facet -> Stream.of(facet.name(), Errable.class, VajramCodeGenerator.toJavaName(facet.name())))).flatMap(Function.identity()).toArray());
        MethodSpec.Builder fromFacetValues = MethodSpec.methodBuilder((String)"from").returns((TypeName)enclosingClass).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(Facets.class, "values", new Modifier[0]);
        List<String> inputNames = facetDefs.stream().map(FacetGenModel::name).toList();
        fromFacetValues.addStatement("return new $T(%s)".formatted(inputNames.stream().map(s -> "values.getInputValueOrDefault($S, null)").collect(Collectors.joining(", "))), Stream.concat(Stream.of(enclosingClass), inputNames.stream()).toArray());
        return new FromAndTo(fromFacetValues.build(), toFacetValues.build());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeAndName getTypeName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom ?> dataType) {
        return this.getTypeName(dataType, List.of());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeAndName getTypeName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom ?> dataType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) AnnotationSpec> typeAnnotations) {
        TypeMirror javaModelType = dataType.javaModelType(this.processingEnv);
        return new TypeAndName(TypeName.get((TypeMirror)javaModelType).annotated(typeAnnotations), Optional.of(javaModelType), typeAnnotations);
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) MethodSpec getterCodeForInput(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) FacetGenModel facet, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String name, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeAndName typeAndName) {
        DependencyModel dependencyDef;
        boolean wrapWithOptional = !facet.isMandatory() && (facet instanceof InputModel || facet instanceof DependencyModel && !(dependencyDef = (DependencyModel)facet).canFanout());
        return MethodSpec.methodBuilder((String)name).returns(wrapWithOptional ? VajramCodeGenerator.optional(this.boxPrimitive(typeAndName).typeName().withoutAnnotations()) : this.unboxPrimitive(typeAndName).typeName().withoutAnnotations()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(!wrapWithOptional ? CodeBlock.of((String)"if($L == null) {\n  throw new IllegalStateException(\"The inputDef '$L' is not optional, but has null value. This should not happen\");\n}", (Object[])new Object[]{name, name}) : CodeBlock.builder().build()).addCode(wrapWithOptional ? CodeBlock.builder().addStatement("return $T.ofNullable(this.$L)", new Object[]{Optional.class, name}).build() : CodeBlock.builder().addStatement("return this.$L", new Object[]{name}).build()).build();
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String codeGenInputUtil() {
        boolean doInputsNeedBatching = this.vajramInfo.facetStream().filter(d -> d instanceof InputModel).map(d -> (InputModel)d).anyMatch(InputModel::isBatched);
        if (doInputsNeedBatching) {
            return this.codeGenBatchedInputUtil();
        }
        return this.codeGenSimpleInputUtil();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String codeGenSimpleInputUtil() {
        TypeSpec.Builder inputUtilClass = this.createInputUtilClass();
        TypeSpec.Builder allInputsClass = this.util.classBuilder(Utils.getAllFacetsClassname(this.vajramName)).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.STATIC}).addSuperinterface(FacetContainer.class).addAnnotations(VajramCodeGenerator.recordAnnotations());
        ArrayList<FieldTypeName> fieldsList = new ArrayList<FieldTypeName>();
        this.vajramInfo.inputs().forEach(inputDef -> {
            String inputJavaName = VajramCodeGenerator.toJavaName(inputDef.name());
            TypeAndName inputType = this.getTypeName(inputDef.type(), List.of(AnnotationSpec.builder(Nullable.class).build()));
            TypeAndName boxedInputType = this.boxPrimitive(inputType);
            allInputsClass.addField(boxedInputType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            allInputsClass.addMethod(this.getterCodeForInput((FacetGenModel)inputDef, inputJavaName, inputType));
            fieldsList.add(new FieldTypeName(boxedInputType.typeName(), inputJavaName));
        });
        this.vajramInfo.dependencies().forEach(dependencyDef -> {
            String inputJavaName = VajramCodeGenerator.toJavaName(dependencyDef.name());
            TypeAndName depType = this.getDependencyOutputsType((DependencyModel)dependencyDef);
            TypeAndName boxedDepType = this.boxPrimitive(depType);
            allInputsClass.addField(boxedDepType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            allInputsClass.addMethod(this.getterCodeForInput((FacetGenModel)dependencyDef, inputJavaName, depType));
            fieldsList.add(new FieldTypeName(boxedDepType.typeName(), inputJavaName));
        });
        this.generateConstructor(fieldsList).ifPresent(arg_0 -> ((TypeSpec.Builder)allInputsClass).addMethod(arg_0));
        StringWriter writer = new StringWriter();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)inputUtilClass.addType(allInputsClass.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) MethodSpec> generateConstructor(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) FieldTypeName> fieldsList) {
        if (fieldsList.isEmpty()) {
            return Optional.empty();
        }
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder();
        fieldsList.forEach(fieldTypeName -> {
            constructor.addParameter(fieldTypeName.typeName(), fieldTypeName.name(), new Modifier[0]);
            constructor.addCode(CodeBlock.builder().addStatement("this.$L = $L", new Object[]{fieldTypeName.name(), fieldTypeName.name()}).build());
        });
        return Optional.of(constructor.build());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeAndName getDependencyOutputsType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) DependencyModel dependencyDef) {
        DataType<?> depResponseType = dependencyDef.responseType();
        if (dependencyDef.canFanout()) {
            return new TypeAndName((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(DependencyResponse.class), (TypeName[])new TypeName[]{VajramCodeGenerator.toClassName(dependencyDef.depReqClassQualifiedName()), this.boxPrimitive(this.getTypeName(depResponseType)).typeName()}));
        }
        return this.getTypeName(depResponseType, List.of(AnnotationSpec.builder(Nullable.class).build()));
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ClassName toClassName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String depReqClassName) {
        int lastDotIndex = depReqClassName.lastIndexOf(".");
        return ClassName.get((String)depReqClassName.substring(0, lastDotIndex), (String)depReqClassName.substring(lastDotIndex + 1), (String[])new String[0]);
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String codeGenBatchedInputUtil() {
        StringWriter writer = new StringWriter();
        try {
            TypeSpec.Builder inputUtilClass = this.createInputUtilClass();
            VajramInfo vajramFacetsDef = this.vajramInfo;
            String imClassName = Utils.getBatchedFacetsClassname(this.vajramName);
            String ciClassName = Utils.getCommonFacetsClassname(this.vajramName);
            FromAndTo imFromAndTo = this.fromAndToMethods(vajramFacetsDef.inputs().stream().filter(InputModel::isBatched).toList(), ClassName.get((String)this.packageName, (String)Utils.getFacetUtilClassName(this.vajramName), (String[])new String[]{imClassName}));
            TypeSpec.Builder inputsNeedingBatching = this.util.classBuilder(imClassName).addModifiers(new Modifier[]{Modifier.STATIC}).addSuperinterface(FacetValuesAdaptor.class).addAnnotations(VajramCodeGenerator.recordAnnotations()).addMethod(imFromAndTo.to()).addMethod(imFromAndTo.from());
            FromAndTo ciFromAndTo = this.fromAndToMethods(Stream.concat(vajramFacetsDef.inputs().stream().filter(inputDef -> !inputDef.isBatched()), vajramFacetsDef.dependencies().stream()).toList(), ClassName.get((String)this.packageName, (String)Utils.getFacetUtilClassName(this.vajramName), (String[])new String[]{ciClassName}));
            TypeSpec.Builder commonInputs = this.util.classBuilder(ciClassName).addModifiers(new Modifier[]{Modifier.STATIC}).addSuperinterface(FacetValuesAdaptor.class).addAnnotations(VajramCodeGenerator.recordAnnotations()).addMethod(ciFromAndTo.to()).addMethod(ciFromAndTo.from());
            ClassName batchFacetsType = ClassName.get((String)this.packageName, (String)Utils.getFacetUtilClassName(this.vajramName), (String[])new String[]{imClassName});
            ClassName commonFacetsType = ClassName.get((String)this.packageName, (String)Utils.getFacetUtilClassName(this.vajramName), (String[])new String[]{ciClassName});
            ArrayList<FieldTypeName> ciFieldsList = new ArrayList<FieldTypeName>();
            ArrayList<FieldTypeName> imFieldsList = new ArrayList<FieldTypeName>();
            vajramFacetsDef.inputs().forEach(inputDef -> {
                String inputJavaName = VajramCodeGenerator.toJavaName(inputDef.name());
                TypeAndName inputType = this.getTypeName(inputDef.type(), List.of(AnnotationSpec.builder(Nullable.class).build()));
                TypeAndName boxedInputType = this.boxPrimitive(inputType);
                if (inputDef.isBatched()) {
                    inputsNeedingBatching.addField(boxedInputType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                    inputsNeedingBatching.addMethod(this.getterCodeForInput((FacetGenModel)inputDef, inputJavaName, inputType));
                    imFieldsList.add(new FieldTypeName(boxedInputType.typeName(), inputJavaName));
                } else {
                    commonInputs.addField(boxedInputType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                    commonInputs.addMethod(this.getterCodeForInput((FacetGenModel)inputDef, inputJavaName, inputType));
                    ciFieldsList.add(new FieldTypeName(boxedInputType.typeName(), inputJavaName));
                }
            });
            vajramFacetsDef.dependencies().forEach(dependencyDef -> {
                TypeAndName depType = this.getDependencyOutputsType((DependencyModel)dependencyDef);
                String inputJavaName = VajramCodeGenerator.toJavaName(dependencyDef.name());
                TypeAndName boxedDepType = this.boxPrimitive(depType);
                commonInputs.addField(boxedDepType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                commonInputs.addMethod(this.getterCodeForInput((FacetGenModel)dependencyDef, inputJavaName, depType));
                ciFieldsList.add(new FieldTypeName(boxedDepType.typeName(), inputJavaName));
            });
            this.generateConstructor(ciFieldsList).ifPresent(arg_0 -> ((TypeSpec.Builder)commonInputs).addMethod(arg_0));
            this.generateConstructor(imFieldsList).ifPresent(arg_0 -> ((TypeSpec.Builder)inputsNeedingBatching).addMethod(arg_0));
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(FacetsConverter.class), (TypeName[])new TypeName[]{batchFacetsType, commonFacetsType});
            CodeBlock.Builder initializer = CodeBlock.builder().add("$L", new Object[]{this.util.classBuilder("").addSuperinterface((TypeName)parameterizedTypeName).addMethod(MethodSpec.methodBuilder((String)"getBatched").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)batchFacetsType).addParameter(Facets.class, "facetValues", new Modifier[0]).addStatement("return $T.from(facetValues)", new Object[]{batchFacetsType}).build()).addMethod(MethodSpec.methodBuilder((String)"getCommon").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)commonFacetsType).addParameter(Facets.class, "facetValues", new Modifier[0]).addStatement("return $T.from(facetValues)", new Object[]{commonFacetsType}).build()).build()});
            FieldSpec.Builder converter = FieldSpec.builder((TypeName)parameterizedTypeName, (String)"BATCH_CONVERTER", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC}).initializer(initializer.build());
            JavaFile.builder((String)this.packageName, (TypeSpec)inputUtilClass.addType(inputsNeedingBatching.build()).addType(commonInputs.build()).addField(converter.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) AnnotationSpec> recordAnnotations() {
        return VajramCodeGenerator.annotations(EqualsAndHashCode.class, ToString.class);
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) AnnotationSpec> annotations(Class<?> ... annotations) {
        return Arrays.stream(annotations).map(aClass -> AnnotationSpec.builder((Class)aClass).build()).toList();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeSpec.Builder createInputUtilClass() {
        TypeSpec.Builder classBuilder = this.util.classBuilder(Utils.getFacetUtilClassName(this.vajramName)).addModifiers(new Modifier[]{Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        List<FacetGenModel> facets = this.vajramInfo.facetStream().toList();
        ArrayList<FieldSpec.Builder> depSpecFields = new ArrayList<FieldSpec.Builder>(facets.size());
        for (FacetGenModel facet : facets) {
            String facetJavaName = VajramCodeGenerator.toJavaName(facet.name());
            TypeAndName facetType = this.getTypeName(this.getDataType(facet));
            TypeAndName boxedFacetType = this.boxPrimitive(facetType);
            ClassName vajramReqClass = ClassName.get((String)this.packageName, (String)this.requestClassName, (String[])new String[0]);
            String inputNameFieldName = facetJavaName + "_n";
            if (!(facet instanceof DependencyModel)) continue;
            DependencyModel vajramDepDef = (DependencyModel)facet;
            ClassName depReqClass = ClassName.bestGuess((String)vajramDepDef.depReqClassQualifiedName());
            ClassName specType = ClassName.get(vajramDepDef.canFanout() ? VajramDepFanoutTypeSpec.class : VajramDepSingleTypeSpec.class);
            FieldSpec.Builder inputSpecField = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)specType, (TypeName[])new TypeName[]{boxedFacetType.typeName(), vajramReqClass, depReqClass}), (String)(facetJavaName + "_s"), (Modifier[])new Modifier[0]).initializer("new $T<>($T.$L, $T.class, $T.class)", new Object[]{specType, vajramReqClass, inputNameFieldName, vajramReqClass, depReqClass});
            depSpecFields.add(inputSpecField.addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL}));
        }
        return classBuilder.addFields(depSpecFields.stream().map(FieldSpec.Builder::build).toList());
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String getRequestClassName() {
        return this.requestClassName;
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String getPackageName() {
        return this.packageName;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String toJavaName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String inputName) {
        return inputName;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeName optional(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeName javaType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{javaType});
    }

    private record TypeAndName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeName typeName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeMirror> type, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) AnnotationSpec> annotationSpecs) {
        private TypeAndName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeName typeName) {
            this(typeName, Optional.empty(), List.of());
        }
    }

    private record FromAndTo(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) MethodSpec from, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) MethodSpec to) {
    }

    private record FieldTypeName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeName typeName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String name) {
    }
}

