/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.models;

import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.vajram.Output;
import com.flipkart.krystal.vajram.codegen.Utils;
import com.flipkart.krystal.vajram.codegen.models.VajramInfo;
import com.flipkart.krystal.vajram.exception.VajramValidationException;
import com.flipkart.krystal.vajram.facets.resolution.sdk.Resolve;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ParsedVajramData(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String vajramName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ExecutableElement> resolvers, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ExecutableElement outputLogic, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeElement vajramClass, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String packageName, /*
 * Issues handling annotations - annotations may be inaccurate
 */
@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom ?> responseType) {
    @Generated
    private static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Logger log = LoggerFactory.getLogger(ParsedVajramData.class);

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ParsedVajramData> fromVajram(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) VajramInfo vajramInfo, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Utils util) {
        TypeElement vajramClass = vajramInfo.vajramClass();
        String packageName = vajramInfo.packageName();
        for (ExecutableElement method : ParsedVajramData.iter(ParsedVajramData.getAllMethods(vajramClass))) {
            String errorMessage = "Vajram class %s has non-static method %s".formatted(vajramInfo.vajramId(), method.getSimpleName());
            if (!ParsedVajramData.isOutputLogic(method) && !ParsedVajramData.isResolver(method) || ParsedVajramData.isStatic(method)) continue;
            util.error(errorMessage, method);
            throw new VajramValidationException(errorMessage);
        }
        ArrayList<ExecutableElement> resolverMethods = new ArrayList<ExecutableElement>();
        ExecutableElement outputLogic = ParsedVajramData.getOutputLogicAndResolverMethods(vajramClass, resolverMethods, util);
        return Optional.of(new ParsedVajramData(vajramInfo.vajramId().vajramId(), resolverMethods, outputLogic, vajramClass, packageName, vajramInfo.responseType()));
    }

    public static void validateNoDuplicateResolvers(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ExecutableElement> methods, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Utils util) {
        HashMap<String, Map> lookUpMap = new HashMap<String, Map>();
        for (ExecutableElement method : methods) {
            String[] depInputs;
            String depName = method.getAnnotation(Resolve.class).depName();
            for (String depinput : depInputs = method.getAnnotation(Resolve.class).depInputs()) {
                if (lookUpMap.getOrDefault(depName, Map.of()).getOrDefault(depinput, false).booleanValue()) {
                    String errorMessage = "Two Resolver resolving same input (%s) for dependency name (%s)".formatted(depinput, depName);
                    util.error(errorMessage, method);
                    throw new VajramValidationException(errorMessage);
                }
                lookUpMap.computeIfAbsent(depName, k -> new HashMap()).put(depinput, true);
            }
        }
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ExecutableElement getOutputLogicAndResolverMethods(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeElement vajramClass, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ExecutableElement> resolveMethods, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Utils util) {
        ExecutableElement outputLogic = null;
        List<ExecutableElement> methods = ParsedVajramData.getStaticMethods(vajramClass);
        for (ExecutableElement method : methods) {
            if (ParsedVajramData.isResolver(method)) {
                resolveMethods.add(method);
                continue;
            }
            if (!ParsedVajramData.isOutputLogic(method)) continue;
            if (outputLogic == null) {
                outputLogic = method;
                continue;
            }
            String errorMessage = "Multiple @Output annotated methods (%s, %s) found in %s".formatted(outputLogic.getSimpleName(), method.getSimpleName(), vajramClass.getSimpleName());
            util.error(errorMessage, outputLogic);
            util.error(errorMessage, method);
            throw new VajramValidationException(errorMessage);
        }
        ParsedVajramData.validateNoDuplicateResolvers(resolveMethods, util);
        if (outputLogic == null) {
            String errorMessage = "Missing output logic method";
            util.error(errorMessage, vajramClass);
            throw new VajramValidationException(errorMessage);
        }
        return outputLogic;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) boolean isResolver(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ExecutableElement method) {
        return ((Resolve[])method.getAnnotationsByType(Resolve.class)).length == 1;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) boolean isOutputLogic(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ExecutableElement method) {
        return ((Output[])method.getAnnotationsByType(Output.class)).length == 1;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ExecutableElement> getStaticMethods(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeElement vajramClass) {
        return ParsedVajramData.getAllMethods(vajramClass).filter(element -> element.getModifiers().contains((Object)Modifier.STATIC)).toList();
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Stream<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ExecutableElement> getAllMethods(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) TypeElement vajramCalss) {
        return vajramCalss.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.METHOD).map(element -> (ExecutableElement)element);
    }

    private static <T> @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Iterable<T> iter(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Stream<T> elementStream) {
        return elementStream::iterator;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) boolean isStatic(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }
}

