/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.processor;

import com.flipkart.krystal.model.ModelRoot;
import com.flipkart.krystal.vajram.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.vajram.codegen.common.models.Utils;
import com.flipkart.krystal.vajram.codegen.common.models.VajramValidationException;
import com.flipkart.krystal.vajram.codegen.common.spi.ModelsCodeGenContext;
import com.flipkart.krystal.vajram.codegen.common.spi.ModelsCodeGeneratorProvider;
import com.flipkart.krystal.vajram.codegen.processor.Constants;
import com.google.auto.service.AutoService;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.optional.qual.Present;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;

@SupportedAnnotationTypes(value={"com.flipkart.krystal.model.ModelRoot"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@SupportedOptions(value={"krystal.vajram.codegen.phase"})
@AutoService(value={Processor.class})
public final class ModelGenProcessor
extends AbstractProcessor {
    @Override
    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean process(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Set<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement> annotations, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RoundEnvironment roundEnv) {
        CodegenPhase codegenPhase;
        Utils util = new Utils(this.processingEnv, this.getClass());
        String phaseString = this.processingEnv.getOptions().get("krystal.vajram.codegen.phase");
        if (phaseString == null) {
            util.note((CharSequence)"Skipping %s since codegen phase is null".formatted(this.getClass().getSimpleName()));
            return false;
        }
        try {
            codegenPhase = CodegenPhase.valueOf((String)phaseString);
        }
        catch (IllegalArgumentException e) {
            util.error("%s could not parse phase string '%s'. Exactly one of %s must be passed as value to the java compiler via the annotation processor argument '-A%s='".formatted(this.getClass().getSimpleName(), String.valueOf(phaseString), Arrays.toString(CodegenPhase.values()), "krystal.vajram.codegen.phase"), null);
            return false;
        }
        List<TypeElement> modelRoots = roundEnv.getElementsAnnotatedWith(ModelRoot.class).stream().filter(element -> element.getKind() == ElementKind.INTERFACE).map(executableElement -> (TypeElement)executableElement).toList();
        util.note((CharSequence)"Model Roots received by %s: %s".formatted(this.getClass().getSimpleName(), modelRoots.stream().map(Objects::toString).collect(Collectors.joining(System.lineSeparator(), "[" + System.lineSeparator(), System.lineSeparator() + "]"))));
        Iterable codeGeneratorProviders = Iterables.concat(List.of(Constants.DEFAULT_MODELS_CODEGEN_PROVIDER), ServiceLoader.load(ModelsCodeGeneratorProvider.class, this.getClass().getClassLoader()));
        for (TypeElement modelRoot : modelRoots) {
            ModelsCodeGenContext creationContext = new ModelsCodeGenContext(modelRoot, util, codegenPhase);
            for (ModelsCodeGeneratorProvider customCodeGeneratorProvider : codeGeneratorProviders) {
                try {
                    customCodeGeneratorProvider.create(creationContext).generate();
                }
                catch (VajramValidationException e) {}
            }
        }
        return false;
    }
}

