/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.processor;

import com.flipkart.krystal.annos.TraitDependency;
import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.FacetValuesBuilder;
import com.flipkart.krystal.data.FacetValuesContainer;
import com.flipkart.krystal.data.FanoutDepResponses;
import com.flipkart.krystal.data.IfNull;
import com.flipkart.krystal.data.ImmutableFacetValues;
import com.flipkart.krystal.data.ImmutableFacetValuesContainer;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.data.One2OneDepResponse;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.datatypes.ApplicableToTypes;
import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.datatypes.JavaType;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.facets.FacetUtils;
import com.flipkart.krystal.facets.resolution.ResolutionTarget;
import com.flipkart.krystal.facets.resolution.ResolverCommand;
import com.flipkart.krystal.serial.ReservedSerialIds;
import com.flipkart.krystal.serial.SerialId;
import com.flipkart.krystal.vajram.IOVajramDef;
import com.flipkart.krystal.vajram.TraitRequestRoot;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramDef;
import com.flipkart.krystal.vajram.VajramDefRoot;
import com.flipkart.krystal.vajram.VajramRequestRoot;
import com.flipkart.krystal.vajram.batching.BatchEnabledFacetValues;
import com.flipkart.krystal.vajram.batching.BatchEnabledImmutableFacetValues;
import com.flipkart.krystal.vajram.batching.Batched;
import com.flipkart.krystal.vajram.batching.BatchedFacets;
import com.flipkart.krystal.vajram.batching.BatchesGroupedBy;
import com.flipkart.krystal.vajram.codegen.common.models.CodeGenParams;
import com.flipkart.krystal.vajram.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.vajram.codegen.common.models.Constants;
import com.flipkart.krystal.vajram.codegen.common.models.DefaultFacetModel;
import com.flipkart.krystal.vajram.codegen.common.models.DependencyModel;
import com.flipkart.krystal.vajram.codegen.common.models.FacetGenModel;
import com.flipkart.krystal.vajram.codegen.common.models.FacetJavaType;
import com.flipkart.krystal.vajram.codegen.common.models.ParsedVajramData;
import com.flipkart.krystal.vajram.codegen.common.models.TypeAndName;
import com.flipkart.krystal.vajram.codegen.common.models.Utils;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfoLite;
import com.flipkart.krystal.vajram.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.vajram.codegen.common.spi.VajramCodeGenContext;
import com.flipkart.krystal.vajram.facets.DependencyCommand;
import com.flipkart.krystal.vajram.facets.FacetIdNameMapping;
import com.flipkart.krystal.vajram.facets.FacetValidation;
import com.flipkart.krystal.vajram.facets.FanoutCommand;
import com.flipkart.krystal.vajram.facets.One2OneCommand;
import com.flipkart.krystal.vajram.facets.resolution.AbstractFanoutInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.AbstractOne2OneInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.FanoutInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.InputResolver;
import com.flipkart.krystal.vajram.facets.resolution.One2OneInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.Resolve;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.flipkart.krystal.vajram.facets.specs.InputMirrorSpec;
import com.flipkart.krystal.vajram.facets.specs.MandatoryFacetDefaultSpec;
import com.flipkart.krystal.vajram.facets.specs.MandatoryFanoutDepSpec;
import com.flipkart.krystal.vajram.facets.specs.MandatoryOne2OneDepSpec;
import com.flipkart.krystal.vajram.facets.specs.OptionalFacetDefaultSpec;
import com.flipkart.krystal.vajram.facets.specs.OptionalFanoutDepSpec;
import com.flipkart.krystal.vajram.facets.specs.OptionalOne2OneDepSpec;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Documented;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import lombok.EqualsAndHashCode;
import lombok.Generated;
import lombok.ToString;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.optional.qual.Present;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.aliasing.qual.NonLeaked;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VajramCodeGenerator
implements CodeGenerator {
    @Generated
    private static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Logger log = LoggerFactory.getLogger(VajramCodeGenerator.class);
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String packageName;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo currentVajramInfo;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Integer, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel> facetModels;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel> facetModelsByName;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean needsBatching;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Integer, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Boolean> depFanoutMap;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodegenPhase codegenPhase;
    private @MonotonicNonNull @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ParsedVajramData parsedVajramData;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Utils util;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String vajramName;

    public VajramCodeGenerator(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramCodeGenContext creationContext) {
        this.currentVajramInfo = creationContext.vajramInfo();
        this.packageName = creationContext.vajramInfo().lite().packageName();
        this.util = creationContext.util();
        this.facetModels = creationContext.vajramInfo().facetStream().collect(Collectors.toMap(FacetGenModel::id, Function.identity(), (o1, o2) -> o1, () -> new LinkedHashMap()));
        this.facetModelsByName = creationContext.vajramInfo().facetStream().collect(Collectors.toMap(FacetGenModel::name, Function.identity(), (o1, o2) -> o1, () -> new LinkedHashMap()));
        this.needsBatching = creationContext.vajramInfo().givenFacets().stream().anyMatch(FacetGenModel::isBatched);
        this.depFanoutMap = creationContext.vajramInfo().dependencies().stream().collect(Collectors.toMap(DependencyModel::id, DependencyModel::canFanout));
        this.codegenPhase = creationContext.codegenPhase();
        this.vajramName = this.currentVajramInfo.vajramName();
    }

    public void generate() {
        this.validate();
        if (CodegenPhase.MODELS.equals((Object)this.codegenPhase)) {
            this.vajramRequest();
            if (this.currentVajramInfo.vajramClass().getAnnotation(Vajram.class) != null) {
                this.vajramFacets();
            }
        } else if (CodegenPhase.FINAL.equals((Object)this.codegenPhase)) {
            this.vajramWrapper();
        }
    }

    private void validate() {
        this.validateIfNoValueStrategyApplicability();
        this.validateSerialIdReservations();
    }

    private void vajramRequest() {
        ClassName requestInterfaceType = this.currentVajramInfo.lite().requestInterfaceType();
        ClassName immutReqInterfaceType = this.currentVajramInfo.lite().immutReqInterfaceType();
        List<DefaultFacetModel> inputs = this.currentVajramInfo.givenFacets().stream().filter(facetDef -> facetDef.facetTypes().contains((Object)FacetType.INPUT)).toList();
        TypeSpec.Builder requestInterface = this.util.interfaceBuilder(requestInterfaceType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.currentVajramInfo.lite().isTrait() ? TraitRequestRoot.class : VajramRequestRoot.class).addSuperinterfaces(this.currentVajramInfo.requestInterfaceSuperTypes());
        FieldSpec vajramIdField = FieldSpec.builder(VajramID.class, (String)"_VAJRAM_ID", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.vajramID($S)", new Object[]{VajramID.class, this.vajramName}).addJavadoc("The VajramID for this Vajram", new Object[0]).build();
        requestInterface.addField(vajramIdField);
        requestInterface.addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(FacetValuesContainer.class, "_vajramID", 0)).addModifiers(new Modifier[]{Modifier.DEFAULT}).addStatement("return _VAJRAM_ID", new Object[0]).build());
        this.facetConstants(requestInterface, inputs, CodeGenParams.builder().isRequest(true).build());
        this.modelsClassMembers(requestInterface, requestInterfaceType, this.currentVajramInfo.facetStream().filter(facet -> facet.facetTypes().contains((Object)FacetType.INPUT)).toList(), CodeGenParams.builder().isRequest(true).isModelRoot(true).build());
        TypeSpec.Builder immutReqInterface = this.util.interfaceBuilder(immutReqInterfaceType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterfaces(this.currentVajramInfo.immutReqInterfaceSuperTypes());
        TypeSpec.Builder builderInterface = this.util.interfaceBuilder("Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addSuperinterfaces(this.currentVajramInfo.reqBuilderInterfaceSuperTypes());
        this.modelsClassMembers(builderInterface, immutReqInterfaceType, this.currentVajramInfo.facetStream().filter(facet -> facet.facetTypes().contains((Object)FacetType.INPUT)).toList(), CodeGenParams.builder().isRequest(true).isBuilderRoot(true).build());
        ClassName immutRequestPojoType = ClassName.get((String)this.packageName, (String)Utils.getImmutRequestPojoName((String)this.vajramName), (String[])new String[0]);
        ClassName pojoRequestBuilderType = immutRequestPojoType.nestedClass("Builder");
        TypeSpec.Builder immutRequestPojo = this.util.classBuilder(immutRequestPojoType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)immutReqInterfaceType);
        this.modelsClassMembers(immutRequestPojo, immutRequestPojoType, this.currentVajramInfo.facetStream().filter(facet -> facet.facetTypes().contains((Object)FacetType.INPUT)).toList(), CodeGenParams.builder().isRequest(true).withImpl(true).build());
        TypeSpec.Builder builderClass = this.util.classBuilder("Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addSuperinterface(this.currentVajramInfo.lite().builderInterfaceType());
        this.modelsClassMembers(builderClass, immutRequestPojoType, this.currentVajramInfo.facetStream().filter(facet -> facet.facetTypes().contains((Object)FacetType.INPUT)).toList(), CodeGenParams.builder().isRequest(true).isBuilder(true).withImpl(true).build());
        this.util.generateSourceFile(requestInterfaceType.canonicalName(), JavaFile.builder((String)this.packageName, (TypeSpec)requestInterface.addMethods(this.facetContainerMethods(inputs, requestInterfaceType, immutReqInterfaceType, CodeGenParams.builder().isRequest(true).build())).build()).build().toString(), this.currentVajramInfo.vajramClass());
        this.util.generateSourceFile(immutReqInterfaceType.canonicalName(), JavaFile.builder((String)this.packageName, (TypeSpec)immutReqInterface.addMethods(this.facetContainerMethods(inputs, immutReqInterfaceType, immutReqInterfaceType, CodeGenParams.builder().isRequest(true).build())).addType(builderInterface.addMethods(this.facetContainerMethods(inputs, immutReqInterfaceType, immutReqInterfaceType, CodeGenParams.builder().isRequest(true).isBuilder(true).build())).build()).build()).build().toString(), this.currentVajramInfo.vajramClass());
        this.util.generateSourceFile(immutRequestPojoType.canonicalName(), JavaFile.builder((String)this.packageName, (TypeSpec)immutRequestPojo.addMethods(this.facetContainerMethods(inputs, immutRequestPojoType, immutRequestPojoType, CodeGenParams.builder().isRequest(true).withImpl(true).build())).addMethod(MethodSpec.methodBuilder((String)"_builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)pojoRequestBuilderType).addStatement("return new $T()", new Object[]{pojoRequestBuilderType}).build()).addType(builderClass.addMethods(this.facetContainerMethods(inputs, immutRequestPojoType, immutRequestPojoType, CodeGenParams.builder().isRequest(true).isBuilder(true).withImpl(true).build())).build()).build()).build().toString(), this.currentVajramInfo.vajramClass());
    }

    public void vajramFacets() {
        this.basicFacetsClasses();
        boolean doInputsNeedBatching = this.currentVajramInfo.facetStream().anyMatch(FacetGenModel::isBatched);
        if (doInputsNeedBatching) {
            this.batchFacetsClasses();
        }
    }

    public void vajramWrapper() {
        this.initParsedVajramData();
        TypeSpec.Builder vajramWrapperClass = this.util.classBuilder(Utils.getVajramImplClassName((String)this.vajramName)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        if (this.currentVajramInfo.lite().isTrait()) {
            vajramWrapperClass.addSuperinterface((TypeName)ClassName.get((TypeElement)this.currentVajramInfo.vajramClass()));
        } else {
            vajramWrapperClass.superclass((TypeName)ClassName.get((TypeElement)this.currentVajramInfo.vajramClass()));
        }
        ClassName requestInterfaceType = this.getRequestInterfaceType();
        ClassName immutRequestType = ClassName.get((String)this.packageName, (String)Utils.getImmutRequestPojoName((String)this.vajramName), (String[])new String[0]);
        ClassName immutFacetsType = ClassName.get((String)this.packageName, (String)Utils.getImmutFacetsClassname((String)this.vajramName), (String[])new String[0]);
        if (this.currentVajramInfo.lite().isVajram()) {
            HashMap<String, List> resolverMap = new HashMap<String, List>();
            for (ExecutableElement resolver : this.getParsedVajramData().resolvers()) {
                String dependency = this.util.extractFacetName(this.vajramName, ((Resolve)Preconditions.checkNotNull((Object)resolver.getAnnotation(Resolve.class))).dep(), resolver);
                resolverMap.computeIfAbsent(dependency, _k -> new ArrayList()).add(resolver);
            }
            ClassName batchFacetsClassName = this.getBatchFacetsClassName();
            ClassName commonFacetsClassName = this.getCommonFacetsClassName();
            TypeName vajramResponseType = this.util.toTypeName(this.getParsedVajramData().vajramInfo().lite().responseType());
            MethodSpec inputResolversMethod = this.createInputResolvers();
            if (inputResolversMethod != null) {
                methodSpecs.add(inputResolversMethod);
            }
            if (this.util.isRawAssignable(this.getParsedVajramData().vajramInfo().vajramClass().asType(), IOVajramDef.class)) {
                methodSpecs.add(this.ioVajramExecuteMethod(batchFacetsClassName, commonFacetsClassName, vajramResponseType.box().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()})));
            } else {
                methodSpecs.add(this.computeVajramExecuteMethod(vajramResponseType));
            }
            vajramWrapperClass.addMethod(MethodSpec.methodBuilder((String)"facetsFromRequest").returns((TypeName)immutFacetsType.nestedClass("Builder")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Request.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}), "request", new Modifier[0]).addStatement("return new $T(($T)$L)", new Object[]{immutFacetsType.nestedClass("Builder"), this.currentVajramInfo.conformsToTraitOrSelf().requestInterfaceType(), "request"}).build());
        }
        StringWriter writer = new StringWriter();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)vajramWrapperClass.addMethods(methodSpecs).addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(VajramDefRoot.class, "newRequestBuilder", 0)).returns((TypeName)immutRequestType.nestedClass("Builder")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return $T._builder()", new Object[]{immutRequestType}).build()).addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(VajramDefRoot.class, "requestRootType", 0)).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{requestInterfaceType})).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return $T.class", new Object[]{requestInterfaceType}).build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String className = this.currentVajramInfo.lite().packageName() + "." + Utils.getVajramImplClassName((String)this.currentVajramInfo.lite().vajramId().id());
        try {
            this.util.generateSourceFile(className, writer.toString(), this.currentVajramInfo.vajramClass());
        }
        catch (Exception e) {
            StringWriter exception = new StringWriter();
            e.printStackTrace(new PrintWriter(exception));
            this.util.error("Error while generating file for class %s. Exception: %s".formatted(className, exception), (Element)this.currentVajramInfo.vajramClass());
        }
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int inferFacetId(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VariableElement parameter) {
        String facetName = parameter.getSimpleName().toString();
        FacetGenModel facetGenModel = this.facetModelsByName.get(facetName);
        if (facetGenModel == null) {
            throw this.util.errorAndThrow("Unknown facet with name %s".formatted(facetName), (Element)parameter);
        }
        return facetGenModel.id();
    }

    private @Nullable @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent MethodSpec createInputResolvers() {
        List resolvers = this.getParsedVajramData().resolvers();
        if (resolvers.isEmpty()) {
            return null;
        }
        MethodSpec.Builder getInputResolversMethod = MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(VajramDef.class, "getInputResolvers", 0));
        CodeBlock.Builder resolveMethodToObjConvCode = CodeBlock.builder();
        getInputResolversMethod.addCode("return $T.<$T>builder().addAll($L())", new Object[]{ImmutableList.class, InputResolver.class, "getSimpleInputResolvers"});
        HashMap<String, List> resolverMap = new HashMap<String, List>();
        for (ExecutableElement resolver : resolvers) {
            resolverMap.computeIfAbsent(this.util.extractFacetName(this.vajramName, Objects.requireNonNull(resolver.getAnnotation(Resolve.class)).dep(), resolver), _k -> new ArrayList()).add(resolver);
        }
        resolverMap.forEach((depName, resolverMethods) -> {
            DependencyModel dep = this.currentVajramInfo.dependencies().stream().filter(d -> d.name().equals(depName)).findAny().orElseThrow();
            for (ExecutableElement resolverMethod : resolverMethods) {
                Resolve resolve = resolverMethod.getAnnotation(Resolve.class);
                if (resolve == null) {
                    throw new AssertionError((Object)"Cannot happen");
                }
                boolean fanoutResolver = this.util.isRawAssignable(resolverMethod.getReturnType(), FanoutCommand.class);
                List<String> resolvedInputNames = Arrays.stream(resolve.depInputs()).map(di -> this.util.extractFacetName(dep.depVajramInfo().vajramId().id(), di, resolverMethod)).toList();
                Class inputResolverInterfaceClass = fanoutResolver ? FanoutInputResolver.class : One2OneInputResolver.class;
                MethodSpec.Builder resolveMethod = MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(inputResolverInterfaceClass, "resolve", 2), (DeclaredType)((DeclaredType)((TypeElement)Preconditions.checkNotNull((Object)this.util.processingEnv().getElementUtils().getTypeElement((CharSequence)Preconditions.checkNotNull((Object)inputResolverInterfaceClass.getCanonicalName())))).asType()), (Types)this.util.processingEnv().getTypeUtils()).addCode(this.buildInputResolver(resolverMethod, fanoutResolver).build());
                List<FacetGenModel> usedFacets = resolverMethod.getParameters().stream().map(this::inferFacetId).map(key -> (FacetGenModel)Preconditions.checkNotNull((Object)this.facetModels.get(key))).toList();
                resolveMethodToObjConvCode.add(".add($L)", new Object[]{TypeSpec.anonymousClassBuilder((String)"$T.of($L), new $T($T.$L, $T.of($L))", (Object[])new Object[]{ImmutableSet.class, CodeBlock.of((String)usedFacets.stream().map(_f -> "$T.$L").collect(Collectors.joining(",")), (Object[])usedFacets.stream().flatMap(facet -> Stream.of(this.getFacetsInterfaceType(), facet.name() + "_s")).toArray()), ResolutionTarget.class, this.getFacetsInterfaceType(), dep.name() + "_s", ImmutableSet.class, CodeBlock.of((String)resolvedInputNames.stream().map(_f -> "$T.$L").collect(Collectors.joining(",")), (Object[])resolvedInputNames.stream().flatMap(inputName -> Stream.of(ClassName.get((String)dep.depReqPackageName(), (String)Utils.getRequestInterfaceName((String)dep.depVajramInfo().vajramId().id()), (String[])new String[0]), inputName + "_s")).toArray())}).addSuperinterface(fanoutResolver ? AbstractFanoutInputResolver.class : AbstractOne2OneInputResolver.class).addMethod(resolveMethod.build()).build()});
            }
        });
        resolveMethodToObjConvCode.add(".build()", new Object[0]);
        return getInputResolversMethod.addStatement(resolveMethodToObjConvCode.build()).build();
    }

    private @NonNull @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ParsedVajramData initParsedVajramData() {
        if (this.parsedVajramData == null) {
            this.parsedVajramData = (ParsedVajramData)ParsedVajramData.fromVajramInfo((VajramInfo)this.currentVajramInfo, (Utils)this.util).orElseThrow(() -> this.util.errorAndThrow("Could not load Vajram class for vajramDef %s.\nParsedVajram Data should never be accessed in model generation phase.".formatted(this.currentVajramInfo.lite().vajramId()), (Element)this.currentVajramInfo.vajramClass()));
        }
        return this.parsedVajramData;
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ParsedVajramData getParsedVajramData() {
        return this.parsedVajramData != null ? this.parsedVajramData : this.initParsedVajramData();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent MethodSpec computeVajramExecuteMethod(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeName vajramResponseType) {
        MethodSpec.Builder executeBuilder = MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(VajramDef.class, "execute", 1)).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableMap.class), (TypeName[])new TypeName[]{ClassName.get(FacetValues.class), ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{vajramResponseType.box()})}));
        if (this.needsBatching) {
            this.util.error("Batching is not supported in ComputeVajrams", this.getParsedVajramData().vajramInfo().givenFacets().stream().filter(FacetGenModel::isBatched).findAny().map(DefaultFacetModel::facetField).orElse(this.getParsedVajramData().vajramInfo().vajramClass()));
        } else {
            this.nonBatchedExecuteMethodBuilder(executeBuilder, false);
        }
        return executeBuilder.build();
    }

    private void nonBatchedExecuteMethodBuilder(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent MethodSpec.Builder executeBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isIOVajram) {
        String methodCallSuffix;
        CodeBlock.Builder returnBuilder = CodeBlock.builder().add("return _facetValuesList.stream().collect(\n     $T.toImmutableMap($T.identity(),\n     $L -> {\n        $T $L = ($T)$L;\n", new Object[]{ImmutableMap.class, Function.class, "_incomingFacets", this.getFacetsInterfaceType(), "_facetValues", this.getFacetsInterfaceType(), "_incomingFacets"});
        ExecutableElement outputLogic = Objects.requireNonNull(this.getParsedVajramData().outputLogic(), "Cannot generate execute method if output logic is missing");
        outputLogic.getParameters().forEach(parameter -> this.generateFacetLocalVariable(outputLogic, (VariableElement)parameter, returnBuilder, "_facetValues"));
        if (isIOVajram) {
            TypeMirror returnType = outputLogic.getReturnType();
            if (!this.util.isRawAssignable(returnType, CompletableFuture.class)) {
                this.util.error("The OutputLogic of non-batched IO vajramDef %s must return a CompletableFuture".formatted(this.vajramName), (Element)outputLogic);
            }
            returnBuilder.add("\nreturn $L(\n", new Object[]{outputLogic.getSimpleName()});
            methodCallSuffix = ");\n";
        } else {
            returnBuilder.add("\nreturn $T.errableFrom(() -> $L(\n", new Object[]{Errable.class, outputLogic.getSimpleName()});
            methodCallSuffix = ")).toFuture();\n";
        }
        ArrayList<String> outputLogicParamsCode = new ArrayList<String>();
        ArrayList<Object> outputLogicParamsCodeArgs = new ArrayList<Object>();
        for (VariableElement variableElement : outputLogic.getParameters()) {
            this.generateLogicParams(variableElement, outputLogicParamsCode, outputLogicParamsCodeArgs);
        }
        returnBuilder.add(String.join((CharSequence)", ", outputLogicParamsCode), outputLogicParamsCodeArgs.toArray());
        returnBuilder.add(methodCallSuffix, new Object[0]);
        returnBuilder.add("}));\n", new Object[0]);
        executeBuilder.addCode(returnBuilder.build());
    }

    private void generateLogicParams(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VariableElement param, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String> outputLogicParamsCode, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> outputLogicParamsCodeArgs) {
        int facetId = this.inferFacetId(param);
        FacetGenModel facetGenModel = this.facetModels.get(facetId);
        if (facetGenModel == null) {
            throw new AssertionError((Object)"Cannot happen");
        }
        if (facetGenModel.isBatched()) {
            this.util.error("Cannot use batch facet '%s' as direct input param for output logic".formatted(facetId), (Element)param);
        } else {
            outputLogicParamsCode.add("$L");
            outputLogicParamsCodeArgs.add(facetGenModel.name());
        }
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent MethodSpec ioVajramExecuteMethod(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName batchableInputs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName commonFacets, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeName vajramResponseType) {
        MethodSpec.Builder executeMethodBuilder = MethodSpec.methodBuilder((String)"execute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{FacetValues.class}), "_facetValuesList", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableMap.class), (TypeName[])new TypeName[]{ClassName.get(FacetValues.class), ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{vajramResponseType})})).addAnnotation(Override.class);
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        if (this.needsBatching) {
            this.batchedExecuteMethodBuilder(batchableInputs, commonFacets, vajramResponseType, codeBuilder, executeMethodBuilder);
        } else {
            this.nonBatchedExecuteMethodBuilder(executeMethodBuilder, true);
        }
        return executeMethodBuilder.build();
    }

    private void batchedExecuteMethodBuilder(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName batchableInputs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName commonFacets, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeName vajramResponseType, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeBlock.Builder codeBuilder, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent MethodSpec.Builder executeMethodBuilder) {
        ExecutableElement outputLogic = Objects.requireNonNull(this.getParsedVajramData().outputLogic(), "Execute method cannot be generated without output logic");
        ImmutableMap facets = (ImmutableMap)this.currentVajramInfo.facetStream().collect(ImmutableMap.toImmutableMap(FacetGenModel::name, Function.identity()));
        TypeMirror returnType = outputLogic.getReturnType();
        Preconditions.checkState((boolean)this.util.isRawAssignable(this.util.processingEnv().getTypeUtils().erasure(returnType), Map.class), (String)"A vajramDef supporting input batching must return map. Vajram: %s", (Object)this.vajramName);
        TypeMirror mapValue = (TypeMirror)Utils.getTypeParameters((TypeMirror)returnType).get(1);
        if (!this.util.isRawAssignable(mapValue, CompletableFuture.class)) {
            this.util.error("Batched IO Vajram should return a map whose value type must be `CompletableFuture`.\nViolating vajramDef: %s".formatted(this.vajramName), (Element)outputLogic);
        }
        String batchingExecutePrepareParams = "    if($facetValuesList:L.isEmpty()) {\n      return $imMap:T.of();\n    }\n    $map:T<$inputBatching:T, $facetValues:T> _batchItems = new $linkHashMap:T<>();\n    $commonInput:T _common = (($facetsInterface:T)$facetValuesList:L.get(0))._common();\n    for ($facetValues:T $facetsVar:L : $facetValuesList:L) {\n      $facetsInterface:T _castFacets = ($facetsInterface:T) $facetsVar:L;\n      $inputBatching:T _batch = _castFacets._batchItem();\n      _batchItems.put(_batch, $facetsVar:L);\n    }\n";
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("facetValues", ClassName.get(FacetValues.class));
        valueMap.put("facetValuesList", "_facetValuesList");
        valueMap.put("facetsVar", "_facetValues");
        valueMap.put("facetsInterface", ClassName.get((String)this.packageName, (String)Utils.getFacetsInterfaceName((String)this.vajramName), (String[])new String[0]));
        valueMap.put("inputBatching", batchableInputs);
        valueMap.put("commonInput", commonFacets);
        valueMap.put("facetJavaType", vajramResponseType);
        valueMap.put("outputLogicMethod", outputLogic.getSimpleName());
        valueMap.put("modInput", ClassName.get(BatchedFacets.class));
        valueMap.put("imMap", ClassName.get(ImmutableMap.class));
        valueMap.put("imList", ClassName.get(ImmutableList.class));
        valueMap.put("comFuture", ClassName.get(CompletableFuture.class));
        valueMap.put("linkHashMap", ClassName.get(LinkedHashMap.class));
        valueMap.put("map", ClassName.get(Map.class));
        valueMap.put("list", ClassName.get(List.class));
        valueMap.put("valErr", Errable.class);
        valueMap.put("function", ClassName.get(Function.class));
        valueMap.put("optional", ClassName.get(Optional.class));
        codeBuilder.addNamed(batchingExecutePrepareParams, valueMap);
        for (VariableElement variableElement : outputLogic.getParameters()) {
            if (variableElement.getSimpleName().contentEquals("_batchItems")) {
                TypeMirror paramType = variableElement.asType();
                List list = Utils.getTypeParameters((TypeMirror)paramType);
                TypeMirror expected = ((TypeElement)Preconditions.checkNotNull((Object)this.util.processingEnv().getElementUtils().getTypeElement(this.getBatchFacetsClassName().canonicalName()))).asType();
                if (this.util.processingEnv().getTypeUtils().isSameType(Objects.requireNonNull(this.util.processingEnv().getTypeUtils().asElement(paramType)).asType(), Objects.requireNonNull(this.util.processingEnv().getElementUtils().getTypeElement(Objects.requireNonNull(ImmutableCollection.class.getCanonicalName()))).asType()) && list.size() == 1 && this.util.processingEnv().getTypeUtils().isSameType(expected, (TypeMirror)list.get(0))) continue;
                this.util.error("Batch of facetValues param must be of ImmutableCollection<" + expected + "> . Found: " + paramType, (Element)variableElement);
                continue;
            }
            FacetGenModel facet = (FacetGenModel)facets.get((Object)variableElement.getSimpleName().toString());
            if (facet == null) {
                this.util.error("No facet with the name " + variableElement.getSimpleName() + " exists in the vajramDef " + this.currentVajramInfo.lite().vajramId(), (Element)variableElement);
            } else if (!facet.isUsedToGroupBatches()) {
                this.util.error("Facet '" + facet.name() + "' can be accessed individually in the output logic only if it has been annotated as @" + BatchesGroupedBy.class.getSimpleName(), (Element)variableElement);
            }
            this.generateFacetLocalVariable(outputLogic, variableElement, codeBuilder, "_common");
        }
        codeBuilder.add("var _output = $L(", new Object[]{outputLogic.getSimpleName()});
        ArrayList<String> outputLogicParamsCode = new ArrayList<String>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (VariableElement variableElement : outputLogic.getParameters()) {
            if (variableElement.getSimpleName().contentEquals("_batchItems")) {
                outputLogicParamsCode.add("$T.copyOf($L.keySet())");
                arrayList.add(ImmutableList.class);
                arrayList.add("_batchItems");
                continue;
            }
            this.generateLogicParams(variableElement, outputLogicParamsCode, arrayList);
        }
        codeBuilder.add(String.join((CharSequence)", ", outputLogicParamsCode), arrayList.toArray());
        codeBuilder.add(");", new Object[0]);
        codeBuilder.addNamed("    $map:T<$facetValues:T, $comFuture:T<$facetJavaType:T>> _returnValue = new $linkHashMap:T<>();\n\n    _output.forEach((_batch, _result) -> _returnValue.put(\n          $optional:T.ofNullable(_batchItems.get(_batch)).orElseThrow(),\n          _result.<$facetJavaType:T>thenApply($function:T.identity())));\n    return $imMap:T.copyOf(_returnValue);\n", valueMap);
        executeMethodBuilder.addCode(codeBuilder.build());
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeBlock.Builder buildInputResolver(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement method, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean fanoutResolver) {
        Resolve resolve = (Resolve)Preconditions.checkNotNull((Object)method.getAnnotation(Resolve.class), (Object)"Resolver method must have 'Resolve' annotation");
        String depName = this.util.extractFacetName(this.vajramName, resolve.dep(), method);
        FacetGenModel facetGenModel = (FacetGenModel)Preconditions.checkNotNull((Object)this.facetModelsByName.get(depName));
        if (!(facetGenModel instanceof DependencyModel)) {
            this.util.error("No facet definition found for " + facetGenModel.name(), (Element)method);
            return CodeBlock.builder();
        }
        DependencyModel dependencyModel = (DependencyModel)facetGenModel;
        VajramID depVajramName = dependencyModel.depVajramInfo().vajramId();
        String depRequestPackage = dependencyModel.depReqPackageName();
        ClassName requestBuilderType = ClassName.get((String)depRequestPackage, (String)Utils.getImmutRequestInterfaceName((String)depVajramName.id()), (String[])new String[0]).nestedClass("Builder");
        CodeBlock.Builder codeBuilder = fanoutResolver ? CodeBlock.builder().addStatement("var $2L = (($1T)_depRequest)", new Object[]{requestBuilderType, "_resolverRequest"}) : CodeBlock.builder().addStatement("var $2L = (($1T)_depRequests)", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableList.class), (TypeName[])new TypeName[]{requestBuilderType}), "_resolverRequests"});
        codeBuilder.addStatement("var $L = (($T)_rawFacetValues)", new Object[]{"_facetValues", this.getFacetsInterfaceType()});
        method.getParameters().forEach(parameter -> this.generateFacetLocalVariable(method, (VariableElement)parameter, codeBuilder, "_facetValues"));
        this.buildResolverInvocation(codeBuilder, method, dependencyModel, Arrays.stream(resolve.depInputs()).map(di -> this.util.extractFacetName(dependencyModel.depVajramInfo().vajramId().id(), di, method)).collect(LinkedHashSet::new, HashSet::add, AbstractCollection::addAll), fanoutResolver, requestBuilderType);
        return codeBuilder;
    }

    private void generateFacetLocalVariable(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement method, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VariableElement parameter, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeBlock.Builder codeBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String facetsVar) {
        int usingFacetId = this.inferFacetId(parameter);
        FacetGenModel usingFacetModel = (FacetGenModel)Preconditions.checkNotNull((Object)this.facetModels.get(usingFacetId));
        if (usingFacetModel instanceof DependencyModel) {
            this.generateDependencyResolutions(method, usingFacetId, codeBuilder, parameter);
        } else if (usingFacetModel instanceof DefaultFacetModel) {
            DefaultFacetModel defaultFacetModel = (DefaultFacetModel)usingFacetModel;
            TypeMirror facetType = this.util.toTypeMirror(defaultFacetModel.dataType());
            String variable = usingFacetModel.name();
            TypeMirror parameterTypeMirror = parameter.asType();
            TypeName parameterType = TypeName.get((TypeMirror)parameterTypeMirror);
            if (defaultFacetModel.isMandatoryOnServer()) {
                if (!this.util.processingEnv().getTypeUtils().isAssignable(facetType, parameterTypeMirror)) {
                    this.util.error("Incorrect facet type being consumed. Expected '%s', found '%s'".formatted(facetType, parameterType), (Element)parameter);
                }
                codeBuilder.add(CodeBlock.builder().addStatement("var $L = $T.validateMandatoryFacet($L.$L(), $S, $S)", new Object[]{variable, FacetValidation.class, facetsVar, usingFacetModel.name(), this.currentVajramInfo.lite().vajramId().id(), usingFacetModel.name()}).build());
            } else if (this.util.isRawAssignable(parameterTypeMirror, Optional.class)) {
                codeBuilder.add(CodeBlock.builder().addStatement("var $L = $T.ofNullable($L.$L())", new Object[]{variable, Optional.class, facetsVar, usingFacetModel.name()}).build());
            } else {
                this.util.error(String.format("Optional dependency %s must have type as Optional", usingFacetModel.name()), (Element)parameter);
            }
        } else {
            this.util.error("No facetDef resolver found for " + usingFacetModel.name(), (Element)parameter);
        }
    }

    private void generateDependencyResolutions(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement method, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int usingFacetId, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeBlock.Builder ifBlockBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VariableElement parameter) {
        FacetGenModel usingFacetDef = (FacetGenModel)Preconditions.checkNotNull((Object)this.facetModels.get(usingFacetId));
        TypeMirror parameterType = parameter.asType();
        String usingFacetName = usingFacetDef.name();
        if (usingFacetDef instanceof DependencyModel) {
            DependencyModel dependencyModel = (DependencyModel)usingFacetDef;
            String variableName = usingFacetName;
            VajramInfoLite depVajramInfoLite = dependencyModel.depVajramInfo();
            TypeName boxedDepType = this.util.toTypeName(depVajramInfoLite.responseType()).box();
            TypeName unboxedDepType = boxedDepType.isBoxedPrimitive() ? boxedDepType.unbox() : boxedDepType;
            String logicName = method.getSimpleName().toString();
            if (this.depFanoutMap.getOrDefault(usingFacetId, false).booleanValue()) {
                boolean typeMismatch = false;
                if (!this.util.isRawAssignable(parameterType, FanoutDepResponses.class)) {
                    typeMismatch = true;
                } else if (Utils.getTypeParameters((TypeMirror)parameterType).size() != 2) {
                    typeMismatch = true;
                }
                if (typeMismatch) {
                    this.util.error("The fanout dependency ('%s') can be consumed only via the FanoutDepResponses<ReqType,RespType> class. Found '%s' instead".formatted(dependencyModel.name(), parameterType), (Element)parameter);
                }
                String depValueAccessorCode = "$T $L = $L.$L()";
                ifBlockBuilder.addStatement(depValueAccessorCode, new Object[]{this.util.responsesType(dependencyModel), variableName, "_facetValues", usingFacetName});
            } else {
                String depAccessLhs = "$1T $2L";
                String depAccessRhs = "$3L.$4L()";
                String depValueAccessorCode = depAccessLhs + " = " + depAccessRhs;
                if (usingFacetDef.isMandatoryOnServer()) {
                    if (unboxedDepType.equals((Object)TypeName.get((TypeMirror)parameterType))) {
                        ifBlockBuilder.addStatement(depAccessLhs + "= $5T.validateMandatoryFacet(" + depAccessRhs + ".response().valueOpt().orElse(null), $6S, $7S)", new Object[]{unboxedDepType, variableName, "_facetValues", usingFacetName, FacetValidation.class, this.currentVajramInfo.lite().vajramId().id(), usingFacetName});
                    } else {
                        this.util.error("A resolver must consume a mandatory dependency directly using its type (%s). Found '%s' instead".formatted(unboxedDepType, parameterType), (Element)parameter);
                    }
                } else if (this.util.isRawAssignable(parameterType, Errable.class)) {
                    ifBlockBuilder.addStatement(depValueAccessorCode + ".response()", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Errable.class), (TypeName[])new TypeName[]{boxedDepType}), variableName, "_facetValues", usingFacetName});
                } else if (this.util.isRawAssignable(parameterType, Optional.class)) {
                    String code = depValueAccessorCode + ".response().valueOpt()";
                    ifBlockBuilder.addStatement(code, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{boxedDepType}), variableName, "_facetValues", usingFacetName});
                } else if (this.util.isRawAssignable(parameterType, One2OneDepResponse.class)) {
                    ifBlockBuilder.addStatement(depValueAccessorCode, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{boxedDepType}), variableName, "_facetValues", usingFacetName});
                } else {
                    this.util.error("A resolver ('%s') must not access an optional dependency ('%s') directly.Use Optional<>, Errable<>, or DependencyResponse<> instead".formatted(logicName, usingFacetName), (Element)parameter);
                }
            }
        }
    }

    private void buildResolverInvocation(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeBlock.Builder methodCodeBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement resolverMethod, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependencyModel dependencyModel, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Set<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String> depInputNames, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean fanoutResolver, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName requestBuilderType) {
        String resolverResultVar = fanoutResolver ? "_resolverResults" : "_resolverResult";
        methodCodeBuilder.add("var $L = $L(", new Object[]{resolverResultVar, resolverMethod.getSimpleName()});
        ImmutableList resolverSources = this.getResolverSources(resolverMethod).asList();
        for (int i = 0; i < resolverSources.size(); ++i) {
            int facetId = (Integer)resolverSources.get(i);
            String facetName = ((FacetGenModel)Preconditions.checkNotNull((Object)this.facetModels.get(facetId))).name();
            methodCodeBuilder.add("$L", new Object[]{facetName});
            if (i == resolverMethod.getParameters().size() - 1) continue;
            methodCodeBuilder.add(", ", new Object[0]);
        }
        methodCodeBuilder.add(");\n", new Object[0]);
        TypeMirror returnType = this.util.box(resolverMethod.getReturnType());
        boolean resolverReturnedDepCommand = false;
        if (this.util.isRawAssignable(returnType, DependencyCommand.class)) {
            resolverReturnedDepCommand = true;
            methodCodeBuilder.beginControlFlow("if($L.shouldSkip())", new Object[]{resolverResultVar});
            methodCodeBuilder.addStatement("\t return $T.skip($L.doc(), $L.skipCause())", new Object[]{ResolverCommand.class, resolverResultVar, resolverResultVar});
            methodCodeBuilder.add("} else {\n\t", new Object[0]);
            TypeMirror actualReturnType = (TypeMirror)Utils.getTypeParameters((TypeMirror)returnType).get(0);
            if (this.util.isRawAssignable(returnType, One2OneCommand.class)) {
                methodCodeBuilder.beginControlFlow("for($T $L: $L)", new Object[]{requestBuilderType, "_resolverRequest", "_resolverRequests"});
                if (this.util.isRawAssignable(actualReturnType, Request.class)) {
                    for (String depInputName : depInputNames) {
                        methodCodeBuilder.addStatement("$L.ifPresent(_r -> $L.$L(_r.$L()))", new Object[]{"_resolverResult", "_resolverRequest", depInputName, depInputName});
                    }
                } else {
                    if (depInputNames.size() != 1) {
                        this.util.error("Resolver method which resolves multiple dependency inputs must return a Request Builder object", (Element)resolverMethod);
                    }
                    String depFacetName = depInputNames.iterator().next();
                    methodCodeBuilder.addStatement("$L.ifPresent($L::$L)", new Object[]{"_resolverResult", "_resolverRequest", depFacetName});
                }
                methodCodeBuilder.endControlFlow();
            } else if (this.util.isRawAssignable(returnType, FanoutCommand.class)) {
                if (!dependencyModel.canFanout()) {
                    this.util.error("Dependency '%s' is not a fanout dependency, yet the resolver method returns a MultiExecute command.This is not allowed. Return a SingleExecute command, a single value, or mark the dependency as `canFanout = true`.".formatted(dependencyModel.name()), (Element)resolverMethod);
                }
                methodCodeBuilder.addStatement("var $L = new $T()", new Object[]{"_resolverRequests", ParameterizedTypeName.get((ClassName)ClassName.get(ArrayList.class), (TypeName[])new TypeName[]{requestBuilderType})});
                if (this.util.isRawAssignable(actualReturnType, ImmutableRequest.Builder.class) && depInputNames.size() <= 1) {
                    this.util.error("Resolver method that returns a request builder object must resolve multiple dependency inputs. Otherwise this can lead to unnecessary creation of request builder objects.", (Element)resolverMethod);
                }
                methodCodeBuilder.beginControlFlow("for($T $L: $L.inputs())", new Object[]{actualReturnType, "_resolverResult", "_resolverResults"});
                if (this.util.isRawAssignable(actualReturnType, ImmutableRequest.Builder.class)) {
                    methodCodeBuilder.add("$L.add($L._newCopy()", new Object[]{"_resolverRequests", "_resolverRequest"});
                    for (String depFacetName : depInputNames) {
                        methodCodeBuilder.add(".$L($L.$L())", new Object[]{depFacetName, "_resolverResult", depFacetName});
                    }
                    methodCodeBuilder.add(");", new Object[0]);
                } else {
                    if (depInputNames.size() > 1) {
                        this.util.error("Resolver method which resolves multiple dependency inputs must return a %s object".formatted(ImmutableRequest.Builder.class), (Element)resolverMethod);
                    }
                    String depFacetName = depInputNames.iterator().next();
                    methodCodeBuilder.addStatement("$L.add($L._newCopy().$L($L))", new Object[]{"_resolverRequests", "_resolverRequest", depFacetName, "_resolverResult"});
                }
                methodCodeBuilder.endControlFlow();
            }
        } else if (this.util.isRawAssignable(returnType, Request.class)) {
            methodCodeBuilder.beginControlFlow("for($T $L: $L)", new Object[]{requestBuilderType, "_resolverRequest", "_resolverRequests"});
            for (String depFacetName : depInputNames) {
                methodCodeBuilder.addStatement("$L.$L($L.$L())", new Object[]{"_resolverRequest", depFacetName, "_resolverResult", depFacetName});
            }
            methodCodeBuilder.endControlFlow();
        } else {
            methodCodeBuilder.beginControlFlow("for($T $L: $L)", new Object[]{requestBuilderType, "_resolverRequest", "_resolverRequests"});
            if (depInputNames.size() != 1) {
                this.util.error("Resolver method which resolves multiple dependency inputs must return a Request object", (Element)resolverMethod);
            }
            String depFacetName = depInputNames.iterator().next();
            methodCodeBuilder.addStatement("$L.$L($L)\n", new Object[]{"_resolverRequest", depFacetName, "_resolverResult"});
            methodCodeBuilder.endControlFlow();
        }
        if (fanoutResolver) {
            methodCodeBuilder.addStatement("return $T.executeWithRequests($T.copyOf($L))", new Object[]{ResolverCommand.class, ImmutableList.class, "_resolverRequests"});
        } else {
            methodCodeBuilder.addStatement("return $T.executeWithRequests($L)", new Object[]{ResolverCommand.class, "_resolverRequests"});
        }
        if (resolverReturnedDepCommand) {
            methodCodeBuilder.endControlFlow();
        }
    }

    private void modelsClassMembers(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeSpec.Builder classSpec, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName enclosingClassType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel> eligibleFacets, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenParams codeGenParams) {
        if (codeGenParams.wrapsRequest() && codeGenParams.isRequest()) {
            throw new IllegalArgumentException("A request cannot wrap another request - this is a bug");
        }
        MethodSpec.Builder fullConstructor = MethodSpec.constructorBuilder();
        ClassName immutRequestType = this.currentVajramInfo.conformsToTraitOrSelf().immutReqInterfaceType();
        if (codeGenParams.withImpl()) {
            classSpec.addAnnotations((Iterable)(codeGenParams.isBuilder() ? List.of(AnnotationSpec.builder(ToString.class).addMember("doNotUseGetters", "true", new Object[0]).build()) : Utils.recordAnnotations()));
            if (codeGenParams.wrapsRequest()) {
                ClassName requestOrBuilderType = codeGenParams.isBuilder() ? immutRequestType.nestedClass("Builder") : immutRequestType;
                fullConstructor.addParameter(ParameterSpec.builder((TypeName)requestOrBuilderType, (String)"_request", (Modifier[])new Modifier[0]).build());
                fullConstructor.addStatement("this._request = _request", new Object[0]);
                FieldSpec.Builder builder = FieldSpec.builder((TypeName)requestOrBuilderType, (String)"_request", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                if (!codeGenParams.isBuilder()) {
                    builder.addModifiers(new Modifier[]{Modifier.FINAL});
                }
                classSpec.addField(builder.build());
            }
            if (codeGenParams.isFacetsSubset() && codeGenParams.isBuilder()) {
                MethodSpec.Builder requestConstructor = MethodSpec.constructorBuilder();
                requestConstructor.addParameter(ParameterSpec.builder((TypeName)this.currentVajramInfo.conformsToTraitOrSelf().requestInterfaceType(), (String)"_request", (Modifier[])new Modifier[0]).addAnnotation(NonNull.class).build());
                for (FacetGenModel facetGenModel : eligibleFacets) {
                    if (!facetGenModel.facetTypes().contains((Object)FacetType.INPUT)) continue;
                    requestConstructor.addStatement("this.$L = $T.$L.getFromRequest(_request)", new Object[]{facetGenModel.name(), this.getRequestInterfaceType(), facetGenModel.name() + "_s"});
                }
                classSpec.addMethod(requestConstructor.build());
            }
        }
        for (FacetGenModel facetGenModel : eligibleFacets) {
            FacetJavaType facetJavaType = this.util.getFacetFieldType(facetGenModel);
            ParameterSpec facetParam = ParameterSpec.builder((TypeName)facetJavaType.javaTypeName(facetGenModel).annotated(Utils.annotations((Class[])facetJavaType.typeAnnotations(facetGenModel, codeGenParams))), (String)facetGenModel.name(), (Modifier[])new Modifier[0]).build();
            boolean isInput = facetGenModel.facetTypes().contains((Object)FacetType.INPUT);
            if (!(!codeGenParams.withImpl() || isInput && codeGenParams.wrapsRequest())) {
                boolean usePlatformDefault;
                FieldSpec.Builder facetField = FieldSpec.builder((TypeName)facetJavaType.javaTypeName(facetGenModel).annotated(Utils.annotations((Class[])facetJavaType.typeAnnotations(facetGenModel, codeGenParams))), (String)facetGenModel.name(), (Modifier[])new Modifier[]{Modifier.PRIVATE});
                if (codeGenParams.isBuilder()) {
                    facetField.initializer(facetJavaType.fieldInitializer(facetGenModel));
                } else {
                    facetField.addModifiers(new Modifier[]{Modifier.FINAL});
                }
                classSpec.addField(facetField.build());
                fullConstructor.addParameter(facetParam);
                IfNull ifNull = facetGenModel.facetField().getAnnotation(IfNull.class);
                boolean bl = usePlatformDefault = ifNull != null && ifNull.value().usePlatformDefault();
                if (usePlatformDefault && !codeGenParams.isBuilder()) {
                    fullConstructor.addStatement("this.$L = $L != null ? $L : $T.$L.getPlatformDefaultValue()", new Object[]{facetGenModel.name(), facetGenModel.name(), facetGenModel.name(), this.getRequestInterfaceType(), facetGenModel.name() + "_s"});
                } else {
                    fullConstructor.addStatement("this.$L = $L", new Object[]{facetGenModel.name(), facetGenModel.name()});
                }
            }
            this.createFacetGetter(classSpec, facetGenModel, codeGenParams);
            if (!codeGenParams.isBuilder()) continue;
            MethodSpec.Builder setterBuilder = MethodSpec.methodBuilder((String)facetGenModel.name()).returns((TypeName)enclosingClassType.nestedClass("Builder")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(facetParam);
            if (codeGenParams.isBuilderRoot()) {
                String documentation = facetGenModel.documentation();
                setterBuilder.addJavadoc("Sets the facet '$L'$L\n@param $L the value to set\n@return this builder for method chaining", new Object[]{facetGenModel.name(), documentation == null ? "\n" : ":\n<p>" + documentation, facetGenModel.name()});
            }
            if (codeGenParams.withImpl()) {
                setterBuilder.addStatement(isInput && codeGenParams.wrapsRequest() ? CodeBlock.of((String)"this._request.$L($L)", (Object[])new Object[]{facetGenModel.name(), facetGenModel.name()}) : CodeBlock.of((String)"this.$L = $L", (Object[])new Object[]{facetGenModel.name(), facetGenModel.name()})).addStatement("return this", new Object[]{facetGenModel.name()});
            } else {
                setterBuilder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
            }
            classSpec.addMethod(setterBuilder.build());
        }
        if (codeGenParams.withImpl()) {
            classSpec.addMethod(fullConstructor.build());
        }
        if (codeGenParams.isBuilder() && codeGenParams.withImpl() && !fullConstructor.parameters.isEmpty()) {
            classSpec.addMethod(MethodSpec.constructorBuilder().addCode(codeGenParams.wrapsRequest() ? CodeBlock.builder().addStatement("this._request = $T._builder()", new Object[]{this.currentVajramInfo.lite().immutReqPojoType()}).build() : CodeBlock.builder().build()).build());
        }
        if (codeGenParams.isBuilder() && codeGenParams.withImpl() && !codeGenParams.isRequest() && !codeGenParams.isFacetsSubset()) {
            classSpec.addMethod(MethodSpec.constructorBuilder().addParameter(ParameterSpec.builder((TypeName)this.currentVajramInfo.conformsToTraitOrSelf().requestInterfaceType(), (String)"_request", (Modifier[])new Modifier[0]).build()).addStatement("this._request = _request._asBuilder()", new Object[0]).build());
        }
    }

    private void createFacetGetter(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeSpec.Builder clazz, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel facet, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenParams codeGenParams) {
        String documentation;
        FacetJavaType fieldType = this.util.getFacetFieldType(facet);
        FacetJavaType returnType = this.util.facetJavaType(facet, codeGenParams);
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)facet.name()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(returnType.javaTypeName(facet).annotated(Utils.annotations((Class[])returnType.typeAnnotations(facet, codeGenParams))));
        if (codeGenParams.isModelRoot() && (documentation = facet.documentation()) != null && !documentation.trim().isEmpty()) {
            method.addJavadoc("$L", new Object[]{documentation});
        }
        if (codeGenParams.withImpl()) {
            method.addStatement(fieldType.fieldGetterCode(facet, codeGenParams));
        } else {
            method.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        clazz.addMethod(method.build());
    }

    private void validateSerialIdReservations() {
        ReservedSerialIds reservedSerialIds = this.currentVajramInfo.vajramClass().getAnnotation(ReservedSerialIds.class);
        if (reservedSerialIds == null) {
            return;
        }
        Set reservedIdSet = (Set)Arrays.stream(reservedSerialIds.value()).boxed().collect(ImmutableSet.toImmutableSet());
        for (FacetGenModel facet : this.facetModelsByName.values()) {
            SerialId facetSerialId = facet.facetField().getAnnotation(SerialId.class);
            if (facetSerialId == null || !reservedIdSet.contains(facetSerialId.value())) continue;
            this.util.error(String.format("SerialId %d on facet '%s' in Vajram '%s' conflicts with a reserved ID. This ID is reserved via the @ReservedSerialIds annotation on the Vajram class.", facetSerialId.value(), facet.name(), this.currentVajramInfo.vajramClass().getSimpleName()), (Element)facet.facetField());
        }
    }

    private void validateIfNoValueStrategyApplicability() {
        for (FacetGenModel facet : this.facetModelsByName.values()) {
            IfNull.IfNullThen ifNullThen;
            VariableElement facetField = facet.facetField();
            IfNull ifNull = facetField.getAnnotation(IfNull.class);
            if (ifNull != null && (ifNullThen = ifNull.value()).usePlatformDefault() && facet.facetTypes().contains((Object)FacetType.DEPENDENCY)) {
                this.util.error("Defaulting to a platform default value is not supported for dependency facets.", (Element)facetField);
            }
            DataType dataType = this.util.getDataType(facet);
            VajramCodeGenerator.validateIfNoValueStrategyApplicability(facetField, dataType, this.util);
        }
    }

    static void validateIfNoValueStrategyApplicability(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Element typedElement, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?> dataType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Utils util) {
        IfNull ifNull = typedElement.getAnnotation(IfNull.class);
        if (ifNull != null) {
            ApplicableToTypes applicableToTypes;
            IfNull.IfNullThen ifNullThen = ifNull.value();
            try {
                applicableToTypes = IfNull.IfNullThen.class.getField(ifNullThen.name()).getAnnotation(ApplicableToTypes.class);
            }
            catch (NoSuchFieldException e) {
                throw util.errorAndThrow("Failed to access field " + ifNullThen.name() + " in IfNoValue.Strategy enum", typedElement);
            }
            if (applicableToTypes != null) {
                List<JavaType> applicableTypes = Arrays.stream(applicableToTypes.value()).map(x$0 -> JavaType.create((Class)x$0, (DataType[])new DataType[0])).toList();
                boolean isApplicableToAll = applicableToTypes.all();
                ProcessingEnvironment processingEnv = util.processingEnv();
                Types typeUtils = processingEnv.getTypeUtils();
                TypeMirror rawFacetType = typeUtils.erasure(dataType.javaModelType(processingEnv));
                if (!applicableTypes.isEmpty()) {
                    boolean isCompatible = false;
                    for (JavaType applicableType : applicableTypes) {
                        if (!typeUtils.isSameType(rawFacetType, applicableType.javaModelType(processingEnv))) continue;
                        isCompatible = true;
                        break;
                    }
                    if (!isCompatible) {
                        util.error(String.format("The IfNoValue.Strategy.%s is not applicable to data with type '%s'. This strategy is only applicable to the following types: %s", ifNullThen.name(), rawFacetType, applicableTypes.stream().map(JavaType::canonicalClassName).collect(Collectors.joining(","))), typedElement);
                    }
                } else if (!isApplicableToAll) {
                    util.error(String.format("The IfNoValue.Strategy.%s is not applicable to data of type '%s'. This strategy is not applicable to any types.", ifNullThen.name(), rawFacetType), typedElement);
                }
            }
        }
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableList<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent MethodSpec> facetContainerMethods(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel> eligibleFacets, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName enclosingClassName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName immutableClassName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenParams codeGenParams) {
        ArrayList<MethodSpec.Builder> methodBuilders = new ArrayList<MethodSpec.Builder>();
        String constructorParamString = (codeGenParams.isRequest() ? eligibleFacets.stream().map(FacetGenModel::name) : (codeGenParams.wrapsRequest() ? Stream.concat(Stream.of("%s"), eligibleFacets.stream().filter(f -> !f.facetTypes().contains((Object)FacetType.INPUT)).map(FacetGenModel::name)) : eligibleFacets.stream().map(FacetGenModel::name))).collect(Collectors.joining(", "));
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"_build").returns((TypeName)immutableClassName);
        if (codeGenParams.withImpl()) {
            methodBuilder.addStatement(codeGenParams.isBuilder() ? "return new %s(%s)".formatted(immutableClassName.simpleName(), constructorParamString.formatted(codeGenParams.wrapsRequest() ? "_request._build()" : "_batchable._build(), _common._build()")) : "return this", new Object[0]);
        } else {
            methodBuilder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        methodBuilders.add(methodBuilder);
        methodBuilder = MethodSpec.methodBuilder((String)"_asBuilder").returns((TypeName)immutableClassName.nestedClass("Builder"));
        if (codeGenParams.withImpl()) {
            methodBuilder.addStatement(codeGenParams.isBuilder() ? "return this" : "return new Builder(%s)".formatted(constructorParamString.formatted(codeGenParams.wrapsRequest() ? "_request._asBuilder()" : "_batchable._asBuilder(), _common._asBuilder()")), new Object[0]);
        } else {
            methodBuilder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        methodBuilders.add(methodBuilder);
        methodBuilder = MethodSpec.methodBuilder((String)"_newCopy").returns((TypeName)(codeGenParams.isBuilder() ? enclosingClassName.nestedClass("Builder") : enclosingClassName));
        if (codeGenParams.withImpl()) {
            methodBuilder.addStatement(codeGenParams.isBuilder() ? "return new Builder(%s)".formatted(constructorParamString.formatted(codeGenParams.wrapsRequest() ? "_request._newCopy()" : "_batchable._newCopy(), _common._newCopy()")) : "return this", new Object[0]);
        } else {
            methodBuilder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        methodBuilders.add(methodBuilder);
        ImmutableList.Builder list = ImmutableList.builder();
        for (MethodSpec.Builder b : methodBuilders) {
            if (b == null) continue;
            MethodSpec build = b.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).build();
            list.add((Object)build);
        }
        return list.build();
    }

    private void basicFacetsClasses() {
        StringWriter writer;
        boolean doInputsNeedBatching = this.currentVajramInfo.facetStream().anyMatch(FacetGenModel::isBatched);
        List<FacetGenModel> allFacets = this.currentVajramInfo.facetStream().toList();
        ClassName facetsType = this.getFacetsInterfaceType();
        ClassName immutableFacetsType = ClassName.get((String)this.packageName, (String)Utils.getImmutFacetsClassname((String)this.vajramName), (String[])new String[0]);
        TypeSpec.Builder facetsInterface = this.util.interfaceBuilder(Utils.getFacetsInterfaceName((String)this.vajramName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(doInputsNeedBatching ? BatchEnabledFacetValues.class : FacetValues.class);
        facetsInterface.addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(FacetValuesContainer.class, "_vajramID", 0)).addModifiers(new Modifier[]{Modifier.DEFAULT}).addStatement("return $T._VAJRAM_ID", new Object[]{this.getRequestInterfaceType()}).build());
        this.facetConstants(facetsInterface, this.currentVajramInfo.facetStream().toList(), CodeGenParams.builder().build());
        allFacets.forEach(facet -> this.createFacetGetter(facetsInterface, (FacetGenModel)facet, CodeGenParams.builder().wrapsRequest(true).build()));
        TypeSpec.Builder immutFacetsClass = this.util.classBuilder(Utils.getImmutFacetsClassname((String)this.vajramName)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)facetsType).addSuperinterface(doInputsNeedBatching ? BatchEnabledImmutableFacetValues.class : ImmutableFacetValues.class);
        this.modelsClassMembers(immutFacetsClass, immutableFacetsType, allFacets, CodeGenParams.builder().wrapsRequest(true).withImpl(true).build());
        TypeSpec.Builder facetsBuilderClass = this.util.classBuilder("Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addSuperinterface((TypeName)facetsType).addSuperinterface(doInputsNeedBatching ? BatchEnabledImmutableFacetValues.Builder.class : FacetValuesBuilder.class);
        this.modelsClassMembers(facetsBuilderClass, immutableFacetsType, allFacets, CodeGenParams.builder().wrapsRequest(true).isBuilder(true).withImpl(true).build());
        if (doInputsNeedBatching) {
            ClassName batchImmutFacetsType = this.getBatchFacetsClassName();
            ClassName commonImmutFacetsType = this.getCommonFacetsClassName();
            this.codegenBatchableFacets(facetsInterface, batchImmutFacetsType, commonImmutFacetsType, CodeGenParams.builder().build());
            this.codegenBatchableFacets(immutFacetsClass, batchImmutFacetsType, commonImmutFacetsType, CodeGenParams.builder().withImpl(true).build());
            this.codegenBatchableFacets(facetsBuilderClass, batchImmutFacetsType, commonImmutFacetsType, CodeGenParams.builder().withImpl(true).build());
        }
        try {
            writer = new StringWriter();
            JavaFile.builder((String)this.packageName, (TypeSpec)facetsInterface.addMethod(MethodSpec.methodBuilder((String)"_build").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)immutableFacetsType).addAnnotation(Override.class).build()).addMethod(MethodSpec.methodBuilder((String)"_asBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)immutableFacetsType.nestedClass("Builder")).addAnnotation(Override.class).build()).build()).build().writeTo((Appendable)writer);
            this.util.generateSourceFile(this.packageName + "." + Utils.getFacetsInterfaceName((String)this.vajramName), writer.toString(), this.currentVajramInfo.vajramClass());
        }
        catch (IOException e) {
            this.util.error(String.valueOf(e.getMessage()), (Element)this.currentVajramInfo.vajramClass());
        }
        try {
            writer = new StringWriter();
            JavaFile.builder((String)this.packageName, (TypeSpec)immutFacetsClass.addMethods(this.facetContainerMethods(allFacets, immutableFacetsType, immutableFacetsType, CodeGenParams.builder().wrapsRequest(true).withImpl(true).build())).addMethod(MethodSpec.methodBuilder((String)"_builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)immutableFacetsType.nestedClass("Builder")).addStatement("return new $T()", new Object[]{immutableFacetsType.nestedClass("Builder")}).build()).addType(facetsBuilderClass.addMethods(this.facetContainerMethods(allFacets, immutableFacetsType, immutableFacetsType, CodeGenParams.builder().wrapsRequest(true).isBuilder(true).withImpl(true).build())).build()).build()).build().writeTo((Appendable)writer);
            this.util.generateSourceFile(this.packageName + "." + Utils.getImmutFacetsClassname((String)this.vajramName), writer.toString(), this.currentVajramInfo.vajramClass());
        }
        catch (IOException e) {
            this.util.error(String.valueOf(e.getMessage()), (Element)this.currentVajramInfo.vajramClass());
        }
    }

    private void batchFacetsClasses() {
        ClassName allFacetsType = this.getFacetsInterfaceType();
        ClassName allImmutFacetsType = ClassName.get((String)this.packageName, (String)Utils.getImmutFacetsClassname((String)this.vajramName), (String[])new String[0]);
        ClassName batchImmutFacetsType = this.getBatchFacetsClassName();
        ClassName commonImmutFacetsType = this.getCommonFacetsClassName();
        List<FacetGenModel> batchedFacets = this.currentVajramInfo.facetStream().filter(FacetGenModel::isBatched).toList();
        List<FacetGenModel> commonFacets = this.currentVajramInfo.facetStream().filter(FacetGenModel::isUsedToGroupBatches).toList();
        TypeSpec.Builder batchImmutFacetsClass = this.util.classBuilder(batchImmutFacetsType.simpleName()).addModifiers(new Modifier[]{Modifier.FINAL}).addSuperinterface(ImmutableFacetValuesContainer.class).addField((TypeName)allImmutFacetsType, "_facetValues", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)allFacetsType, "_facetValues", new Modifier[0]).addStatement("this.$L = $L._build()", new Object[]{"_facetValues", "_facetValues"}).build()).addAnnotation(AnnotationSpec.builder(EqualsAndHashCode.class).addMember("onlyExplicitlyIncluded", "true", new Object[0]).build()).addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(FacetValuesContainer.class, "_facets", 0)).addStatement("return $T._facets.stream()\n  .filter($T::isBatched)\n  .collect($T.toImmutableSet())\n", new Object[]{this.getFacetsInterfaceType(), FacetSpec.class, ImmutableSet.class}).build()).addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(FacetValuesContainer.class, "_vajramID", 0)).addStatement("return $T._VAJRAM_ID", new Object[]{this.getRequestInterfaceType()}).build());
        for (FacetGenModel facet : batchedFacets) {
            CodeGenParams codeGenParams = CodeGenParams.builder().isSubsetBatch(true).withImpl(true).build();
            FacetJavaType returnType = this.util.facetJavaType(facet, codeGenParams);
            MethodSpec.Builder getter = MethodSpec.methodBuilder((String)facet.name()).returns(returnType.javaTypeName(facet).annotated(Utils.annotations((Class[])returnType.typeAnnotations(facet, codeGenParams)))).addStatement(returnType.fieldGetterCode(facet, codeGenParams));
            if (facet.isGiven()) {
                getter.addAnnotation(EqualsAndHashCode.Include.class);
            }
            batchImmutFacetsClass.addMethod(getter.build());
        }
        TypeSpec.Builder commonImmutFacetsClass = this.util.classBuilder(commonImmutFacetsType.simpleName()).addModifiers(new Modifier[]{Modifier.FINAL}).addSuperinterface(ImmutableFacetValuesContainer.class).addField((TypeName)allFacetsType, "_facetValues", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)allFacetsType, "_facetValues", new Modifier[0]).addStatement("this.$L = $L._build()", new Object[]{"_facetValues", "_facetValues"}).build()).addAnnotation(AnnotationSpec.builder(EqualsAndHashCode.class).addMember("onlyExplicitlyIncluded", "true", new Object[0]).build()).addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(FacetValuesContainer.class, "_facets", 0)).addStatement("return $T._facets.stream()\n  .filter(spec -> !spec.isBatched())\n  .collect($T.toImmutableSet())\n", new Object[]{this.getFacetsInterfaceType(), ImmutableSet.class}).build()).addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(FacetValuesContainer.class, "_vajramID", 0)).addStatement("return $T._VAJRAM_ID", new Object[]{this.getRequestInterfaceType()}).build());
        for (FacetGenModel facet : commonFacets) {
            CodeGenParams codeGenParams = CodeGenParams.builder().isSubsetCommon(true).withImpl(true).build();
            FacetJavaType returnType = this.util.facetJavaType(facet, codeGenParams);
            MethodSpec.Builder getter = MethodSpec.methodBuilder((String)facet.name()).returns(returnType.javaTypeName(facet).annotated(Utils.annotations((Class[])returnType.typeAnnotations(facet, codeGenParams)))).addStatement(returnType.fieldGetterCode(facet, codeGenParams));
            if (facet.isGiven()) {
                getter.addAnnotation(EqualsAndHashCode.Include.class);
            }
            commonImmutFacetsClass.addMethod(getter.build());
        }
        this.util.generateSourceFile(batchImmutFacetsType.canonicalName(), JavaFile.builder((String)this.packageName, (TypeSpec)batchImmutFacetsClass.build()).build().toString(), this.currentVajramInfo.vajramClass());
        this.util.generateSourceFile(commonImmutFacetsType.canonicalName(), JavaFile.builder((String)this.packageName, (TypeSpec)commonImmutFacetsClass.build()).build().toString(), this.currentVajramInfo.vajramClass());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName getFacetsInterfaceType() {
        return ClassName.get((String)this.packageName, (String)Utils.getFacetsInterfaceName((String)this.vajramName), (String[])new String[0]);
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName getRequestInterfaceType() {
        return ClassName.get((String)this.packageName, (String)Utils.getRequestInterfaceName((String)this.vajramName), (String[])new String[0]);
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName getBatchFacetsClassName() {
        return ClassName.get((String)this.packageName, (String)(this.vajramName + "_BatchItem"), (String[])new String[0]);
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName getCommonFacetsClassName() {
        return ClassName.get((String)this.packageName, (String)(this.vajramName + "_CommonFac"), (String[])new String[0]);
    }

    private void codegenBatchableFacets(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeSpec.Builder allFacetsType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName batchFacetsType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName commonFacetsType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenParams codeGenParams) {
        MethodSpec.Builder batchElementMethod = MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(BatchEnabledFacetValues.class, "_batchItem", 0)).returns((TypeName)batchFacetsType);
        MethodSpec.Builder commonMethod = MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(BatchEnabledFacetValues.class, "_common", 0)).returns((TypeName)commonFacetsType);
        if (codeGenParams.withImpl()) {
            batchElementMethod.addStatement("return new $T(this)", new Object[]{batchFacetsType});
            commonMethod.addStatement("return new $T(this)", new Object[]{commonFacetsType});
        } else {
            batchElementMethod.addModifiers(new Modifier[]{Modifier.ABSTRACT});
            commonMethod.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        allFacetsType.addMethod(batchElementMethod.build()).addMethod(commonMethod.build());
    }

    private void facetConstants(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeSpec.Builder classBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel> facetValues, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenParams codeGenParams) {
        ArrayList<FieldSpec> specFields = new ArrayList<FieldSpec>(facetValues.size());
        ArrayList<FieldSpec> idFields = new ArrayList<FieldSpec>();
        int facetCount = 0;
        for (FacetGenModel facetGenModel : facetValues) {
            String docComment;
            ParameterizedTypeName parameterizedTypeName;
            DependencyModel vajramDepDef;
            ++facetCount;
            String facetDoc = facetGenModel.documentation();
            FieldSpec facetIdField = FieldSpec.builder(String.class, (String)(facetGenModel.name() + "_n"), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{this.vajramName + ":" + facetGenModel.name()}).addJavadoc(facetDoc != null ? CodeBlock.of((String)facetDoc, (Object[])new Object[0]) : Constants.EMPTY_CODE_BLOCK).build();
            idFields.add(facetIdField);
            TypeAndName facetType = this.util.getTypeName(this.util.getDataType(facetGenModel));
            TypeAndName boxedFacetType = this.util.box(facetType);
            ClassName vajramReqClass = this.getRequestInterfaceType();
            ClassName specType = ClassName.get(codeGenParams.isRequest() ? InputMirrorSpec.class : (facetGenModel instanceof DependencyModel ? ((vajramDepDef = (DependencyModel)facetGenModel).canFanout() ? (vajramDepDef.isMandatoryOnServer() ? MandatoryFanoutDepSpec.class : OptionalFanoutDepSpec.class) : (vajramDepDef.isMandatoryOnServer() ? MandatoryOne2OneDepSpec.class : OptionalOne2OneDepSpec.class)) : (facetGenModel.isMandatoryOnServer() ? MandatoryFacetDefaultSpec.class : OptionalFacetDefaultSpec.class)));
            ArrayList collectClassNames = new ArrayList();
            if (facetGenModel instanceof DependencyModel) {
                DependencyModel vajramDepDef2 = (DependencyModel)facetGenModel;
                parameterizedTypeName = ParameterizedTypeName.get((ClassName)specType, (TypeName[])new TypeName[]{boxedFacetType.typeName(), vajramReqClass, ClassName.bestGuess((String)vajramDepDef2.depReqClassQualifiedName())});
            } else {
                parameterizedTypeName = ParameterizedTypeName.get((ClassName)specType, (TypeName[])new TypeName[]{boxedFacetType.typeName(), vajramReqClass});
            }
            FieldSpec.Builder fieldSpec = FieldSpec.builder((TypeName)parameterizedTypeName, (String)(facetGenModel.name() + "_s"), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addAnnotation(AnnotationSpec.builder(FacetIdNameMapping.class).addMember("id", "$L", new Object[]{facetGenModel.id()}).addMember("name", "$S", new Object[]{facetGenModel.name()}).build());
            CodeBlock.Builder initializerCodeBlock = CodeBlock.builder();
            initializerCodeBlock.add("new $T<>(\n  $L,\n  $S,\n  $T.$L,\n", new Object[]{specType, facetGenModel.id(), facetGenModel.name(), this.getRequestInterfaceType(), "_VAJRAM_ID"}).add(this.util.getJavaTypeCreationCode((JavaType)facetGenModel.dataType(), collectClassNames, facetGenModel.facetField()) + ",", collectClassNames.toArray());
            if (facetGenModel instanceof DefaultFacetModel && !codeGenParams.isRequest()) {
                initializerCodeBlock.add("$T.of(", new Object[]{ImmutableSet.class});
                ArrayList<String> params = new ArrayList<String>();
                ArrayList<String> args = new ArrayList<String>();
                if (facetGenModel.facetTypes().contains((Object)FacetType.INPUT)) {
                    params.add("$T.$L");
                    args.addAll(List.of(FacetType.class, "INPUT"));
                }
                if (facetGenModel.facetTypes().contains((Object)FacetType.INJECTION)) {
                    params.add("$T.$L");
                    args.addAll(List.of(FacetType.class, "INJECTION"));
                }
                initializerCodeBlock.add(String.join((CharSequence)",", params) + "),", args.toArray());
            }
            initializerCodeBlock.add("  $T.class,\n", new Object[]{vajramReqClass});
            if (facetGenModel instanceof DependencyModel) {
                DependencyModel vajramDepDef3 = (DependencyModel)facetGenModel;
                ClassName depReqClass = ClassName.bestGuess((String)vajramDepDef3.depReqClassQualifiedName());
                ClassName depReqInterfaceClass = ClassName.get((String)vajramDepDef3.depReqPackageName(), (String)Utils.getRequestInterfaceName((String)vajramDepDef3.depVajramInfo().vajramId().id()), (String[])new String[0]);
                initializerCodeBlock.add("  $T.class,\n  $T.$L,\n", new Object[]{depReqClass, depReqInterfaceClass, "_VAJRAM_ID"});
            }
            if ((docComment = this.util.processingEnv().getElementUtils().getDocComment(facetGenModel.facetField())) == null) {
                docComment = "";
            }
            initializerCodeBlock.add("$S,", new Object[]{docComment});
            if (codeGenParams.isRequest()) {
                VajramInfoLite conformsToTraitInfoOrSelf = this.currentVajramInfo.conformsToTraitOrSelf();
                initializerCodeBlock.add("  $T.fieldTagsParser(() -> $T.class.getDeclaredField($S)),\n  _request -> (($T)_request).$L(),\n  (_request, _value) -> {\n    if(_value != null) {\n      (($T) _request).$L(_value);\n    }\n  }\n)\n", new Object[]{FacetUtils.class, this.getRequestInterfaceType(), facetGenModel.name() + "_s", conformsToTraitInfoOrSelf.requestInterfaceType(), facetGenModel.name(), conformsToTraitInfoOrSelf.immutReqInterfaceType().nestedClass("Builder"), facetGenModel.name()});
                fieldSpec.addAnnotations(facetGenModel.facetField().getAnnotationMirrors().stream().filter(annotationMirror -> annotationMirror.getAnnotationType().asElement().getAnnotation(Documented.class) != null).map(AnnotationSpec::get).toList());
            } else {
                DependencyModel dep;
                initializerCodeBlock.add("    $L,\n    $T.fieldTagsParser(\n      () -> $T.$L.class.getDeclaredField($S),\n      () -> $T.class.getDeclaredField($S)),\n    _facetValues -> (($T)_facetValues).$L(),\n    (_facetValues, _value) -> {\n      if(_value != null) {\n        (($T) _facetValues).$L(_value);\n      }\n    }\n  )\n", new Object[]{facetGenModel.facetField().getAnnotation(Batched.class) != null, FacetUtils.class, this.currentVajramInfo.vajramClass(), facetGenModel.facetTypes().contains((Object)FacetType.INPUT) ? "_Inputs" : "_InternalFacets", facetGenModel.name(), this.getFacetsInterfaceType(), facetGenModel.name() + "_s", ClassName.get((String)this.packageName, (String)Utils.getFacetsInterfaceName((String)this.vajramName), (String[])new String[0]), facetGenModel.name(), ClassName.get((String)this.packageName, (String)Utils.getImmutFacetsClassname((String)this.vajramName), (String[])new String[]{"Builder"}), facetGenModel.name()});
                if (facetGenModel instanceof DependencyModel && (dep = (DependencyModel)facetGenModel).depVajramInfo().isTrait()) {
                    fieldSpec.addAnnotation(TraitDependency.class);
                }
            }
            specFields.add(fieldSpec.initializer(initializerCodeBlock.build()).build());
        }
        for (int i = 0; i < facetCount; ++i) {
            classBuilder.addField((FieldSpec)idFields.get(i)).addField((FieldSpec)specFields.get(i));
        }
        ParameterizedTypeName facetsFieldType = ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableSet.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)(codeGenParams.isRequest() ? ClassName.get(InputMirrorSpec.class) : ClassName.get(FacetSpec.class)), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class), WildcardTypeName.subtypeOf((TypeName)this.getRequestInterfaceType())}))});
        FieldSpec fieldSpec = FieldSpec.builder((TypeName)facetsFieldType, (String)"_facets", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(specFields.stream().map(specField -> "$N").collect(Collectors.joining(", ", "$T.of(", ")")), Stream.concat(Stream.of(ImmutableSet.class), specFields.stream()).toArray()).build();
        classBuilder.addField(fieldSpec);
        classBuilder.addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(FacetValuesContainer.class, "_facets", 0)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)facetsFieldType).addStatement("return $N", new Object[]{fieldSpec}).build());
    }

    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableSet<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Integer> getResolverSources(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement resolve) {
        return (ImmutableSet)resolve.getParameters().stream().map(this::inferFacetId).collect(ImmutableSet.toImmutableSet());
    }
}

