/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.processor;

import com.flipkart.krystal.model.IfAbsent;
import com.flipkart.krystal.model.ImmutableModel;
import com.flipkart.krystal.model.MandatoryDataMissingException;
import com.flipkart.krystal.model.Model;
import com.flipkart.krystal.model.ModelClusterRoot;
import com.flipkart.krystal.model.ModelRoot;
import com.flipkart.krystal.model.PlainJavaObject;
import com.flipkart.krystal.model.SupportedModelProtocols;
import com.flipkart.krystal.vajram.codegen.common.datatypes.CodeGenType;
import com.flipkart.krystal.vajram.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.vajram.codegen.common.models.CodeGenerationException;
import com.flipkart.krystal.vajram.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.vajram.codegen.common.models.DeclaredTypeVisitor;
import com.flipkart.krystal.vajram.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.vajram.codegen.common.spi.ModelsCodeGenContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JavaModelsGenerator
implements CodeGenerator {
    private final ModelsCodeGenContext codeGenContext;
    private final CodeGenUtility util;

    public JavaModelsGenerator(ModelsCodeGenContext codeGenContext) {
        this.codeGenContext = codeGenContext;
        this.util = codeGenContext.util();
    }

    public void generate() {
        if (!this.isApplicable()) {
            return;
        }
        this.validate();
        TypeElement modelRootType = this.codeGenContext.modelRootType();
        CodeGenUtility util = this.codeGenContext.util();
        ModelRoot modelRoot = modelRootType.getAnnotation(ModelRoot.class);
        List modelMethods = util.extractAndValidateModelMethods(modelRootType);
        String packageName = util.processingEnv().getElementUtils().getPackageOf(modelRootType).toString();
        String modelRootName = modelRootType.getSimpleName().toString();
        String immutableModelName = modelRootName + modelRoot.suffixSeparator() + "Immut";
        String immutablePojoName = modelRootName + modelRoot.suffixSeparator() + "ImmutPojo";
        TypeSpec immutableInterface = this.generateImmutableInterface(modelRootType, modelMethods, immutableModelName);
        if (this.isPlainJavaObjectSupported(modelRootType, util)) {
            TypeSpec immutablePojo = this.generateImmutablePojo(modelRootType, modelMethods, immutableModelName, immutablePojoName);
            this.writeJavaFile(packageName, immutablePojo, modelRootType, util);
        }
        this.writeJavaFile(packageName, immutableInterface, modelRootType, util);
    }

    private boolean isApplicable() {
        return CodegenPhase.MODELS.equals((Object)this.codeGenContext.codegenPhase());
    }

    private void validate() {
        this.validateModelRoot(this.codeGenContext.modelRootType(), this.codeGenContext.util());
    }

    private void validateModelRoot(TypeElement modelRootType, CodeGenUtility util) {
        if (!modelRootType.getKind().isInterface()) {
            util.error("Type with @ModelRoot annotation must be an interface: " + modelRootType.getQualifiedName(), new Element[]{modelRootType});
        }
        Preconditions.checkArgument((boolean)modelRootType.getTypeParameters().isEmpty(), (Object)"Generic model roots are not currently supported.");
        if (!JavaModelsGenerator.extendsModel(modelRootType, util)) {
            util.error("Interface with @ModelRoot annotation must extend Model: " + modelRootType.getQualifiedName(), new Element[]{modelRootType});
        }
    }

    private static boolean extendsModel(TypeElement modelRootType, CodeGenUtility util) {
        boolean extendsModel = false;
        for (TypeMirror typeMirror : modelRootType.getInterfaces()) {
            TypeElement superElement = Objects.requireNonNull((TypeElement)util.processingEnv().getTypeUtils().asElement(typeMirror));
            if (!superElement.getQualifiedName().contentEquals(Model.class.getCanonicalName()) && !JavaModelsGenerator.extendsModel(superElement, util)) continue;
            extendsModel = true;
            break;
        }
        return extendsModel;
    }

    private TypeSpec generateImmutableInterface(TypeElement modelRootType, List<ExecutableElement> modelMethods, String immutableModelName) {
        ModelRoot modelRoot = modelRootType.getAnnotation(ModelRoot.class);
        Optional<TypeElement> parentModelRootOpt = this.getParentInterfaceWithAnnotation(modelRootType, ModelRoot.class);
        boolean hasParentModelRoot = parentModelRootOpt.isPresent();
        Optional<TypeElement> modelClusterRoot = parentModelRootOpt.isPresent() ? Optional.empty() : this.getInterfaceWithAnnotation(modelRootType, ModelClusterRoot.class);
        ImmutableList typeParamTypes = modelClusterRoot.map(mcr -> this.util.getTypeParamTypes(modelRootType, mcr)).orElse(ImmutableList.of());
        Optional<ModelClusterRoot> modelClusterRootAnno = modelClusterRoot.map(typeElement -> typeElement.getAnnotation(ModelClusterRoot.class));
        Optional parentModelRootAnno = parentModelRootOpt.flatMap(a -> a.getAnnotationMirrors().stream().filter(m -> ((QualifiedNameable)m.getAnnotationType().asElement()).getQualifiedName().contentEquals(ModelRoot.class.getCanonicalName())).findAny());
        ClassName immutableModelRootType = parentModelRootOpt.flatMap(parentModelRoot -> parentModelRootAnno.isPresent() ? Optional.of(ClassName.get((String)this.util.processingEnv().getElementUtils().getPackageOf((Element)parentModelRoot).getQualifiedName().toString(), (String)(parentModelRoot.getSimpleName() + (String)this.util.getAnnotationElement((AnnotationMirror)parentModelRootAnno.get(), "suffixSeparator", String.class) + "Immut"), (String[])new String[0])) : Optional.empty()).or(() -> modelClusterRootAnno.flatMap(anno -> this.util.getTypeFromAnnotationMember(() -> ((ModelClusterRoot)anno).immutableRoot())).map(tm -> (TypeElement)this.util.processingEnv().getTypeUtils().asElement((TypeMirror)tm)).map(ClassName::get)).orElse(ClassName.get(ImmutableModel.class));
        ClassName modelBuilderRootType = parentModelRootOpt.flatMap(parentModelRoot -> parentModelRootAnno.isPresent() ? Optional.of(ClassName.get((String)this.util.processingEnv().getElementUtils().getPackageOf((Element)parentModelRoot).getQualifiedName().toString(), (String)(parentModelRoot.getSimpleName() + (String)this.util.getAnnotationElement((AnnotationMirror)parentModelRootAnno.get(), "suffixSeparator", String.class) + "Immut"), (String[])new String[]{"Builder"})) : Optional.empty()).or(() -> modelClusterRootAnno.flatMap(anno -> this.util.getTypeFromAnnotationMember(() -> ((ModelClusterRoot)anno).builderRoot())).map(tm -> (TypeElement)this.util.processingEnv().getTypeUtils().asElement((TypeMirror)tm)).map(ClassName::get)).orElse(ClassName.get(ImmutableModel.Builder.class));
        TypeSpec.Builder builderInterface = TypeSpec.interfaceBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addSuperinterface((TypeName)(typeParamTypes.isEmpty() ? modelBuilderRootType : ParameterizedTypeName.get((ClassName)modelBuilderRootType, (TypeName[])((TypeName[])typeParamTypes.stream().map(TypeName::get).toArray(TypeName[]::new))))).addMethods(this.generateBuilderInterfaceMethods(modelMethods, immutableModelName, hasParentModelRoot));
        if (modelRoot.builderExtendsModelRoot()) {
            builderInterface.addSuperinterface(modelRootType.asType());
        }
        return TypeSpec.interfaceBuilder((String)immutableModelName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ClassName.get((TypeElement)modelRootType)).addSuperinterface((TypeName)(typeParamTypes.isEmpty() ? immutableModelRootType : ParameterizedTypeName.get((ClassName)immutableModelRootType, (TypeName[])((TypeName[])typeParamTypes.stream().map(TypeName::get).toArray(TypeName[]::new))))).addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethod(Model.class, "_build", 0)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)ClassName.get((String)"", (String)immutableModelName, (String[])new String[0])).addStatement("return this", new Object[0]).build()).addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethod(Model.class, "_newCopy", 0)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)ClassName.get((String)"", (String)immutableModelName, (String[])new String[0])).build()).addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethod(Model.class, "_asBuilder", 0)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)ClassName.get((String)"", (String)(immutableModelName + ".Builder"), (String[])new String[0])).build()).addType(builderInterface.build()).build();
    }

    private Optional<TypeElement> getParentInterfaceWithAnnotation(TypeElement typeElement, Class<?> annotationClass) {
        return this.getInterfaceWithAnnotation(typeElement, annotationClass, true);
    }

    private Optional<TypeElement> getInterfaceWithAnnotation(TypeElement typeElement, Class<?> annotationClass) {
        return this.getInterfaceWithAnnotation(typeElement, annotationClass, false);
    }

    private Optional<TypeElement> getInterfaceWithAnnotation(TypeElement typeElement, Class<?> annotationClass, boolean skipFirst) {
        Optional annotation;
        Optional<Object> optional = annotation = skipFirst ? Optional.empty() : typeElement.getAnnotationMirrors().stream().filter(m -> ((QualifiedNameable)m.getAnnotationType().asElement()).getQualifiedName().contentEquals(Objects.requireNonNullElse(annotationClass.getCanonicalName(), ""))).findAny();
        if (annotation.isEmpty()) {
            List<TypeElement> list = typeElement.getInterfaces().stream().map(t -> this.util.processingEnv().getTypeUtils().asElement((TypeMirror)t)).filter(e -> e instanceof TypeElement).map(e -> (TypeElement)e).map(te -> this.getInterfaceWithAnnotation(Objects.requireNonNull(te), annotationClass, false)).filter(Optional::isPresent).map(Optional::get).toList();
            if (list.isEmpty()) {
                return Optional.empty();
            }
            if (list.size() > 1) {
                this.util.error("More than one super interface has @%s annotation. Expected zero or one".formatted(annotationClass.getSimpleName()), new Element[]{typeElement});
                return Optional.empty();
            }
            return Optional.ofNullable(list.get(0));
        }
        return Optional.of(typeElement);
    }

    private List<MethodSpec> generateBuilderInterfaceMethods(List<ExecutableElement> modelMethods, String immutableModelName, boolean hasParentModelRoot) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        for (ExecutableElement method : modelMethods) {
            this.validateOptionalField(method);
            String methodName = method.getSimpleName().toString();
            TypeMirror returnType = method.getReturnType();
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(this.getParameterType(returnType), methodName, new Modifier[0]).returns((TypeName)ClassName.get((String)"", (String)"Builder", (String[])new String[0]));
            if (hasParentModelRoot) {
                methodBuilder.addAnnotation(Override.class);
            }
            methods.add(methodBuilder.build());
        }
        methods.addAll(List.of(MethodSpec.overriding((ExecutableElement)this.util.getMethod(Model.class, "_build", 0)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)ClassName.get((String)"", (String)immutableModelName, (String[])new String[0])).build(), MethodSpec.overriding((ExecutableElement)this.util.getMethod(Model.class, "_newCopy", 0)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)ClassName.get((String)"", (String)"Builder", (String[])new String[0])).build(), MethodSpec.overriding((ExecutableElement)this.util.getMethod(Model.class, "_asBuilder", 0)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)ClassName.get((String)"", (String)(immutableModelName + ".Builder"), (String[])new String[0])).addStatement("return this", new Object[0]).build()));
        return methods;
    }

    /*
     * WARNING - void declaration
     */
    private TypeSpec generateImmutablePojo(TypeElement modelRootType, List<ExecutableElement> modelMethods, String immutableModelName, String immutablePojoName) {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        for (ExecutableElement executableElement : modelMethods) {
            void var9_15;
            String string = executableElement.getSimpleName().toString();
            if (this.util.isOptional(executableElement.getReturnType())) {
                TypeMirror innerType = this.util.getOptionalInnerType(executableElement.getReturnType());
                if (innerType.getKind().isPrimitive()) {
                    TypeName typeName = TypeName.get((TypeMirror)innerType).box();
                } else {
                    TypeName typeName = TypeName.get((TypeMirror)innerType);
                }
            } else {
                IfAbsent ifAbsent = this.util.getIfAbsent((Element)executableElement);
                if (executableElement.getReturnType().getKind().isPrimitive() && !ifAbsent.value().isMandatoryOnServer()) {
                    TypeName typeName = TypeName.get((TypeMirror)executableElement.getReturnType()).box();
                } else {
                    TypeName typeName = TypeName.get((TypeMirror)executableElement.getReturnType());
                }
            }
            if (this.util.isOptional(executableElement.getReturnType()) || this.util.isNullable(executableElement.getReturnType())) {
                void var9_21;
                TypeName typeName = var9_21.annotated(new AnnotationSpec[]{AnnotationSpec.builder((ClassName)ClassName.get(Nullable.class)).build()});
            }
            fields.add(FieldSpec.builder((TypeName)var9_15, (String)string, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        }
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
        for (ExecutableElement executableElement : modelMethods) {
            String string = executableElement.getSimpleName().toString();
            constructorBuilder.addParameter(ParameterSpec.builder((TypeName)this.getParameterType(executableElement.getReturnType()), (String)string, (Modifier[])new Modifier[0]).build());
            constructorBuilder.addStatement("this.$N = $N", new Object[]{string, string});
        }
        ArrayList<MethodSpec> arrayList = new ArrayList<MethodSpec>();
        for (ExecutableElement executableElement : modelMethods) {
            arrayList.add(this.getterMethod(executableElement).build());
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"_asBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get((String)"", (String)(immutablePojoName + ".Builder"), (String[])new String[0]));
        builder.addCode("return new $T()", new Object[]{ClassName.get((String)"", (String)(immutablePojoName + ".Builder"), (String[])new String[0])});
        for (ExecutableElement method : modelMethods) {
            String fieldName = method.getSimpleName().toString();
            builder.addCode(".$L($L)", new Object[]{fieldName, fieldName});
        }
        builder.addCode(";", new Object[0]);
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)"_newCopy").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get((String)"", (String)immutablePojoName, (String[])new String[0]));
        String fieldNames = modelMethods.stream().map(m -> m.getSimpleName().toString()).collect(Collectors.joining(", "));
        builder2.addStatement("return new $T($L)", new Object[]{ClassName.get((String)"", (String)immutablePojoName, (String[])new String[0]), fieldNames});
        arrayList.add(builder.build());
        arrayList.add(builder2.build());
        MethodSpec builderMethod = MethodSpec.methodBuilder((String)"_builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassName.get((String)"", (String)(immutablePojoName + ".Builder"), (String[])new String[0])).addStatement("return new $T()", new Object[]{ClassName.get((String)"", (String)(immutablePojoName + ".Builder"), (String[])new String[0])}).build();
        TypeSpec builderClass = this.generateBuilderClass(modelRootType, modelMethods, immutableModelName, immutablePojoName);
        return TypeSpec.classBuilder((String)immutablePojoName).addAnnotations((Iterable)CodeGenUtility.recordAnnotations()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)ClassName.get((String)"", (String)immutableModelName, (String[])new String[0])).addFields(fields).addMethod(constructorBuilder.build()).addMethods(arrayList).addMethod(builderMethod).addType(builderClass).build();
    }

    private MethodSpec.Builder getterMethod(ExecutableElement method) {
        TypeMirror returnType = method.getReturnType();
        String methodName = method.getSimpleName().toString();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeName.get((TypeMirror)returnType).annotated(returnType.getAnnotationMirrors().stream().map(AnnotationSpec::get).toList()));
        if (this.util.isOptional(returnType)) {
            methodBuilder.addStatement("return $T.ofNullable($N)", new Object[]{Optional.class, methodName});
        } else {
            if (this.util.getIfAbsent((Element)method).value().usePlatformDefault() && !returnType.getKind().isPrimitive()) {
                try {
                    methodBuilder.addCode("if($N == null){\n  return $L;\n}\n", new Object[]{methodName, ((CodeGenType)new DeclaredTypeVisitor(this.util, (Element)method).visit(returnType)).defaultValueExpr(this.util.processingEnv())});
                }
                catch (CodeGenerationException e) {
                    throw this.util.errorAndThrow("Could not find default value expression for specified type %s. Either the relevant type was not configured properly in a DataTypeFactory or the @IfAbsent() annotation is incorrectly specified.", new Element[]{method});
                }
            }
            methodBuilder.addStatement("return $N", new Object[]{methodName});
        }
        return methodBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private TypeSpec generateBuilderClass(TypeElement modelRootType, List<ExecutableElement> modelMethods, String immutableModelName, String immutablePojoName) {
        void var10_20;
        ModelRoot modelRoot = modelRootType.getAnnotation(ModelRoot.class);
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        for (ExecutableElement method : modelMethods) {
            void var10_10;
            String fieldName = method.getSimpleName().toString();
            if (this.util.isOptional(method.getReturnType())) {
                TypeMirror innerType = this.util.getOptionalInnerType(method.getReturnType());
                if (innerType.getKind().isPrimitive()) {
                    TypeName typeName = TypeName.get((TypeMirror)innerType).box();
                } else {
                    TypeName typeName = TypeName.get((TypeMirror)innerType);
                }
            } else if (method.getReturnType().getKind().isPrimitive()) {
                TypeName typeName = TypeName.get((TypeMirror)method.getReturnType()).box();
            } else {
                TypeName typeName = TypeName.get((TypeMirror)method.getReturnType());
            }
            if (this.util.isOptional(method.getReturnType()) || this.util.isNullable(method.getReturnType())) {
                TypeName annotatedType = var10_10.annotated(new AnnotationSpec[]{AnnotationSpec.builder((ClassName)ClassName.get(Nullable.class)).build()});
                fields.add(FieldSpec.builder((TypeName)annotatedType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
                continue;
            }
            fields.add(FieldSpec.builder((TypeName)var10_10, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        }
        MethodSpec noArgConstructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        ArrayList<MethodSpec> dataAccessMethods = new ArrayList<MethodSpec>();
        for (ExecutableElement executableElement : modelMethods) {
            String methodName = executableElement.getSimpleName().toString();
            dataAccessMethods.add(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.getParameterType(executableElement.getReturnType()), methodName, new Modifier[0]).returns((TypeName)ClassName.get((String)"", (String)"Builder", (String[])new String[0])).addStatement("this.$N = $N", new Object[]{methodName, methodName}).addStatement("return this", new Object[0]).addAnnotation(Override.class).build());
            if (!modelRoot.builderExtendsModelRoot()) continue;
            dataAccessMethods.add(this.getterMethod(executableElement).build());
        }
        MethodSpec.Builder buildMethodBuilder = MethodSpec.methodBuilder((String)"_build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"", (String)immutablePojoName, (String[])new String[0])).addAnnotation(Override.class);
        for (ExecutableElement method : modelMethods) {
            String fieldName = method.getSimpleName().toString();
            TypeMirror returnType = method.getReturnType();
            TypeMirror actualType = this.util.getOptionalInnerType(returnType);
            CodeGenType dataType = (CodeGenType)new DeclaredTypeVisitor(this.util, (Element)method).visit(actualType, null);
            if (this.typeSupportsAbsentValues(returnType)) continue;
            buildMethodBuilder.beginControlFlow("if (this.$N == null)", new Object[]{fieldName});
            IfAbsent.IfAbsentThen ifAbsentThen = this.util.getIfAbsent((Element)method).value();
            switch (ifAbsentThen) {
                case FAIL: {
                    buildMethodBuilder.addStatement("throw new $T($S, $S)", new Object[]{MandatoryDataMissingException.class, immutableModelName, fieldName});
                    break;
                }
                case ASSUME_DEFAULT_VALUE: {
                    try {
                        buildMethodBuilder.addStatement("this.$N = $L", new Object[]{fieldName, dataType.defaultValueExpr(this.util.processingEnv())});
                        break;
                    }
                    catch (CodeGenerationException e) {
                        throw this.util.errorAndThrow("Could not find default value expression for type '%s'".formatted(dataType), new Element[]{method});
                    }
                }
                default: {
                    throw new AssertionError((Object)("Unexpected IfAbsentThen = " + ifAbsentThen));
                }
            }
            buildMethodBuilder.endControlFlow();
        }
        buildMethodBuilder.addCode("return new $T(", new Object[]{ClassName.get((String)"", (String)immutablePojoName, (String[])new String[0])});
        boolean bl = false;
        while (var10_20 < modelMethods.size()) {
            String fieldName = modelMethods.get((int)var10_20).getSimpleName().toString();
            buildMethodBuilder.addCode("$N", new Object[]{fieldName});
            if (var10_20 < modelMethods.size() - 1) {
                buildMethodBuilder.addCode(", ", new Object[0]);
            }
            ++var10_20;
        }
        buildMethodBuilder.addCode(");", new Object[0]);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"_newCopy").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get((String)"", (String)(immutablePojoName + ".Builder"), (String[])new String[0]));
        builder.addCode("return new $T()", new Object[]{ClassName.get((String)"", (String)(immutablePojoName + ".Builder"), (String[])new String[0])});
        for (ExecutableElement method : modelMethods) {
            String fieldName = method.getSimpleName().toString();
            builder.addCode(".$L(this.$L)", new Object[]{fieldName, fieldName});
        }
        builder.addCode(";", new Object[0]);
        return TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addSuperinterface((TypeName)ClassName.get((String)"", (String)(immutableModelName + ".Builder"), (String[])new String[0])).addFields(fields).addMethod(noArgConstructor).addMethods(dataAccessMethods).addMethod(buildMethodBuilder.build()).addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethod(Model.class, "_asBuilder", 0)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"", (String)(immutablePojoName + ".Builder"), (String[])new String[0])).addStatement("return this", new Object[0]).build()).addMethod(builder.build()).build();
    }

    private boolean isPlainJavaObjectSupported(TypeElement modelRootType, CodeGenUtility util) {
        SupportedModelProtocols supportedModelProtocols = modelRootType.getAnnotation(SupportedModelProtocols.class);
        if (supportedModelProtocols == null) {
            return true;
        }
        List modelProtocols = util.getTypesFromAnnotationMember(() -> ((SupportedModelProtocols)supportedModelProtocols).value());
        if (modelProtocols.isEmpty()) {
            return true;
        }
        return modelProtocols.stream().map(typeMirror -> util.processingEnv().getTypeUtils().asElement((TypeMirror)typeMirror)).filter(elem -> elem instanceof QualifiedNameable).map(element -> Objects.requireNonNull((QualifiedNameable)element).getQualifiedName().toString()).anyMatch(PlainJavaObject.class.getCanonicalName()::equals);
    }

    private TypeName getParameterType(TypeMirror specifiedType) {
        TypeName typeName;
        TypeMirror inferredType = specifiedType;
        if (this.util.isOptional(specifiedType)) {
            inferredType = this.util.getOptionalInnerType(specifiedType);
        }
        if ((typeName = TypeName.get((TypeMirror)inferredType)).isPrimitive()) {
            typeName = typeName.box();
        }
        if (this.util.isOptional(specifiedType) || this.util.isNullable(specifiedType)) {
            typeName = typeName.annotated(new AnnotationSpec[]{AnnotationSpec.builder((ClassName)ClassName.get(Nullable.class)).build()});
        }
        return typeName;
    }

    private void validateOptionalField(ExecutableElement method) {
        IfAbsent.IfAbsentThen ifAbsentThen = this.util.getIfAbsent((Element)method).value();
        if (!ifAbsentThen.isMandatoryOnServer() && !this.typeSupportsAbsentValues(method.getReturnType())) {
            this.util.error("Field '%s' with @IfAbsent(%s) must be an Optional or annotated with %s: ".formatted(method.getSimpleName(), ifAbsentThen, Nullable.class.getCanonicalName()), new Element[]{method});
        }
    }

    private boolean typeSupportsAbsentValues(TypeMirror returnType) {
        return !returnType.getKind().isPrimitive() && (this.util.isOptional(returnType) || this.util.isNullable(returnType));
    }

    private void writeJavaFile(String packageName, TypeSpec typeSpec, TypeElement originatingElement, CodeGenUtility util) {
        try {
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
            String fileName = packageName + "." + typeSpec.name;
            util.generateSourceFile(fileName, javaFile.toString(), originatingElement);
        }
        catch (Exception e) {
            util.error("Error generating Java file: " + e.getMessage(), new Element[]{originatingElement});
        }
    }
}

