/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.processor;

import com.flipkart.krystal.vajram.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.vajram.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.common.models.VajramValidationException;
import com.flipkart.krystal.vajram.codegen.common.spi.AllVajramCodeGenContext;
import com.flipkart.krystal.vajram.codegen.common.spi.AllVajramsCodeGeneratorProvider;
import com.flipkart.krystal.vajram.codegen.common.spi.VajramCodeGenContext;
import com.flipkart.krystal.vajram.codegen.common.spi.VajramCodeGeneratorProvider;
import com.flipkart.krystal.vajram.codegen.processor.Constants;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.optional.qual.Present;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractVajramCodegenProcessor
extends AbstractProcessor {
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodegenPhase codegenPhase;

    public AbstractVajramCodegenProcessor(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodegenPhase codegenPhase) {
        this.codegenPhase = codegenPhase;
    }

    @Override
    public final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean process(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Set<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement> annotations, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RoundEnvironment roundEnv) {
        CodeGenUtility util = new CodeGenUtility(this.processingEnv, this.getClass());
        String phaseString = this.processingEnv.getOptions().get("krystal.vajram.codegen.phase");
        try {
            if (phaseString == null || !this.codegenPhase.equals((Object)CodegenPhase.valueOf((String)phaseString))) {
                util.note((CharSequence)"Skipping %s since codegen phase is '%s'. This class only supports '%s'".formatted(this.getClass().getSimpleName(), String.valueOf(phaseString), this.codegenPhase));
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            util.error("%s could not parse phase string '%s'. Exactly one of %s must be passed as value to the java compiler via the annotation processor argument '-A%s='".formatted(this.getClass().getSimpleName(), String.valueOf(phaseString), Arrays.toString(CodegenPhase.values()), "krystal.vajram.codegen.phase"), new Element[0]);
            return false;
        }
        List vajramDefinitions = util.getDefinitionClasses(roundEnv);
        util.note((CharSequence)"Vajrams and Traits received by %s: %s".formatted(this.getClass().getSimpleName(), vajramDefinitions.stream().map(Objects::toString).collect(Collectors.joining(System.lineSeparator(), "[" + System.lineSeparator(), System.lineSeparator() + "]"))));
        Iterable vajramCodeGeneratorProviders = Iterables.concat(List.of(Constants.DEFAULT_VAJRAM_CODEGEN_PROVIDER), ServiceLoader.load(VajramCodeGeneratorProvider.class, this.getClass().getClassLoader()));
        ArrayList<VajramInfo> vajramInfos = new ArrayList<VajramInfo>();
        for (TypeElement vajramDefinition : vajramDefinitions) {
            try {
                VajramInfo vajramInfo = util.computeVajramInfo(vajramDefinition);
                vajramInfos.add(vajramInfo);
                VajramCodeGenContext creationContext = new VajramCodeGenContext(vajramInfo, util, this.codegenPhase);
                for (VajramCodeGeneratorProvider customCodeGeneratorProvider : vajramCodeGeneratorProviders) {
                    try {
                        customCodeGeneratorProvider.create(creationContext).generate();
                    }
                    catch (VajramValidationException e) {}
                }
            }
            catch (VajramValidationException e) {
            }
        }
        ServiceLoader<AllVajramsCodeGeneratorProvider> allVajramCodeGeneratorProviders = ServiceLoader.load(AllVajramsCodeGeneratorProvider.class, this.getClass().getClassLoader());
        for (AllVajramsCodeGeneratorProvider allVajramCodeGen : allVajramCodeGeneratorProviders) {
            allVajramCodeGen.create(new AllVajramCodeGenContext(vajramInfos, util, this.codegenPhase)).generate();
        }
        return false;
    }
}

