/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.guice;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.facets.InputDef;
import com.flipkart.krystal.vajram.facets.InputSource;
import com.flipkart.krystal.vajram.tags.AnnotationTag;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.flipkart.krystal.vajramexecutor.krystex.inputinjection.VajramInjectionProvider;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Key;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VajramGuiceInjector
implements VajramInjectionProvider {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(VajramGuiceInjector.class);
    private final @UnknownKeyFor @NonNull @Initialized VajramKryonGraph vajramKryonGraph;
    private final @UnknownKeyFor @NonNull @Initialized Injector injector;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized VajramID, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Provider<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> providerCache = new LinkedHashMap();

    public VajramGuiceInjector(@UnknownKeyFor @NonNull @Initialized VajramKryonGraph vajramKryonGraph, @UnknownKeyFor @NonNull @Initialized Injector injector) {
        this.vajramKryonGraph = vajramKryonGraph;
        this.injector = injector;
    }

    public <T> @UnknownKeyFor @NonNull @Initialized Errable<T> get(@UnknownKeyFor @NonNull @Initialized VajramID vajramID, @UnknownKeyFor @NonNull @Initialized InputDef<T> inputDef) {
        if (!inputDef.sources().contains((Object)InputSource.SESSION)) {
            return Errable.empty();
        }
        return Errable.errableFrom(() -> {
            Provider provider = this.providerCache.computeIfAbsent(vajramID, _v -> new LinkedHashMap()).computeIfAbsent(inputDef.name(), _i -> {
                try {
                    Type type = inputDef.type().javaReflectType();
                    Annotation annotation = this.getQualifier(vajramID, inputDef);
                    if (annotation == null) {
                        return this.injector.getProvider(Key.get((Type)type));
                    }
                    return this.injector.getProvider(Key.get((Type)type, (Annotation)annotation));
                }
                catch (ClassNotFoundException e) {
                    throw new StackTracelessException("Unable to load data type of Input", (Throwable)e);
                }
            });
            return provider.get();
        });
    }

    private @Nullable @UnknownKeyFor @Initialized Annotation getQualifier(@UnknownKeyFor @NonNull @Initialized VajramID vajramID, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized InputDef<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputDef) {
        Optional vajramDefinition = this.vajramKryonGraph.getVajramDefinition(vajramID);
        if (vajramDefinition.isEmpty()) {
            return null;
        }
        ImmutableMap facetTags = ((VajramDefinition)vajramDefinition.get()).getFacetTags();
        String inputName = inputDef.name();
        return Optional.ofNullable((Tag)((ImmutableMap)facetTags.getOrDefault((Object)inputName, (Object)ImmutableMap.of())).get(Named.class)).map(tag -> {
            AnnotationTag annoTag;
            Annotation patt3513$temp;
            if (tag instanceof AnnotationTag && (patt3513$temp = (annoTag = (AnnotationTag)tag).tagValue()) instanceof Named) {
                Named named = (Named)patt3513$temp;
                return named;
            }
            return null;
        }).orElse(null);
    }
}

