/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.guice.inputinjection;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.flipkart.krystal.vajram.inputinjection.VajramInjectionProvider;
import com.google.inject.Injector;
import com.google.inject.Key;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VajramGuiceInputInjector
implements VajramInjectionProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VajramGuiceInputInjector.class);
    private final Injector injector;
    private final Map<VajramID, Map<String, Provider<?>>> providerCache = new LinkedHashMap();

    @Inject
    public VajramGuiceInputInjector(Injector injector) {
        this.injector = injector;
    }

    public <T> Errable<@NonNull T> get(VajramID vajramID, FacetSpec<T, ?> facetDef) {
        if (!facetDef.facetTypes().contains((Object)FacetType.INJECTION)) {
            return Errable.nil();
        }
        return Errable.errableFrom(() -> {
            Provider provider = this.providerCache.computeIfAbsent(vajramID, _v -> new LinkedHashMap()).computeIfAbsent(facetDef.name(), _i -> {
                try {
                    Type type = facetDef.type().javaReflectType();
                    Optional<Annotation> annotation = this.getQualifier(vajramID, facetDef);
                    if (annotation.isEmpty()) {
                        return this.injector.getProvider(Key.get((Type)type));
                    }
                    return this.injector.getProvider(Key.get((Type)type, (Annotation)annotation.get()));
                }
                catch (ClassNotFoundException e) {
                    throw new StackTracelessException("Unable to load data type of Input", (Throwable)e);
                }
            });
            return provider.get();
        });
    }

    private <T> Optional<Annotation> getQualifier(VajramID vajramID, FacetSpec<T, ?> facetDef) {
        List qualifierAnnotations = facetDef.tags().annotations().stream().mapMulti((tag, consumer) -> {
            boolean isQualifierAnno;
            boolean bl = isQualifierAnno = tag.annotationType().getAnnotation(Qualifier.class) != null;
            if (isQualifierAnno) {
                consumer.accept(tag);
            }
        }).toList();
        if (qualifierAnnotations.isEmpty()) {
            return Optional.empty();
        }
        if (qualifierAnnotations.size() == 1) {
            return Optional.ofNullable((Annotation)qualifierAnnotations.get(0));
        }
        throw new IllegalStateException("More than one @jakarta.inject.Qualifier annotations (%s) found on input '%s' of vajram '%s'. This is not allowed".formatted(qualifierAnnotations, facetDef.name(), vajramID.id()));
    }
}

