/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.exec;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.vajram.ComputeVajram;
import com.flipkart.krystal.vajram.IOVajram;
import com.flipkart.krystal.vajram.Output;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.exec.VajramMetadata;
import com.flipkart.krystal.vajram.facets.DefaultInputResolverDefinition;
import com.flipkart.krystal.vajram.facets.DependencyDef;
import com.flipkart.krystal.vajram.facets.FacetContainer;
import com.flipkart.krystal.vajram.facets.InputDef;
import com.flipkart.krystal.vajram.facets.QualifiedInputs;
import com.flipkart.krystal.vajram.facets.Using;
import com.flipkart.krystal.vajram.facets.VajramFacetDefinition;
import com.flipkart.krystal.vajram.facets.resolution.InputResolverDefinition;
import com.flipkart.krystal.vajram.facets.resolution.sdk.Resolve;
import com.flipkart.krystal.vajram.tags.AnnotationTag;
import com.flipkart.krystal.vajram.tags.AnnotationTagKey;
import com.flipkart.krystal.vajram.tags.AnnotationTags;
import com.flipkart.krystal.vajram.tags.NamedValueTag;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VajramDefinition {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VajramDefinition.class);
    private final Vajram<?> vajram;
    private final ImmutableCollection<InputResolverDefinition> inputResolverDefinitions;
    private final ImmutableMap<AnnotationTagKey, Tag> outputLogicTags;
    private final ImmutableSet<String> outputLogicSources;
    private final ImmutableMap<String, ImmutableMap<Object, Tag>> facetTags;
    private final VajramMetadata vajramMetadata;

    public VajramDefinition(Vajram<?> vajram) {
        this.vajram = vajram;
        this.inputResolverDefinitions = ImmutableList.copyOf(VajramDefinition.parseInputResolvers(vajram));
        this.outputLogicTags = VajramDefinition.parseOutputLogicTags(vajram);
        this.facetTags = VajramDefinition.parseFacetTags(vajram);
        this.vajramMetadata = new VajramMetadata(vajram);
        this.outputLogicSources = VajramDefinition.parseOutputLogicSources(vajram);
    }

    private static ImmutableSet<String> parseOutputLogicSources(Vajram<?> vajram) {
        Optional<Method> outputLogicMethod = Arrays.stream(VajramDefinition.getVajramSourceClass(vajram.getClass()).getDeclaredMethods()).filter(method -> method.getAnnotation(Output.class) != null).findFirst();
        ImmutableSet allFacetNames = (ImmutableSet)vajram.getFacetDefinitions().stream().map(VajramFacetDefinition::name).collect(ImmutableSet.toImmutableSet());
        if (outputLogicMethod.isPresent() && vajram.getFacetDefinitions().stream().noneMatch(f -> {
            InputDef input;
            return f instanceof InputDef && (input = (InputDef)f).isBatched();
        })) {
            Parameter[] outputLogicParams = outputLogicMethod.get().getParameters();
            if (outputLogicParams.length == 1 && FacetContainer.class.isAssignableFrom(outputLogicParams[0].getType())) {
                return allFacetNames;
            }
            return (ImmutableSet)Arrays.stream(outputLogicParams).map(VajramDefinition::inferFacetName).collect(ImmutableSet.toImmutableSet());
        }
        return allFacetNames;
    }

    private static ImmutableMap<String, ImmutableMap<Object, Tag>> parseFacetTags(Vajram<?> vajram) {
        ImmutableMap facetDefs = (ImmutableMap)vajram.getFacetDefinitions().stream().collect(ImmutableMap.toImmutableMap(VajramFacetDefinition::name, Function.identity()));
        LinkedHashMap<String, ImmutableMap> result = new LinkedHashMap<String, ImmutableMap>();
        for (Field declaredField : vajram.getClass().getDeclaredFields()) {
            Annotation[] annotations;
            LinkedHashMap<Object, Tag> tags = new LinkedHashMap<Object, Tag>();
            String facetName = declaredField.getName();
            VajramFacetDefinition facetDef = (VajramFacetDefinition)facetDefs.get((Object)facetName);
            if (facetDef != null) {
                tags.putAll((Map<Object, Tag>)facetDef.tags());
            }
            for (Annotation annotation : annotations = declaredField.getAnnotations()) {
                boolean isRepeatable;
                boolean bl = isRepeatable = annotation.annotationType().getAnnotation(Repeatable.class) != null;
                if (isRepeatable) {
                    log.warn("Repeatable annotations are not supported as tags. Ignoring {}", (Object)annotation);
                    continue;
                }
                AnnotationTag<Annotation> annotationTag = AnnotationTag.from(annotation);
                tags.put(annotationTag.tagKey(), annotationTag);
            }
            result.put(facetName, ImmutableMap.copyOf(tags));
        }
        return ImmutableMap.copyOf(result);
    }

    private static Collection<InputResolverDefinition> parseInputResolvers(Vajram<?> vajram) {
        ArrayList<InputResolverDefinition> inputResolvers = new ArrayList<InputResolverDefinition>((Collection<InputResolverDefinition>)vajram.getSimpleInputResolvers());
        ImmutableSet resolverMethods = (ImmutableSet)Arrays.stream(VajramDefinition.getVajramSourceClass(vajram.getClass()).getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Resolve.class)).collect(ImmutableSet.toImmutableSet());
        ImmutableMap dependencyDefinitions = (ImmutableMap)vajram.getFacetDefinitions().stream().filter(vi -> vi instanceof DependencyDef).map(vi -> (DependencyDef)vi).collect(ImmutableMap.toImmutableMap(VajramFacetDefinition::name, Function.identity()));
        for (Method resolverMethod : resolverMethods) {
            Resolve resolver = resolverMethod.getAnnotation(Resolve.class);
            if (resolver == null) {
                throw new AssertionError();
            }
            String targetDependency = resolver.depName();
            DependencyDef dependencyDef = (DependencyDef)dependencyDefinitions.get((Object)targetDependency);
            if (dependencyDef == null) {
                throw new IllegalStateException("Could not find dependency with name %s".formatted(targetDependency));
            }
            Object[] targetInputs = resolver.depInputs();
            ImmutableSet sources = (ImmutableSet)Arrays.stream(resolverMethod.getParameters()).map(VajramDefinition::inferFacetName).collect(ImmutableSet.toImmutableSet());
            inputResolvers.add(new DefaultInputResolverDefinition((ImmutableSet<String>)sources, new QualifiedInputs(targetDependency, dependencyDef.dataAccessSpec(), (ImmutableSet<String>)ImmutableSet.copyOf((Object[])targetInputs))));
        }
        return inputResolvers;
    }

    private static String inferFacetName(Parameter parameter) {
        return Arrays.stream(parameter.getAnnotations()).filter(annotation -> annotation instanceof Using).map(annotation -> (Using)annotation).findAny().map(Using::value).orElseGet(parameter::getName);
    }

    private static ImmutableMap<AnnotationTagKey, Tag> parseOutputLogicTags(Vajram<?> vajram) {
        Optional<Method> outputLogicMethod = Arrays.stream(VajramDefinition.getVajramSourceClass(vajram.getClass()).getDeclaredMethods()).filter(method -> method.getAnnotation(Output.class) != null).findFirst();
        List tagWithArray = outputLogicMethod.map(method -> Arrays.stream(method.getAnnotations()).map(AnnotationTag::from).toList()).orElse(List.of());
        Map collect = tagWithArray.stream().collect(Collectors.toMap(AnnotationTag::tagKey, Function.identity()));
        outputLogicMethod.ifPresent(method -> {
            AnnotationTag<NamedValueTag> vajramTypeTag = AnnotationTags.newNamedTag("vajram_type", vajram instanceof IOVajram ? "io_vajram" : "compute_vajram");
            collect.put(vajramTypeTag.tagKey(), vajramTypeTag);
        });
        AnnotationTag<NamedValueTag> vajramIdTag = AnnotationTags.newNamedTag("vajram_id", vajram.getId().vajramId());
        collect.put(vajramIdTag.tagKey(), vajramIdTag);
        return ImmutableMap.copyOf(collect);
    }

    private static Class<?> getVajramSourceClass(Class<?> vajramClass) {
        Class<?> superclass = vajramClass.getSuperclass();
        if (Object.class.equals(superclass) || superclass == null) {
            throw new IllegalArgumentException();
        }
        if (IOVajram.class.equals(superclass) || ComputeVajram.class.equals(superclass)) {
            return vajramClass;
        }
        return VajramDefinition.getVajramSourceClass(superclass);
    }

    @Generated
    public Vajram<?> getVajram() {
        return this.vajram;
    }

    @Generated
    public ImmutableCollection<InputResolverDefinition> getInputResolverDefinitions() {
        return this.inputResolverDefinitions;
    }

    @Generated
    public ImmutableMap<AnnotationTagKey, Tag> getOutputLogicTags() {
        return this.outputLogicTags;
    }

    @Generated
    public ImmutableSet<String> getOutputLogicSources() {
        return this.outputLogicSources;
    }

    @Generated
    public ImmutableMap<String, ImmutableMap<Object, Tag>> getFacetTags() {
        return this.facetTags;
    }

    @Generated
    public VajramMetadata vajramMetadata() {
        return this.vajramMetadata;
    }
}

