/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.batching;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.data.ImmutableFacetValuesContainer;
import com.flipkart.krystal.vajram.batching.BatchEnabledFacetValues;
import com.flipkart.krystal.vajram.batching.BatchedFacets;
import com.flipkart.krystal.vajram.batching.InputBatcher;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

public final class InputBatcherImpl
implements InputBatcher {
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int DEFAULT_BATCH_SIZE = 1;
    private @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Consumer<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BatchedFacets>> batchingListener;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableFacetValuesContainer, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BatchEnabledFacetValues>> unBatchedRequests = new HashMap<ImmutableFacetValuesContainer, List<BatchEnabledFacetValues>>();
    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int minBatchSize = 1;

    public InputBatcherImpl() {
    }

    public InputBatcherImpl(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int minBatchSize) {
        this.minBatchSize = minBatchSize;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BatchedFacets> add(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BatchEnabledFacetValues batchEnabledFacets) {
        ImmutableFacetValuesContainer commonFacets = batchEnabledFacets._common();
        this.unBatchedRequests.computeIfAbsent(commonFacets, k -> new ArrayList()).add(batchEnabledFacets);
        return this.getBatchedInputs(commonFacets, false);
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BatchedFacets> getBatchedInputs(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableFacetValuesContainer commonFacets, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean force) {
        if (commonFacets == null) {
            return ImmutableList.of();
        }
        List<BatchEnabledFacetValues> batchItems = this.unBatchedRequests.getOrDefault(commonFacets, (List<BatchEnabledFacetValues>)ImmutableList.of());
        if (force || batchItems.size() >= this.minBatchSize) {
            ImmutableList batchedFacets = ImmutableList.of((Object)new BatchedFacets((ImmutableList<BatchEnabledFacetValues>)ImmutableList.copyOf(batchItems)));
            this.unBatchedRequests.put(commonFacets, new ArrayList());
            return batchedFacets;
        }
        return ImmutableList.of();
    }

    @Override
    public void batch() {
        ImmutableList batchedFacets = (ImmutableList)this.unBatchedRequests.keySet().stream().map(c -> this.getBatchedInputs((ImmutableFacetValuesContainer)c, true)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        if (this.batchingListener != null) {
            this.batchingListener.accept((ImmutableList<BatchedFacets>)batchedFacets);
        }
    }

    @Override
    public void onBatching(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Consumer<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BatchedFacets>> listener) {
        this.batchingListener = listener;
    }

    public void onConfigUpdate(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ConfigProvider configProvider) {
        this.minBatchSize = configProvider.getConfig("min_batch_size").orElse(1);
    }
}

