/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.facets.resolution;

import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.vajram.exception.MandatoryFacetMissingException;
import com.flipkart.krystal.vajram.facets.resolution.SimpleInputResolverSpec;
import com.flipkart.krystal.vajram.facets.resolution.SkipPredicate;
import com.flipkart.krystal.vajram.facets.resolution.Transformer;
import com.flipkart.krystal.vajram.facets.specs.InputMirrorSpec;
import com.flipkart.krystal.vajram.facets.specs.MandatorySingleValueFacetSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class MandatorySingleValTransformFanoutResolverStage<S, T, CV extends Request, DV extends Request> {
    private final InputMirrorSpec<T, DV> targetInput;
    private final MandatorySingleValueFacetSpec<S, CV> sourceFacet;
    private final List<SkipPredicate> skipConditions = new ArrayList<SkipPredicate>();

    MandatorySingleValTransformFanoutResolverStage(InputMirrorSpec<T, DV> targetInput, MandatorySingleValueFacetSpec<S, CV> sourceFacet) {
        this.targetInput = targetInput;
        this.sourceFacet = sourceFacet;
    }

    public MandatorySingleValTransformFanoutResolverStage<S, T, CV, DV> skipIf(Predicate<S> whenToSkip, String reason) {
        this.skipConditions.add(new SkipPredicate(reason, facetValue -> whenToSkip.test(((FacetValue.SingleFacetValue)facetValue).singleValue().valueOpt().orElseThrow(this.mandatoryFacetMissingException()))));
        return this;
    }

    public SimpleInputResolverSpec<T, CV, DV> asResolver(Function<S, ? extends Collection<? extends T>> transformer) {
        return new SimpleInputResolverSpec<T, CV, DV>(this.targetInput, this.sourceFacet, this.skipConditions, new Transformer.One2Many(facetValue -> (Collection)transformer.apply(facetValue.singleValue().valueOpt().orElseThrow(this.mandatoryFacetMissingException()))));
    }

    private Supplier<MandatoryFacetMissingException> mandatoryFacetMissingException() {
        return () -> new MandatoryFacetMissingException(this.sourceFacet.ofVajramID().vajramId(), this.sourceFacet.name());
    }
}

