/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.batching;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.data.ImmutableFacetValuesContainer;
import com.flipkart.krystal.vajram.batching.BatchEnabledFacetValues;
import com.flipkart.krystal.vajram.batching.BatchedFacets;
import com.flipkart.krystal.vajram.batching.InputBatcher;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class InputBatcherImpl
implements InputBatcher {
    private static final int DEFAULT_BATCH_SIZE = 1;
    private @Nullable Consumer<ImmutableList<BatchedFacets>> batchingListener;
    private final Map<ImmutableFacetValuesContainer, List<BatchEnabledFacetValues>> unBatchedRequests = new HashMap<ImmutableFacetValuesContainer, List<BatchEnabledFacetValues>>();
    private int minBatchSize = 1;

    public InputBatcherImpl() {
    }

    public InputBatcherImpl(int minBatchSize) {
        this.minBatchSize = minBatchSize;
    }

    @Override
    public ImmutableList<BatchedFacets> add(BatchEnabledFacetValues batchEnabledFacets) {
        ImmutableFacetValuesContainer batchKey = batchEnabledFacets._batchKey();
        this.unBatchedRequests.computeIfAbsent(batchKey, k -> new ArrayList()).add(batchEnabledFacets);
        return this.getBatchedInputs(batchKey, false);
    }

    private ImmutableList<BatchedFacets> getBatchedInputs(ImmutableFacetValuesContainer batchKey, boolean force) {
        List<BatchEnabledFacetValues> batchItems = this.unBatchedRequests.getOrDefault(batchKey, (List<BatchEnabledFacetValues>)ImmutableList.of());
        if (force || batchItems.size() >= this.minBatchSize) {
            ImmutableList batchedFacets = ImmutableList.of((Object)new BatchedFacets((ImmutableList<BatchEnabledFacetValues>)ImmutableList.copyOf(batchItems)));
            this.unBatchedRequests.put(batchKey, new ArrayList());
            return batchedFacets;
        }
        return ImmutableList.of();
    }

    @Override
    public void batch() {
        ImmutableList batchedFacets = (ImmutableList)this.unBatchedRequests.keySet().stream().map(c -> this.getBatchedInputs((ImmutableFacetValuesContainer)c, true)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        if (this.batchingListener != null) {
            this.batchingListener.accept((ImmutableList<BatchedFacets>)batchedFacets);
        }
    }

    @Override
    public void onBatching(Consumer<ImmutableList<BatchedFacets>> listener) {
        this.batchingListener = listener;
    }

    public void onConfigUpdate(ConfigProvider configProvider) {
        this.minBatchSize = configProvider.getConfig("min_batch_size").orElse(1);
    }
}

