/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.krystex.ResolverDefinition;
import com.flipkart.krystal.krystex.node.IOLogicDefinition;
import com.flipkart.krystal.krystex.node.LogicDefinitionRegistry;
import com.flipkart.krystal.krystex.node.MainLogicDecorator;
import com.flipkart.krystal.krystex.node.MainLogicDefinition;
import com.flipkart.krystal.krystex.node.NodeDefinition;
import com.flipkart.krystal.krystex.node.NodeDefinitionRegistry;
import com.flipkart.krystal.krystex.node.NodeId;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import com.flipkart.krystal.krystex.node.ResolverCommand;
import com.flipkart.krystal.krystex.node.ResolverLogicDefinition;
import com.flipkart.krystal.vajram.ApplicationRequestContext;
import com.flipkart.krystal.vajram.ComputeVajram;
import com.flipkart.krystal.vajram.IOVajram;
import com.flipkart.krystal.vajram.MandatoryInputsMissingException;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramDefinitionException;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.VajramLoader;
import com.flipkart.krystal.vajram.das.AccessSpecMatchingResult;
import com.flipkart.krystal.vajram.das.DataAccessSpec;
import com.flipkart.krystal.vajram.das.VajramIndex;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.exec.VajramExecutableGraph;
import com.flipkart.krystal.vajram.inputs.Dependency;
import com.flipkart.krystal.vajram.inputs.DependencyCommand;
import com.flipkart.krystal.vajram.inputs.Input;
import com.flipkart.krystal.vajram.inputs.InputSource;
import com.flipkart.krystal.vajram.inputs.InputValuesAdaptor;
import com.flipkart.krystal.vajram.inputs.VajramInputDefinition;
import com.flipkart.krystal.vajram.modulation.InputModulator;
import com.flipkart.krystal.vajram.modulation.InputsConverter;
import com.flipkart.krystal.vajramexecutor.krystex.DecoratedLogicDefinitionRegistry;
import com.flipkart.krystal.vajramexecutor.krystex.InputModulationDecorator;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutor;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public final class VajramNodeGraph
implements VajramExecutableGraph {
    private final NodeDefinitionRegistry nodeDefinitionRegistry;
    private final DecoratedLogicDefinitionRegistry logicRegistry;
    private final Map<VajramID, VajramDefinition> vajramDefinitions = new LinkedHashMap<VajramID, VajramDefinition>();
    private final Map<VajramID, NodeId> vajramExecutables = new LinkedHashMap<VajramID, NodeId>();
    private final VajramIndex vajramIndex = new VajramIndex();
    private final Map<VajramID, Supplier<InputModulator<InputValuesAdaptor, InputValuesAdaptor>>> inputModulators = new LinkedHashMap<VajramID, Supplier<InputModulator<InputValuesAdaptor, InputValuesAdaptor>>>();

    private VajramNodeGraph() {
        LogicDefinitionRegistry logicDefinitionRegistry = new LogicDefinitionRegistry();
        this.nodeDefinitionRegistry = new NodeDefinitionRegistry(logicDefinitionRegistry);
        this.logicRegistry = new DecoratedLogicDefinitionRegistry(logicDefinitionRegistry);
    }

    public static VajramNodeGraph loadFromClasspath(String ... packagePrefixes) {
        return VajramNodeGraph.loadFromClasspath(packagePrefixes, ImmutableList.of());
    }

    public static VajramNodeGraph loadFromClasspath(String[] packagePrefixes, Iterable<Vajram<?>> vajrams) {
        VajramNodeGraph vajramNodeGraph = new VajramNodeGraph();
        for (String packagePrefix : packagePrefixes) {
            VajramLoader.loadVajramsFromClassPath((String)packagePrefix).forEach(vajramNodeGraph::registerVajram);
        }
        vajrams.forEach(vajramNodeGraph::registerVajram);
        return vajramNodeGraph;
    }

    public void registerInputModulator(VajramID vajramID, Supplier<InputModulator<InputValuesAdaptor, InputValuesAdaptor>> inputModulator) {
        this.inputModulators.put(vajramID, inputModulator);
        Vajram vajram = this.vajramDefinitions.get(vajramID).getVajram();
        if (vajram instanceof IOVajram) {
            IOVajram ioVajram = (IOVajram)vajram;
            Supplier inputModulationDecoratorSupplier = VajramNodeGraph.getInputModulationDecoratorSupplier(ioVajram, inputModulator);
            NodeId nodeId = this.vajramExecutables.get(vajramID);
            if (nodeId != null) {
                this.nodeDefinitionRegistry.logicDefinitionRegistry().getMain(this.nodeDefinitionRegistry.get(nodeId).mainLogicNode()).registerRequestScopedNodeDecorator(inputModulationDecoratorSupplier);
            }
        }
    }

    public <C extends ApplicationRequestContext> KrystexVajramExecutor<C> createExecutor(C requestContext) {
        return new KrystexVajramExecutor<C>(this, requestContext);
    }

    void registerVajram(Vajram vajram) {
        if (this.vajramDefinitions.containsKey(vajram.getId())) {
            return;
        }
        this.vajramDefinitions.put(vajram.getId(), new VajramDefinition(vajram));
        this.vajramIndex.add(vajram);
    }

    NodeId getNodeId(VajramID vajramId) {
        return this._getVajramExecutionGraph(vajramId);
    }

    private NodeId _getVajramExecutionGraph(VajramID vajramId) {
        NodeId nodeId = this.vajramExecutables.get(vajramId);
        if (nodeId != null) {
            return nodeId;
        }
        nodeId = new NodeId(vajramId.vajramId());
        this.vajramExecutables.put(vajramId, nodeId);
        VajramDefinition vajramDefinition = this.getVajramDefinition(vajramId).orElseThrow();
        InputResolverCreationResult inputResolverCreationResult = this.createNodeLogicsForInputResolvers(vajramDefinition);
        ImmutableMap<String, NodeId> depNameToProviderNode = this.createNodeDefinitionsForDependencies(vajramDefinition);
        MainLogicDefinition<?> vajramLogicMainLogicDefinition = this.createVajramNodeLogic(vajramDefinition);
        NodeDefinition nodeDefinition = this.nodeDefinitionRegistry.newNodeDefinition(nodeId.value(), vajramLogicMainLogicDefinition.nodeLogicId(), depNameToProviderNode, inputResolverCreationResult.resolverDefinitions());
        return nodeDefinition.nodeId();
    }

    private InputResolverCreationResult createNodeLogicsForInputResolvers(VajramDefinition vajramDefinition) {
        Vajram vajram = vajramDefinition.getVajram();
        VajramID vajramId = vajram.getId();
        ArrayList inputResolvers = new ArrayList(vajramDefinition.getInputResolverDefinitions());
        ImmutableList resolverDefinitions = (ImmutableList)inputResolvers.stream().map(inputResolver -> {
            String dependencyName = inputResolver.resolutionTarget().dependencyName();
            ImmutableSet resolvedInputNames = inputResolver.resolutionTarget().inputNames();
            ImmutableSet sources = inputResolver.sources();
            ImmutableCollection requiredInputs = (ImmutableCollection)vajram.getInputDefinitions().stream().filter(i -> sources.contains((Object)i.name())).collect(ImmutableList.toImmutableList());
            ResolverLogicDefinition inputResolverNode = this.logicRegistry.newResolverLogic("%s:dep(%s):inputResolver(%s)".formatted(vajramId, dependencyName, String.join((CharSequence)",", (Iterable<? extends CharSequence>)resolvedInputNames)), (Set<String>)sources, inputValues -> {
                this.validateMandatory(vajramId, inputValues, (ImmutableCollection<VajramInputDefinition>)requiredInputs);
                DependencyCommand dependencyCommand = vajram.resolveInputOfDependency(dependencyName, resolvedInputNames, inputValues);
                if (dependencyCommand instanceof DependencyCommand.Skip) {
                    DependencyCommand.Skip skipCommand = (DependencyCommand.Skip)dependencyCommand;
                    return ResolverCommand.skip((String)skipCommand.reason());
                }
                return ResolverCommand.multiExecuteWith((ImmutableList)((ImmutableList)dependencyCommand.inputs().stream().filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList())));
            });
            return new ResolverDefinition(inputResolverNode.nodeLogicId(), sources, dependencyName, resolvedInputNames);
        }).collect(ImmutableList.toImmutableList());
        return new InputResolverCreationResult((ImmutableList<ResolverDefinition>)resolverDefinitions);
    }

    private void validateMandatory(VajramID vajramID, Inputs nodeInputs, ImmutableCollection<VajramInputDefinition> requiredInputs) {
        Iterable mandatoryInputs = requiredInputs.stream().filter(inputDefinition -> inputDefinition instanceof Input).filter(VajramInputDefinition::isMandatory)::iterator;
        HashMap<String, Throwable> missingMandatoryValues = new HashMap<String, Throwable>();
        for (VajramInputDefinition mandatoryInput : mandatoryInputs) {
            ValueOrError value = nodeInputs.getInputValue(mandatoryInput.name());
            if (!value.error().isPresent() && !value.value().isEmpty()) continue;
            missingMandatoryValues.put(mandatoryInput.name(), value.error().orElse(new NoSuchElementException("No value present for input %s".formatted(mandatoryInput.name()))));
        }
        if (missingMandatoryValues.isEmpty()) {
            return;
        }
        throw new MandatoryInputsMissingException(vajramID, missingMandatoryValues);
    }

    private MainLogicDefinition<?> createVajramNodeLogic(VajramDefinition vajramDefinition) {
        VajramID vajramId = vajramDefinition.getVajram().getId();
        ImmutableCollection inputDefinitions = vajramDefinition.getVajram().getInputDefinitions();
        ImmutableSet inputs = (ImmutableSet)inputDefinitions.stream().map(VajramInputDefinition::name).collect(ImmutableSet.toImmutableSet());
        NodeLogicId vajramLogicNodeName = new NodeLogicId("%s:vajramLogic".formatted(vajramId));
        Vajram vajram = vajramDefinition.getVajram();
        if (vajram instanceof ComputeVajram) {
            ComputeVajram computeVajram = (ComputeVajram)vajram;
            return this.logicRegistry.newComputeLogic(vajramLogicNodeName.asString(), (Set<String>)inputs, nodeInputs -> {
                this.validateMandatory(vajramId, (Inputs)nodeInputs, (ImmutableCollection<VajramInputDefinition>)vajramDefinition.getVajram().getInputDefinitions());
                Inputs inputValues = VajramNodeGraph.injectFromSession((ImmutableCollection<VajramInputDefinition>)inputDefinitions, nodeInputs);
                return computeVajram.executeCompute(ImmutableList.of((Object)inputValues)).get((Object)inputValues);
            });
        }
        vajram = vajramDefinition.getVajram();
        if (vajram instanceof IOVajram) {
            IOVajram ioVajram = (IOVajram)vajram;
            IOLogicDefinition ioNodeDefinition = this.logicRegistry.newIOLogic(vajramLogicNodeName, (Set<String>)inputs, dependencyValues -> {
                dependencyValues.forEach(nodeInputs -> this.validateMandatory(vajramId, (Inputs)nodeInputs, (ImmutableCollection<VajramInputDefinition>)vajramDefinition.getVajram().getInputDefinitions()));
                ImmutableList inputValues = (ImmutableList)dependencyValues.stream().map(nodeInputs -> VajramNodeGraph.injectFromSession((ImmutableCollection<VajramInputDefinition>)inputDefinitions, nodeInputs)).collect(ImmutableList.toImmutableList());
                return ioVajram.execute(inputValues);
            });
            this.enableInputModulation(ioNodeDefinition, ioVajram);
            return ioNodeDefinition;
        }
        throw new UnsupportedOperationException();
    }

    private <T> void enableInputModulation(IOLogicDefinition<T> nodeDefinition, IOVajram<?> ioVajram) {
        Supplier<InputModulator<InputValuesAdaptor, InputValuesAdaptor>> inputModulationDecorator = this.inputModulators.get(ioVajram.getId());
        if (inputModulationDecorator != null) {
            nodeDefinition.registerRequestScopedNodeDecorator(VajramNodeGraph.getInputModulationDecoratorSupplier(ioVajram, inputModulationDecorator));
        }
    }

    private static <T> Supplier<MainLogicDecorator<T>> getInputModulationDecoratorSupplier(IOVajram<?> ioVajram, Supplier<InputModulator<InputValuesAdaptor, InputValuesAdaptor>> inputModulationDecorator) {
        InputsConverter inputsConvertor = ioVajram.getInputsConvertor();
        return () -> new InputModulationDecorator((InputModulator)inputModulationDecorator.get(), inputsConvertor);
    }

    private static Inputs injectFromSession(ImmutableCollection<VajramInputDefinition> inputDefinitions, Inputs inputs) {
        HashMap newValues = new HashMap();
        for (VajramInputDefinition inputDefinition : inputDefinitions) {
            Input input;
            String inputName = inputDefinition.name();
            if (!(inputDefinition instanceof Input) || !(input = (Input)inputDefinition).sources().contains(InputSource.CLIENT)) continue;
            ValueOrError value = inputs.getInputValue(inputName);
            if (ValueOrError.empty().equals((Object)value) && !input.sources().contains(InputSource.SESSION)) continue;
        }
        if (!newValues.isEmpty()) {
            inputs.values().forEach(newValues::putIfAbsent);
            return new Inputs(newValues);
        }
        return inputs;
    }

    private ImmutableMap<String, NodeId> createNodeDefinitionsForDependencies(VajramDefinition vajramDefinition) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (VajramInputDefinition vajramInputDefinition : vajramDefinition.getVajram().getInputDefinitions()) {
            if (!(vajramInputDefinition instanceof Dependency)) continue;
            Dependency definition = (Dependency)vajramInputDefinition;
            dependencies.add(definition);
        }
        HashMap<String, NodeId> depNameToProviderNode = new HashMap<String, NodeId>();
        for (Dependency dependency : dependencies) {
            DataAccessSpec accessSpec = dependency.dataAccessSpec();
            String dependencyName = dependency.name();
            AccessSpecMatchingResult accessSpecMatchingResult = this.vajramIndex.getVajrams(accessSpec);
            if (accessSpecMatchingResult.hasUnsuccessfulMatches()) {
                throw new VajramDefinitionException("Unable to find vajrams for accessSpecs %s".formatted(accessSpecMatchingResult.unsuccessfulMatches()));
            }
            ImmutableMap dependencyVajrams = accessSpecMatchingResult.successfulMatches();
            if (dependencyVajrams.size() > 1) {
                throw new UnsupportedOperationException();
            }
            Vajram dependencyVajram = (Vajram)dependencyVajrams.values().iterator().next();
            depNameToProviderNode.put(dependencyName, this._getVajramExecutionGraph(dependencyVajram.getId()));
        }
        return ImmutableMap.copyOf(depNameToProviderNode);
    }

    private Optional<VajramDefinition> getVajramDefinition(VajramID vajramId) {
        return Optional.ofNullable(this.vajramDefinitions.get(vajramId));
    }

    public NodeDefinitionRegistry getNodeDefinitionRegistry() {
        return this.nodeDefinitionRegistry;
    }

    private record InputResolverCreationResult(ImmutableList<ResolverDefinition> resolverDefinitions) {
    }
}

