/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.krystex.ComputeLogicDefinition;
import com.flipkart.krystal.krystex.IOLogicDefinition;
import com.flipkart.krystal.krystex.LogicDefinitionRegistry;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.ResolverCommand;
import com.flipkart.krystal.krystex.ResolverDefinition;
import com.flipkart.krystal.krystex.ResolverLogicDefinition;
import com.flipkart.krystal.krystex.SingleThreadExecutorPool;
import com.flipkart.krystal.krystex.decoration.LogicDecorationOrdering;
import com.flipkart.krystal.krystex.decoration.MainLogicDecoratorConfig;
import com.flipkart.krystal.krystex.node.NodeDefinition;
import com.flipkart.krystal.krystex.node.NodeDefinitionRegistry;
import com.flipkart.krystal.krystex.node.NodeId;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import com.flipkart.krystal.logic.LogicTag;
import com.flipkart.krystal.utils.MultiLeasePool;
import com.flipkart.krystal.vajram.ApplicationRequestContext;
import com.flipkart.krystal.vajram.ComputeVajram;
import com.flipkart.krystal.vajram.IOVajram;
import com.flipkart.krystal.vajram.MandatoryInputsMissingException;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramDefinitionException;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.VajramLoader;
import com.flipkart.krystal.vajram.das.AccessSpecMatchingResult;
import com.flipkart.krystal.vajram.das.DataAccessSpec;
import com.flipkart.krystal.vajram.das.VajramIndex;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.exec.VajramExecutableGraph;
import com.flipkart.krystal.vajram.inputs.Dependency;
import com.flipkart.krystal.vajram.inputs.DependencyCommand;
import com.flipkart.krystal.vajram.inputs.Input;
import com.flipkart.krystal.vajram.inputs.InputResolver;
import com.flipkart.krystal.vajram.inputs.InputSource;
import com.flipkart.krystal.vajram.inputs.VajramInputDefinition;
import com.flipkart.krystal.vajramexecutor.krystex.InputModulationDecorator;
import com.flipkart.krystal.vajramexecutor.krystex.InputModulatorConfig;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutor;
import com.flipkart.krystal.vajramexecutor.krystex.LogicDefRegistryDecorator;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public final class VajramNodeGraph
implements VajramExecutableGraph {
    private final NodeDefinitionRegistry nodeDefinitionRegistry;
    private final LogicDefRegistryDecorator logicRegistryDecorator;
    private final Map<VajramID, VajramDefinition> vajramDefinitions = new LinkedHashMap<VajramID, VajramDefinition>();
    private final Map<VajramID, NodeId> vajramExecutables = new LinkedHashMap<VajramID, NodeId>();
    private final VajramIndex vajramIndex = new VajramIndex();
    private final ImmutableMap<VajramID, InputModulatorConfig> inputModulatorConfigs;
    private final ImmutableMap<String, MainLogicDecoratorConfig> sessionScopedDecoratorConfigs;
    private final LogicDecorationOrdering logicDecorationOrdering;
    private final SingleThreadExecutorPool executorPool;

    private VajramNodeGraph(String[] packagePrefixes, ImmutableMap<VajramID, InputModulatorConfig> inputModulatorConfigs, ImmutableMap<String, MainLogicDecoratorConfig> sessionScopedDecorators, LogicDecorationOrdering logicDecorationOrdering, int executorPool) {
        this.inputModulatorConfigs = inputModulatorConfigs;
        this.sessionScopedDecoratorConfigs = sessionScopedDecorators;
        this.logicDecorationOrdering = logicDecorationOrdering;
        this.executorPool = new SingleThreadExecutorPool(executorPool);
        LogicDefinitionRegistry logicDefinitionRegistry = new LogicDefinitionRegistry();
        this.nodeDefinitionRegistry = new NodeDefinitionRegistry(logicDefinitionRegistry);
        this.logicRegistryDecorator = new LogicDefRegistryDecorator(logicDefinitionRegistry);
        for (String packagePrefix : packagePrefixes) {
            VajramLoader.loadVajramsFromClassPath((String)packagePrefix).forEach(this::registerVajram);
        }
    }

    public MultiLeasePool<ExecutorService> getExecutorPool() {
        return this.executorPool;
    }

    public <C extends ApplicationRequestContext> KrystexVajramExecutor<C> createExecutor(C requestContext) {
        return new KrystexVajramExecutor<C>(this, this.logicDecorationOrdering, this.executorPool, requestContext);
    }

    private void registerVajram(Vajram vajram) {
        if (this.vajramDefinitions.containsKey(vajram.getId())) {
            return;
        }
        this.vajramDefinitions.put(vajram.getId(), new VajramDefinition(vajram));
        this.vajramIndex.add(vajram);
    }

    NodeId getNodeId(VajramID vajramId) {
        return this._getVajramExecutionGraph(vajramId);
    }

    private NodeId _getVajramExecutionGraph(VajramID vajramId) {
        NodeId nodeId = this.vajramExecutables.get(vajramId);
        if (nodeId != null) {
            return nodeId;
        }
        nodeId = new NodeId(vajramId.vajramId());
        this.vajramExecutables.put(vajramId, nodeId);
        VajramDefinition vajramDefinition = this.getVajramDefinition(vajramId).orElseThrow(() -> new NoSuchElementException("Could not find vajram with id: %s".formatted(vajramId)));
        InputResolverCreationResult inputResolverCreationResult = this.createNodeLogicsForInputResolvers(vajramDefinition);
        ImmutableMap<String, NodeId> depNameToProviderNode = this.createNodeDefinitionsForDependencies(vajramDefinition);
        MainLogicDefinition<?> vajramLogicMainLogicDefinition = this.createVajramNodeLogic(vajramDefinition);
        NodeDefinition nodeDefinition = this.nodeDefinitionRegistry.newNodeDefinition(nodeId.value(), vajramLogicMainLogicDefinition.nodeLogicId(), depNameToProviderNode, inputResolverCreationResult.resolverDefinitions());
        return nodeDefinition.nodeId();
    }

    private InputResolverCreationResult createNodeLogicsForInputResolvers(VajramDefinition vajramDefinition) {
        Vajram vajram = vajramDefinition.getVajram();
        VajramID vajramId = vajram.getId();
        ArrayList inputResolvers = new ArrayList(vajramDefinition.getInputResolverDefinitions());
        ImmutableList resolverDefinitions = (ImmutableList)inputResolvers.stream().map(inputResolverDefinition -> {
            String dependencyName = inputResolverDefinition.resolutionTarget().dependencyName();
            ImmutableSet resolvedInputNames = inputResolverDefinition.resolutionTarget().inputNames();
            ImmutableSet sources = inputResolverDefinition.sources();
            ImmutableCollection requiredInputs = (ImmutableCollection)vajram.getInputDefinitions().stream().filter(i -> sources.contains((Object)i.name())).collect(ImmutableList.toImmutableList());
            ResolverLogicDefinition inputResolverNode = this.logicRegistryDecorator.newResolverLogic("%s:dep(%s):inputResolver(%s)".formatted(vajramId, dependencyName, String.join((CharSequence)",", (Iterable<? extends CharSequence>)resolvedInputNames)), (Set<String>)sources, inputValues -> {
                DependencyCommand dependencyCommand;
                this.validateMandatory(vajramId, inputValues, (ImmutableCollection<VajramInputDefinition>)requiredInputs);
                if (inputResolverDefinition instanceof InputResolver) {
                    InputResolver inputResolver = (InputResolver)inputResolverDefinition;
                    dependencyCommand = inputResolver.resolve(dependencyName, resolvedInputNames, inputValues);
                } else {
                    dependencyCommand = vajram.resolveInputOfDependency(dependencyName, resolvedInputNames, inputValues);
                }
                if (dependencyCommand instanceof DependencyCommand.Skip) {
                    DependencyCommand.Skip skipCommand = (DependencyCommand.Skip)dependencyCommand;
                    return ResolverCommand.skip((String)skipCommand.reason());
                }
                return ResolverCommand.multiExecuteWith((ImmutableList)((ImmutableList)dependencyCommand.inputs().stream().filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList())));
            });
            return new ResolverDefinition(inputResolverNode.nodeLogicId(), sources, dependencyName, resolvedInputNames);
        }).collect(ImmutableList.toImmutableList());
        return new InputResolverCreationResult((ImmutableList<ResolverDefinition>)resolverDefinitions);
    }

    private void validateMandatory(VajramID vajramID, Inputs inputs, ImmutableCollection<VajramInputDefinition> requiredInputs) {
        Iterable mandatoryInputs = requiredInputs.stream().filter(inputDefinition -> inputDefinition instanceof Input).filter(VajramInputDefinition::isMandatory)::iterator;
        HashMap<String, Throwable> missingMandatoryValues = new HashMap<String, Throwable>();
        for (VajramInputDefinition mandatoryInput : mandatoryInputs) {
            ValueOrError value = inputs.getInputValue(mandatoryInput.name());
            if (!value.error().isPresent() && !value.value().isEmpty()) continue;
            missingMandatoryValues.put(mandatoryInput.name(), value.error().orElse(new NoSuchElementException("No value present for input %s".formatted(mandatoryInput.name()))));
        }
        if (missingMandatoryValues.isEmpty()) {
            return;
        }
        throw new MandatoryInputsMissingException(vajramID, missingMandatoryValues);
    }

    private MainLogicDefinition<?> createVajramNodeLogic(VajramDefinition vajramDefinition) {
        ComputeLogicDefinition vajramLogic;
        VajramID vajramId = vajramDefinition.getVajram().getId();
        ImmutableCollection inputDefinitions = vajramDefinition.getVajram().getInputDefinitions();
        ImmutableSet inputNames = (ImmutableSet)inputDefinitions.stream().map(VajramInputDefinition::name).collect(ImmutableSet.toImmutableSet());
        NodeLogicId vajramLogicNodeName = new NodeLogicId("%s:vajramLogic".formatted(vajramId));
        Vajram vajram = vajramDefinition.getVajram();
        if (vajram instanceof ComputeVajram) {
            ComputeVajram computeVajram = (ComputeVajram)vajram;
            vajramLogic = this.logicRegistryDecorator.newComputeLogic(vajramLogicNodeName.asString(), (Set<String>)inputNames, inputs -> {
                this.validateMandatory(vajramId, (Inputs)inputs, (ImmutableCollection<VajramInputDefinition>)vajramDefinition.getVajram().getInputDefinitions());
                Inputs inputValues = VajramNodeGraph.injectFromSession((ImmutableCollection<VajramInputDefinition>)inputDefinitions, inputs);
                return ValueOrError.valueOrError(() -> computeVajram.executeCompute(inputValues));
            }, (ImmutableMap<String, LogicTag>)vajramDefinition.getMainLogicTags());
        } else {
            vajram = vajramDefinition.getVajram();
            if (vajram instanceof IOVajram) {
                IOVajram ioVajram = (IOVajram)vajram;
                IOLogicDefinition ioNodeDefinition = this.logicRegistryDecorator.newIOLogic(vajramLogicNodeName, (Set<String>)inputNames, dependencyValues -> {
                    dependencyValues.forEach(inputs -> this.validateMandatory(vajramId, (Inputs)inputs, (ImmutableCollection<VajramInputDefinition>)vajramDefinition.getVajram().getInputDefinitions()));
                    ImmutableList inputValues = (ImmutableList)dependencyValues.stream().map(inputs -> VajramNodeGraph.injectFromSession((ImmutableCollection<VajramInputDefinition>)inputDefinitions, inputs)).collect(ImmutableList.toImmutableList());
                    return ioVajram.execute(inputValues);
                }, (ImmutableMap<String, LogicTag>)vajramDefinition.getMainLogicTags());
                this.enableInputModulation(ioNodeDefinition, ioVajram);
                vajramLogic = ioNodeDefinition;
            } else {
                throw new UnsupportedOperationException();
            }
        }
        this.sessionScopedDecoratorConfigs.values().forEach(arg_0 -> vajramLogic.registerSessionScopedLogicDecorator(arg_0));
        return vajramLogic;
    }

    private <T> void enableInputModulation(IOLogicDefinition<T> logicDefinition, IOVajram<?> ioVajram) {
        InputModulatorConfig inputModulatorConfig = (InputModulatorConfig)this.inputModulatorConfigs.get((Object)ioVajram.getId());
        if (inputModulatorConfig != null) {
            logicDefinition.registerRequestScopedDecorator(new MainLogicDecoratorConfig(InputModulationDecorator.DECORATOR_TYPE, nodeExecutionContext -> ioVajram.getInputDefinitions().stream().filter(inputDefinition -> inputDefinition instanceof Input).map(inputDefinition -> (Input)inputDefinition).anyMatch(Input::needsModulation), inputModulatorConfig.instanceIdGenerator(), decoratorContext -> inputModulatorConfig.decoratorFactory().apply(new InputModulatorConfig.ModulatorContext(ioVajram, (MainLogicDecoratorConfig.DecoratorContext)decoratorContext))));
        }
    }

    private static Inputs injectFromSession(ImmutableCollection<VajramInputDefinition> inputDefinitions, Inputs inputs) {
        HashMap newValues = new HashMap();
        for (VajramInputDefinition inputDefinition : inputDefinitions) {
            String inputName = inputDefinition.name();
            if (!(inputDefinition instanceof Input)) continue;
            Input input = (Input)inputDefinition;
            if (input.sources().contains(InputSource.CLIENT)) {
                ValueOrError value = inputs.getInputValue(inputName);
                if (!ValueOrError.empty().equals((Object)value)) continue;
            }
            if (!input.sources().contains(InputSource.SESSION)) continue;
        }
        if (!newValues.isEmpty()) {
            inputs.values().forEach(newValues::putIfAbsent);
            return new Inputs(newValues);
        }
        return inputs;
    }

    private ImmutableMap<String, NodeId> createNodeDefinitionsForDependencies(VajramDefinition vajramDefinition) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (VajramInputDefinition vajramInputDefinition : vajramDefinition.getVajram().getInputDefinitions()) {
            if (!(vajramInputDefinition instanceof Dependency)) continue;
            Dependency definition = (Dependency)vajramInputDefinition;
            dependencies.add(definition);
        }
        HashMap<String, NodeId> depNameToProviderNode = new HashMap<String, NodeId>();
        for (Dependency dependency : dependencies) {
            DataAccessSpec accessSpec = dependency.dataAccessSpec();
            String dependencyName = dependency.name();
            AccessSpecMatchingResult accessSpecMatchingResult = this.vajramIndex.getVajrams(accessSpec);
            if (accessSpecMatchingResult.hasUnsuccessfulMatches()) {
                throw new VajramDefinitionException("Unable to find vajrams for accessSpecs %s".formatted(accessSpecMatchingResult.unsuccessfulMatches()));
            }
            ImmutableMap dependencyVajrams = accessSpecMatchingResult.successfulMatches();
            if (dependencyVajrams.size() > 1) {
                throw new UnsupportedOperationException();
            }
            Vajram dependencyVajram = (Vajram)dependencyVajrams.values().iterator().next();
            depNameToProviderNode.put(dependencyName, this._getVajramExecutionGraph(dependencyVajram.getId()));
        }
        return ImmutableMap.copyOf(depNameToProviderNode);
    }

    private Optional<VajramDefinition> getVajramDefinition(VajramID vajramId) {
        return Optional.ofNullable(this.vajramDefinitions.get(vajramId));
    }

    public static Builder builder() {
        return new Builder();
    }

    public NodeDefinitionRegistry getNodeDefinitionRegistry() {
        return this.nodeDefinitionRegistry;
    }

    private record InputResolverCreationResult(ImmutableList<ResolverDefinition> resolverDefinitions) {
    }

    public static final class Builder {
        private final LinkedHashSet<String> packagePrefixes = new LinkedHashSet();
        private final Map<String, MainLogicDecoratorConfig> sessionScopedDecoratorConfigs = new HashMap<String, MainLogicDecoratorConfig>();
        private final Map<VajramID, InputModulatorConfig> inputModulators = new LinkedHashMap<VajramID, InputModulatorConfig>();
        private LogicDecorationOrdering logicDecorationOrdering = new LogicDecorationOrdering(ImmutableSet.of());
        private int maxRequestsPerThread = 1;

        public Builder loadFromPackage(String packagePrefix) {
            this.packagePrefixes.add(packagePrefix);
            return this;
        }

        public Builder decorateVajramLogicForSession(MainLogicDecoratorConfig logicDecoratorConfig) {
            if (this.sessionScopedDecoratorConfigs.putIfAbsent(logicDecoratorConfig.decoratorType(), logicDecoratorConfig) != null) {
                throw new IllegalArgumentException("Cannot have two decorator configs for same decorator type : %s".formatted(logicDecoratorConfig.decoratorType()));
            }
            return this;
        }

        public Builder maxRequestsPerThread(int maxRequestsPerThread) {
            this.maxRequestsPerThread = maxRequestsPerThread;
            return this;
        }

        public Builder registerInputModulator(VajramID vajramID, InputModulatorConfig inputModulator) {
            this.inputModulators.put(vajramID, inputModulator);
            return this;
        }

        public Builder logicDecorationOrdering(LogicDecorationOrdering logicDecorationOrdering) {
            this.logicDecorationOrdering = logicDecorationOrdering;
            return this;
        }

        public VajramNodeGraph build() {
            return new VajramNodeGraph((String[])this.packagePrefixes.toArray(String[]::new), (ImmutableMap<VajramID, InputModulatorConfig>)ImmutableMap.copyOf(this.inputModulators), (ImmutableMap<String, MainLogicDecoratorConfig>)ImmutableMap.copyOf(this.sessionScopedDecoratorConfigs), this.logicDecorationOrdering, this.maxRequestsPerThread);
        }
    }
}

