/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.krystex.KrystalExecutor;
import com.flipkart.krystal.krystex.decoration.LogicDecorationOrdering;
import com.flipkart.krystal.krystex.node.KrystalNodeExecutor;
import com.flipkart.krystal.utils.MultiLeasePool;
import com.flipkart.krystal.vajram.ApplicationRequestContext;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.VajramRequest;
import com.flipkart.krystal.vajram.exec.VajramExecutor;
import com.flipkart.krystal.vajramexecutor.krystex.VajramNodeGraph;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

public class KrystexVajramExecutor<C extends ApplicationRequestContext>
implements VajramExecutor<C> {
    private final VajramNodeGraph vajramNodeGraph;
    private final C applicationRequestContext;
    private final KrystalExecutor krystalExecutor;

    public KrystexVajramExecutor(VajramNodeGraph vajramNodeGraph, LogicDecorationOrdering logicDecorationOrdering, MultiLeasePool<? extends ExecutorService> executorServicePool, C applicationRequestContext) {
        this.vajramNodeGraph = vajramNodeGraph;
        this.applicationRequestContext = applicationRequestContext;
        this.krystalExecutor = new KrystalNodeExecutor(vajramNodeGraph.getNodeDefinitionRegistry(), logicDecorationOrdering, executorServicePool, applicationRequestContext.requestId());
    }

    public <T> CompletableFuture<T> execute(VajramID vajramId, Function<C, VajramRequest> vajramRequestBuilder) {
        return this.krystalExecutor.executeNode(this.vajramNodeGraph.getNodeId(vajramId), vajramRequestBuilder.apply(this.applicationRequestContext).toInputValues());
    }

    public <T> CompletableFuture<T> execute(VajramID vajramId, Function<C, VajramRequest> vajramRequestBuilder, String requestId) {
        return this.krystalExecutor.executeNode(this.vajramNodeGraph.getNodeId(vajramId), vajramRequestBuilder.apply(this.applicationRequestContext).toInputValues(), requestId);
    }

    public void flush() {
        this.krystalExecutor.flush();
    }

    public void close() {
        this.krystalExecutor.close();
    }
}

