/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.krystex.ForkJoinExecutorPool;
import com.flipkart.krystal.krystex.LogicDefinitionRegistry;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.ResolverCommand;
import com.flipkart.krystal.krystex.ResolverDefinition;
import com.flipkart.krystal.krystex.ResolverLogicDefinition;
import com.flipkart.krystal.krystex.decoration.LogicDecorationOrdering;
import com.flipkart.krystal.krystex.decoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.decoration.MainLogicDecoratorConfig;
import com.flipkart.krystal.krystex.node.DependantChain;
import com.flipkart.krystal.krystex.node.KrystalNodeExecutorConfig;
import com.flipkart.krystal.krystex.node.NodeDefinition;
import com.flipkart.krystal.krystex.node.NodeDefinitionRegistry;
import com.flipkart.krystal.krystex.node.NodeId;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import com.flipkart.krystal.utils.MultiLeasePool;
import com.flipkart.krystal.vajram.ApplicationRequestContext;
import com.flipkart.krystal.vajram.IOVajram;
import com.flipkart.krystal.vajram.MandatoryInputsMissingException;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramDefinitionException;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.VajramLoader;
import com.flipkart.krystal.vajram.das.AccessSpecMatchingResult;
import com.flipkart.krystal.vajram.das.DataAccessSpec;
import com.flipkart.krystal.vajram.das.VajramIndex;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.exec.VajramExecutableGraph;
import com.flipkart.krystal.vajram.inputs.Dependency;
import com.flipkart.krystal.vajram.inputs.DependencyCommand;
import com.flipkart.krystal.vajram.inputs.Input;
import com.flipkart.krystal.vajram.inputs.InputSource;
import com.flipkart.krystal.vajram.inputs.SingleExecute;
import com.flipkart.krystal.vajram.inputs.VajramInputDefinition;
import com.flipkart.krystal.vajram.inputs.resolution.InputResolver;
import com.flipkart.krystal.vajramexecutor.krystex.InputModulationDecorator;
import com.flipkart.krystal.vajramexecutor.krystex.InputModulatorConfig;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutor;
import com.flipkart.krystal.vajramexecutor.krystex.LogicDefRegistryDecorator;
import com.flipkart.krystal.vajramexecutor.krystex.inputinjection.InputInjectionProvider;
import com.flipkart.krystal.vajramexecutor.krystex.inputinjection.InputInjector;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;

public final class VajramNodeGraph
implements VajramExecutableGraph {
    private final NodeDefinitionRegistry nodeDefinitionRegistry;
    private final LogicDefRegistryDecorator logicRegistryDecorator;
    private final Map<VajramID, VajramDefinition> vajramDefinitions = new LinkedHashMap<VajramID, VajramDefinition>();
    private final Map<VajramID, NodeId> vajramExecutables = new LinkedHashMap<VajramID, NodeId>();
    private final VajramIndex vajramIndex = new VajramIndex();
    private final ImmutableMap<String, MainLogicDecoratorConfig> sessionScopedDecoratorConfigs;
    private final LogicDecorationOrdering logicDecorationOrdering;
    private final MultiLeasePool<? extends ExecutorService> executorPool;
    private final InputInjector inputInjector;

    private VajramNodeGraph(String[] packagePrefixes, ImmutableMap<String, MainLogicDecoratorConfig> sessionScopedDecorators, LogicDecorationOrdering logicDecorationOrdering, InputInjectionProvider inputInjectionProvider, double maxParallelismPerCore) {
        this.sessionScopedDecoratorConfigs = sessionScopedDecorators;
        this.logicDecorationOrdering = logicDecorationOrdering;
        this.executorPool = new ForkJoinExecutorPool(maxParallelismPerCore);
        LogicDefinitionRegistry logicDefinitionRegistry = new LogicDefinitionRegistry();
        this.nodeDefinitionRegistry = new NodeDefinitionRegistry(logicDefinitionRegistry);
        this.logicRegistryDecorator = new LogicDefRegistryDecorator(logicDefinitionRegistry);
        for (String packagePrefix : packagePrefixes) {
            VajramLoader.loadVajramsFromClassPath((String)packagePrefix).forEach(this::registerVajram);
        }
        this.inputInjector = new InputInjector(this, inputInjectionProvider);
    }

    public MultiLeasePool<? extends ExecutorService> getExecutorPool() {
        return this.executorPool;
    }

    public <C extends ApplicationRequestContext> KrystexVajramExecutor<C> createExecutor(C requestContext) {
        return this.createExecutor(requestContext, KrystalNodeExecutorConfig.builder().build());
    }

    public <C extends ApplicationRequestContext> KrystexVajramExecutor<C> createExecutor(C requestContext, KrystalNodeExecutorConfig krystexConfig) {
        if (this.logicDecorationOrdering != null && LogicDecorationOrdering.none().equals((Object)krystexConfig.logicDecorationOrdering())) {
            krystexConfig = krystexConfig.toBuilder().logicDecorationOrdering(this.logicDecorationOrdering).build();
        }
        return new KrystexVajramExecutor<C>(this, requestContext, this.executorPool, krystexConfig);
    }

    public void registerInputModulators(VajramID vajramID, InputModulatorConfig ... inputModulators) {
        NodeId nodeId = this.getNodeId(vajramID);
        VajramDefinition vajramDefinition = this.vajramDefinitions.get(vajramID);
        MainLogicDefinition mainLogicDefinition = this.nodeDefinitionRegistry.get(nodeId).getMainLogicDefinition();
        if (nodeId == null || vajramDefinition == null || mainLogicDefinition == null) {
            throw new IllegalArgumentException("Unable to find vajram with id %s".formatted(vajramID));
        }
        Vajram vajram = vajramDefinition.getVajram();
        ArrayList<MainLogicDecoratorConfig> mainLogicDecoratorConfigList = new ArrayList<MainLogicDecoratorConfig>();
        for (InputModulatorConfig inputModulatorConfig : inputModulators) {
            Predicate<LogicExecutionContext> biFunction = logicExecutionContext -> vajram.getInputDefinitions().stream().filter(inputDefinition -> inputDefinition instanceof Input).map(inputDefinition -> (Input)inputDefinition).anyMatch(Input::needsModulation) && inputModulatorConfig.shouldModulate().test((LogicExecutionContext)logicExecutionContext);
            mainLogicDecoratorConfigList.add(new MainLogicDecoratorConfig(InputModulationDecorator.DECORATOR_TYPE, biFunction, inputModulatorConfig.instanceIdGenerator(), decoratorContext -> inputModulatorConfig.decoratorFactory().apply(new InputModulatorConfig.ModulatorContext((Vajram<?>)vajram, (MainLogicDecoratorConfig.DecoratorContext)decoratorContext))));
        }
        mainLogicDefinition.registerRequestScopedDecorator(mainLogicDecoratorConfigList);
    }

    public DependantChain computeDependantChain(String firstVajramId, String firstDependencyName, String ... subsequentDependencyNames) {
        NodeId firstNodeId = this._getVajramExecutionGraph(VajramID.vajramID((String)firstVajramId));
        NodeDefinition currentNode = this.nodeDefinitionRegistry.get(firstNodeId);
        DependantChain currentDepChain = DependantChain.start((NodeId)firstNodeId, (String)firstDependencyName);
        String previousDepName = firstDependencyName;
        for (String currentDepName : subsequentDependencyNames) {
            NodeId depNodeId = (NodeId)currentNode.dependencyNodes().get((Object)previousDepName);
            if (depNodeId == null) {
                throw new IllegalStateException("Unable find node for dependency %s of node %s".formatted(currentDepName, currentNode));
            }
            currentDepChain = DependantChain.extend((DependantChain)currentDepChain, (NodeId)depNodeId, (String)currentDepName);
            currentNode = this.nodeDefinitionRegistry.get(depNodeId);
            previousDepName = currentDepName;
        }
        return currentDepChain;
    }

    public void close() {
        this.executorPool.close();
    }

    private void registerVajram(Vajram vajram) {
        if (this.vajramDefinitions.containsKey(vajram.getId())) {
            return;
        }
        this.vajramDefinitions.put(vajram.getId(), new VajramDefinition(vajram));
        this.vajramIndex.add(vajram);
    }

    NodeId getNodeId(VajramID vajramId) {
        return this._getVajramExecutionGraph(vajramId);
    }

    private NodeId _getVajramExecutionGraph(VajramID vajramId) {
        NodeId nodeId = this.vajramExecutables.get(vajramId);
        if (nodeId != null) {
            return nodeId;
        }
        nodeId = new NodeId(vajramId.vajramId());
        this.vajramExecutables.put(vajramId, nodeId);
        VajramDefinition vajramDefinition = this.getVajramDefinition(vajramId).orElseThrow(() -> new NoSuchElementException("Could not find vajram with id: %s".formatted(vajramId)));
        InputResolverCreationResult inputResolverCreationResult = this.createNodeLogicsForInputResolvers(vajramDefinition);
        ImmutableMap<String, NodeId> depNameToProviderNode = this.createNodeDefinitionsForDependencies(vajramDefinition);
        MainLogicDefinition<?> vajramLogicMainLogicDefinition = this.createVajramNodeLogic(nodeId, vajramDefinition);
        NodeDefinition nodeDefinition = this.nodeDefinitionRegistry.newNodeDefinition(nodeId.value(), vajramLogicMainLogicDefinition.nodeLogicId(), depNameToProviderNode, inputResolverCreationResult.resolverDefinitions());
        return nodeDefinition.nodeId();
    }

    private InputResolverCreationResult createNodeLogicsForInputResolvers(VajramDefinition vajramDefinition) {
        Vajram vajram = vajramDefinition.getVajram();
        VajramID vajramId = vajram.getId();
        ImmutableCollection inputDefinitions = vajram.getInputDefinitions();
        ArrayList inputResolvers = new ArrayList(vajramDefinition.getInputResolverDefinitions());
        ImmutableList resolverDefinitions = (ImmutableList)inputResolvers.stream().map(inputResolverDefinition -> {
            String dependencyName = inputResolverDefinition.resolutionTarget().dependencyName();
            ImmutableSet resolvedInputNames = inputResolverDefinition.resolutionTarget().inputNames();
            ImmutableSet sources = inputResolverDefinition.sources();
            ImmutableCollection requiredInputs = (ImmutableCollection)inputDefinitions.stream().filter(def -> sources.contains((Object)def.name())).collect(ImmutableList.toImmutableList());
            ResolverLogicDefinition inputResolverNode = this.logicRegistryDecorator.newResolverLogic(vajramId.vajramId(), "%s:dep(%s):inputResolver(%s)".formatted(vajramId, dependencyName, String.join((CharSequence)",", (Iterable<? extends CharSequence>)resolvedInputNames)), (Set<String>)sources, inputValues -> {
                DependencyCommand dependencyCommand;
                this.validateMandatory(vajramId, inputValues, (ImmutableCollection<VajramInputDefinition>)requiredInputs);
                try {
                    if (inputResolverDefinition instanceof InputResolver) {
                        InputResolver inputResolver = (InputResolver)inputResolverDefinition;
                        dependencyCommand = inputResolver.resolve(dependencyName, resolvedInputNames, inputValues);
                    } else {
                        dependencyCommand = vajram.resolveInputOfDependency(dependencyName, resolvedInputNames, inputValues);
                    }
                }
                catch (Throwable t) {
                    dependencyCommand = SingleExecute.skipExecution((String)"Resolver threw exception: %s".formatted(Throwables.getStackTraceAsString((Throwable)t)));
                }
                if (dependencyCommand.shouldSkip()) {
                    return ResolverCommand.skip((String)dependencyCommand.doc());
                }
                return ResolverCommand.multiExecuteWith((ImmutableList)((ImmutableList)dependencyCommand.inputs().stream().filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList())));
            });
            return new ResolverDefinition(inputResolverNode.nodeLogicId(), sources, dependencyName, resolvedInputNames);
        }).collect(ImmutableList.toImmutableList());
        return new InputResolverCreationResult((ImmutableList<ResolverDefinition>)resolverDefinitions);
    }

    private void validateMandatory(VajramID vajramID, Inputs inputs, ImmutableCollection<VajramInputDefinition> requiredInputs) {
        Iterable mandatoryInputs = requiredInputs.stream().filter(inputDefinition -> inputDefinition instanceof Input).filter(VajramInputDefinition::isMandatory)::iterator;
        HashMap<String, Throwable> missingMandatoryValues = new HashMap<String, Throwable>();
        for (VajramInputDefinition mandatoryInput : mandatoryInputs) {
            ValueOrError value = inputs.getInputValue(mandatoryInput.name());
            if (!value.error().isPresent() && !value.value().isEmpty()) continue;
            missingMandatoryValues.put(mandatoryInput.name(), value.error().orElse(new NoSuchElementException("No value present for input %s".formatted(mandatoryInput.name()))));
        }
        if (missingMandatoryValues.isEmpty()) {
            return;
        }
        throw new MandatoryInputsMissingException(vajramID, missingMandatoryValues);
    }

    private MainLogicDefinition<?> createVajramNodeLogic(NodeId nodeId, VajramDefinition vajramDefinition) {
        VajramID vajramId = vajramDefinition.getVajram().getId();
        ImmutableCollection inputDefinitions = vajramDefinition.getVajram().getInputDefinitions();
        ImmutableSet inputNames = (ImmutableSet)inputDefinitions.stream().map(VajramInputDefinition::name).collect(ImmutableSet.toImmutableSet());
        NodeLogicId vajramLogicNodeName = new NodeLogicId(nodeId, "%s:vajramLogic".formatted(vajramId));
        MainLogicDefinition vajramLogic = this.logicRegistryDecorator.newMainLogic(vajramDefinition.getVajram() instanceof IOVajram, vajramLogicNodeName, (Set<String>)inputNames, inputsList -> {
            inputsList.forEach(inputs -> this.validateMandatory(vajramId, (Inputs)inputs, (ImmutableCollection<VajramInputDefinition>)inputDefinitions));
            return vajramDefinition.getVajram().execute(inputsList);
        }, (ImmutableMap<String, Tag>)vajramDefinition.getMainLogicTags());
        this.registerInputInjector(vajramLogic, vajramDefinition.getVajram());
        this.sessionScopedDecoratorConfigs.values().forEach(arg_0 -> vajramLogic.registerSessionScopedLogicDecorator(arg_0));
        return vajramLogic;
    }

    private <T> void registerInputInjector(MainLogicDefinition<T> logicDefinition, Vajram<?> vajram) {
        logicDefinition.registerSessionScopedLogicDecorator(new MainLogicDecoratorConfig(InputInjector.DECORATOR_TYPE, logicExecutionContext -> vajram.getInputDefinitions().stream().filter(inputDefinition -> inputDefinition instanceof Input).map(inputDefinition -> (Input)inputDefinition).anyMatch(input -> input.sources() != null && input.sources().contains((Object)InputSource.SESSION)), logicExecutionContext -> logicExecutionContext.nodeId().value(), decoratorContext -> this.inputInjector));
    }

    private ImmutableMap<String, NodeId> createNodeDefinitionsForDependencies(VajramDefinition vajramDefinition) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (VajramInputDefinition vajramInputDefinition : vajramDefinition.getVajram().getInputDefinitions()) {
            if (!(vajramInputDefinition instanceof Dependency)) continue;
            Dependency definition = (Dependency)vajramInputDefinition;
            dependencies.add(definition);
        }
        HashMap<String, NodeId> depNameToProviderNode = new HashMap<String, NodeId>();
        for (Dependency dependency : dependencies) {
            DataAccessSpec accessSpec = dependency.dataAccessSpec();
            String dependencyName = dependency.name();
            AccessSpecMatchingResult accessSpecMatchingResult = this.vajramIndex.getVajrams(accessSpec);
            if (accessSpecMatchingResult.hasUnsuccessfulMatches()) {
                throw new VajramDefinitionException("Unable to find vajrams for accessSpecs %s".formatted(accessSpecMatchingResult.unsuccessfulMatches()));
            }
            ImmutableMap dependencyVajrams = accessSpecMatchingResult.successfulMatches();
            if (dependencyVajrams.size() > 1) {
                throw new UnsupportedOperationException("");
            }
            Vajram dependencyVajram = (Vajram)dependencyVajrams.values().iterator().next();
            depNameToProviderNode.put(dependencyName, this._getVajramExecutionGraph(dependencyVajram.getId()));
        }
        return ImmutableMap.copyOf(depNameToProviderNode);
    }

    public Optional<VajramDefinition> getVajramDefinition(VajramID vajramId) {
        return Optional.ofNullable(this.vajramDefinitions.get(vajramId));
    }

    public static Builder builder() {
        return new Builder();
    }

    public NodeDefinitionRegistry getNodeDefinitionRegistry() {
        return this.nodeDefinitionRegistry;
    }

    private record InputResolverCreationResult(ImmutableList<ResolverDefinition> resolverDefinitions) {
    }

    public static final class Builder {
        private final Set<String> packagePrefixes = new LinkedHashSet<String>();
        private final Map<String, MainLogicDecoratorConfig> sessionScopedDecoratorConfigs = new HashMap<String, MainLogicDecoratorConfig>();
        private LogicDecorationOrdering logicDecorationOrdering = new LogicDecorationOrdering(ImmutableSet.of());
        private InputInjectionProvider inputInjectionProvider;
        private double maxParallelismPerCore = 1.0;

        public Builder loadFromPackage(String packagePrefix) {
            this.packagePrefixes.add(packagePrefix);
            return this;
        }

        public Builder decorateVajramLogicForSession(MainLogicDecoratorConfig logicDecoratorConfig) {
            if (this.sessionScopedDecoratorConfigs.putIfAbsent(logicDecoratorConfig.decoratorType(), logicDecoratorConfig) != null) {
                throw new IllegalArgumentException("Cannot have two decorator configs for same decorator type : %s".formatted(logicDecoratorConfig.decoratorType()));
            }
            return this;
        }

        public Builder maxParallelismPerCore(double maxParallelismPerCore) {
            this.maxParallelismPerCore = maxParallelismPerCore;
            return this;
        }

        public Builder logicDecorationOrdering(LogicDecorationOrdering logicDecorationOrdering) {
            this.logicDecorationOrdering = logicDecorationOrdering;
            return this;
        }

        public Builder injectInputsWith(InputInjectionProvider inputInjectionProvider) {
            this.inputInjectionProvider = inputInjectionProvider;
            return this;
        }

        public VajramNodeGraph build() {
            return new VajramNodeGraph((String[])this.packagePrefixes.toArray(String[]::new), (ImmutableMap<String, MainLogicDecoratorConfig>)ImmutableMap.copyOf(this.sessionScopedDecoratorConfigs), this.logicDecorationOrdering, this.inputInjectionProvider, this.maxParallelismPerCore);
        }
    }
}

